/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.destroystokyo.paper.event.player.PlayerReadyArrowEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.player.PlayerClientLoadedWorldEvent;
import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import io.papermc.paper.event.player.PlayerShieldDisableEvent;
import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftVector;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public abstract class EntityHuman
extends EntityLiving {
    private static final Logger a = LogUtils.getLogger();
    public static final EnumMainHand bG = EnumMainHand.b;
    public static final int bH = 0;
    public static final int bI = 20;
    public static final int bJ = 100;
    public static final int bK = 10;
    public static final int bL = 200;
    public static final int bM = 499;
    public static final int bN = 500;
    public static final float bO = 4.5f;
    public static final float bP = 3.0f;
    public static final float bQ = 1.5f;
    public static final float bR = 0.6f;
    public static final float bS = 0.6f;
    public static final float bT = 1.62f;
    private static final int b = 40;
    public static final Vec3D bU = new Vec3D(0.0, 0.6, 0.0);
    public static final EntitySize bV = EntitySize.b(0.6f, 1.8f).b(1.62f).a(EntityAttachments.a().a(EntityAttachment.b, bU));
    private static final Map<EntityPose, EntitySize> c = ImmutableMap.builder().put((Object)EntityPose.a, (Object)bV).put((Object)EntityPose.c, (Object)EntityLiving.aD).put((Object)EntityPose.b, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.d, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.e, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.f, (Object)EntitySize.b(0.6f, 1.5f).b(1.27f).a(EntityAttachments.a().a(EntityAttachment.b, bU))).put((Object)EntityPose.h, (Object)EntitySize.c(0.2f, 0.2f).b(1.62f)).build();
    private static final DataWatcherObject<Float> d = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> e = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Byte> bW = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Byte> bX = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<NBTTagCompound> bY = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.t);
    protected static final DataWatcherObject<NBTTagCompound> bZ = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.t);
    public static final int ca = 60;
    private long f;
    final PlayerInventory g = new PlayerInventory(this);
    protected InventoryEnderChest cb = new InventoryEnderChest(this);
    public final ContainerPlayer cc;
    public Container cd;
    protected FoodMetaData ce = new FoodMetaData();
    protected int cf;
    private boolean h = false;
    protected int cg = 60;
    public float ch;
    public float ci;
    public int cj;
    public double ck;
    public double cl;
    public double cm;
    public double cn;
    public double co;
    public double cp;
    public int i;
    protected boolean cq;
    private final PlayerAbilities j = new PlayerAbilities();
    public int cr;
    public int cs;
    public float ct;
    public int cu;
    protected final float cv = 0.02f;
    private int k;
    public GameProfile cC;
    private boolean cD;
    private net.minecraft.world.item.ItemStack cE = net.minecraft.world.item.ItemStack.j;
    private final ItemCooldown cF = this.g();
    private Optional<GlobalPos> cG = Optional.empty();
    @Nullable
    public EntityFishingHook cw;
    public float cx;
    @Nullable
    public Vec3D cy;
    @Nullable
    public Entity cz;
    private boolean cH;
    private int cI;
    public boolean affectsSpawning = true;
    public TriState flyingFallDamage = TriState.NOT_SET;
    public boolean fauxSleeping;
    public int oldLevel = -1;

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public EntityHuman(World level, BlockPosition pos, float yRot, GameProfile gameProfile) {
        super((EntityTypes<? extends EntityLiving>)EntityTypes.bR, level);
        this.a_(gameProfile.getId());
        this.cC = gameProfile;
        this.cc = new ContainerPlayer(this.g, !level.C, this);
        this.cd = this.cc;
        this.b((double)pos.u() + 0.5, pos.v() + 1, (double)pos.w() + 0.5, yRot, 0.0f);
        this.bk = 180.0f;
    }

    public boolean a(World level, BlockPosition pos, EnumGamemode gameMode) {
        if (!gameMode.f()) {
            return false;
        }
        if (gameMode == EnumGamemode.d) {
            return true;
        }
        if (this.gv()) {
            return false;
        }
        net.minecraft.world.item.ItemStack mainHandItem = this.eZ();
        return mainHandItem.f() || !mainHandItem.b(new ShapeDetectorBlock(level, pos, false));
    }

    public static AttributeProvider.Builder fX() {
        return EntityLiving.ed().a(GenericAttributes.c, 1.0).a(GenericAttributes.v, 0.1f).a(GenericAttributes.e).a(GenericAttributes.q).a(GenericAttributes.g, 4.5).a(GenericAttributes.j, 3.0).a(GenericAttributes.f).a(GenericAttributes.C).a(GenericAttributes.z).a(GenericAttributes.t).a(GenericAttributes.D);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(d, Float.valueOf(0.0f));
        builder.a(e, 0);
        builder.a(bW, (byte)0);
        builder.a(bX, (byte)bG.b());
        builder.a(bY, new NBTTagCompound());
        builder.a(bZ, new NBTTagCompound());
    }

    @Override
    public void h() {
        this.ad = this.Z_();
        if (this.Z_() || this.bZ()) {
            this.d(false);
        }
        if (this.cj > 0) {
            --this.cj;
        }
        if (this.fR()) {
            ++this.i;
            if (this.i == 100 && !new PlayerDeepSleepEvent((Player)this.getBukkitEntity()).callEvent()) {
                this.i = Integer.MIN_VALUE;
            }
            if (this.i > 100) {
                this.i = 100;
            }
            if (!this.dV().C && this.dV().V()) {
                this.a(false, true);
            }
        } else if (this.i > 0) {
            ++this.i;
            if (this.i >= 110) {
                this.i = 0;
            }
        }
        this.gb();
        super.h();
        if (!this.dV().C && this.cd != null && !this.cd.b(this)) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.cd = this.cc;
        }
        this.t();
        EntityHuman entityHuman = this;
        if (entityHuman instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entityHuman;
            this.ce.a(serverPlayer);
            this.a(StatisticList.k);
            this.a(StatisticList.l);
            if (this.bL()) {
                this.a(StatisticList.m);
            }
            if (this.cg()) {
                this.a(StatisticList.o);
            }
            if (!this.fR()) {
                this.a(StatisticList.n);
            }
        }
        int i2 = 29999999;
        double d2 = MathHelper.a(this.dA(), -2.9999999E7, 2.9999999E7);
        double d1 = MathHelper.a(this.dG(), -2.9999999E7, 2.9999999E7);
        if (d2 != this.dA() || d1 != this.dG()) {
            this.a_(d2, this.dC(), d1);
        }
        ++this.aS;
        net.minecraft.world.item.ItemStack mainHandItem = this.eZ();
        if (!net.minecraft.world.item.ItemStack.a(this.cE, mainHandItem)) {
            if (!net.minecraft.world.item.ItemStack.b(this.cE, mainHandItem)) {
                this.gD();
            }
            this.cE = mainHandItem.v();
        }
        if (!((Entity)this).a(TagsFluid.a) && this.c(Items.oT)) {
            this.m();
        }
        this.cF.a();
        this.gc();
        if (this.cI > 0) {
            --this.cI;
        }
    }

    @Override
    protected float fq() {
        return this.fG() ? 15.0f : super.fq();
    }

    public boolean fY() {
        return this.cd();
    }

    protected boolean fZ() {
        return this.cd();
    }

    protected boolean ga() {
        return this.cd();
    }

    protected boolean gb() {
        this.cq = ((Entity)this).a(TagsFluid.a);
        return this.cq;
    }

    @Override
    public void l(boolean downwards) {
        if (!this.gj().b) {
            super.l(downwards);
        }
    }

    @Override
    public void m(boolean downwards) {
        if (!this.gj().b) {
            super.m(downwards);
        }
    }

    private void m() {
        this.addEffect(new MobEffect(MobEffects.m, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
    }

    private boolean c(Item item) {
        for (EnumItemSlot equipmentSlot : EnumItemSlot.i) {
            net.minecraft.world.item.ItemStack itemBySlot = this.a(equipmentSlot);
            Equippable equippable = itemBySlot.a(DataComponents.D);
            if (!itemBySlot.a(item) || equippable == null || equippable.a() != equipmentSlot) continue;
            return true;
        }
        return false;
    }

    protected ItemCooldown g() {
        return new ItemCooldown();
    }

    private void t() {
        this.ck = this.cn;
        this.cl = this.co;
        this.cm = this.cp;
        double d2 = this.dA() - this.cn;
        double d1 = this.dC() - this.co;
        double d22 = this.dG() - this.cp;
        double d3 = 10.0;
        if (d2 > 10.0) {
            this.ck = this.cn = this.dA();
        }
        if (d22 > 10.0) {
            this.cm = this.cp = this.dG();
        }
        if (d1 > 10.0) {
            this.cl = this.co = this.dC();
        }
        if (d2 < -10.0) {
            this.ck = this.cn = this.dA();
        }
        if (d22 < -10.0) {
            this.cm = this.cp = this.dG();
        }
        if (d1 < -10.0) {
            this.cl = this.co = this.dC();
        }
        this.cn += d2 * 0.25;
        this.cp += d22 * 0.25;
        this.co += d1 * 0.25;
    }

    protected void gc() {
        if (this.h(EntityPose.d)) {
            EntityPose pose = this.fJ() ? EntityPose.b : (this.fR() ? EntityPose.c : (this.ck() ? EntityPose.d : (this.fv() ? EntityPose.e : (this.cd() && !this.j.b ? EntityPose.f : EntityPose.a))));
            EntityPose pose1 = this.Z_() || this.bZ() || this.h(pose) ? pose : (this.h(EntityPose.f) ? EntityPose.f : EntityPose.d);
            this.b(pose1);
        }
    }

    protected boolean h(EntityPose pose) {
        return this.dV().a((Entity)this, this.a(pose).a(this.dt()).h(1.0E-7));
    }

    @Override
    protected SoundEffect aV() {
        return SoundEffects.uU;
    }

    @Override
    protected SoundEffect aW() {
        return SoundEffects.uS;
    }

    @Override
    protected SoundEffect aX() {
        return SoundEffects.uT;
    }

    @Override
    public int bX() {
        return 10;
    }

    @Override
    public void a(SoundEffect sound, float volume, float pitch) {
        this.dV().a(this, this.dA(), this.dC(), this.dG(), sound, this.dm(), volume, pitch);
    }

    public void a(SoundEffect sound, SoundCategory source, float volume, float pitch) {
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.h;
    }

    @Override
    public int dn() {
        return 20;
    }

    @Override
    public void b(byte id) {
        if (id == 9) {
            this.w();
        } else if (id == 23) {
            this.cD = false;
        } else if (id == 22) {
            this.cD = true;
        } else {
            super.b(id);
        }
    }

    public void closeContainer(InventoryCloseEvent.Reason reason) {
        this.p();
        this.cd = this.cc;
    }

    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        this.cd = this.cc;
    }

    public void p() {
        this.cd = this.cc;
    }

    protected void q() {
    }

    @Override
    public void r() {
        if (!this.dV().C && this.fZ() && this.bZ()) {
            this.ae();
            if (!this.bZ()) {
                this.g(false);
                return;
            }
        }
        super.r();
        this.ch = this.ci;
        this.ci = 0.0f;
    }

    @Override
    protected void fu() {
        super.fu();
        this.eX();
        this.aZ = this.dL();
    }

    @Override
    public void d_() {
        if (this.cf > 0) {
            --this.cf;
        }
        this.j();
        this.g.j();
        this.ch = this.ci;
        if (this.j.b && !this.bZ()) {
            this.k();
        }
        super.d_();
        this.C((float)this.h(GenericAttributes.v));
        float f2 = this.aJ() && !this.eE() && !this.ck() ? Math.min(0.1f, (float)this.dy().i()) : 0.0f;
        this.ci += (f2 - this.ci) * 0.4f;
        if (this.eD() > 0.0f && !this.Z_()) {
            AxisAlignedBB aabb = this.bZ() && !this.dk().dQ() ? this.cR().b(this.dk().cR()).c(1.0, 0.0, 1.0) : this.cR().c(1.0, 0.5, 1.0);
            List<Entity> entities = this.dV().a_(this, aabb);
            ArrayList list = Lists.newArrayList();
            for (Entity entity : entities) {
                if (entity.aq() == EntityTypes.V) {
                    list.add(entity);
                    continue;
                }
                if (entity.dQ()) continue;
                this.d(entity);
            }
            if (!list.isEmpty()) {
                this.d((Entity)SystemUtils.a(list, this.ae));
            }
        }
        this.c(this.gA());
        this.c(this.gB());
        if ((!this.dV().C && (this.Z > 0.5f || this.bj()) || this.j.b || this.fR() || this.av) && !this.dV().paperConfig().entities.behavior.parrotsAreUnaffectedByPlayerMovement) {
            this.gx();
        }
    }

    protected void j() {
    }

    private void c(@Nullable NBTTagCompound entityCompound) {
        if (!(entityCompound == null || entityCompound.e("Silent") && entityCompound.q("Silent") || this.dV().A.a(200) != 0)) {
            String string = entityCompound.l("id");
            EntityTypes.a(string).filter(entityType -> entityType == EntityTypes.aO).ifPresent(entityType -> {
                if (!EntityParrot.a(this.dV(), this)) {
                    this.dV().a(null, this.dA(), this.dC(), this.dG(), EntityParrot.a(this.dV(), this.dV().A), this.dm(), 1.0f, EntityParrot.a(this.dV().A));
                }
            });
        }
    }

    private void d(Entity entity) {
        entity.a_(this);
    }

    public int gd() {
        return this.al.a(e);
    }

    public void q(int score) {
        this.al.a(e, score);
    }

    public void r(int score) {
        int score1 = this.gd();
        this.al.a(e, score1 + score);
    }

    public void a(int ticks, float damage, net.minecraft.world.item.ItemStack itemStack) {
        this.bB = ticks;
        this.bC = damage;
        this.bD = itemStack;
        if (!this.dV().C) {
            this.gx();
            this.c(4, true);
        }
    }

    @Override
    @Nonnull
    public net.minecraft.world.item.ItemStack dZ() {
        return this.fv() && this.bD != null ? this.bD : super.dZ();
    }

    @Override
    public void a(DamageSource cause) {
        World world;
        super.a(cause);
        this.ay();
        if (!this.Z_() && (world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.dropAllDeathLoot(serverLevel, cause);
        }
        if (cause != null) {
            this.n(-MathHelper.b((this.eJ() + this.dL()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -MathHelper.a((this.eJ() + this.dL()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.n(0.0, 0.1, 0.0);
        }
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aH();
        this.c(false);
        this.c(Optional.of(GlobalPos.a(this.dV().ai(), this.dv())));
    }

    @Override
    protected void f(WorldServer level) {
        super.f(level);
        if (!level.O().b(GameRules.d)) {
            this.ge();
            this.g.k();
        }
    }

    protected void ge() {
        for (int i2 = 0; i2 < this.g.b(); ++i2) {
            net.minecraft.world.item.ItemStack item = this.g.a(i2);
            if (item.f() || !EnchantmentManager.a(item, EnchantmentEffectComponents.D)) continue;
            this.g.b(i2);
        }
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return damageSource.k().d().a();
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.uK;
    }

    public void g(net.minecraft.world.item.ItemStack stack) {
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack itemStack, boolean includeThrowerName) {
        return this.a(itemStack, false, includeThrowerName);
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack droppedItem, boolean dropAround, boolean includeThrowerName) {
        return this.drop(droppedItem, dropAround, includeThrowerName, true, null);
    }

    @Nullable
    public EntityItem drop(net.minecraft.world.item.ItemStack droppedItem, boolean dropAround, boolean includeThrowerName, boolean callEvent) {
        return this.drop(droppedItem, dropAround, includeThrowerName, callEvent, null);
    }

    @Nullable
    public EntityItem drop(net.minecraft.world.item.ItemStack droppedItem, boolean dropAround, boolean includeThrowerName, boolean callEvent, @Nullable Consumer<org.bukkit.entity.Item> entityOperation) {
        if (!droppedItem.f() && this.dV().C) {
            this.a(EnumHand.a);
        }
        return null;
    }

    public float c(IBlockData state) {
        float destroySpeed = this.g.a(state);
        if (destroySpeed > 1.0f) {
            destroySpeed += (float)this.h(GenericAttributes.t);
        }
        if (MobEffectUtil.a(this)) {
            destroySpeed *= 1.0f + (float)(MobEffectUtil.b(this) + 1) * 0.2f;
        }
        if (this.b(MobEffects.d)) {
            float f2 = switch (this.c(MobEffects.d).e()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            destroySpeed *= f2;
        }
        destroySpeed *= (float)this.h(GenericAttributes.f);
        if (((Entity)this).a(TagsFluid.a)) {
            destroySpeed *= (float)this.g(GenericAttributes.C).g();
        }
        if (!this.aJ()) {
            destroySpeed /= 5.0f;
        }
        return destroySpeed;
    }

    public boolean d(IBlockData state) {
        return !state.C() || this.g.f().b(state);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.a_(this.cC.getId());
        NBTTagList list = compound.c("Inventory", 10);
        this.g.b(list);
        this.g.j = compound.h("SelectedItemSlot");
        this.i = compound.g("SleepTimer");
        this.ct = compound.j("XpP");
        this.cr = compound.h("XpLevel");
        this.cs = compound.h("XpTotal");
        this.cu = compound.h("XpSeed");
        if (this.cu == 0) {
            this.cu = this.ae.f();
        }
        this.q(compound.h("Score"));
        this.ce.a(compound);
        this.j.b(compound);
        this.g(GenericAttributes.v).a(this.j.b());
        if (compound.b("EnderItems", 9)) {
            this.cb.a(compound.c("EnderItems", 10), this.dX());
        }
        if (compound.b("ShoulderEntityLeft", 10)) {
            this.i(compound.p("ShoulderEntityLeft"));
        }
        if (compound.b("ShoulderEntityRight", 10)) {
            this.j(compound.p("ShoulderEntityRight"));
        }
        if (compound.b("LastDeathLocation", 10)) {
            this.c(GlobalPos.b.parse((DynamicOps)DynamicOpsNBT.a, (Object)compound.c("LastDeathLocation")).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)));
        }
        if (compound.b("current_explosion_impact_pos", 9)) {
            Vec3D.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)compound.c("current_explosion_impact_pos")).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(currentImpulseImpactPos -> {
                this.cy = currentImpulseImpactPos;
            });
        }
        this.cH = compound.q("ignore_fall_damage_from_current_explosion");
        this.cI = compound.h("current_impulse_context_reset_grace_time");
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        GameProfileSerializer.e(compound);
        compound.a("Inventory", this.g.a(new NBTTagList()));
        compound.a("SelectedItemSlot", this.g.j);
        compound.a("SleepTimer", (short)this.i);
        compound.a("XpP", this.ct);
        compound.a("XpLevel", this.cr);
        compound.a("XpTotal", this.cs);
        compound.a("XpSeed", this.cu);
        compound.a("Score", this.gd());
        this.ce.b(compound);
        this.j.a(compound);
        compound.a("EnderItems", this.cb.a(this.dX()));
        if (!this.gA().g()) {
            compound.a("ShoulderEntityLeft", this.gA());
        }
        if (!this.gB().g()) {
            compound.a("ShoulderEntityRight", this.gB());
        }
        this.gI().flatMap(pos -> GlobalPos.b.encodeStart((DynamicOps)DynamicOpsNBT.a, pos).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0))).ifPresent(tag -> compound.a("LastDeathLocation", (NBTBase)tag));
        if (this.cy != null) {
            compound.a("current_explosion_impact_pos", (NBTBase)Vec3D.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cy).getOrThrow());
        }
        compound.a("ignore_fall_damage_from_current_explosion", this.cH);
        compound.a("current_impulse_context_reset_grace_time", this.cI);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource) {
        if (super.a(level, damageSource)) {
            return true;
        }
        if (damageSource.a(DamageTypeTags.n)) {
            return !level.O().b(GameRules.H);
        }
        if (damageSource.a(DamageTypeTags.m)) {
            return !level.O().b(GameRules.I);
        }
        return damageSource.a(DamageTypeTags.i) ? !level.O().b(GameRules.J) : damageSource.a(DamageTypeTags.o) && !level.O().b(GameRules.K);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        boolean damaged;
        if (this.a(level, damageSource)) {
            return false;
        }
        if (this.j.a && !damageSource.a(DamageTypeTags.d)) {
            return false;
        }
        this.bf = 0;
        if (this.eE()) {
            return false;
        }
        if (damageSource.g()) {
            if (level.am() == EnumDifficulty.a) {
                return false;
            }
            if (level.am() == EnumDifficulty.b) {
                amount = Math.min(amount / 2.0f + 1.0f, amount);
            }
            if (level.am() == EnumDifficulty.d) {
                amount = amount * 3.0f / 2.0f;
            }
        }
        if (damaged = super.a(level, damageSource, amount)) {
            this.gx();
        }
        return damaged;
    }

    @Override
    protected void d(EntityLiving entity) {
        super.d(entity);
        net.minecraft.world.item.ItemStack itemBlockingWith = this.fH();
        if (entity.fU() && itemBlockingWith != null) {
            this.disableShield(itemBlockingWith, entity);
        }
    }

    @Override
    public boolean ew() {
        return !this.gj().a && super.ew();
    }

    public boolean a(EntityHuman other) {
        Team team;
        if (other instanceof EntityPlayer) {
            EntityPlayer thatPlayer = (EntityPlayer)other;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = other.dV().getCraftServer().getOfflinePlayer(other.cI());
            team = other.dV().getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof EntityPlayer) {
            return !team.hasPlayer((OfflinePlayer)((EntityPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.dV().getCraftServer().getOfflinePlayer(this.cI()));
    }

    @Override
    protected void c(DamageSource damageSource, float damage) {
        this.a(damageSource, damage, EnumItemSlot.c, EnumItemSlot.d, EnumItemSlot.e, EnumItemSlot.f);
    }

    @Override
    protected void d(DamageSource damageSource, float damageAmount) {
        this.a(damageSource, damageAmount, EnumItemSlot.f);
    }

    @Override
    protected void z(float damage) {
        if (this.by.a(Items.ws)) {
            if (!this.dV().C) {
                this.b(StatisticList.c.b(this.by.h()));
            }
            if (damage >= 3.0f) {
                int i2 = 1 + MathHelper.d(damage);
                EnumHand usedItemHand = this.fA();
                this.by.a(i2, (EntityLiving)this, EntityHuman.d(usedItemHand));
                if (this.by.f()) {
                    if (usedItemHand == EnumHand.a) {
                        this.a(EnumItemSlot.a, net.minecraft.world.item.ItemStack.j);
                    } else {
                        this.a(EnumItemSlot.b, net.minecraft.world.item.ItemStack.j);
                    }
                    this.by = net.minecraft.world.item.ItemStack.j;
                    this.a(SoundEffects.xe, 0.8f, 0.8f + this.dV().A.i() * 0.4f);
                }
            }
        }
    }

    @Override
    protected boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        return super.actuallyHurt(level, damageSource, amount, event);
    }

    public boolean aa() {
        return false;
    }

    public void a(TileEntitySign signEntity, boolean isFrontText) {
    }

    public void a(CommandBlockListenerAbstract commandEntity) {
    }

    public void a(TileEntityCommand commandBlockEntity) {
    }

    public void a(TileEntityStructure structureEntity) {
    }

    public void a(TileEntityJigsaw jigsawBlockEntity) {
    }

    public void a(EntityHorseAbstract horse, IInventory inventory) {
    }

    public OptionalInt a(@Nullable ITileInventory menu) {
        return OptionalInt.empty();
    }

    public void a(int containerId, MerchantRecipeList offers, int villagerLevel, int villagerXp, boolean showProgress, boolean canRestock) {
    }

    public void a(net.minecraft.world.item.ItemStack stack, EnumHand hand) {
    }

    public EnumInteractionResult a(Entity entityToInteractOn, EnumHand hand) {
        if (this.Z_()) {
            if (entityToInteractOn instanceof ITileInventory) {
                this.a((ITileInventory)((Object)entityToInteractOn));
            }
            return EnumInteractionResult.e;
        }
        net.minecraft.world.item.ItemStack itemInHand = this.b(hand);
        net.minecraft.world.item.ItemStack itemStack = itemInHand.v();
        EnumInteractionResult interactionResult = entityToInteractOn.a(this, hand);
        if (interactionResult.a()) {
            if (this.j.d && itemInHand == this.b(hand) && itemInHand.M() < itemStack.M()) {
                itemInHand.e(itemStack.M());
            }
            return interactionResult;
        }
        if (!itemInHand.f() && entityToInteractOn instanceof EntityLiving) {
            EnumInteractionResult interactionResult1;
            if (this.j.d) {
                itemInHand = itemStack;
            }
            if ((interactionResult1 = itemInHand.a(this, (EntityLiving)entityToInteractOn, hand)).a()) {
                this.dV().a(GameEvent.r, entityToInteractOn.dt(), GameEvent.a.a(this));
                if (itemInHand.f() && !this.j.d) {
                    this.a(hand, net.minecraft.world.item.ItemStack.j);
                }
                return interactionResult1;
            }
        }
        return EnumInteractionResult.e;
    }

    @Override
    public void bQ() {
        this.removeVehicle(false);
    }

    @Override
    public void removeVehicle(boolean suppressCancellation) {
        super.removeVehicle(suppressCancellation);
        this.J = 0;
    }

    @Override
    protected boolean fi() {
        return super.fi() || this.fR() || this.dQ() || !this.valid;
    }

    @Override
    public boolean ek() {
        return !this.j.b;
    }

    @Override
    protected Vec3D a(Vec3D vec, EnumMoveType mover) {
        float f2 = this.dP();
        if (!this.j.b && !(vec.e > 0.0) && (mover == EnumMoveType.a || mover == EnumMoveType.b) && this.ga() && this.I(f2)) {
            double d2;
            double d1 = vec.f;
            double d22 = 0.05;
            double d3 = Math.signum(d2) * 0.05;
            double d4 = Math.signum(d1) * 0.05;
            for (d2 = vec.d; d2 != 0.0 && this.b(d2, 0.0, f2); d2 -= d3) {
                if (!(Math.abs(d2) <= 0.05)) continue;
                d2 = 0.0;
                break;
            }
            while (d1 != 0.0 && this.b(0.0, d1, f2)) {
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    break;
                }
                d1 -= d4;
            }
            while (d2 != 0.0 && d1 != 0.0 && this.b(d2, d1, f2)) {
                d2 = Math.abs(d2) <= 0.05 ? 0.0 : (d2 -= d3);
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    continue;
                }
                d1 -= d4;
            }
            return new Vec3D(d2, vec.e, d1);
        }
        return vec;
    }

    private boolean I(float maxUpStep) {
        return this.aJ() || this.Z < maxUpStep && !this.b(0.0, 0.0, maxUpStep - this.Z);
    }

    private boolean b(double x2, double z2, float distance) {
        AxisAlignedBB boundingBox = this.cR();
        return this.dV().a((Entity)this, new AxisAlignedBB(boundingBox.a + x2, boundingBox.b - (double)distance - (double)1.0E-5f, boundingBox.c + z2, boundingBox.d + x2, boundingBox.b, boundingBox.f + z2));
    }

    public void e(Entity target) {
        boolean willAttack = target.cB() && !target.v(this);
        PrePlayerAttackEntityEvent playerAttackEntityEvent = new PrePlayerAttackEntityEvent((Player)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), willAttack);
        if (playerAttackEntityEvent.callEvent() && willAttack) {
            float f2 = this.fv() ? this.bC : (float)this.h(GenericAttributes.c);
            net.minecraft.world.item.ItemStack weaponItem = this.dZ();
            DamageSource damageSource = Optional.ofNullable(weaponItem.h().a(this)).orElse(this.dW().a(this));
            float f1 = this.a(target, f2, damageSource) - f2;
            float attackStrengthScale = this.H(0.5f);
            f2 *= 0.2f + attackStrengthScale * attackStrengthScale * 0.8f;
            f1 *= attackStrengthScale;
            if (target.aq().a(TagsEntity.H) && target instanceof IProjectile) {
                IProjectile projectile = (IProjectile)target;
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(target, damageSource, f1, false)) {
                    return;
                }
                if (projectile.a(ProjectileDeflection.c, this, this, true)) {
                    this.dV().a(null, this.dA(), this.dC(), this.dG(), SoundEffects.uD, this.dm());
                    return;
                }
            }
            if (f2 > 0.0f || f1 > 0.0f) {
                double d1;
                double d2;
                boolean flag1;
                boolean flag;
                boolean bl = flag = attackStrengthScale > 0.9f;
                if (this.cj() && flag) {
                    EntityHuman.sendSoundEffect(this, this.dA(), this.dC(), this.dG(), SoundEffects.uC, this.dm(), 1.0f, 1.0f);
                    flag1 = true;
                } else {
                    flag1 = false;
                }
                f2 += weaponItem.h().a(target, f2, damageSource);
                boolean flag2 = flag && this.Z > 0.0f && !this.aJ() && !this.q_() && !this.bj() && !this.b(MobEffects.o) && !this.bZ() && target instanceof EntityLiving && !this.cj();
                boolean bl2 = flag2 = flag2 && !this.dV().paperConfig().entities.behavior.disablePlayerCrits;
                if (flag2) {
                    damageSource = damageSource.critical();
                    f2 *= 1.5f;
                }
                float f22 = f2 + f1;
                boolean flag3 = false;
                if (flag && !flag2 && !flag1 && this.aJ() && (d2 = this.ah().j()) < MathHelper.k(d1 = (double)this.fp() * 2.5) && this.b(EnumHand.a).a(TagsItem.bG)) {
                    flag3 = true;
                }
                float f3 = 0.0f;
                if (target instanceof EntityLiving) {
                    EntityLiving livingEntity = (EntityLiving)target;
                    f3 = livingEntity.eD();
                }
                Vec3D deltaMovement = target.dy();
                boolean flag4 = target.b(damageSource, f22);
                if (flag4) {
                    float f4 = this.b(target, damageSource) + (flag1 ? 1.0f : 0.0f);
                    if (f4 > 0.0f) {
                        if (target instanceof EntityLiving) {
                            EntityLiving livingEntity1 = (EntityLiving)target;
                            livingEntity1.knockback(f4 * 0.5f, MathHelper.a(this.dL() * ((float)Math.PI / 180)), -MathHelper.b(this.dL() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.Cause.ENTITY_ATTACK);
                        } else {
                            target.push(-MathHelper.a(this.dL() * ((float)Math.PI / 180)) * f4 * 0.5f, 0.1, MathHelper.b(this.dL() * ((float)Math.PI / 180)) * f4 * 0.5f, this);
                        }
                        this.i(this.dy().d(0.6, 1.0, 0.6));
                        if (!this.dV().paperConfig().misc.disableSprintInterruptionOnAttack) {
                            this.h(false);
                        }
                    }
                    if (flag3) {
                        float f5 = 1.0f + (float)this.h(GenericAttributes.D) * f2;
                        for (EntityLiving livingEntity2 : this.dV().a(EntityLiving.class, target.cR().c(1.0, 0.25, 1.0))) {
                            if (livingEntity2 == this || livingEntity2 == target || this.s(livingEntity2) || livingEntity2 instanceof EntityArmorStand && ((EntityArmorStand)livingEntity2).x() || !(this.g((Entity)livingEntity2) < 9.0)) continue;
                            float f6 = this.a((Entity)livingEntity2, f5, damageSource) * attackStrengthScale;
                            livingEntity2.lastDamageCancelled = false;
                            livingEntity2.a((WorldServer)this.dV(), damageSource.knownCause(EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK), f6);
                            if (livingEntity2.lastDamageCancelled) continue;
                            livingEntity2.knockback(0.4f, MathHelper.a(this.dL() * ((float)Math.PI / 180)), -MathHelper.b(this.dL() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.Cause.SWEEP_ATTACK);
                            World world = this.dV();
                            if (!(world instanceof WorldServer)) continue;
                            WorldServer serverLevel = (WorldServer)world;
                            EnchantmentManager.a(serverLevel, (Entity)livingEntity2, damageSource);
                        }
                        EntityHuman.sendSoundEffect(this, this.dA(), this.dC(), this.dG(), SoundEffects.uF, this.dm(), 1.0f, 1.0f);
                        this.gf();
                    }
                    if (target instanceof EntityPlayer && target.T) {
                        boolean cancelled = false;
                        Player player = (Player)target.getBukkitEntity();
                        Vector velocity = CraftVector.toBukkit(deltaMovement);
                        PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                        this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            cancelled = true;
                        } else if (!velocity.equals((Object)event.getVelocity())) {
                            player.setVelocity(event.getVelocity());
                        }
                        if (!cancelled) {
                            ((EntityPlayer)target).f.b(new PacketPlayOutEntityVelocity(target));
                            target.T = false;
                            target.i(deltaMovement);
                        }
                    }
                    if (flag2) {
                        EntityHuman.sendSoundEffect(this, this.dA(), this.dC(), this.dG(), SoundEffects.uB, this.dm(), 1.0f, 1.0f);
                        this.b(target);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            EntityHuman.sendSoundEffect(this, this.dA(), this.dC(), this.dG(), SoundEffects.uE, this.dm(), 1.0f, 1.0f);
                        } else {
                            EntityHuman.sendSoundEffect(this, this.dA(), this.dC(), this.dG(), SoundEffects.uG, this.dm(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.c(target);
                    }
                    this.B(target);
                    Entity entity = target;
                    if (target instanceof EntityComplexPart) {
                        entity = ((EntityComplexPart)target).a;
                    }
                    boolean flag5 = false;
                    World event = this.dV();
                    if (event instanceof WorldServer) {
                        WorldServer serverLevel1 = (WorldServer)event;
                        if (entity instanceof EntityLiving) {
                            EntityLiving livingEntity2x = (EntityLiving)entity;
                            flag5 = weaponItem.a(livingEntity2x, (EntityLiving)this);
                        }
                        EnchantmentManager.a(serverLevel1, target, damageSource);
                    }
                    if (!this.dV().C && !weaponItem.f() && entity instanceof EntityLiving) {
                        if (flag5) {
                            weaponItem.b((EntityLiving)entity, (EntityLiving)this);
                        }
                        if (weaponItem.f()) {
                            if (weaponItem == this.eZ()) {
                                this.a(EnumHand.a, net.minecraft.world.item.ItemStack.j);
                            } else {
                                this.a(EnumHand.b, net.minecraft.world.item.ItemStack.j);
                            }
                        }
                    }
                    if (target instanceof EntityLiving) {
                        float f7 = f3 - ((EntityLiving)target).eD();
                        this.a(StatisticList.G, Math.round(f7 * 10.0f));
                        if (this.dV() instanceof WorldServer && f7 > 2.0f) {
                            int i2 = (int)((double)f7 * 0.5);
                            ((WorldServer)this.dV()).a(Particles.g, target.dA(), target.e(0.5), target.dG(), i2, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.causeFoodExhaustion(this.dV().spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
                } else {
                    EntityHuman.sendSoundEffect(this, this.dA(), this.dC(), this.dG(), SoundEffects.uD, this.dm(), 1.0f, 1.0f);
                    if (this instanceof EntityPlayer) {
                        ((EntityPlayer)this).getBukkitEntity().updateInventory();
                    }
                }
            }
        }
    }

    protected float a(Entity entity, float damage, DamageSource damageSource) {
        return damage;
    }

    @Override
    protected void g(EntityLiving target) {
        this.e((Entity)target);
    }

    @DoNotUse
    @Deprecated
    public void h(net.minecraft.world.item.ItemStack stack) {
        this.disableShield(stack, null);
    }

    public void disableShield(net.minecraft.world.item.ItemStack stack, @Nullable EntityLiving attacker) {
        CraftEntity finalAttacker;
        CraftEntity craftEntity = finalAttacker = attacker != null ? attacker.getBukkitEntity() : null;
        if (finalAttacker != null) {
            PlayerShieldDisableEvent shieldDisableEvent = new PlayerShieldDisableEvent((Player)this.getBukkitEntity(), (org.bukkit.entity.Entity)finalAttacker, 100);
            if (!shieldDisableEvent.callEvent()) {
                return;
            }
            this.gE().a(stack, shieldDisableEvent.getCooldown());
        } else {
            this.gE().a(stack, 100);
        }
        this.fF();
        this.dV().a((Entity)this, (byte)30);
    }

    public void b(Entity entityHit) {
    }

    public void c(Entity entityHit) {
    }

    public void gf() {
        double d2 = -MathHelper.a(this.dL() * ((float)Math.PI / 180));
        double d1 = MathHelper.b(this.dL() * ((float)Math.PI / 180));
        if (this.dV() instanceof WorldServer) {
            ((WorldServer)this.dV()).a(Particles.al, this.dA() + d2, this.e(0.5), this.dG() + d1, 0, d2, 0.0, d1, 0.0);
        }
    }

    public void gg() {
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        this.remove(reason, null);
    }

    @Override
    public void remove(Entity.RemovalReason reason, EntityRemoveEvent.Cause eventCause) {
        super.remove(reason, eventCause);
        this.cc.a(this);
        if (this.cd != null && this.gk()) {
            this.q();
        }
    }

    public boolean c() {
        return false;
    }

    public GameProfile gh() {
        return this.cC;
    }

    public PlayerInventory gi() {
        return this.g;
    }

    public PlayerAbilities gj() {
        return this.j;
    }

    @Override
    public boolean fV() {
        return this.j.d;
    }

    public void a(net.minecraft.world.item.ItemStack carried, net.minecraft.world.item.ItemStack clicked, ClickAction action) {
    }

    public boolean gk() {
        return this.cd != this.cc;
    }

    public boolean gl() {
        return true;
    }

    public Either<EnumBedResult, Unit> a(BlockPosition bedPos) {
        return this.startSleepInBed(bedPos, false);
    }

    public Either<EnumBedResult, Unit> startSleepInBed(BlockPosition bedPos, boolean force) {
        this.b(bedPos);
        this.i = 0;
        return Either.right(Unit.a);
    }

    public void a(boolean wakeImmediately, boolean updateLevelForSleepingPlayers) {
        super.fS();
        if (this.dV() instanceof WorldServer && updateLevelForSleepingPlayers) {
            ((WorldServer)this.dV()).f();
        }
        this.i = wakeImmediately ? 0 : 100;
    }

    @Override
    public void fS() {
        this.a(true, true);
    }

    public boolean gm() {
        return this.fR() && this.i >= 100;
    }

    public int gn() {
        return this.i;
    }

    public void a(IChatBaseComponent chatComponent, boolean actionBar) {
    }

    public void a(MinecraftKey statKey) {
        this.b(StatisticList.i.b(statKey));
    }

    public void a(MinecraftKey stat, int increment) {
        this.a(StatisticList.i.b(stat), increment);
    }

    public void b(Statistic<?> stat) {
        this.a(stat, 1);
    }

    public void a(Statistic<?> stat, int increment) {
    }

    public void a(Statistic<?> stat) {
    }

    public int a(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    public void a(RecipeHolder<?> recipe, List<net.minecraft.world.item.ItemStack> items) {
    }

    public void b(List<ResourceKey<IRecipe<?>>> recipes) {
    }

    public int b(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    @Override
    public void a_(Vec3D travelVector) {
        if (this.bZ()) {
            super.a_(travelVector);
        } else {
            double d2;
            if (this.ck()) {
                double d1;
                d2 = this.bT().e;
                double d3 = d1 = d2 < -0.2 ? 0.085 : 0.06;
                if (d2 <= 0.0 || this.bm || !this.dV().b_(BlockPosition.a(this.dA(), this.dC() + 1.0 - 0.1, this.dG())).c()) {
                    Vec3D deltaMovement = this.dy();
                    this.i(deltaMovement.b(0.0, (d2 - deltaMovement.e) * d1, 0.0));
                }
            }
            if (this.gj().b) {
                d2 = this.dy().e;
                super.a_(travelVector);
                this.i(this.dy().a(EnumDirection.EnumAxis.b, d2 * 0.6));
            } else {
                super.a_(travelVector);
            }
        }
    }

    @Override
    protected boolean ft() {
        return !this.j.b && super.ft();
    }

    @Override
    public void bp() {
        if (this.j.b) {
            this.i(false);
        } else {
            super.bp();
        }
    }

    protected boolean h(BlockPosition pos) {
        return !this.dV().a_(pos).j(this.dV(), pos);
    }

    @Override
    public float fp() {
        return (float)this.h(GenericAttributes.v);
    }

    @Override
    public boolean a(float fallDistance, float multiplier, DamageSource source) {
        float min;
        boolean flag;
        if (this.j.c && !this.flyingFallDamage.toBooleanOrElse(false)) {
            return false;
        }
        if (fallDistance >= 2.0f) {
            this.a(StatisticList.t, (int)Math.round((double)fallDistance * 100.0));
        }
        boolean bl = flag = this.cy != null && this.cH;
        if (flag) {
            boolean flag1;
            min = Math.min(fallDistance, (float)(this.cy.e - this.dC()));
            boolean bl2 = flag1 = min <= 0.0f;
            if (flag1) {
                this.gP();
            } else {
                this.gO();
            }
        } else {
            min = fallDistance;
        }
        if (min > 0.0f && super.a(min, multiplier, source)) {
            this.gP();
            return true;
        }
        return false;
    }

    public boolean go() {
        if (!this.fJ() && this.ft() && !this.bj()) {
            this.gp();
            return true;
        }
        return false;
    }

    public void gp() {
        if (!CraftEventFactory.callToggleGlideEvent(this, true).isCancelled()) {
            this.b(7, true);
        } else {
            this.b(7, true);
            this.b(7, false);
        }
    }

    public void gq() {
        if (!CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            this.b(7, true);
            this.b(7, false);
        }
    }

    @Override
    protected void bs() {
        if (!this.Z_()) {
            super.bs();
        }
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        if (this.bj()) {
            this.aY();
            this.b(state);
        } else {
            BlockPosition primaryStepSoundBlockPos = this.e(pos);
            if (!pos.equals(primaryStepSoundBlockPos)) {
                IBlockData blockState = this.dV().a_(primaryStepSoundBlockPos);
                if (blockState.a(TagsBlock.bq)) {
                    this.a(blockState, state);
                } else {
                    super.b(primaryStepSoundBlockPos, blockState);
                }
            } else {
                super.b(pos, state);
            }
        }
    }

    @Override
    public EntityLiving.a eM() {
        return new EntityLiving.a(SoundEffects.uR, SoundEffects.uH);
    }

    @Override
    public boolean a(WorldServer level, EntityLiving entity) {
        this.b(StatisticList.g.b(entity.aq()));
        return true;
    }

    @Override
    public void a(IBlockData state, Vec3D motionMultiplier) {
        if (!this.j.b) {
            super.a(state, motionMultiplier);
        }
        this.gO();
    }

    public void d(int xpPoints) {
        this.r(xpPoints);
        this.ct += (float)xpPoints / (float)this.gs();
        this.cs = MathHelper.a(this.cs + xpPoints, 0, Integer.MAX_VALUE);
        while (this.ct < 0.0f) {
            float f2 = this.ct * (float)this.gs();
            if (this.cr > 0) {
                this.c(-1);
                this.ct = 1.0f + f2 / (float)this.gs();
                continue;
            }
            this.c(-1);
            this.ct = 0.0f;
        }
        while (this.ct >= 1.0f) {
            this.ct = (this.ct - 1.0f) * (float)this.gs();
            this.c(1);
            this.ct /= (float)this.gs();
        }
    }

    public int gr() {
        return this.cu;
    }

    public void a(net.minecraft.world.item.ItemStack enchantedItem, int levelCost) {
        this.cr -= levelCost;
        if (this.cr < 0) {
            this.cr = 0;
            this.ct = 0.0f;
            this.cs = 0;
        }
        this.cu = this.ae.f();
    }

    public void c(int levels) {
        this.cr = IntMath.saturatedAdd((int)this.cr, (int)levels);
        if (this.cr < 0) {
            this.cr = 0;
            this.ct = 0.0f;
            this.cs = 0;
        }
        if (levels > 0 && this.cr % 5 == 0 && (float)this.k < (float)this.af - 100.0f) {
            float f2 = this.cr > 30 ? 1.0f : (float)this.cr / 30.0f;
            this.dV().a(null, this.dA(), this.dC(), this.dG(), SoundEffects.uQ, this.dm(), f2 * 0.75f, 1.0f);
            this.k = this.af;
        }
    }

    public int gs() {
        if (this.cr >= 30) {
            return 112 + (this.cr - 30) * 9;
        }
        return this.cr >= 15 ? 37 + (this.cr - 15) * 5 : 7 + this.cr * 2;
    }

    private static void sendSoundEffect(EntityHuman fromEntity, double x2, double y2, double z2, SoundEffect soundEffect, SoundCategory soundCategory, float volume, float pitch) {
        fromEntity.dV().a(fromEntity, x2, y2, z2, soundEffect, soundCategory, volume, pitch);
        if (fromEntity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)fromEntity;
            serverPlayer.f.b(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.b.e(soundEffect), soundCategory, x2, y2, z2, volume, pitch, fromEntity.ae.g()));
        }
    }

    public void G(float exhaustion) {
        this.causeFoodExhaustion(exhaustion, EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    }

    public void causeFoodExhaustion(float exhaustion, EntityExhaustionEvent.ExhaustionReason reason) {
        EntityExhaustionEvent event;
        if (!(this.j.a || this.dV().C || (event = CraftEventFactory.callPlayerExhaustionEvent(this, reason, exhaustion)).isCancelled())) {
            this.ce.a(event.getExhaustion());
        }
    }

    public Optional<WardenSpawnTracker> ac() {
        return Optional.empty();
    }

    public FoodMetaData gt() {
        return this.ce;
    }

    public boolean u(boolean canAlwaysEat) {
        return this.j.a || canAlwaysEat || this.ce.b();
    }

    public boolean gu() {
        return this.eD() > 0.0f && this.eD() < this.eS();
    }

    public boolean gv() {
        return this.j.e;
    }

    public boolean a(BlockPosition pos, EnumDirection facing, net.minecraft.world.item.ItemStack stack) {
        if (this.j.e) {
            return true;
        }
        BlockPosition blockPos = pos.a(facing.g());
        ShapeDetectorBlock blockInWorld = new ShapeDetectorBlock(this.dV(), blockPos, false);
        return stack.a(blockInWorld);
    }

    @Override
    protected int e(WorldServer level) {
        return !level.O().b(GameRules.d) && !this.Z_() ? Math.min(this.cr * 7, 100) : 0;
    }

    @Override
    protected boolean eo() {
        return true;
    }

    @Override
    public boolean cM() {
        return true;
    }

    @Override
    protected Entity.MovementEmission bg() {
        return this.j.b || this.aJ() && this.cg() ? Entity.MovementEmission.a : Entity.MovementEmission.d;
    }

    public void x() {
    }

    @Override
    public IChatBaseComponent al() {
        return IChatBaseComponent.b(this.cC.getName());
    }

    public InventoryEnderChest gw() {
        return this.cb;
    }

    @Override
    public net.minecraft.world.item.ItemStack a(EnumItemSlot slot1) {
        if (slot1 == EnumItemSlot.a) {
            return this.g.f();
        }
        if (slot1 == EnumItemSlot.b) {
            return (net.minecraft.world.item.ItemStack)this.g.i.getFirst();
        }
        return slot1.a() == EnumItemSlot.Function.b ? this.g.h.get(slot1.b()) : net.minecraft.world.item.ItemStack.j;
    }

    @Override
    protected boolean b(EnumItemSlot slot) {
        return slot.a() == EnumItemSlot.Function.b;
    }

    @Override
    public void a(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack, boolean silent) {
        this.c(stack);
        if (slot == EnumItemSlot.a) {
            this.onEquipItem(slot, this.g.g.set(this.g.j, stack), stack, silent);
        } else if (slot == EnumItemSlot.b) {
            this.onEquipItem(slot, this.g.i.set(0, stack), stack, silent);
        } else if (slot.a() == EnumItemSlot.Function.b) {
            this.onEquipItem(slot, this.g.h.set(slot.b(), stack), stack, silent);
        }
    }

    public boolean i(net.minecraft.world.item.ItemStack stack) {
        return this.g.f(stack);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> fc() {
        return Lists.newArrayList((Object[])new net.minecraft.world.item.ItemStack[]{this.eZ(), this.fa()});
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> fb() {
        return this.g.h;
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.g;
    }

    public boolean h(NBTTagCompound entityCompound) {
        if (this.bZ() || !this.aJ() || this.bj() || this.av) {
            return false;
        }
        if (this.gA().g()) {
            this.i(entityCompound);
            this.f = this.dV().ad();
            return true;
        }
        if (this.gB().g()) {
            this.j(entityCompound);
            this.f = this.dV().ad();
            return true;
        }
        return false;
    }

    public void gx() {
        if (this.f + 20L < this.dV().ad()) {
            if (this.respawnEntityOnShoulder(this.gA())) {
                this.i(new NBTTagCompound());
            }
            if (this.respawnEntityOnShoulder(this.gB())) {
                this.j(new NBTTagCompound());
            }
        }
    }

    public Entity releaseLeftShoulderEntity() {
        Entity entity = this.respawnEntityOnShoulder0(this.gA());
        if (entity != null) {
            this.i(new NBTTagCompound());
        }
        return entity;
    }

    public Entity releaseRightShoulderEntity() {
        Entity entity = this.respawnEntityOnShoulder0(this.gB());
        if (entity != null) {
            this.j(new NBTTagCompound());
        }
        return entity;
    }

    private boolean respawnEntityOnShoulder(NBTTagCompound entityCompound) {
        return this.respawnEntityOnShoulder0(entityCompound) != null;
    }

    @Nullable
    private Entity respawnEntityOnShoulder0(NBTTagCompound entityCompound) {
        if (!this.dV().C && !entityCompound.g()) {
            return EntityTypes.a(entityCompound, this.dV(), EntitySpawnReason.r).map(entity -> {
                if (entity instanceof EntityTameableAnimal) {
                    ((EntityTameableAnimal)entity).b(this.at);
                }
                entity.a_(this.dA(), this.dC() + (double)0.7f, this.dG());
                return ((WorldServer)this.dV()).addWithUUID((Entity)entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY) ? entity : null;
            }).orElse(null);
        }
        return null;
    }

    @Override
    public abstract boolean Z_();

    @Override
    public boolean bG() {
        return !this.Z_() && super.bG();
    }

    @Override
    public boolean ck() {
        return !this.j.b && !this.Z_() && super.ck();
    }

    public abstract boolean b();

    @Override
    public boolean cJ() {
        return !this.j.b;
    }

    public Scoreboard gy() {
        return this.dV().R();
    }

    @Override
    public IChatBaseComponent p_() {
        IChatMutableComponent mutableComponent = ScoreboardTeam.a(this.cr(), this.al());
        return this.a(mutableComponent);
    }

    private IChatMutableComponent a(IChatMutableComponent displayName) {
        String name = this.gh().getName();
        return displayName.a(style -> style.a(new ChatClickable(ChatClickable.EnumClickAction.d, "/tell " + name + " ")).a(this.cQ()).a(name));
    }

    @Override
    public String cI() {
        return this.gh().getName();
    }

    @Override
    protected void F(float absorptionAmount) {
        this.au().a(d, Float.valueOf(absorptionAmount));
    }

    @Override
    public float fw() {
        return this.au().a(d).floatValue();
    }

    public boolean a(PlayerModelPart part) {
        return (this.au().a(bW) & part.a()) == part.a();
    }

    @Override
    public SlotAccess a_(int slot) {
        if (slot == 499) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack a() {
                    return EntityHuman.this.cd.g();
                }

                @Override
                public boolean a(net.minecraft.world.item.ItemStack carried) {
                    EntityHuman.this.cd.b(carried);
                    return true;
                }
            };
        }
        final int i2 = slot - 500;
        if (i2 >= 0 && i2 < 4) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack a() {
                    return EntityHuman.this.cc.r().a(i2);
                }

                @Override
                public boolean a(net.minecraft.world.item.ItemStack carried) {
                    EntityHuman.this.cc.r().a(i2, carried);
                    EntityHuman.this.cc.a(EntityHuman.this.g);
                    return true;
                }
            };
        }
        if (slot >= 0 && slot < this.g.g.size()) {
            return SlotAccess.a(this.g, slot);
        }
        int i1 = slot - 200;
        return i1 >= 0 && i1 < this.cb.b() ? SlotAccess.a(this.cb, i1) : super.a_(slot);
    }

    public boolean gz() {
        return this.cD;
    }

    public void v(boolean reducedDebugInfo) {
        this.cD = reducedDebugInfo;
    }

    @Override
    public void h(int ticks) {
        super.h(this.j.a ? Math.min(ticks, 1) : ticks);
    }

    @Override
    public EnumMainHand fy() {
        return this.al.a(bX) == 0 ? EnumMainHand.a : EnumMainHand.b;
    }

    public void b(EnumMainHand hand) {
        this.al.a(bX, (byte)(hand != EnumMainHand.a ? 1 : 0));
    }

    public NBTTagCompound gA() {
        return this.al.a(bY);
    }

    public void i(NBTTagCompound entityCompound) {
        this.al.a(bY, entityCompound);
    }

    public NBTTagCompound gB() {
        return this.al.a(bZ);
    }

    public void j(NBTTagCompound entityCompound) {
        this.al.a(bZ, entityCompound);
    }

    public float gC() {
        return (float)(1.0 / this.h(GenericAttributes.e) * 20.0);
    }

    public float H(float adjustTicks) {
        return MathHelper.a(((float)this.aS + adjustTicks) / this.gC(), 0.0f, 1.0f);
    }

    public void gD() {
        this.aS = 0;
    }

    public ItemCooldown gE() {
        return this.cF;
    }

    @Override
    protected float aT() {
        return !this.j.b && !this.fJ() ? super.aT() : 1.0f;
    }

    public float gF() {
        return (float)this.h(GenericAttributes.q);
    }

    public boolean gG() {
        return this.j.d && this.G() >= 2;
    }

    public int G() {
        return 0;
    }

    public boolean s(int permissionLevel) {
        return this.G() >= permissionLevel;
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return c.getOrDefault((Object)pose, bV);
    }

    @Override
    public ImmutableList<EntityPose> fO() {
        return ImmutableList.of((Object)((Object)EntityPose.a), (Object)((Object)EntityPose.f), (Object)((Object)EntityPose.d));
    }

    protected boolean tryReadyArrow(net.minecraft.world.item.ItemStack bow, net.minecraft.world.item.ItemStack itemstack, MutableBoolean cancelled) {
        EntityHuman entityHuman = this;
        if (!(entityHuman instanceof EntityPlayer)) {
            return true;
        }
        EntityPlayer serverPlayer = (EntityPlayer)entityHuman;
        boolean notCancelled = new PlayerReadyArrowEvent((Player)serverPlayer.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(bow), (ItemStack)CraftItemStack.asCraftMirror(itemstack)).callEvent();
        if (!notCancelled) {
            cancelled.setValue(true);
        }
        return notCancelled;
    }

    @Override
    public net.minecraft.world.item.ItemStack d(net.minecraft.world.item.ItemStack shootable) {
        EntityHuman entityHuman;
        if (!(shootable.h() instanceof ItemProjectileWeapon)) {
            return net.minecraft.world.item.ItemStack.j;
        }
        MutableBoolean anyEventCancelled = new MutableBoolean();
        Predicate<net.minecraft.world.item.ItemStack> supportedHeldProjectiles = ((ItemProjectileWeapon)shootable.h()).d().and(item -> this.tryReadyArrow(shootable, (net.minecraft.world.item.ItemStack)item, anyEventCancelled));
        net.minecraft.world.item.ItemStack heldProjectile = ItemProjectileWeapon.a(this, supportedHeldProjectiles);
        if (!heldProjectile.f()) {
            return heldProjectile;
        }
        supportedHeldProjectiles = ((ItemProjectileWeapon)shootable.h()).b().and(item -> this.tryReadyArrow(shootable, (net.minecraft.world.item.ItemStack)item, anyEventCancelled));
        for (int i2 = 0; i2 < this.g.b(); ++i2) {
            net.minecraft.world.item.ItemStack item2 = this.g.a(i2);
            if (!supportedHeldProjectiles.test(item2)) continue;
            return item2;
        }
        if (anyEventCancelled.booleanValue() && !this.j.d && (entityHuman = this) instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityHuman;
            this.resyncUsingItem(player);
        }
        return this.j.d ? new net.minecraft.world.item.ItemStack(Items.pb) : net.minecraft.world.item.ItemStack.j;
    }

    @Override
    public Vec3D u(float partialTicks) {
        double d2 = 0.22 * (this.fy() == EnumMainHand.b ? -1.0 : 1.0);
        float f2 = MathHelper.h(partialTicks * 0.5f, this.dN(), this.O) * ((float)Math.PI / 180);
        float f1 = MathHelper.h(partialTicks, this.aY, this.aX) * ((float)Math.PI / 180);
        if (this.fJ() || this.fv()) {
            float f22;
            Vec3D viewVector = this.g(partialTicks);
            Vec3D deltaMovement = this.dy();
            double d1 = deltaMovement.j();
            double d22 = viewVector.j();
            if (d1 > 0.0 && d22 > 0.0) {
                double d3 = (deltaMovement.d * viewVector.d + deltaMovement.f * viewVector.f) / Math.sqrt(d1 * d22);
                double d4 = deltaMovement.d * viewVector.f - deltaMovement.f * viewVector.d;
                f22 = (float)(Math.signum(d4) * Math.acos(d3));
            } else {
                f22 = 0.0f;
            }
            return this.o(partialTicks).e(new Vec3D(d2, -0.11, 0.85).c(-f22).a(-f2).b(-f1));
        }
        if (this.cl()) {
            return this.o(partialTicks).e(new Vec3D(d2, 0.2, -0.15).a(-f2).b(-f1));
        }
        double d5 = this.cR().c() - 1.0;
        double d1 = this.ci() ? -0.2 : 0.07;
        return this.o(partialTicks).e(new Vec3D(d2, d5, d1).b(-f1));
    }

    @Override
    public boolean dU() {
        return true;
    }

    public boolean gH() {
        return this.fz() && this.fB().a(Items.rU);
    }

    @Override
    public boolean dT() {
        return false;
    }

    public Optional<GlobalPos> gI() {
        return this.cG;
    }

    public void c(Optional<GlobalPos> lastDeathLocation) {
        this.cG = lastDeathLocation;
    }

    @Override
    public float eJ() {
        return this.cx;
    }

    @Override
    public void p(float yaw) {
        super.p(yaw);
        this.cx = yaw;
    }

    @Override
    public boolean dO() {
        return true;
    }

    @Override
    protected float fo() {
        if (this.j.b && !this.bZ()) {
            return this.cj() ? this.j.a() * 2.0f : this.j.a();
        }
        return this.cj() ? 0.025999999f : 0.02f;
    }

    public boolean gJ() {
        return this.h;
    }

    public void gK() {
        if (!this.h) {
            --this.cg;
            if (this.cg <= 0) {
                this.h = true;
                PlayerClientLoadedWorldEvent event = new PlayerClientLoadedWorldEvent((Player)((CraftPlayer)this.getBukkitEntity()), true);
                event.callEvent();
            }
        }
    }

    public void w(boolean clientLoaded) {
        this.h = clientLoaded;
        if (!this.h) {
            this.cg = 60;
        }
    }

    public double gL() {
        return this.h(GenericAttributes.g);
    }

    public double gM() {
        return this.h(GenericAttributes.j);
    }

    public boolean b(Entity entity, double distance) {
        return !entity.dQ() && this.a(entity.cR(), distance);
    }

    public boolean a(AxisAlignedBB boundingBox, double distance) {
        double d2 = this.gM() + distance;
        return boundingBox.e(this.bF()) < d2 * d2;
    }

    public boolean a(BlockPosition pos, double distance) {
        double d2 = this.gL() + distance;
        return new AxisAlignedBB(pos).e(this.bF()) < d2 * d2;
    }

    public void x(boolean ignoreFallDamageFromCurrentImpulse) {
        this.cH = ignoreFallDamageFromCurrentImpulse;
        this.cI = ignoreFallDamageFromCurrentImpulse ? 40 : 0;
    }

    public boolean gN() {
        return this.cH;
    }

    public void gO() {
        if (this.cI == 0) {
            this.gP();
        }
    }

    public void gP() {
        this.cI = 0;
        this.cz = null;
        this.cy = null;
        this.cH = false;
    }

    public boolean gQ() {
        return false;
    }

    @Override
    public boolean di() {
        return true;
    }

    @Override
    public boolean q_() {
        return !this.j.b && super.q_();
    }

    public static final class EnumBedResult
    extends Enum<EnumBedResult> {
        public static final /* enum */ EnumBedResult a = new EnumBedResult();
        public static final /* enum */ EnumBedResult b = new EnumBedResult(IChatBaseComponent.c("block.minecraft.bed.no_sleep"));
        public static final /* enum */ EnumBedResult c = new EnumBedResult(IChatBaseComponent.c("block.minecraft.bed.too_far_away"));
        public static final /* enum */ EnumBedResult d = new EnumBedResult(IChatBaseComponent.c("block.minecraft.bed.obstructed"));
        public static final /* enum */ EnumBedResult e = new EnumBedResult();
        public static final /* enum */ EnumBedResult f = new EnumBedResult(IChatBaseComponent.c("block.minecraft.bed.not_safe"));
        @Nullable
        private final IChatBaseComponent g;
        private static final /* synthetic */ EnumBedResult[] h;

        public static EnumBedResult[] values() {
            return (EnumBedResult[])h.clone();
        }

        public static EnumBedResult valueOf(String name) {
            return Enum.valueOf(EnumBedResult.class, name);
        }

        private EnumBedResult() {
            this.g = null;
        }

        private EnumBedResult(IChatBaseComponent message) {
            this.g = message;
        }

        @Nullable
        public IChatBaseComponent a() {
            return this.g;
        }

        private static /* synthetic */ EnumBedResult[] b() {
            return new EnumBedResult[]{a, b, c, d, e, f};
        }

        static {
            h = EnumBedResult.b();
        }
    }
}

