/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.animal.horse.EntityLlamaTrader;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.storage.IWorldDataServer;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class MobSpawnerTrader
implements MobSpawner {
    private static final int b = 1200;
    public static final int a = 24000;
    private static final int c = 25;
    private static final int d = 75;
    private static final int e = 25;
    private static final int f = 10;
    private static final int g = 10;
    private final RandomSource h = RandomSource.a();
    private final IWorldDataServer i;
    private int j;
    private int k;
    private int l;

    public MobSpawnerTrader(IWorldDataServer serverLevelData) {
        this.i = serverLevelData;
        this.j = Integer.MIN_VALUE;
    }

    @Override
    public int a(WorldServer level, boolean spawnHostiles, boolean spawnPassives) {
        if (this.j == Integer.MIN_VALUE) {
            this.j = level.paperConfig().entities.spawning.wanderingTrader.spawnMinuteLength;
            this.k = level.paperConfig().entities.spawning.wanderingTrader.spawnDayLength;
            this.l = level.paperConfig().entities.spawning.wanderingTrader.spawnChanceMin;
        }
        if (!level.O().b(GameRules.M)) {
            return 0;
        }
        if (--this.j - 1 > 0) {
            --this.j;
            return 0;
        }
        this.j = level.paperConfig().entities.spawning.wanderingTrader.spawnMinuteLength;
        this.k -= level.paperConfig().entities.spawning.wanderingTrader.spawnMinuteLength;
        if (this.k > 0) {
            return 0;
        }
        this.k = level.paperConfig().entities.spawning.wanderingTrader.spawnDayLength;
        if (!level.O().b(GameRules.e)) {
            return 0;
        }
        int i2 = this.l;
        this.l = MathHelper.a(this.l + level.paperConfig().entities.spawning.wanderingTrader.spawnChanceFailureIncrement, level.paperConfig().entities.spawning.wanderingTrader.spawnChanceMin, level.paperConfig().entities.spawning.wanderingTrader.spawnChanceMax);
        if (this.h.a(100) > i2) {
            return 0;
        }
        if (this.a(level)) {
            this.l = level.paperConfig().entities.spawning.wanderingTrader.spawnChanceMin;
            return 1;
        }
        return 0;
    }

    private boolean a(WorldServer serverLevel) {
        EntityPlayer randomPlayer = serverLevel.k();
        if (randomPlayer == null) {
            return true;
        }
        if (this.h.a(10) != 0) {
            return false;
        }
        BlockPosition blockPos = randomPlayer.dv();
        int i2 = 48;
        VillagePlace poiManager = serverLevel.A();
        Optional<BlockPosition> optional = poiManager.d(holder -> holder.a(PoiTypes.o), blockPos3 -> true, blockPos, 48, VillagePlace.Occupancy.c);
        BlockPosition blockPos1 = optional.orElse(blockPos);
        BlockPosition blockPos2 = this.a((IWorldReader)serverLevel, blockPos1, 48);
        if (blockPos2 != null && this.a(serverLevel, blockPos2)) {
            if (serverLevel.t(blockPos2).a(BiomeTags.ah)) {
                return false;
            }
            EntityVillagerTrader wanderingTrader = EntityTypes.bE.spawn(serverLevel, trader -> trader.t(48000), blockPos2, EntitySpawnReason.h, false, false, CreatureSpawnEvent.SpawnReason.NATURAL);
            if (wanderingTrader != null) {
                for (int i1 = 0; i1 < 2; ++i1) {
                    this.a(serverLevel, wanderingTrader, 4);
                }
                this.i.a(wanderingTrader.cG());
                wanderingTrader.h(blockPos1);
                wanderingTrader.a(blockPos1, 16);
                return true;
            }
        }
        return false;
    }

    private void a(WorldServer serverLevel, EntityVillagerTrader trader, int maxDistance) {
        EntityLlamaTrader traderLlama;
        BlockPosition blockPos = this.a((IWorldReader)serverLevel, trader.dv(), maxDistance);
        if (blockPos != null && (traderLlama = EntityTypes.bx.spawn(serverLevel, blockPos, EntitySpawnReason.h, CreatureSpawnEvent.SpawnReason.NATURAL)) != null) {
            traderLlama.b((Entity)trader, true);
        }
    }

    @Nullable
    private BlockPosition a(IWorldReader level, BlockPosition pos, int maxDistance) {
        BlockPosition blockPos = null;
        SpawnPlacementType placementType = EntityPositionTypes.a(EntityTypes.bE);
        for (int i2 = 0; i2 < 10; ++i2) {
            int i22;
            int height;
            int i1 = pos.u() + this.h.a(maxDistance * 2) - maxDistance;
            BlockPosition blockPos1 = new BlockPosition(i1, height = level.a(HeightMap.Type.b, i1, i22 = pos.w() + this.h.a(maxDistance * 2) - maxDistance), i22);
            if (!placementType.isSpawnPositionOk(level, blockPos1, EntityTypes.bE)) continue;
            blockPos = blockPos1;
            break;
        }
        return blockPos;
    }

    private boolean a(IBlockAccess level, BlockPosition pos) {
        for (BlockPosition blockPos : BlockPosition.c(pos, pos.b(1, 2, 1))) {
            if (level.a_(blockPos).g(level, blockPos).c()) continue;
            return false;
        }
        return true;
    }
}

