/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.Behaviors;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorGolemLastSeen;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.VillagerReplenishTradeEvent;
import org.bukkit.inventory.MerchantRecipe;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class EntityVillager
extends EntityVillagerAbstract
implements ReputationHandler,
VillagerDataHolder {
    private static final Logger ce = LogUtils.getLogger();
    private static final DataWatcherObject<VillagerData> cf = DataWatcher.a(EntityVillager.class, DataWatcherRegistry.u);
    public static final int ca = 12;
    public static final Map<Item, Integer> cb = ImmutableMap.of((Object)Items.qc, (Object)4, (Object)Items.vf, (Object)1, (Object)Items.ve, (Object)1, (Object)Items.wk, (Object)1);
    private static final int cg = 2;
    private static final int ch = 10;
    private static final int ci = 1200;
    private static final int cj = 24000;
    private static final int ck = 10;
    private static final int cl = 5;
    private static final long cm = 24000L;
    @VisibleForTesting
    public static final float cc = 0.5f;
    private int cn;
    private boolean co;
    @Nullable
    private EntityHuman cp;
    private boolean cq;
    private int cr;
    private final Reputation cs = new Reputation();
    private long ct;
    private long cu;
    private int cv;
    private long cw;
    public int cx;
    private long cy;
    private boolean cz;
    private static final ImmutableList<MemoryModuleType<?>> cC = ImmutableList.of(MemoryModuleType.b, MemoryModuleType.c, MemoryModuleType.d, MemoryModuleType.e, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.i, MemoryModuleType.j, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.L, MemoryModuleType.aP, (Object[])new MemoryModuleType[]{MemoryModuleType.m, MemoryModuleType.n, MemoryModuleType.q, MemoryModuleType.r, MemoryModuleType.t, MemoryModuleType.v, MemoryModuleType.w, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.A, MemoryModuleType.f, MemoryModuleType.C, MemoryModuleType.D, MemoryModuleType.E, MemoryModuleType.H, MemoryModuleType.I, MemoryModuleType.J, MemoryModuleType.F});
    private static final ImmutableList<SensorType<? extends Sensor<? super EntityVillager>>> cD = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.e, SensorType.f, SensorType.g, SensorType.h, SensorType.i, SensorType.j);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<EntityVillager, Holder<VillagePlaceType>>> cd = ImmutableMap.of(MemoryModuleType.b, (villager, holder) -> holder.a(PoiTypes.n), MemoryModuleType.c, (villager, holder) -> villager.gC().b().b().test((Holder<VillagePlaceType>)holder), MemoryModuleType.d, (villager, holder) -> VillagerProfession.a.test((Holder<VillagePlaceType>)holder), MemoryModuleType.e, (villager, holder) -> holder.a(PoiTypes.o));

    public EntityVillager(EntityTypes<? extends EntityVillager> entityType, World level) {
        this(entityType, level, VillagerType.c);
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> entityType, World level, VillagerType villagerType) {
        super((EntityTypes<? extends EntityVillagerAbstract>)entityType, level);
        ((Navigation)this.P()).b(true);
        this.P().a(true);
        this.P().a(48.0f);
        this.a_(true);
        this.a(this.gC().a(villagerType).a(VillagerProfession.b));
    }

    public BehaviorController<EntityVillager> eb() {
        return super.eb();
    }

    protected BehaviorController.b<EntityVillager> ec() {
        return BehaviorController.a(cC, cD);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        BehaviorController<EntityVillager> brain = this.ec().a(dynamic);
        this.a(brain);
        return brain;
    }

    public void g(WorldServer serverLevel) {
        BehaviorController<EntityVillager> brain = this.eb();
        brain.b(serverLevel, this);
        this.bE = brain.i();
        this.a(this.eb());
    }

    @Override
    private void a(BehaviorController<EntityVillager> villagerBrain) {
        VillagerProfession profession = this.gC().b();
        if (this.e_()) {
            villagerBrain.a(Schedule.e);
            villagerBrain.a(Activity.d, Behaviors.a(0.5f));
        } else {
            villagerBrain.a(Schedule.f);
            villagerBrain.a(Activity.c, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.b(profession, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.c, (Object)((Object)MemoryStatus.a))));
        }
        villagerBrain.a(Activity.a, Behaviors.a(profession, 0.5f));
        villagerBrain.a(Activity.f, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.d(profession, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.e, (Object)((Object)MemoryStatus.a))));
        villagerBrain.a(Activity.e, Behaviors.c(profession, 0.5f));
        villagerBrain.a(Activity.b, Behaviors.e(profession, 0.5f));
        villagerBrain.a(Activity.g, Behaviors.f(profession, 0.5f));
        villagerBrain.a(Activity.i, Behaviors.g(profession, 0.5f));
        villagerBrain.a(Activity.h, Behaviors.h(profession, 0.5f));
        villagerBrain.a(Activity.j, Behaviors.i(profession, 0.5f));
        villagerBrain.a((Set<Activity>)ImmutableSet.of((Object)Activity.a));
        villagerBrain.b(Activity.b);
        villagerBrain.a(Activity.b);
        villagerBrain.a(this.dV().ae(), this.dV().ad());
    }

    @Override
    protected void i() {
        super.i();
        if (this.dV() instanceof WorldServer) {
            this.g((WorldServer)this.dV());
        }
    }

    public static AttributeProvider.Builder gB() {
        return EntityInsentient.F().a(GenericAttributes.v, 0.5);
    }

    public boolean gD() {
        return this.cz;
    }

    @Override
    public void inactiveTick() {
        if (this.p() > 0) {
            this.r(this.p() - 1);
        }
        if (this.dj()) {
            if (this.dV().spigotConfig.tickInactiveVillagers) {
                this.a(this.dV().getMinecraftWorld());
            } else {
                this.customServerAiStep(this.dV().getMinecraftWorld(), true);
            }
        }
        this.ha();
        super.inactiveTick();
    }

    @Override
    protected void a(WorldServer level) {
        this.customServerAiStep(level, false);
    }

    protected void customServerAiStep(WorldServer level, boolean inactive) {
        Raid raidAt;
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("villagerBrain");
        if (!inactive) {
            this.eb().a(level, this);
        }
        profilerFiller.c();
        if (this.cz) {
            this.cz = false;
        }
        if (!this.gt() && this.cn > 0) {
            --this.cn;
            if (this.cn <= 0) {
                if (this.co) {
                    this.gY();
                    this.co = false;
                }
                this.addEffect(new MobEffect(MobEffects.j, 200, 0), EntityPotionEffectEvent.Cause.VILLAGER_TRADE);
            }
        }
        if (this.cp != null) {
            level.a(ReputationEvent.e, (Entity)this.cp, this);
            level.a((Entity)this, (byte)14);
            this.cp = null;
        }
        if (!inactive && !this.gf() && this.ae.a(100) == 0 && (raidAt = level.d(this.dv())) != null && raidAt.u() && !raidAt.a()) {
            level.a((Entity)this, (byte)42);
        }
        if (this.gC().b() == VillagerProfession.b && this.gt()) {
            this.gy();
        }
        if (inactive) {
            return;
        }
        super.a(level);
    }

    @Override
    public void h() {
        super.h();
        if (this.p() > 0) {
            this.r(this.p() - 1);
        }
        this.ha();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.uG) || !this.bL() || this.gt() || this.fR()) {
            return super.b(player, hand);
        }
        if (this.e_()) {
            this.gN();
            return EnumInteractionResult.a;
        }
        if (!this.dV().C) {
            boolean isEmpty = this.gu().isEmpty();
            if (hand == EnumHand.a) {
                if (isEmpty) {
                    this.gN();
                }
                player.a(StatisticList.S);
            }
            if (isEmpty) {
                return EnumInteractionResult.c;
            }
            this.h(player);
        }
        return EnumInteractionResult.a;
    }

    public void gN() {
        this.r(40);
        if (!this.dV().B_()) {
            this.b(SoundEffects.BK);
        }
    }

    private void h(EntityHuman player) {
        this.i(player);
        this.a(player);
        this.a(player, this.p_(), this.gC().c());
    }

    @Override
    public void a(@Nullable EntityHuman player) {
        boolean flag = this.gs() != null && player == null;
        super.a(player);
        if (flag) {
            this.gy();
        }
    }

    @Override
    protected void gy() {
        super.gy();
        this.gO();
    }

    private void gO() {
        if (!this.dV().B_()) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.gu()) {
                merchantOffer.n();
            }
        }
    }

    @Override
    public boolean gE() {
        return true;
    }

    public void gF() {
        this.gT();
        for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.gu()) {
            VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantOffer.asBukkit());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            merchantOffer.j();
        }
        this.gP();
        this.cw = this.dV().ad();
        ++this.cx;
    }

    private void gP() {
        MerchantRecipeList offers = this.gu();
        EntityHuman tradingPlayer = this.gs();
        if (tradingPlayer != null && !offers.isEmpty()) {
            tradingPlayer.a(tradingPlayer.cd.l, offers, this.gC().c(), this.x(), this.gv(), this.gE());
        }
    }

    private boolean gQ() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.gu()) {
            if (!merchantOffer.t()) continue;
            return true;
        }
        return false;
    }

    private boolean gR() {
        return this.cx == 0 || this.cx < 2 && this.dV().ad() > this.cw + 2400L;
    }

    public boolean gG() {
        long l2 = this.cw + 12000L;
        long gameTime = this.dV().ad();
        boolean flag = gameTime > l2;
        long dayTime = this.dV().ae();
        if (this.cy > 0L) {
            long l22 = dayTime / 24000L;
            long l1 = this.cy / 24000L;
            flag |= l22 > l1;
        }
        this.cy = dayTime;
        if (flag) {
            this.cw = gameTime;
            this.hb();
        }
        return this.gR() && this.gQ();
    }

    private void gS() {
        int i2 = 2 - this.cx;
        if (i2 > 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.gu()) {
                VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantOffer.asBukkit());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                merchantOffer.j();
            }
        }
        for (int i1 = 0; i1 < i2; ++i1) {
            this.gT();
        }
        this.gP();
    }

    private void gT() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.gu()) {
            merchantOffer.g();
        }
    }

    private void i(EntityHuman player) {
        int playerReputation = this.g(player);
        if (playerReputation != 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.gu()) {
                if (merchantOffer.ignoreDiscounts) continue;
                merchantOffer.a(-MathHelper.d((float)playerReputation * merchantOffer.p()));
            }
        }
        if (player.b(MobEffects.F)) {
            MobEffect effect = player.c(MobEffects.F);
            int amplifier = effect.e();
            for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer1 : this.gu()) {
                if (merchantOffer1.ignoreDiscounts) continue;
                double d2 = 0.3 + 0.0625 * (double)amplifier;
                int i2 = (int)Math.floor(d2 * (double)merchantOffer1.a().M());
                merchantOffer1.a(-Math.max(i2, 1));
            }
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cf, new VillagerData(VillagerType.c, VillagerProfession.b, 1));
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        VillagerData.c.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.gC()).resultOrPartial(arg_0 -> ((Logger)ce).error(arg_0)).ifPresent(tag -> compound.a("VillagerData", (NBTBase)tag));
        compound.a("FoodLevel", (byte)this.cr);
        compound.a("Gossips", this.cs.a(DynamicOpsNBT.a));
        compound.a("Xp", this.cv);
        compound.a("LastRestock", this.cw);
        compound.a("LastGossipDecay", this.cu);
        compound.a("RestocksToday", this.cx);
        if (this.cz) {
            compound.a("AssignProfessionWhenSpawned", true);
        }
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        if (compound.b("VillagerData", 10)) {
            VillagerData.c.parse((DynamicOps)DynamicOpsNBT.a, (Object)compound.c("VillagerData")).resultOrPartial(arg_0 -> ((Logger)ce).error(arg_0)).ifPresent(villagerData -> this.al.a(cf, villagerData));
        }
        if (compound.b("FoodLevel", 1)) {
            this.cr = compound.f("FoodLevel");
        }
        NBTTagList list = compound.c("Gossips", 10);
        this.cs.a(new Dynamic<NBTTagList>(DynamicOpsNBT.a, list));
        if (compound.b("Xp", 3)) {
            this.cv = compound.h("Xp");
        }
        this.cw = compound.i("LastRestock");
        this.cu = compound.i("LastGossipDecay");
        if (this.dV() instanceof WorldServer) {
            this.g((WorldServer)this.dV());
        }
        this.cx = compound.h("RestocksToday");
        if (compound.e("AssignProfessionWhenSpawned")) {
            this.cz = compound.q("AssignProfessionWhenSpawned");
        }
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    @Nullable
    protected SoundEffect u() {
        if (this.fR()) {
            return null;
        }
        return this.gt() ? SoundEffects.BL : SoundEffects.BG;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.BJ;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.BI;
    }

    public void gH() {
        this.b(this.gC().b().f());
    }

    @Override
    public void a(VillagerData data) {
        VillagerData villagerData = this.gC();
        if (villagerData.b() != data.b()) {
            this.bZ = null;
        }
        this.al.a(cf, data);
    }

    @Override
    public VillagerData gC() {
        return this.al.a(cf);
    }

    @Override
    protected void b(net.minecraft.world.item.trading.MerchantRecipe offer) {
        int i2 = 3 + this.ae.a(4);
        this.cv += offer.q();
        this.cp = this.gs();
        if (this.gX()) {
            this.cn = 40;
            this.co = true;
            i2 += 5;
        }
        if (offer.u()) {
            this.dV().b(new EntityExperienceOrb(this.dV(), this.dA(), this.dC() + 0.5, this.dG(), i2, ExperienceOrb.SpawnReason.VILLAGER_TRADE, this.gs(), this));
        }
    }

    @Override
    public void a(@Nullable EntityLiving livingBase) {
        if (livingBase != null && this.dV() instanceof WorldServer) {
            ((WorldServer)this.dV()).a(ReputationEvent.c, (Entity)livingBase, this);
            if (this.bL() && livingBase instanceof EntityHuman) {
                this.dV().a((Entity)this, (byte)13);
            }
        }
        super.a(livingBase);
    }

    @Override
    public void a(DamageSource cause) {
        Entity entity;
        if (SpigotConfig.logVillagerDeaths) {
            ce.info("Villager {} died, message: '{}'", (Object)this, (Object)cause.a(this).getString());
        }
        if ((entity = cause.d()) != null) {
            this.b(entity);
        }
        this.gU();
        super.a(cause);
    }

    public void gU() {
        this.a(MemoryModuleType.b);
        this.a(MemoryModuleType.c);
        this.a(MemoryModuleType.d);
        this.a(MemoryModuleType.e);
    }

    private void b(Entity murderer) {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            Optional<NearestVisibleLivingEntities> memory = this.bE.c(MemoryModuleType.h);
            if (!memory.isEmpty()) {
                memory.get().b(ReputationHandler.class::isInstance).forEach(livingEntity -> serverLevel.a(ReputationEvent.d, murderer, (ReputationHandler)((Object)livingEntity)));
            }
        }
    }

    @Override
    public void a(MemoryModuleType<GlobalPos> moduleType) {
        if (this.dV() instanceof WorldServer) {
            MinecraftServer server = ((WorldServer)this.dV()).p();
            this.bE.c(moduleType).ifPresent(globalPos -> {
                WorldServer level = server.a(globalPos.a());
                if (level != null) {
                    VillagePlace poiManager = level.A();
                    Optional<Holder<VillagePlaceType>> type = poiManager.c(globalPos.b());
                    BiPredicate<EntityVillager, Holder<VillagePlaceType>> biPredicate = cd.get(moduleType);
                    if (type.isPresent() && biPredicate.test(this, type.get())) {
                        poiManager.b(globalPos.b());
                        PacketDebug.c(level, globalPos.b());
                    }
                }
            });
        }
    }

    @Override
    public boolean X_() {
        return this.cr + this.gZ() >= 12 && !this.fR() && this.Y_() == 0;
    }

    private boolean gV() {
        return this.cr < 12;
    }

    private void gW() {
        if (this.gV() && this.gZ() != 0) {
            for (int i2 = 0; i2 < this.t().b(); ++i2) {
                int count;
                Integer integer;
                ItemStack item = this.t().a(i2);
                if (item.f() || (integer = cb.get(item.h())) == null) continue;
                for (int i1 = count = item.M(); i1 > 0; --i1) {
                    this.cr += integer.intValue();
                    this.t().a(i2, 1);
                    if (this.gV()) continue;
                    return;
                }
            }
        }
    }

    public int g(EntityHuman player) {
        return this.cs.a(player.cG(), (ReputationType gossipType) -> true);
    }

    private void u(int qty) {
        this.cr -= qty;
    }

    public void gI() {
        this.gW();
        this.u(12);
    }

    public void b(MerchantRecipeList offers) {
        this.bZ = offers;
    }

    private boolean gX() {
        int level = this.gC().c();
        return VillagerData.d(level) && this.cv >= VillagerData.c(level);
    }

    public void gY() {
        this.a(this.gC().a(this.gC().c() + 1));
        this.gz();
    }

    @Override
    protected IChatBaseComponent cz() {
        return IChatBaseComponent.c(this.aq().g() + "." + BuiltInRegistries.x.b(this.gC().b()).a());
    }

    @Override
    public void b(byte id) {
        if (id == 12) {
            this.a(Particles.R);
        } else if (id == 13) {
            this.a(Particles.a);
        } else if (id == 14) {
            this.a(Particles.P);
        } else if (id == 42) {
            this.a(Particles.ao);
        } else {
            super.b(id);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (spawnReason == EntitySpawnReason.e) {
            this.a(this.gC().a(VillagerProfession.b));
        }
        if (spawnReason == EntitySpawnReason.n || spawnReason == EntitySpawnReason.m || EntitySpawnReason.a(spawnReason) || spawnReason == EntitySpawnReason.o) {
            this.a(this.gC().a(VillagerType.a(level.t(this.dv()))));
        }
        if (spawnReason == EntitySpawnReason.d) {
            this.cz = true;
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Nullable
    public EntityVillager b(WorldServer level, EntityAgeable otherParent) {
        double randomDouble = this.ae.j();
        VillagerType villagerType = randomDouble < 0.5 ? VillagerType.a(level.t(this.dv())) : (randomDouble < 0.75 ? this.gC().a() : ((EntityVillager)otherParent).gC().a());
        EntityVillager villager = new EntityVillager(EntityTypes.bC, level, villagerType);
        villager.a((WorldAccess)level, level.d_(villager.dv()), EntitySpawnReason.e, null);
        return villager;
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        if (level.am() != EnumDifficulty.a) {
            EntityWitch witch = this.convertTo(EntityTypes.bH, ConversionParams.a(this, false, false), (T mob) -> {
                if (CraftEventFactory.callEntityZapEvent(this, lightning, mob).isCancelled()) {
                    return false;
                }
                if (SpigotConfig.logVillagerDeaths) {
                    ce.info("Villager {} was struck by lightning {}.", (Object)this, (Object)lightning);
                }
                mob.a((WorldAccess)level, level.d_(mob.dv()), EntitySpawnReason.i, null);
                mob.fY();
                this.gU();
                return true;
            }, EntityTransformEvent.TransformReason.LIGHTNING, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            if (witch == null) {
                super.a(level, lightning);
            }
        } else {
            super.a(level, lightning);
        }
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        InventoryCarrier.a(level, this, this, entity);
    }

    @Override
    public boolean c(WorldServer level, ItemStack stack) {
        Item item = stack.h();
        return (stack.a(TagsItem.bN) || this.gC().b().d().contains((Object)item)) && this.t().c(stack);
    }

    public boolean gJ() {
        return this.gZ() >= 24;
    }

    public boolean gK() {
        return this.gZ() < 12;
    }

    private int gZ() {
        InventorySubcontainer inventory = this.t();
        return cb.entrySet().stream().mapToInt(entry -> inventory.a_((Item)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    public boolean gL() {
        return this.t().a_((ItemStack itemStack) -> itemStack.a(TagsItem.bM));
    }

    @Override
    protected void gz() {
        this.updateTrades(2);
    }

    public boolean updateTrades(int amount) {
        VillagerTrades.IMerchantRecipeOption[] itemListings;
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> map;
        VillagerData villagerData = this.gC();
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> map1 = this.dV().K().b(FeatureFlags.b) ? ((map = VillagerTrades.c.get(villagerData.b())) != null ? map : VillagerTrades.a.get(villagerData.b())) : VillagerTrades.a.get(villagerData.b());
        if (map1 != null && !map1.isEmpty() && (itemListings = (VillagerTrades.IMerchantRecipeOption[])map1.get(villagerData.c())) != null) {
            MerchantRecipeList offers = this.gu();
            this.a(offers, itemListings, amount);
            return true;
        }
        return false;
    }

    public void a(WorldServer serverLevel, EntityVillager target, long gameTime) {
        if (!(gameTime >= this.ct && gameTime < this.ct + 1200L || gameTime >= target.ct && gameTime < target.ct + 1200L)) {
            this.cs.a(target.cs, this.ae, 10);
            this.ct = gameTime;
            target.ct = gameTime;
            this.a(serverLevel, gameTime, 5);
        }
    }

    private void ha() {
        long gameTime = this.dV().ad();
        if (this.cu == 0L) {
            this.cu = gameTime;
        } else if (gameTime >= this.cu + 24000L) {
            this.cs.b();
            this.cu = gameTime;
        }
    }

    public void a(WorldServer serverLevel, long gameTime, int minVillagerAmount) {
        AxisAlignedBB aabb;
        List<EntityVillager> entitiesOfClass;
        List<EntityVillager> list;
        if (this.a(gameTime) && (list = (entitiesOfClass = serverLevel.a(EntityVillager.class, aabb = this.cR().c(10.0, 10.0, 10.0))).stream().filter(villager -> villager.a(gameTime)).limit(5L).toList()).size() >= minVillagerAmount && SpawnUtil.trySpawnMob(EntityTypes.ap, EntitySpawnReason.f, serverLevel, this.dv(), 10, 8, 6, SpawnUtil.a.a, false, CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE, () -> SensorGolemLastSeen.b(this)).isPresent()) {
            entitiesOfClass.forEach(SensorGolemLastSeen::b);
        }
    }

    public boolean a(long gameTime) {
        return this.b(this.dV().ad()) && !this.bE.a(MemoryModuleType.F);
    }

    @Override
    public void a(ReputationEvent type, Entity target) {
        if (type == ReputationEvent.a) {
            this.cs.a(target.cG(), ReputationType.d, 20);
            this.cs.a(target.cG(), ReputationType.c, 25);
        } else if (type == ReputationEvent.e) {
            this.cs.a(target.cG(), ReputationType.e, 2);
        } else if (type == ReputationEvent.c) {
            this.cs.a(target.cG(), ReputationType.b, 25);
        } else if (type == ReputationEvent.d) {
            this.cs.a(target.cG(), ReputationType.a, 25);
        }
    }

    @Override
    public int x() {
        return this.cv;
    }

    public void t(int villagerXp) {
        this.cv = villagerXp;
    }

    private void hb() {
        this.gS();
        this.cx = 0;
    }

    public Reputation gM() {
        return this.cs;
    }

    @Override
    public void a(NBTBase gossip) {
        this.cs.a(new Dynamic<NBTBase>(DynamicOpsNBT.a, gossip));
    }

    @Override
    protected void ac() {
        super.ac();
        PacketDebug.a(this);
    }

    @Override
    public void b(BlockPosition pos) {
        super.b(pos);
        this.bE.a(MemoryModuleType.H, Long.valueOf(this.dV().ad()));
        this.bE.b(MemoryModuleType.m);
        this.bE.b(MemoryModuleType.E);
    }

    @Override
    public void fS() {
        super.fS();
        this.bE.a(MemoryModuleType.I, Long.valueOf(this.dV().ad()));
    }

    private boolean b(long gameTime) {
        Optional<Long> memory = this.bE.c(MemoryModuleType.H);
        return memory.filter(_long -> gameTime - _long < 24000L).isPresent();
    }
}

