/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.WardenAngerChangeEvent;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.warden.SonicBoom;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.monster.warden.WardenAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;

public class Warden
extends EntityMonster
implements VibrationSystem {
    private static final Logger ca = LogUtils.getLogger();
    private static final int cb = 40;
    private static final int cc = 200;
    private static final int cd = 500;
    private static final float ce = 0.3f;
    private static final float cf = 1.0f;
    private static final float cg = 1.5f;
    private static final int ch = 30;
    private static final int ci = 24;
    private static final DataWatcherObject<Integer> cj = DataWatcher.a(Warden.class, DataWatcherRegistry.b);
    private static final int ck = 200;
    private static final int cl = 260;
    private static final int cm = 20;
    private static final int cn = 120;
    private static final int co = 20;
    private static final int cp = 35;
    private static final int cq = 10;
    private static final int cr = 20;
    private static final int cs = 100;
    private static final int ct = 20;
    private static final int cu = 30;
    private static final float cv = 4.5f;
    private static final float cw = 0.7f;
    private static final int cx = 30;
    private int cy;
    private int cz;
    private int cC;
    private int cD;
    public AnimationState a = new AnimationState();
    public AnimationState b = new AnimationState();
    public AnimationState c = new AnimationState();
    public AnimationState d = new AnimationState();
    public AnimationState bY = new AnimationState();
    public AnimationState bZ = new AnimationState();
    private final DynamicGameEventListener<VibrationSystem.b> cE;
    private final VibrationSystem.d cF;
    private VibrationSystem.a cG;
    AngerManagement cH = new AngerManagement(this::b, Collections.emptyList());

    public Warden(EntityTypes<? extends EntityMonster> entityType, World level) {
        super(entityType, level);
        this.cF = new a();
        this.cG = new VibrationSystem.a();
        this.cE = new DynamicGameEventListener<VibrationSystem.b>(new VibrationSystem.b(this));
        this.bN = 5;
        this.P().a(true);
        this.a(PathType.m, 0.0f);
        this.a(PathType.q, 8.0f);
        this.a(PathType.f, 8.0f);
        this.a(PathType.i, 8.0f);
        this.a(PathType.o, 0.0f);
        this.a(PathType.n, 0.0f);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        return new PacketPlayOutSpawnEntity((Entity)this, entity, this.c(EntityPose.n) ? 1 : 0);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        if (packet.p() == 1) {
            this.b(EntityPose.n);
        }
    }

    @Override
    public boolean a(IWorldReader level) {
        return super.a(level) && level.a((Entity)this, this.aq().n().a(this.dt()));
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return 0.0f;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource) {
        return this.gv() && !damageSource.a(DamageTypeTags.d) || super.a(level, damageSource);
    }

    boolean gv() {
        return this.c(EntityPose.o) || this.c(EntityPose.n);
    }

    @Override
    protected boolean o(Entity vehicle) {
        return false;
    }

    @Override
    public boolean fU() {
        return true;
    }

    @Override
    protected float aU() {
        return this.X + 0.55f;
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gx().a(GenericAttributes.s, 500.0).a(GenericAttributes.v, 0.3f).a(GenericAttributes.p, 1.0).a(GenericAttributes.d, 1.5).a(GenericAttributes.c, 30.0).a(GenericAttributes.m, 24.0);
    }

    @Override
    public boolean bh() {
        return true;
    }

    @Override
    public float fg() {
        return 4.0f;
    }

    @Override
    @Nullable
    protected SoundEffect u() {
        return !this.c(EntityPose.l) && !this.gv() ? this.t().b() : null;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.CC;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.Cy;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.CM, 10.0f, 1.0f);
    }

    @Override
    public boolean c(WorldServer level, Entity source) {
        level.a((Entity)this, (byte)4);
        this.a(SoundEffects.Cx, 10.0f, this.fh());
        SonicBoom.a((EntityLiving)this, 40);
        return super.c(level, source);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cj, 0);
    }

    public int p() {
        return this.al.a(cj);
    }

    private void gy() {
        this.al.a(cj, this.gB());
    }

    @Override
    public void h() {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            VibrationSystem.c.a((World)serverLevel, this.cG, this.cF);
            if (this.fZ() || this.aa()) {
                WardenAi.a((EntityLiving)this);
            }
        }
        super.h();
        if (this.dV().B_()) {
            if (this.af % this.gz() == 0) {
                this.cC = 10;
                if (!this.bb()) {
                    this.dV().a(this.dA(), this.dC(), this.dG(), SoundEffects.CB, this.dm(), 5.0f, this.fh(), false);
                }
            }
            this.cz = this.cy;
            if (this.cy > 0) {
                --this.cy;
            }
            this.cD = this.cC;
            if (this.cC > 0) {
                --this.cC;
            }
            switch (this.aw()) {
                case n: {
                    this.a(this.c);
                    break;
                }
                case o: {
                    this.a(this.d);
                }
            }
        }
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("wardenBrain");
        this.eb().a(level, this);
        profilerFiller.c();
        super.a(level);
        if ((this.af + this.ar()) % 120 == 0) {
            Warden.a(level, this.dt(), this, 20);
        }
        if (this.af % 20 == 0) {
            this.cH.a(level, this::b);
            this.gy();
        }
        WardenAi.a(this);
    }

    @Override
    public void b(byte id) {
        if (id == 4) {
            this.a.a();
            this.bY.a(this.af);
        } else if (id == 61) {
            this.cy = 10;
        } else if (id == 62) {
            this.bZ.a(this.af);
        } else {
            super.b(id);
        }
    }

    private int gz() {
        float f2 = (float)this.p() / (float)AngerLevel.c.a();
        return 40 - MathHelper.d(MathHelper.a(f2, 0.0f, 1.0f) * 30.0f);
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.cz, this.cy) / 10.0f;
    }

    public float K(float partialTick) {
        return MathHelper.h(partialTick, this.cD, this.cC) / 10.0f;
    }

    private void a(AnimationState animationState) {
        if ((float)animationState.a((float)this.af) < 4500.0f) {
            RandomSource random = this.dY();
            IBlockData blockStateOn = this.bu();
            if (blockStateOn.o() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    double d2 = this.dA() + (double)MathHelper.b(random, -0.7f, 0.7f);
                    double y2 = this.dC();
                    double d1 = this.dG() + (double)MathHelper.b(random, -0.7f, 0.7f);
                    this.dV().a(new ParticleParamBlock(Particles.b, blockStateOn), d2, y2, d1, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (Entity.aq.equals(key)) {
            switch (this.aw()) {
                case n: {
                    this.c.a(this.af);
                    break;
                }
                case o: {
                    this.d.a(this.af);
                    break;
                }
                case l: {
                    this.a.a(this.af);
                    break;
                }
                case m: {
                    this.b.a(this.af);
                }
            }
        }
        super.a(key);
    }

    @Override
    public boolean a(Explosion explosion) {
        return this.gv();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return WardenAi.a(this, dynamic);
    }

    public BehaviorController<Warden> eb() {
        return super.eb();
    }

    @Override
    protected void ac() {
        super.ac();
        PacketDebug.a(this);
    }

    @Override
    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> listenerConsumer) {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            listenerConsumer.accept(this.cE, serverLevel);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Contract(value="null->false")
    public boolean b(@Nullable Entity entity) {
        if (!(entity instanceof EntityLiving)) return false;
        EntityLiving livingEntity = (EntityLiving)entity;
        if (this.dV() != entity.dV()) return false;
        if (!IEntitySelector.e.test(entity)) return false;
        if (this.s(entity)) return false;
        if (livingEntity.aq() == EntityTypes.f) return false;
        if (livingEntity.aq() == EntityTypes.bF) return false;
        if (livingEntity.cC()) return false;
        if (livingEntity.eE()) return false;
        if (!this.dV().F_().a(livingEntity.cR())) return false;
        return true;
    }

    public static void a(WorldServer level, Vec3D pos, @Nullable Entity source, int radius) {
        MobEffect mobEffectInstance = new MobEffect(MobEffects.G, 260, 0, false, false);
        MobEffectUtil.addEffectToPlayersAround(level, source, pos, radius, mobEffectInstance, 200, EntityPotionEffectEvent.Cause.WARDEN);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        AngerManagement.a(this::b).encodeStart(registryOps, (Object)this.cH).resultOrPartial(string -> ca.error("Failed to encode anger state for Warden: '{}'", string)).ifPresent(tag -> compound.a("anger", (NBTBase)tag));
        VibrationSystem.a.a.encodeStart(registryOps, (Object)this.cG).resultOrPartial(string -> ca.error("Failed to encode vibration listener for Warden: '{}'", string)).ifPresent(tag -> compound.a("listener", (NBTBase)tag));
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        if (compound.e("anger")) {
            AngerManagement.a(this::b).parse(registryOps, (Object)compound.c("anger")).resultOrPartial(string -> ca.error("Failed to parse anger state for Warden: '{}'", string)).ifPresent(angerManagement -> {
                this.cH = angerManagement;
            });
            this.gy();
        }
        if (compound.b("listener", 10)) {
            VibrationSystem.a.a.parse(registryOps, (Object)compound.p("listener")).resultOrPartial(string -> ca.error("Failed to parse vibration listener for Warden: '{}'", string)).ifPresent(data -> {
                this.cG = data;
            });
        }
    }

    private void gA() {
        if (!this.c(EntityPose.l)) {
            this.a(this.t().c(), 10.0f, this.fh());
        }
    }

    public AngerLevel t() {
        return AngerLevel.a(this.gB());
    }

    private int gB() {
        return this.cH.b(this.O_());
    }

    public void c(Entity entity) {
        this.cH.a(entity);
    }

    public void d(@Nullable Entity entity) {
        this.a(entity, 35, true);
    }

    @VisibleForTesting
    public void a(@Nullable Entity entity, int offset, boolean playListeningSound) {
        if (!this.gf() && this.b(entity)) {
            int activeAnger = this.cH.b(entity);
            WardenAngerChangeEvent event = new WardenAngerChangeEvent((org.bukkit.entity.Warden)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), activeAnger, Math.min(150, activeAnger + offset));
            this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            offset = event.getNewAnger() - activeAnger;
            WardenAi.a((EntityLiving)this);
            boolean flag = !(this.O_() instanceof EntityHuman);
            int i2 = this.cH.a(entity, offset);
            if (entity instanceof EntityHuman && flag && AngerLevel.a(i2).d()) {
                this.eb().b(MemoryModuleType.o);
            }
            if (playListeningSound) {
                this.gA();
            }
        }
    }

    public Optional<EntityLiving> x() {
        return this.t().d() ? this.cH.a() : Optional.empty();
    }

    @Override
    @Nullable
    public EntityLiving O_() {
        return this.R();
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.eb().a(MemoryModuleType.aE, Unit.a, 1200L);
        if (spawnReason == EntitySpawnReason.k) {
            this.b(EntityPose.n);
            this.eb().a(MemoryModuleType.aC, Unit.a, WardenAi.a);
            this.a(SoundEffects.Cu, 5.0f, 1.0f);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        boolean flag = super.a(level, damageSource, amount);
        if (!this.gf() && !this.gv()) {
            Entity entity = damageSource.d();
            this.a(entity, AngerLevel.c.a() + 20, false);
            if (this.bE.c(MemoryModuleType.o).isEmpty() && entity instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)entity;
                if (damageSource.b() || this.a((Entity)livingEntity, 5.0)) {
                    this.j(livingEntity);
                }
            }
        }
        return flag;
    }

    public void j(EntityLiving attackTarget) {
        this.eb().b(MemoryModuleType.ay);
        this.eb().a(MemoryModuleType.o, attackTarget);
        this.eb().b(MemoryModuleType.E);
        SonicBoom.a((EntityLiving)this, 200);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        EntitySize entityDimensions = super.e(pose);
        return this.gv() ? EntitySize.c(entityDimensions.a(), 1.0f) : entityDimensions;
    }

    @Override
    public boolean bI() {
        return !this.gv() && super.bI();
    }

    @Override
    protected void D(Entity entity) {
        if (!this.gf() && !this.eb().a(MemoryModuleType.aH)) {
            this.eb().a(MemoryModuleType.aH, Unit.a, 20L);
            this.d(entity);
            WardenAi.a(this, entity.dv());
        }
        super.D(entity);
    }

    @VisibleForTesting
    public AngerManagement gs() {
        return this.cH;
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new Navigation(this, this, level){

            @Override
            protected Pathfinder a(int maxVisitedNodes) {
                this.o = new PathfinderNormal();
                return new Pathfinder(this, this.o, maxVisitedNodes){

                    @Override
                    protected float a(PathPoint first, PathPoint second) {
                        return first.b(second);
                    }
                };
            }
        };
    }

    @Override
    public VibrationSystem.a gt() {
        return this.cG;
    }

    @Override
    public VibrationSystem.d gu() {
        return this.cF;
    }

    class a
    implements VibrationSystem.d {
        private static final int b = 16;
        private final PositionSource c;

        a() {
            this.c = new EntityPositionSource(Warden.this, Warden.this.cS());
        }

        @Override
        public int a() {
            return 16;
        }

        @Override
        public PositionSource b() {
            return this.c;
        }

        @Override
        public TagKey<GameEvent> c() {
            return GameEventTags.b;
        }

        @Override
        public boolean d() {
            return true;
        }

        @Override
        public boolean a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, GameEvent.a context) {
            EntityLiving livingEntity;
            Entity entity;
            return !Warden.this.gf() && !Warden.this.eE() && !Warden.this.eb().a(MemoryModuleType.aI) && !Warden.this.gv() && level.F_().a(pos) && (!((entity = context.a()) instanceof EntityLiving) || Warden.this.b((Entity)(livingEntity = (EntityLiving)entity)));
        }

        @Override
        public void a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, @Nullable Entity entity, @Nullable Entity playerEntity, float distance) {
            if (!Warden.this.eE()) {
                Warden.this.bE.a(MemoryModuleType.aI, Unit.a, 40L);
                level.a((Entity)Warden.this, (byte)61);
                Warden.this.a(SoundEffects.CN, 5.0f, Warden.this.fh());
                BlockPosition blockPos = pos;
                if (playerEntity != null) {
                    if (Warden.this.a(playerEntity, 30.0)) {
                        if (Warden.this.eb().a(MemoryModuleType.aA)) {
                            if (Warden.this.b(playerEntity)) {
                                blockPos = playerEntity.dv();
                            }
                            Warden.this.d(playerEntity);
                        } else {
                            Warden.this.a(playerEntity, 10, true);
                        }
                    }
                    Warden.this.eb().a(MemoryModuleType.aA, Unit.a, 100L);
                } else {
                    Warden.this.d(entity);
                }
                if (!Warden.this.t().d()) {
                    Optional<EntityLiving> activeEntity = Warden.this.cH.a();
                    if (playerEntity != null || activeEntity.isEmpty() || activeEntity.get() == entity) {
                        WardenAi.a(Warden.this, blockPos);
                    }
                }
            }
        }
    }
}

