/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinArmPose;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityPiglin
extends EntityPiglinAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> bZ = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> ca = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cb = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final MinecraftKey cc = MinecraftKey.b("baby");
    private static final AttributeModifier cd = new AttributeModifier(cc, 0.2f, AttributeModifier.Operation.b);
    private static final int ce = 16;
    private static final float cf = 0.35f;
    private static final int cg = 5;
    private static final float ch = 0.1f;
    private static final int ci = 3;
    private static final float cj = 0.2f;
    private static final EntitySize ck = EntityTypes.aR.n().a(0.5f).b(0.97f);
    private static final double cl = 0.5;
    public final InventorySubcontainer cm = new InventorySubcontainer(8);
    public boolean cn;
    protected static final ImmutableList<SensorType<? extends Sensor<? super EntityPiglin>>> d = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.f, SensorType.l);
    protected static final ImmutableList<MemoryModuleType<?>> bY = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.v, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.ao, MemoryModuleType.an, MemoryModuleType.L, MemoryModuleType.aP, MemoryModuleType.x, MemoryModuleType.y, (Object[])new MemoryModuleType[]{MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.o, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.t, MemoryModuleType.ab, MemoryModuleType.ac, MemoryModuleType.z, MemoryModuleType.ad, MemoryModuleType.ae, MemoryModuleType.ag, MemoryModuleType.af, MemoryModuleType.ai, MemoryModuleType.aj, MemoryModuleType.ah, MemoryModuleType.al, MemoryModuleType.M, MemoryModuleType.ar, MemoryModuleType.s, MemoryModuleType.as, MemoryModuleType.at, MemoryModuleType.ak, MemoryModuleType.am, MemoryModuleType.au, MemoryModuleType.av, MemoryModuleType.aw});
    public Set<Item> allowedBarterItems = new HashSet<Item>();
    public Set<Item> interestItems = new HashSet<Item>();

    public EntityPiglin(EntityTypes<? extends EntityPiglinAbstract> entityType, World level) {
        super(entityType, level);
        this.bN = 5;
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        if (this.e_()) {
            compound.a("IsBaby", true);
        }
        if (this.cn) {
            compound.a("CannotHunt", true);
        }
        this.b(compound, this.dX());
        NBTTagList barterList = new NBTTagList();
        this.allowedBarterItems.stream().map(BuiltInRegistries.g::b).map(MinecraftKey::toString).map(NBTTagString::a).forEach(barterList::add);
        compound.a("Bukkit.BarterList", barterList);
        NBTTagList interestList = new NBTTagList();
        this.interestItems.stream().map(BuiltInRegistries.g::b).map(MinecraftKey::toString).map(NBTTagString::a).forEach(interestList::add);
        compound.a("Bukkit.InterestList", interestList);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.a(compound.q("IsBaby"));
        this.z(compound.q("CannotHunt"));
        this.a(compound, this.dX());
        this.allowedBarterItems = compound.c("Bukkit.BarterList", 8).stream().map(NBTBase::u_).map(MinecraftKey::c).map(BuiltInRegistries.g::a).collect(Collectors.toCollection(HashSet::new));
        this.interestItems = compound.c("Bukkit.InterestList", 8).stream().map(NBTBase::u_).map(MinecraftKey::c).map(BuiltInRegistries.g::a).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    @VisibleForDebug
    public InventorySubcontainer t() {
        return this.cm;
    }

    @Override
    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
        EntityCreeper creeper;
        super.a(level, damageSource, recentlyHit);
        Entity entity = damageSource.d();
        if (entity instanceof EntityCreeper && (creeper = (EntityCreeper)entity).gt()) {
            ItemStack itemStack = new ItemStack(Items.vq);
            creeper.gu();
            this.a(level, itemStack);
        }
        this.cm.f().forEach(itemStack1 -> this.a(level, (ItemStack)itemStack1));
    }

    protected ItemStack i(ItemStack stack) {
        return this.cm.b(stack);
    }

    protected boolean j(ItemStack stack) {
        return this.cm.c(stack);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bZ, false);
        builder.a(ca, false);
        builder.a(cb, false);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (bZ.equals(key)) {
            this.m_();
        }
    }

    public static AttributeProvider.Builder gy() {
        return EntityMonster.gx().a(GenericAttributes.s, 16.0).a(GenericAttributes.v, 0.35f).a(GenericAttributes.c, 5.0);
    }

    public static boolean b(EntityTypes<EntityPiglin> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return !level.a_(pos.e()).a(Blocks.lm);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.H_();
        if (spawnReason != EntitySpawnReason.d) {
            if (random.i() < 0.2f) {
                this.a(true);
            } else if (this.gs()) {
                this.a(EnumItemSlot.a, this.gA());
            }
        }
        PiglinAI.a(this, level.H_());
        this.a(random, difficulty);
        this.a(level, random, difficulty);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    protected boolean ab() {
        return false;
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return !this.fZ();
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        if (this.gs()) {
            this.a(EnumItemSlot.f, new ItemStack(Items.qt), random);
            this.a(EnumItemSlot.e, new ItemStack(Items.qu), random);
            this.a(EnumItemSlot.d, new ItemStack(Items.qv), random);
            this.a(EnumItemSlot.c, new ItemStack(Items.qw), random);
        }
    }

    private void a(EnumItemSlot slot, ItemStack stack, RandomSource random) {
        if (random.i() < 0.1f) {
            this.a(slot, stack);
        }
    }

    protected BehaviorController.b<EntityPiglin> ec() {
        return BehaviorController.a(bY, d);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return PiglinAI.a(this, this.ec().a(dynamic));
    }

    public BehaviorController<EntityPiglin> eb() {
        return super.eb();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (interactionResult.a()) {
            return interactionResult;
        }
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            return PiglinAI.a(serverLevel, this, player, hand);
        }
        boolean flag = PiglinAI.b(this, player.b(hand)) && this.gt() != EntityPiglinArmPose.d;
        return (EnumInteractionResult)((Object)(flag ? EnumInteractionResult.a : EnumInteractionResult.e));
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? ck : super.e(pose);
    }

    @Override
    public void a(boolean childZombie) {
        this.au().a(bZ, childZombie);
        if (!this.dV().C) {
            AttributeModifiable attribute = this.g(GenericAttributes.v);
            attribute.c(cd.b());
            if (childZombie) {
                attribute.b(cd);
            }
        }
    }

    @Override
    public boolean e_() {
        return this.au().a(bZ);
    }

    private void z(boolean cannotHunt) {
        this.cn = cannotHunt;
    }

    @Override
    protected boolean m() {
        return !this.cn;
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("piglinBrain");
        this.eb().a(level, this);
        profilerFiller.c();
        PiglinAI.a(this);
        super.a(level);
    }

    @Override
    protected int e(WorldServer level) {
        return this.bN;
    }

    @Override
    protected void g(WorldServer serverLevel) {
        PiglinAI.a(serverLevel, this);
        this.forceDrops = true;
        this.cm.f().forEach(itemStack -> this.a(serverLevel, (ItemStack)itemStack));
        this.forceDrops = false;
        super.g(serverLevel);
    }

    private ItemStack gA() {
        return (double)this.ae.i() < 0.5 ? new ItemStack(Items.wV) : new ItemStack(Items.pB);
    }

    @Override
    public TagKey<Item> Z() {
        return this.e_() ? null : TagsItem.bT;
    }

    public boolean gB() {
        return this.al.a(ca);
    }

    @Override
    public void b(boolean isCharging) {
        this.al.a(ca, isCharging);
    }

    @Override
    public void a() {
        this.bf = 0;
    }

    @Override
    public EntityPiglinArmPose gt() {
        if (this.gz()) {
            return EntityPiglinArmPose.e;
        }
        if (PiglinAI.a(this.fa())) {
            return EntityPiglinArmPose.d;
        }
        if (this.gh() && this.gu()) {
            return EntityPiglinArmPose.a;
        }
        if (this.gB()) {
            return EntityPiglinArmPose.c;
        }
        return this.b(Items.wV) && ItemCrossbow.g(this.dZ()) ? EntityPiglinArmPose.b : EntityPiglinArmPose.f;
    }

    public boolean gz() {
        return this.al.a(cb);
    }

    public void y(boolean dancing) {
        this.al.a(cb, dancing);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        boolean flag = super.a(level, damageSource, amount);
        if (flag && (entity = damageSource.d()) instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            PiglinAI.a(level, this, livingEntity);
        }
        return flag;
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        this.b(this, 1.6f);
    }

    @Override
    public boolean a(ItemProjectileWeapon projectileWeapon) {
        return projectileWeapon == Items.wV;
    }

    protected void k(ItemStack stack) {
        this.b(EnumItemSlot.a, stack);
    }

    protected void l(ItemStack stack) {
        if (stack.a(PiglinAI.c) || this.allowedBarterItems.contains(stack.h())) {
            this.a(EnumItemSlot.b, stack);
            this.g(EnumItemSlot.b);
        } else {
            this.b(EnumItemSlot.b, stack);
        }
    }

    @Override
    public boolean c(WorldServer level, ItemStack stack) {
        return level.O().b(GameRules.c) && this.fN() && PiglinAI.a(this, stack);
    }

    protected boolean m(ItemStack candidate) {
        EnumItemSlot equipmentSlotForItem = this.f(candidate);
        ItemStack itemBySlot = this.a(equipmentSlotForItem);
        return this.a(candidate, itemBySlot, equipmentSlotForItem);
    }

    @Override
    protected boolean a(ItemStack newItem, ItemStack currentItem, EnumItemSlot slot) {
        if (EnchantmentManager.a(currentItem, EnchantmentEffectComponents.E)) {
            return false;
        }
        TagKey<Item> preferredWeaponType = this.Z();
        boolean flag = PiglinAI.isLovedItem(newItem, this) || preferredWeaponType != null && newItem.a(preferredWeaponType);
        boolean flag1 = PiglinAI.isLovedItem(currentItem, this) || preferredWeaponType != null && currentItem.a(preferredWeaponType);
        return flag && !flag1 || (flag || !flag1) && super.a(newItem, currentItem, slot);
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        PiglinAI.a(level, this, entity);
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        if (this.e_() && entity.aq() == EntityTypes.aj) {
            entity = this.b(entity, 3);
        }
        return super.a(entity, force);
    }

    private Entity b(Entity vehicle, int maxPosition) {
        List<Entity> passengers = vehicle.cY();
        return maxPosition != 1 && !passengers.isEmpty() ? this.b(passengers.get(0), maxPosition - 1) : vehicle;
    }

    @Override
    protected SoundEffect u() {
        return this.dV().C ? null : (SoundEffect)PiglinAI.b(this).orElse(null);
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.ul;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.uj;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.un, 0.15f, 1.0f);
    }

    @Override
    protected void gv() {
        this.b(SoundEffects.uo);
    }
}

