/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.hoglin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.hoglin.HoglinAI;
import net.minecraft.world.entity.monster.hoglin.IOglin;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityHoglin
extends EntityAnimal
implements IMonster,
IOglin {
    private static final DataWatcherObject<Boolean> cc = DataWatcher.a(EntityHoglin.class, DataWatcherRegistry.k);
    private static final int cd = 40;
    private static final float ce = 0.3f;
    private static final int cf = 1;
    private static final float cg = 0.6f;
    private static final int ch = 6;
    private static final float ci = 0.5f;
    public static final int bY = 300;
    private int cj;
    public int ck;
    public boolean cl;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super EntityHoglin>>> bZ = ImmutableList.of(SensorType.c, SensorType.d, SensorType.o, SensorType.n);
    protected static final ImmutableList<? extends MemoryModuleType<?>> ca = ImmutableList.of(MemoryModuleType.r, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.n, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.o, MemoryModuleType.p, MemoryModuleType.aq, (Object[])new MemoryModuleType[]{MemoryModuleType.z, MemoryModuleType.as, MemoryModuleType.at, MemoryModuleType.ap, MemoryModuleType.K, MemoryModuleType.aw, MemoryModuleType.ax, MemoryModuleType.Z});

    public EntityHoglin(EntityTypes<? extends EntityHoglin> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        this.bN = 5;
    }

    @VisibleForTesting
    public void s(int timeInOverworld) {
        this.ck = timeInOverworld;
    }

    @Override
    public boolean y() {
        return true;
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gx().a(GenericAttributes.s, 40.0).a(GenericAttributes.v, 0.3f).a(GenericAttributes.p, 0.6f).a(GenericAttributes.d, 1.0).a(GenericAttributes.c, 6.0);
    }

    @Override
    public boolean c(WorldServer level, Entity source) {
        if (source instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)source;
            this.cj = 10;
            this.dV().a((Entity)this, (byte)4);
            this.b(SoundEffects.mO);
            HoglinAI.a(this, livingEntity);
            return IOglin.a(level, this, livingEntity);
        }
        return false;
    }

    @Override
    protected void e(EntityLiving entity) {
        if (this.t()) {
            IOglin.a(this, entity);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        boolean flag = super.a(level, damageSource, amount);
        if (flag && (entity = damageSource.d()) instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            HoglinAI.a(level, this, livingEntity);
        }
        return flag;
    }

    protected BehaviorController.b<EntityHoglin> ec() {
        return BehaviorController.a(ca, bZ);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return HoglinAI.a(this.ec().a(dynamic));
    }

    public BehaviorController<EntityHoglin> eb() {
        return super.eb();
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("hoglinBrain");
        this.eb().a(level, this);
        profilerFiller.c();
        HoglinAI.a(this);
        if (this.gs()) {
            ++this.ck;
            if (this.ck > 300) {
                this.b(SoundEffects.mP);
                this.gu();
            }
        } else {
            this.ck = 0;
        }
    }

    @Override
    public void d_() {
        if (this.cj > 0) {
            --this.cj;
        }
        super.d_();
    }

    @Override
    protected void i() {
        if (this.e_()) {
            this.bN = 3;
            this.g(GenericAttributes.c).a(0.5);
        } else {
            this.bN = 5;
            this.g(GenericAttributes.c).a(6.0);
        }
    }

    public static boolean c(EntityTypes<EntityHoglin> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return !level.a_(pos.e()).a(Blocks.lm);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (level.H_().i() < 0.2f) {
            this.a(true);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return !this.fZ();
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        if (HoglinAI.a(this, pos)) {
            return -1.0f;
        }
        return level.a_(pos.e()).a(Blocks.oY) ? 10.0f : 0.0f;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (interactionResult.a()) {
            this.fY();
        }
        return interactionResult;
    }

    @Override
    public void b(byte id) {
        if (id == 4) {
            this.cj = 10;
            this.b(SoundEffects.mO);
        } else {
            super.b(id);
        }
    }

    @Override
    public int x() {
        return this.cj;
    }

    @Override
    public boolean em() {
        return true;
    }

    @Override
    protected int e(WorldServer level) {
        return this.bN;
    }

    private void gu() {
        EntityZoglin converted = this.convertTo(EntityTypes.bM, ConversionParams.a(this, true, false), (T mob) -> mob.a(new MobEffect(MobEffects.i, 200, 0)), EntityTransformEvent.TransformReason.PIGLIN_ZOMBIFIED, CreatureSpawnEvent.SpawnReason.PIGLIN_ZOMBIFIED);
        if (converted == null) {
            this.ck = 0;
        }
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.ap);
    }

    public boolean t() {
        return !this.e_();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cc, false);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        if (this.gv()) {
            compound.a("IsImmuneToZombification", true);
        }
        compound.a("TimeInOverworld", this.ck);
        if (this.cl) {
            compound.a("CannotBeHunted", true);
        }
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.x(compound.q("IsImmuneToZombification"));
        this.ck = compound.h("TimeInOverworld");
        this.y(compound.q("CannotBeHunted"));
    }

    public void x(boolean immuneToZombification) {
        this.au().a(cc, immuneToZombification);
    }

    public boolean gv() {
        return this.au().a(cc);
    }

    public boolean gs() {
        return !this.dV().G_().b() && !this.gv() && !this.gf();
    }

    private void y(boolean cannotBeHunted) {
        this.cl = cannotBeHunted;
    }

    public boolean gt() {
        return this.t() && !this.cl;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable otherParent) {
        EntityHoglin hoglin = EntityTypes.aj.a(level, EntitySpawnReason.e);
        if (hoglin != null) {
            hoglin.fY();
        }
        return hoglin;
    }

    @Override
    public boolean gz() {
        return !HoglinAI.c(this) && super.gz();
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect u() {
        return this.dV().C ? null : (SoundEffect)HoglinAI.b(this).orElse(null);
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.mR;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.mQ;
    }

    @Override
    protected SoundEffect aV() {
        return SoundEffects.nw;
    }

    @Override
    protected SoundEffect aW() {
        return SoundEffects.nv;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.mT, 0.15f, 1.0f);
    }

    @Override
    protected void ac() {
        super.ac();
        PacketDebug.a(this);
    }

    @Override
    @Nullable
    public EntityLiving O_() {
        return this.R();
    }
}

