/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.creaking;

import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.creaking.CreakingAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class Creaking
extends EntityMonster {
    private static final DataWatcherObject<Boolean> cd = DataWatcher.a(Creaking.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> ce = DataWatcher.a(Creaking.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cf = DataWatcher.a(Creaking.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Optional<BlockPosition>> cg = DataWatcher.a(Creaking.class, DataWatcherRegistry.p);
    private static final int ch = 15;
    private static final int ci = 1;
    private static final float cj = 3.0f;
    private static final float ck = 32.0f;
    private static final float cl = 144.0f;
    public static final int a = 40;
    private static final float cm = 0.4f;
    public static final float b = 0.3f;
    public static final int c = 16545810;
    public static final int d = 0x5F5F5F;
    public static final int bY = 8;
    public static final int bZ = 45;
    private static final int cn = 4;
    private int co;
    public final AnimationState ca = new AnimationState();
    public final AnimationState cb = new AnimationState();
    public final AnimationState cc = new AnimationState();
    private int cp;
    private boolean cq;
    private int cr;
    private int cs;

    public Creaking(EntityTypes<? extends Creaking> entityType, World level) {
        super((EntityTypes<? extends EntityMonster>)entityType, level);
        this.bO = new c(this);
        this.bP = new d(this);
        this.bQ = new b(this);
        Navigation groundPathNavigation = (Navigation)this.P();
        groundPathNavigation.a(true);
        this.bN = 0;
    }

    public void h(BlockPosition homePos) {
        this.i(homePos);
        this.a(PathType.q, 8.0f);
        this.a(PathType.f, 8.0f);
        this.a(PathType.i, 8.0f);
        this.a(PathType.o, 0.0f);
        this.a(PathType.n, 0.0f);
    }

    public boolean m() {
        return this.gt() != null;
    }

    @Override
    protected EntityAIBodyControl J() {
        return new a(this);
    }

    protected BehaviorController.b<Creaking> ec() {
        return CreakingAi.a();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return CreakingAi.d(this.ec().a(dynamic));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cd, true);
        builder.a(ce, false);
        builder.a(cf, false);
        builder.a(cg, Optional.empty());
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gx().a(GenericAttributes.s, 1.0).a(GenericAttributes.v, 0.4f).a(GenericAttributes.c, 3.0).a(GenericAttributes.m, 32.0).a(GenericAttributes.B, 1.0625);
    }

    public boolean t() {
        return this.al.a(cd);
    }

    @Override
    public boolean c(WorldServer level, Entity source) {
        if (!(source instanceof EntityLiving)) {
            return false;
        }
        this.co = 15;
        this.dV().a((Entity)this, (byte)4);
        return super.c(level, source);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        BlockPosition homePos = this.gt();
        if (homePos == null || damageSource.a(DamageTypeTags.d)) {
            return super.a(level, damageSource, amount);
        }
        if (!this.a(level, damageSource) && this.cp <= 0 && !this.eE()) {
            CreakingHeartBlockEntity creakingHeartBlockEntity;
            EntityHuman player = this.j(damageSource);
            Entity directEntity = damageSource.c();
            if (!(directEntity instanceof EntityLiving) && !(directEntity instanceof IProjectile) && player == null) {
                return false;
            }
            this.cp = 8;
            this.dV().a((Entity)this, (byte)66);
            TileEntity tileEntity = this.dV().c_(homePos);
            if (tileEntity instanceof CreakingHeartBlockEntity && (creakingHeartBlockEntity = (CreakingHeartBlockEntity)tileEntity).b(this)) {
                if (player != null) {
                    creakingHeartBlockEntity.c();
                }
                this.h(damageSource);
            }
            return true;
        }
        return false;
    }

    public EntityHuman j(DamageSource damageSource) {
        this.f(damageSource);
        return this.g(damageSource);
    }

    @Override
    public boolean bI() {
        return super.bI() && this.t();
    }

    @Override
    public void push(double x2, double y2, double z2, @Nullable Entity pushingEntity) {
        if (this.t()) {
            super.push(x2, y2, z2, pushingEntity);
        }
    }

    public BehaviorController<Creaking> eb() {
        return super.eb();
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("creakingBrain");
        this.eb().a((WorldServer)this.dV(), this);
        profilerFiller.c();
        CreakingAi.a(this);
    }

    @Override
    public void d_() {
        if (this.cp > 0) {
            --this.cp;
        }
        if (this.co > 0) {
            --this.co;
        }
        if (!this.dV().C) {
            boolean flag = this.al.a(cd);
            boolean flag1 = this.gA();
            if (flag1 != flag) {
                ((Entity)this).a(GameEvent.u);
                if (flag1) {
                    this.b(SoundEffects.gr);
                } else {
                    this.X();
                    this.b(SoundEffects.gq);
                }
            }
            this.al.a(cd, flag1);
        }
        super.d_();
    }

    @Override
    public void h() {
        BlockPosition homePos;
        if (!this.dV().C && (homePos = this.gt()) != null) {
            CreakingHeartBlockEntity creakingHeartBlockEntity;
            boolean flag;
            TileEntity tileEntity = this.dV().c_(homePos);
            boolean bl = flag = tileEntity instanceof CreakingHeartBlockEntity && (creakingHeartBlockEntity = (CreakingHeartBlockEntity)tileEntity).b(this);
            if (!flag) {
                this.x(0.0f);
            }
        }
        super.h();
        if (this.dV().C) {
            this.gD();
            this.gz();
        }
    }

    @Override
    protected void el() {
        if (this.m() && this.gv()) {
            ++this.aP;
            if (!this.dV().B_() && this.aP > 45 && !this.dQ()) {
                this.x();
            }
        } else {
            super.el();
        }
    }

    @Override
    protected void B(float partialTick) {
        float min = Math.min(partialTick * 25.0f, 3.0f);
        this.aT.a(min, 0.4f, 1.0f);
    }

    private void gD() {
        this.ca.a(this.co > 0, this.af);
        this.cb.a(this.cp > 0, this.af);
        this.cc.a(this.gv(), this.af);
    }

    public void x() {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            AxisAlignedBB boundingBox = this.cR();
            Vec3D center = boundingBox.f();
            double d2 = boundingBox.b() * 0.3;
            double d1 = boundingBox.c() * 0.3;
            double d22 = boundingBox.d() * 0.3;
            serverLevel.a(new ParticleParamBlock(Particles.bh, Blocks.u.m()), center.d, center.e, center.f, 100, d2, d1, d22, 0.0);
            serverLevel.a(new ParticleParamBlock(Particles.bh, (IBlockData)Blocks.cB.m().b(CreakingHeartBlock.c, true)), center.d, center.e, center.f, 10, d2, d1, d22, 0.0);
        }
        this.b(this.o_());
        this.remove(Entity.RemovalReason.b, null);
    }

    public void k(DamageSource damageSource) {
        this.j(damageSource);
        this.a(damageSource);
        this.b(SoundEffects.gu);
    }

    @Override
    public void b(byte id) {
        if (id == 66) {
            this.cp = 8;
            this.h(this.dW().p());
        } else if (id == 4) {
            this.co = 15;
            this.gj();
        } else {
            super.b(id);
        }
    }

    @Override
    public boolean bi() {
        return this.m() || super.bi();
    }

    @Override
    public boolean eL() {
        return !this.m() && super.eL();
    }

    @Override
    protected boolean r(Entity passenger) {
        return !this.m() && super.r(passenger);
    }

    @Override
    protected boolean bR() {
        return !this.m() && super.bR();
    }

    @Override
    protected void p(Entity passenger) {
        if (this.m()) {
            throw new IllegalStateException("Should never addPassenger without checking couldAcceptPassenger()");
        }
    }

    @Override
    public boolean o(boolean allowPassengers) {
        return !this.m() && super.o(allowPassengers);
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new e(this, level);
    }

    public boolean gs() {
        List list = this.bE.c(MemoryModuleType.j).orElse(List.of());
        if (list.isEmpty()) {
            this.cs = 0;
            return false;
        }
        AxisAlignedBB boundingBox = this.cR();
        for (EntityHuman player : list) {
            if (!boundingBox.d(player.bF())) continue;
            ++this.cs;
            return this.cs > 4;
        }
        this.cs = 0;
        return false;
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        if (compound.e("home_pos")) {
            this.h(GameProfileSerializer.a(compound, "home_pos").orElseThrow());
        }
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        BlockPosition homePos = this.gt();
        if (homePos != null) {
            compound.a("home_pos", GameProfileSerializer.a(homePos));
        }
    }

    public void i(BlockPosition homePos) {
        this.al.a(cg, Optional.of(homePos));
    }

    @Nullable
    public BlockPosition gt() {
        return this.al.a(cg).orElse(null);
    }

    public void gu() {
        this.al.a(cf, true);
    }

    public boolean gv() {
        return this.al.a(cf);
    }

    public boolean gy() {
        return this.cq;
    }

    public void gz() {
        if (this.aP > this.cr) {
            this.cr = this.aP + this.dY().a(this.cq ? 2 : this.aP / 4, this.cq ? 8 : this.aP / 2);
            this.cq = !this.cq;
        }
    }

    @Override
    public void gj() {
        this.b(SoundEffects.gn);
    }

    @Override
    protected SoundEffect u() {
        return this.gC() ? null : SoundEffects.gk;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return this.m() ? SoundEffects.gt : super.e(damageSource);
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.go;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.gp, 0.15f, 1.0f);
    }

    @Override
    @Nullable
    public EntityLiving O_() {
        return this.R();
    }

    @Override
    protected void ac() {
        super.ac();
        PacketDebug.a(this);
    }

    @Override
    public void knockback(double strength, double x2, double z2, @Nullable Entity attacker, EntityKnockbackEvent.Cause cause) {
        if (this.t()) {
            super.knockback(strength, x2, z2, attacker, cause);
        }
    }

    public boolean gA() {
        List list = this.bE.c(MemoryModuleType.j).orElse(List.of());
        boolean isActive = this.gC();
        if (list.isEmpty()) {
            if (isActive) {
                this.gB();
            }
            return true;
        }
        boolean flag = false;
        for (EntityHuman player : list) {
            if (!this.c((EntityLiving)player) || this.s(player)) continue;
            flag = true;
            if (isActive && !EntityLiving.aH.test(player) || !this.a(player, 0.5, false, true, this.dE(), this.dC() + 0.5 * (double)this.ej(), (this.dE() + this.dC()) / 2.0)) continue;
            if (isActive) {
                return false;
            }
            if (!(player.g((Entity)this) < 144.0)) continue;
            this.a(player);
            return false;
        }
        if (!flag && isActive) {
            this.gB();
        }
        return true;
    }

    public void a(EntityHuman player) {
        this.eb().a(MemoryModuleType.o, player);
        ((Entity)this).a(GameEvent.u);
        this.b(SoundEffects.gl);
        this.x(true);
    }

    public void gB() {
        this.eb().b(MemoryModuleType.o);
        ((Entity)this).a(GameEvent.u);
        this.b(SoundEffects.gm);
        this.x(false);
    }

    public void x(boolean isActive) {
        this.al.a(ce, isActive);
    }

    public boolean gC() {
        return this.al.a(ce);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return 0.0f;
    }

    class c
    extends ControllerLook {
        public c(Creaking mob) {
            super(mob);
        }

        @Override
        public void a() {
            if (Creaking.this.t()) {
                super.a();
            }
        }
    }

    class d
    extends ControllerMove {
        public d(Creaking mob) {
            super(mob);
        }

        @Override
        public void a() {
            if (Creaking.this.t()) {
                super.a();
            }
        }
    }

    class b
    extends ControllerJump {
        public b(Creaking mob) {
            super(mob);
        }

        @Override
        public void b() {
            if (Creaking.this.t()) {
                super.b();
            } else {
                Creaking.this.t(false);
            }
        }
    }

    class a
    extends EntityAIBodyControl {
        public a(Creaking mob) {
            super(mob);
        }

        @Override
        public void a() {
            if (Creaking.this.t()) {
                super.a();
            }
        }
    }

    class e
    extends Navigation {
        e(Creaking mob, World level) {
            super(mob, level);
        }

        @Override
        public void c() {
            if (Creaking.this.t()) {
                super.c();
            }
        }

        @Override
        protected Pathfinder a(int maxVisitedNodes) {
            this.o = new f();
            this.o.a(true);
            return new Pathfinder(this.o, maxVisitedNodes);
        }
    }

    class f
    extends PathfinderNormal {
        private static final int m = 1024;

        f() {
        }

        @Override
        public PathType a(PathfindingContext context, int x2, int y2, int z2) {
            BlockPosition homePos = Creaking.this.gt();
            if (homePos == null) {
                return super.a(context, x2, y2, z2);
            }
            double d2 = homePos.j(new BaseBlockPosition(x2, y2, z2));
            return d2 > 1024.0 && d2 >= homePos.j(context.b()) ? PathType.a : super.a(context, x2, y2, z2);
        }
    }
}

