/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.breeze;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorSwim;
import net.minecraft.world.entity.ai.behavior.LongJumpUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.breeze.BreezeUtil;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class LongJump
extends Behavior<Breeze> {
    private static final int c = 4;
    private static final int d = 10;
    private static final int e = 2;
    private static final int f = Math.round(10.0f);
    private static final float g = 24.0f;
    private static final float h = 1.4f;
    private static final float i = 0.058333334f;
    private static final ObjectArrayList<Integer> j = new ObjectArrayList((Collection)Lists.newArrayList((Object[])new Integer[]{40, 55, 60, 75, 80}));

    @VisibleForTesting
    public LongJump() {
        super(Map.of(MemoryModuleType.o, MemoryStatus.a, MemoryModuleType.aU, MemoryStatus.b, MemoryModuleType.aZ, MemoryStatus.c, MemoryModuleType.ba, MemoryStatus.c, MemoryModuleType.aV, MemoryStatus.b, MemoryModuleType.m, MemoryStatus.b, MemoryModuleType.bb, MemoryStatus.c), 200);
    }

    public static boolean a(WorldServer level, Breeze breeze) {
        if (!breeze.aJ() && !breeze.bj()) {
            return false;
        }
        if (BehaviorSwim.a(breeze)) {
            return false;
        }
        if (breeze.eb().a(MemoryModuleType.ba, MemoryStatus.a)) {
            return true;
        }
        EntityLiving livingEntity = breeze.eb().c(MemoryModuleType.o).orElse(null);
        if (livingEntity == null) {
            return false;
        }
        if (LongJump.a(breeze, livingEntity)) {
            breeze.eb().b(MemoryModuleType.o);
            return false;
        }
        if (LongJump.b(breeze, livingEntity)) {
            return false;
        }
        if (!LongJump.c(level, breeze)) {
            return false;
        }
        BlockPosition blockPos = LongJump.a((EntityLiving)breeze, BreezeUtil.a(livingEntity, breeze.dY()));
        if (blockPos == null) {
            return false;
        }
        IBlockData blockState = level.a_(blockPos.e());
        if (breeze.aq().a(blockState)) {
            return false;
        }
        if (!BreezeUtil.a(breeze, blockPos.b()) && !BreezeUtil.a(breeze, blockPos.b(4).b())) {
            return false;
        }
        breeze.eb().a(MemoryModuleType.ba, blockPos);
        return true;
    }

    protected boolean b(WorldServer level, Breeze owner) {
        return LongJump.a(level, owner);
    }

    @Override
    protected boolean a(WorldServer level, Breeze entity, long gameTime) {
        return entity.aw() != EntityPose.a && !entity.eb().a(MemoryModuleType.aU);
    }

    @Override
    protected void b(WorldServer level, Breeze entity, long gameTime) {
        if (entity.eb().a(MemoryModuleType.aZ, MemoryStatus.b)) {
            entity.eb().a(MemoryModuleType.aZ, Unit.a, f);
        }
        entity.b(EntityPose.r);
        level.a(null, entity, SoundEffects.cE, SoundCategory.f, 1.0f, 1.0f);
        entity.eb().c(MemoryModuleType.ba).ifPresent(blockPos -> entity.a(ArgumentAnchor.Anchor.b, blockPos.b()));
    }

    @Override
    protected void c(WorldServer level, Breeze owner, long gameTime) {
        boolean isInWater = owner.bj();
        if (!isInWater && owner.eb().a(MemoryModuleType.bb, MemoryStatus.a)) {
            owner.eb().b(MemoryModuleType.bb);
        }
        if (LongJump.a(owner)) {
            Vec3D vec3 = owner.eb().c(MemoryModuleType.ba).flatMap(blockPos -> LongJump.a(owner, owner.dY(), Vec3D.c(blockPos))).orElse(null);
            if (vec3 == null) {
                owner.b(EntityPose.a);
                return;
            }
            if (isInWater) {
                owner.eb().a(MemoryModuleType.bb, Unit.a);
            }
            owner.a(SoundEffects.cK, 1.0f, 1.0f);
            owner.b(EntityPose.g);
            owner.v(owner.aX);
            owner.r(true);
            owner.i(vec3);
        } else if (LongJump.b(owner)) {
            owner.a(SoundEffects.cL, 1.0f, 1.0f);
            owner.b(EntityPose.a);
            owner.r(false);
            boolean hasMemoryValue = owner.eb().a(MemoryModuleType.x);
            owner.eb().a(MemoryModuleType.aU, Unit.a, hasMemoryValue ? 2L : 10L);
            owner.eb().a(MemoryModuleType.aV, Unit.a, 100L);
        }
    }

    @Override
    protected void d(WorldServer level, Breeze entity, long gameTime) {
        if (entity.aw() == EntityPose.g || entity.aw() == EntityPose.r) {
            entity.b(EntityPose.a);
        }
        entity.eb().b(MemoryModuleType.ba);
        entity.eb().b(MemoryModuleType.aZ);
        entity.eb().b(MemoryModuleType.bb);
    }

    private static boolean a(Breeze breeze) {
        return breeze.eb().c(MemoryModuleType.aZ).isEmpty() && breeze.aw() == EntityPose.r;
    }

    private static boolean b(Breeze breeze) {
        boolean flag = breeze.aw() == EntityPose.g;
        boolean onGround = breeze.aJ();
        boolean flag1 = breeze.bj() && breeze.eb().a(MemoryModuleType.bb, MemoryStatus.b);
        return flag && (onGround || flag1);
    }

    @Nullable
    private static BlockPosition a(EntityLiving owner, Vec3D targetPos) {
        RayTrace clipContext = new RayTrace(targetPos, targetPos.a(EnumDirection.a, 10.0), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, owner);
        MovingObjectPositionBlock hitResult = owner.dV().a(clipContext);
        if (((MovingObjectPosition)hitResult).d() == MovingObjectPosition.EnumMovingObjectType.b) {
            return BlockPosition.a(hitResult.g()).d();
        }
        RayTrace clipContext1 = new RayTrace(targetPos, targetPos.a(EnumDirection.b, 10.0), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, owner);
        MovingObjectPositionBlock hitResult1 = owner.dV().a(clipContext1);
        return ((MovingObjectPosition)hitResult1).d() == MovingObjectPosition.EnumMovingObjectType.b ? BlockPosition.a(hitResult1.g()).d() : null;
    }

    private static boolean a(Breeze breeze, EntityLiving target) {
        return !target.a((Entity)breeze, breeze.h(GenericAttributes.m));
    }

    private static boolean b(Breeze breeze, EntityLiving target) {
        return target.f((Entity)breeze) - 4.0f <= 0.0f;
    }

    private static boolean c(WorldServer level, Breeze breeze) {
        BlockPosition blockPos = breeze.dv();
        if (level.a_(blockPos).a(Blocks.pI)) {
            return false;
        }
        for (int i2 = 1; i2 <= 4; ++i2) {
            BlockPosition blockPos1 = blockPos.a(EnumDirection.b, i2);
            if (level.a_(blockPos1).l() || level.b_(blockPos1).a(TagsFluid.a)) continue;
            return false;
        }
        return true;
    }

    private static Optional<Vec3D> a(Breeze breeze, RandomSource random, Vec3D target) {
        for (int i2 : SystemUtils.a(j, random)) {
            float f2 = 0.058333334f * (float)breeze.h(GenericAttributes.m);
            Optional<Vec3D> optional = LongJumpUtil.a(breeze, target, f2, i2, false);
            if (!optional.isPresent()) continue;
            if (breeze.b(MobEffects.h)) {
                double d2 = optional.get().d().e * (double)breeze.fk();
                return optional.map(vec3 -> vec3.b(0.0, d2, 0.0));
            }
            return optional;
        }
        return Optional.empty();
    }
}

