/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.slf4j.Logger;

public class EntityZombieVillager
extends EntityZombie
implements VillagerDataHolder {
    private static final Logger a = LogUtils.getLogger();
    public static final DataWatcherObject<Boolean> b = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<VillagerData> c = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.u);
    private static final int cb = 3600;
    private static final int cc = 6000;
    private static final int cd = 14;
    private static final int ce = 4;
    public int cf;
    @Nullable
    public UUID cg;
    @Nullable
    private NBTBase ch;
    @Nullable
    private MerchantRecipeList ci;
    private int cj;
    private int lastTick = MinecraftServer.currentTick;

    public EntityZombieVillager(EntityTypes<? extends EntityZombieVillager> entityType, World level) {
        super((EntityTypes<? extends EntityZombie>)entityType, level);
        BuiltInRegistries.x.a(this.ae).ifPresent(profession -> this.a(this.gC().a((VillagerProfession)profession.a())));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(b, false);
        builder.a(c, new VillagerData(VillagerType.c, VillagerProfession.b, 1));
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        VillagerData.c.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.gC()).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(tag -> compound.a("VillagerData", (NBTBase)tag));
        if (this.ci != null) {
            compound.a("Offers", (NBTBase)MerchantRecipeList.a.encodeStart(this.dX().a(DynamicOpsNBT.a), (Object)this.ci).getOrThrow());
        }
        if (this.ch != null) {
            compound.a("Gossips", this.ch);
        }
        compound.a("ConversionTime", this.gB() ? this.cf : -1);
        if (this.cg != null) {
            compound.a("ConversionPlayer", this.cg);
        }
        compound.a("Xp", this.cj);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        if (compound.b("VillagerData", 10)) {
            DataResult dataResult = VillagerData.c.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, compound.c("VillagerData")));
            dataResult.resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(this::a);
        }
        if (compound.e("Offers")) {
            MerchantRecipeList.a.parse(this.dX().a(DynamicOpsNBT.a), (Object)compound.c("Offers")).resultOrPartial(SystemUtils.a("Failed to load offers: ", arg_0 -> ((Logger)a).warn(arg_0))).ifPresent(tradeOffers -> {
                this.ci = tradeOffers;
            });
        }
        if (compound.b("Gossips", 9)) {
            this.ch = compound.c("Gossips", 10);
        }
        if (compound.b("ConversionTime", 99) && compound.h("ConversionTime") > -1) {
            this.a(compound.b("ConversionPlayer") ? compound.a("ConversionPlayer") : null, compound.h("ConversionTime"));
        }
        if (compound.b("Xp", 3)) {
            this.cj = compound.h("Xp");
        }
    }

    @Override
    public void h() {
        if (!this.dV().C && this.bL() && this.gB()) {
            int conversionProgress = this.gE();
            this.cf -= conversionProgress;
            if (this.cf <= 0) {
                this.g((WorldServer)this.dV());
            }
        }
        super.h();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.qF)) {
            if (this.b(MobEffects.r)) {
                itemInHand.a(1, (EntityLiving)player);
                if (!this.dV().C) {
                    this.a(player.cG(), this.ae.a(2401) + 3600);
                }
                return EnumInteractionResult.b;
            }
            return EnumInteractionResult.c;
        }
        return super.b(player, hand);
    }

    @Override
    protected boolean gt() {
        return false;
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return !this.gB() && this.cj == 0;
    }

    public boolean gB() {
        return this.au().a(b);
    }

    public void a(@Nullable UUID conversionStarter, int villagerConversionTime) {
        this.startConverting(conversionStarter, villagerConversionTime, true);
    }

    public void startConverting(@Nullable UUID conversionStarter, int villagerConversionTime, boolean broadcastEntityEvent) {
        this.cg = conversionStarter;
        this.cf = villagerConversionTime;
        this.au().a(b, true);
        this.removeEffect(MobEffects.r, EntityPotionEffectEvent.Cause.CONVERSION);
        this.addEffect(new MobEffect(MobEffects.e, villagerConversionTime, Math.min(this.dV().am().a() - 1, 0)), EntityPotionEffectEvent.Cause.CONVERSION);
        if (broadcastEntityEvent) {
            this.dV().a((Entity)this, (byte)16);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 16) {
            if (!this.bb()) {
                this.dV().a(this.dA(), this.dE(), this.dG(), SoundEffects.EA, this.dm(), 1.0f + this.ae.i(), this.ae.i() * 0.7f + 0.3f, false);
            }
        } else {
            super.b(id);
        }
    }

    private void g(WorldServer serverLevel) {
        EntityVillager converted = this.convertTo(EntityTypes.bC, ConversionParams.a(this, false, false), (T villager) -> {
            EntityHuman playerByUuid;
            for (EnumItemSlot equipmentSlot : this.a(serverLevel, (ItemStack itemStack) -> !EnchantmentManager.a(itemStack, EnchantmentEffectComponents.E))) {
                SlotAccess slot = villager.a_(equipmentSlot.b() + 300);
                slot.a(this.a(equipmentSlot));
            }
            this.forceDrops = false;
            villager.a(this.gC());
            if (this.ch != null) {
                villager.a(this.ch);
            }
            if (this.ci != null) {
                villager.b(this.ci.a());
            }
            villager.t(this.cj);
            villager.a((WorldAccess)serverLevel, serverLevel.d_(villager.dv()), EntitySpawnReason.i, null);
            villager.g(serverLevel);
            if (this.cg != null && (playerByUuid = serverLevel.getGlobalPlayerByUUID(this.cg)) instanceof EntityPlayer) {
                CriterionTriggers.s.a((EntityPlayer)playerByUuid, this, (EntityVillager)villager);
                serverLevel.a(ReputationEvent.a, (Entity)playerByUuid, (ReputationHandler)((Object)villager));
            }
            villager.addEffect(new MobEffect(MobEffects.i, 200, 0), EntityPotionEffectEvent.Cause.CONVERSION);
            if (!this.bb()) {
                serverLevel.a(null, 1027, this.dv(), 0);
            }
        }, EntityTransformEvent.TransformReason.CURED, CreatureSpawnEvent.SpawnReason.CURED);
        if (converted == null) {
            ((ZombieVillager)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    @Override
    @VisibleForTesting
    public void r(int villagerConversionTime) {
        this.cf = villagerConversionTime;
    }

    private int gE() {
        int i2 = 1;
        if (this.ae.i() < 0.01f) {
            int i1 = 0;
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            for (int i22 = (int)this.dA() - 4; i22 < (int)this.dA() + 4 && i1 < 14; ++i22) {
                for (int i3 = (int)this.dC() - 4; i3 < (int)this.dC() + 4 && i1 < 14; ++i3) {
                    for (int i4 = (int)this.dG() - 4; i4 < (int)this.dG() + 4 && i1 < 14; ++i4) {
                        IBlockData blockState = this.dV().a_(mutableBlockPos.d(i22, i3, i4));
                        if (!blockState.a(Blocks.fk) && !(blockState.b() instanceof BlockBed)) continue;
                        if (this.ae.i() < 0.3f) {
                            ++i2;
                        }
                        ++i1;
                    }
                }
            }
        }
        return i2;
    }

    @Override
    public float fh() {
        return this.e_() ? (this.ae.i() - this.ae.i()) * 0.2f + 2.0f : (this.ae.i() - this.ae.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEffect u() {
        return SoundEffects.Ey;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.EC;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.EB;
    }

    @Override
    public SoundEffect t() {
        return SoundEffects.ED;
    }

    @Override
    protected ItemStack gs() {
        return ItemStack.j;
    }

    @Override
    public void a(MerchantRecipeList tradeOffers) {
        this.ci = tradeOffers;
    }

    @Override
    public void a(NBTBase gossips) {
        this.ch = gossips;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.a(this.gC().a(VillagerType.a(level.t(this.dv()))));
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public void a(VillagerData data) {
        VillagerData villagerData = this.gC();
        if (villagerData.b() != data.b()) {
            this.ci = null;
        }
        this.al.a(c, data);
    }

    @Override
    public VillagerData gC() {
        return this.al.a(c);
    }

    public int gD() {
        return this.cj;
    }

    public void s(int villagerXp) {
        this.cj = villagerXp;
    }
}

