/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicates;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveThroughVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRemoveBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityZombie
extends EntityMonster {
    private static final MinecraftKey a = MinecraftKey.b("baby");
    private final AttributeModifier babyModifier;
    private static final MinecraftKey c = MinecraftKey.b("reinforcement_caller_charge");
    private static final AttributeModifier cb = new AttributeModifier(MinecraftKey.b("reinforcement_callee_charge"), -0.05f, AttributeModifier.Operation.a);
    private static final MinecraftKey cc = MinecraftKey.b("leader_zombie_bonus");
    private static final MinecraftKey cd = MinecraftKey.b("zombie_random_spawn_bonus");
    private static final DataWatcherObject<Boolean> ce = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> cf = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Boolean> cg = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    public static final float d = 0.05f;
    public static final int bY = 50;
    public static final int bZ = 40;
    public static final int ca = 7;
    private static final EntitySize ch = EntityTypes.bN.n().a(0.5f).b(0.93f);
    private static final float ci = 0.1f;
    public static final Predicate<EnumDifficulty> cj = difficulty -> difficulty == EnumDifficulty.d;
    private final PathfinderGoalBreakDoor ck;
    private boolean cl;
    private int cm;
    public int cn;
    private boolean shouldBurnInDay;

    public EntityZombie(EntityTypes<? extends EntityZombie> entityType, World level) {
        super((EntityTypes<? extends EntityMonster>)entityType, level);
        this.babyModifier = new AttributeModifier(a, this.dV().paperConfig().entities.behavior.babyZombieMovementModifier, AttributeModifier.Operation.b);
        this.shouldBurnInDay = true;
        this.ck = new PathfinderGoalBreakDoor(this, (Predicate<EnumDifficulty>)Predicates.in((Collection)level.paperConfig().entities.behavior.doorBreakingDifficulty.getOrDefault(entityType, level.paperConfig().entities.behavior.doorBreakingDifficulty.get(EntityTypes.bN))));
    }

    public EntityZombie(World level) {
        this((EntityTypes<? extends EntityZombie>)EntityTypes.bN, level);
    }

    @Override
    protected void E() {
        if (this.dV().paperConfig().entities.behavior.zombiesTargetTurtleEggs) {
            this.bS.a(4, new a((EntityCreature)this, 1.0, 3));
        }
        this.bS.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bS.a(8, new PathfinderGoalRandomLookaround(this));
        this.p();
    }

    protected void p() {
        this.bS.a(2, new PathfinderGoalZombieAttack(this, 1.0, false));
        this.bS.a(6, new PathfinderGoalMoveThroughVillage(this, 1.0, true, 4, this::gz));
        this.bS.a(7, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bT.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(EntityPigZombie.class));
        this.bT.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        if (this.dV().spigotConfig.zombieAggressiveTowardsVillager) {
            this.bT.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        }
        this.bT.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.bT.a(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.bY));
    }

    public static AttributeProvider.Builder gv() {
        return EntityMonster.gx().a(GenericAttributes.m, 35.0).a(GenericAttributes.v, 0.23f).a(GenericAttributes.c, 3.0).a(GenericAttributes.a, 2.0).a(GenericAttributes.A);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ce, false);
        builder.a(cf, 0);
        builder.a(cg, false);
    }

    public boolean gy() {
        return this.au().a(cg);
    }

    public boolean gz() {
        return this.cl;
    }

    public void y(boolean canBreakDoors) {
        if (PathfinderGoalUtil.a(this)) {
            if (this.cl != canBreakDoors) {
                this.cl = canBreakDoors;
                ((Navigation)this.P()).b(canBreakDoors);
                if (canBreakDoors) {
                    this.bS.a(1, this.ck);
                } else {
                    this.bS.a(this.ck);
                }
            }
        } else if (this.cl) {
            this.bS.a(this.ck);
            this.cl = false;
        }
    }

    @Override
    public boolean e_() {
        return this.au().a(ce);
    }

    @Override
    protected int e(WorldServer level) {
        int previousReward = this.bN;
        if (this.e_()) {
            this.bN = (int)((double)this.bN * 2.5);
        }
        int reward = super.e(level);
        this.bN = previousReward;
        return reward;
    }

    @Override
    public void a(boolean childZombie) {
        this.au().a(ce, childZombie);
        if (this.dV() != null && !this.dV().C) {
            AttributeModifiable attribute = this.g(GenericAttributes.v);
            attribute.c(this.babyModifier.b());
            if (childZombie) {
                attribute.b(this.babyModifier);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (ce.equals(key)) {
            this.m_();
        }
        super.a(key);
    }

    protected boolean gt() {
        return true;
    }

    @Override
    public void h() {
        if (!this.dV().C && this.bL() && !this.gf()) {
            if (this.gy()) {
                --this.cn;
                if (this.cn < 0) {
                    this.ah_();
                }
            } else if (this.gt()) {
                if (((Entity)this).a(TagsFluid.a)) {
                    ++this.cm;
                    if (this.cm >= 600) {
                        this.r(300);
                    }
                } else {
                    this.cm = -1;
                }
            }
        }
        super.h();
    }

    @Override
    public void d_() {
        if (this.bL()) {
            boolean flag;
            boolean bl = flag = this.ai_() && this.gk();
            if (flag) {
                ItemStack itemBySlot = this.a(EnumItemSlot.f);
                if (!itemBySlot.f()) {
                    if (itemBySlot.m()) {
                        Item item = itemBySlot.h();
                        itemBySlot.b(itemBySlot.o() + this.ae.a(2));
                        if (itemBySlot.o() >= itemBySlot.p()) {
                            this.a(item, EnumItemSlot.f);
                            this.a(EnumItemSlot.f, ItemStack.j);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.d(8.0f);
                }
            }
        }
        super.d_();
    }

    public void stopDrowning() {
        this.cn = -1;
        this.au().a(cg, false);
    }

    public void r(int conversionTime) {
        this.cn = conversionTime;
        this.au().a(cg, true);
    }

    protected void ah_() {
        this.b(EntityTypes.K);
        if (!this.bb()) {
            this.dV().a(null, 1040, this.dv(), 0);
        }
    }

    protected void b(EntityTypes<? extends EntityZombie> entityType) {
        EntityZombie converted = this.convertTo(entityType, ConversionParams.a(this, true, true), (T zombie) -> zombie.J(zombie.dV().d_(zombie.dv()).d()), EntityTransformEvent.TransformReason.DROWNED, CreatureSpawnEvent.SpawnReason.DROWNED);
        if (converted == null) {
            ((Zombie)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    @VisibleForTesting
    public boolean a(WorldServer level, EntityVillager villager) {
        return EntityZombie.convertVillagerToZombieVillager(level, villager, this.dv(), this.bb(), EntityTransformEvent.TransformReason.INFECTION, CreatureSpawnEvent.SpawnReason.INFECTION) != null;
    }

    public static EntityZombieVillager convertVillagerToZombieVillager(WorldServer level, EntityVillager villager, BlockPosition blockPosition, boolean silent, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        EntityZombieVillager zombieVillager = villager.convertTo(EntityTypes.bP, ConversionParams.a(villager, true, true), (T mob) -> {
            mob.a((WorldAccess)level, level.d_(mob.dv()), EntitySpawnReason.i, new GroupDataZombie(false, true));
            mob.a(villager.gC());
            mob.a(villager.gM().a(DynamicOpsNBT.a));
            mob.a(villager.gu().a());
            mob.s(villager.x());
            if (!silent) {
                level.a(null, 1026, blockPosition, 0);
            }
        }, transformReason, creatureSpawnReason);
        return zombieVillager;
    }

    public boolean ai_() {
        return this.shouldBurnInDay;
    }

    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.shouldBurnInDay = shouldBurnInDay;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (!super.a(level, damageSource, amount)) {
            return false;
        }
        EntityLiving target = this.O_();
        if (target == null && damageSource.d() instanceof EntityLiving) {
            target = (EntityLiving)damageSource.d();
        }
        if (target != null && level.am() == EnumDifficulty.d && (double)this.ae.i() < this.h(GenericAttributes.A) && level.O().b(GameRules.e)) {
            int floor = MathHelper.a(this.dA());
            int floor1 = MathHelper.a(this.dC());
            int floor2 = MathHelper.a(this.dG());
            EntityTypes<? extends EntityZombie> type = this.aq();
            EntityZombie zombie = type.a(level, EntitySpawnReason.j);
            if (zombie == null) {
                return true;
            }
            for (int i2 = 0; i2 < 50; ++i2) {
                int i3;
                int i22;
                int i1 = floor + MathHelper.a(this.ae, 7, 40) * MathHelper.a(this.ae, -1, 1);
                BlockPosition blockPos = new BlockPosition(i1, i22 = floor1 + MathHelper.a(this.ae, 7, 40) * MathHelper.a(this.ae, -1, 1), i3 = floor2 + MathHelper.a(this.ae, 7, 40) * MathHelper.a(this.ae, -1, 1));
                if (!EntityPositionTypes.a(type, level, blockPos) || !EntityPositionTypes.a(type, level, EntitySpawnReason.j, blockPos, level.A)) continue;
                zombie.a_(i1, i22, i3);
                if (level.hasNearbyAlivePlayerThatAffectsSpawning(i1, i22, i3, 7.0) || !level.f(zombie) || !level.g(zombie) || !zombie.x() && level.d(zombie.cR())) continue;
                zombie.setTarget(target, EntityTargetEvent.TargetReason.REINFORCEMENT_TARGET, true);
                zombie.a((WorldAccess)level, level.d_(zombie.dv()), EntitySpawnReason.j, null);
                level.addFreshEntityWithPassengers(zombie, CreatureSpawnEvent.SpawnReason.REINFORCEMENTS);
                AttributeModifiable attribute = this.g(GenericAttributes.A);
                AttributeModifier modifier = attribute.a(c);
                double d2 = modifier != null ? modifier.c() : 0.0;
                attribute.c(c);
                attribute.d(new AttributeModifier(c, d2 - 0.05, AttributeModifier.Operation.a));
                zombie.g(GenericAttributes.A).d(cb);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean c(WorldServer level, Entity source) {
        boolean flag = super.c(level, source);
        if (flag) {
            float effectiveDifficulty = this.dV().d_(this.dv()).b();
            if (this.eZ().f() && this.bY() && this.ae.i() < effectiveDifficulty * 0.3f) {
                EntityCombustByEntityEvent event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)source.getBukkitEntity(), (float)(2 * (int)effectiveDifficulty));
                this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    source.igniteForSeconds(event.getDuration(), false);
                }
            }
        }
        return flag;
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.Eh;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.Er;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.Em;
    }

    protected SoundEffect t() {
        return SoundEffects.Ex;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(this.t(), 0.15f, 1.0f);
    }

    public EntityTypes<? extends EntityZombie> aq() {
        return super.aq();
    }

    protected boolean x() {
        return false;
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        super.a(random, difficulty);
        float f2 = random.i();
        float f3 = this.dV().am() == EnumDifficulty.d ? 0.05f : 0.01f;
        if (f2 < f3) {
            int randomInt = random.a(3);
            if (randomInt == 0) {
                this.a(EnumItemSlot.a, new ItemStack(Items.pG));
            } else {
                this.a(EnumItemSlot.a, new ItemStack(Items.pH));
            }
        }
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("IsBaby", this.e_());
        compound.a("CanBreakDoors", this.gz());
        compound.a("InWaterTime", this.bj() ? this.cm : -1);
        compound.a("DrownedConversionTime", this.gy() ? this.cn : -1);
        compound.a("Paper.ShouldBurnInDay", this.shouldBurnInDay);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.a(compound.q("IsBaby"));
        this.y(compound.q("CanBreakDoors"));
        this.cm = compound.h("InWaterTime");
        if (compound.b("DrownedConversionTime", 99) && compound.h("DrownedConversionTime") > -1) {
            this.r(compound.h("DrownedConversionTime"));
        }
        if (compound.e("Paper.ShouldBurnInDay")) {
            this.shouldBurnInDay = compound.q("Paper.ShouldBurnInDay");
        }
    }

    @Override
    public boolean a(WorldServer level, EntityLiving entity) {
        EntityVillager villager;
        double fallbackChance;
        boolean flag = super.a(level, entity);
        double d2 = level.am() == EnumDifficulty.d ? 100.0 : (fallbackChance = level.am() == EnumDifficulty.c ? 50.0 : 0.0);
        if (this.ae.j() * 100.0 < level.paperConfig().entities.behavior.zombieVillagerInfectionChance.or(fallbackChance) && entity instanceof EntityVillager && this.a(level, villager = (EntityVillager)entity)) {
            flag = false;
        }
        return flag;
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? ch : super.e(pose);
    }

    @Override
    public boolean g(ItemStack stack) {
        return (!stack.a(Items.ry) || !this.e_() || !this.bZ()) && super.g(stack);
    }

    @Override
    public boolean c(WorldServer level, ItemStack stack) {
        return !stack.a(Items.sd) && super.c(level, stack);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.H_();
        spawnGroupData = super.a(level, difficulty, spawnReason, spawnGroupData);
        float specialMultiplier = difficulty.d();
        if (spawnReason != EntitySpawnReason.i) {
            this.a_(this.dV().paperConfig().entities.behavior.mobsCanAlwaysPickUpLoot.zombies || random.i() < 0.55f * specialMultiplier);
        }
        if (spawnGroupData == null) {
            spawnGroupData = new GroupDataZombie(EntityZombie.a(random), true);
        }
        if (spawnGroupData instanceof GroupDataZombie) {
            GroupDataZombie zombieGroupData = (GroupDataZombie)spawnGroupData;
            if (zombieGroupData.a) {
                this.a(true);
                if (zombieGroupData.b) {
                    EntityChicken chicken1;
                    if ((double)random.i() < 0.05) {
                        List<Entity> entitiesOfClass = level.a(EntityChicken.class, this.cR().c(5.0, 3.0, 5.0), IEntitySelector.c);
                        if (!entitiesOfClass.isEmpty()) {
                            EntityChicken chicken = (EntityChicken)entitiesOfClass.get(0);
                            chicken.x(true);
                            this.n(chicken);
                        }
                    } else if ((double)random.i() < 0.05 && (chicken1 = EntityTypes.z.a(this.dV(), EntitySpawnReason.g)) != null) {
                        chicken1.b(this.dA(), this.dC(), this.dG(), this.dL(), 0.0f);
                        chicken1.a(level, difficulty, EntitySpawnReason.g, null);
                        chicken1.x(true);
                        this.n(chicken1);
                        level.addFreshEntity(chicken1, CreatureSpawnEvent.SpawnReason.MOUNT);
                    }
                }
            }
            this.y(random.i() < specialMultiplier * 0.1f);
            if (spawnReason != EntitySpawnReason.i) {
                this.a(random, difficulty);
                this.a(level, random, difficulty);
            }
        }
        if (this.a(EnumItemSlot.f).f()) {
            LocalDate localDate = LocalDate.now();
            int i2 = localDate.get(ChronoField.DAY_OF_MONTH);
            int i1 = localDate.get(ChronoField.MONTH_OF_YEAR);
            if (i1 == 10 && i2 == 31 && random.i() < 0.25f) {
                this.a(EnumItemSlot.f, new ItemStack(random.i() < 0.1f ? Blocks.es : Blocks.er));
                this.bV[EnumItemSlot.f.b()] = 0.0f;
            }
        }
        this.J(specialMultiplier);
        return spawnGroupData;
    }

    @VisibleForTesting
    public void b(int inWaterTime) {
        this.cm = inWaterTime;
    }

    @VisibleForTesting
    public void c(int conversionTime) {
        this.cn = conversionTime;
    }

    public static boolean a(RandomSource random) {
        return random.i() < 0.05f;
    }

    protected void J(float difficulty) {
        this.gA();
        this.g(GenericAttributes.p).c(new AttributeModifier(EntityInsentient.bL, this.ae.j() * (double)0.05f, AttributeModifier.Operation.a));
        double d2 = this.ae.j() * 1.5 * (double)difficulty;
        if (d2 > 1.0) {
            this.g(GenericAttributes.m).c(new AttributeModifier(cd, d2, AttributeModifier.Operation.c));
        }
        if (this.ae.i() < difficulty * 0.05f) {
            this.g(GenericAttributes.A).c(new AttributeModifier(cc, this.ae.j() * 0.25 + 0.5, AttributeModifier.Operation.a));
            this.g(GenericAttributes.s).c(new AttributeModifier(cc, this.ae.j() * 3.0 + 1.0, AttributeModifier.Operation.c));
            this.y(true);
        }
    }

    protected void gA() {
        this.g(GenericAttributes.A).a(this.ae.j() * (double)0.1f);
    }

    @Override
    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
        ItemStack skull;
        EntityCreeper creeper;
        super.a(level, damageSource, recentlyHit);
        Entity entity = damageSource.d();
        if (entity instanceof EntityCreeper && (creeper = (EntityCreeper)entity).gt() && !(skull = this.gs()).f()) {
            creeper.gu();
            this.a(level, skull);
        }
    }

    protected ItemStack gs() {
        return new ItemStack(Items.vn);
    }

    class a
    extends PathfinderGoalRemoveBlock {
        a(EntityCreature mob, double speedModifier, int verticalSearchRange) {
            super(Blocks.mH, mob, speedModifier, verticalSearchRange);
        }

        @Override
        public void a(GeneratorAccess level, BlockPosition pos) {
            level.a(null, pos, SoundEffects.En, SoundCategory.f, 0.5f, 0.9f + EntityZombie.this.ae.i() * 0.2f);
        }

        @Override
        public void a(World level, BlockPosition pos) {
            level.a(null, pos, SoundEffects.AW, SoundCategory.e, 0.7f, 0.9f + level.A.i() * 0.2f);
        }

        @Override
        public double i() {
            return 1.14;
        }
    }

    public static class GroupDataZombie
    implements GroupDataEntity {
        public final boolean a;
        public final boolean b;

        public GroupDataZombie(boolean isBaby, boolean canSpawnJockey) {
            this.a = isBaby;
            this.b = canSpawnJockey;
        }
    }
}

