/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorAttack;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetForget;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetSet;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorGateSingle;
import net.minecraft.world.entity.ai.behavior.BehaviorLook;
import net.minecraft.world.entity.ai.behavior.BehaviorLookWalk;
import net.minecraft.world.entity.ai.behavior.BehaviorNop;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollRandomUnconstrained;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.behavior.BehaviorWalkAwayOutOfRange;
import net.minecraft.world.entity.ai.behavior.BehavorMove;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.hoglin.IOglin;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityZoglin
extends EntityMonster
implements IOglin {
    private static final DataWatcherObject<Boolean> bY = DataWatcher.a(EntityZoglin.class, DataWatcherRegistry.k);
    private static final int bZ = 40;
    private static final int ca = 1;
    private static final float cb = 0.6f;
    private static final int cc = 6;
    private static final float cd = 0.5f;
    private static final int ce = 40;
    private static final int cf = 15;
    private static final int cg = 200;
    private static final float ch = 0.3f;
    private static final float ci = 0.4f;
    private int cj;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super EntityZoglin>>> a = ImmutableList.of(SensorType.c, SensorType.d);
    protected static final ImmutableList<? extends MemoryModuleType<?>> b = ImmutableList.of(MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.n, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.o, MemoryModuleType.p);

    public EntityZoglin(EntityTypes<? extends EntityZoglin> entityType, World level) {
        super((EntityTypes<? extends EntityMonster>)entityType, level);
        this.bN = 5;
    }

    protected BehaviorController.b<EntityZoglin> ec() {
        return BehaviorController.a(b, a);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        BehaviorController<EntityZoglin> brain = this.ec().a(dynamic);
        EntityZoglin.a(brain);
        EntityZoglin.b(brain);
        EntityZoglin.c(brain);
        brain.a((Set<Activity>)ImmutableSet.of((Object)Activity.a));
        brain.b(Activity.b);
        brain.f();
        return brain;
    }

    private static void a(BehaviorController<EntityZoglin> brain) {
        brain.a(Activity.a, 0, (ImmutableList<BehaviorControl<EntityZoglin>>)ImmutableList.of((Object)new BehaviorLook(45, 90), (Object)new BehavorMove()));
    }

    private static void b(BehaviorController<EntityZoglin> brain) {
        brain.a(Activity.b, 10, (ImmutableList<BehaviorControl<EntityZoglin>>)ImmutableList.of(BehaviorAttackTargetSet.a((WorldServer level, E zoglin) -> zoglin.g(level)), SetEntityLookTargetSometimes.a(8.0f, UniformInt.a(30, 60)), new BehaviorGateSingle(ImmutableList.of((Object)Pair.of(BehaviorStrollRandomUnconstrained.a(0.4f), (Object)2), (Object)Pair.of(BehaviorLookWalk.a(0.4f, 3), (Object)2), (Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)1)))));
    }

    private static void c(BehaviorController<EntityZoglin> brain) {
        brain.a(Activity.k, 10, (ImmutableList<BehaviorControl<EntityZoglin>>)ImmutableList.of(BehaviorWalkAwayOutOfRange.a(1.0f), BehaviorBuilder.a(EntityZoglin::p, BehaviorAttack.a(40)), BehaviorBuilder.a(EntityZoglin::e_, BehaviorAttack.a(15)), BehaviorAttackTargetForget.a()), MemoryModuleType.o);
    }

    private Optional<? extends EntityLiving> g(WorldServer level) {
        return this.eb().c(MemoryModuleType.h).orElse(NearestVisibleLivingEntities.a()).a((EntityLiving entity) -> this.b(level, (EntityLiving)entity));
    }

    private boolean b(WorldServer level, EntityLiving entity) {
        EntityTypes<?> type = entity.aq();
        return type != EntityTypes.bM && type != EntityTypes.E && Sensor.c(level, this, entity);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bY, false);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (bY.equals(key)) {
            this.m_();
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (level.H_().i() < 0.2f) {
            this.a(true);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gx().a(GenericAttributes.s, 40.0).a(GenericAttributes.v, 0.3f).a(GenericAttributes.p, 0.6f).a(GenericAttributes.d, 1.0).a(GenericAttributes.c, 6.0);
    }

    public boolean p() {
        return !this.e_();
    }

    @Override
    public boolean c(WorldServer level, Entity source) {
        if (source instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)source;
            this.cj = 10;
            level.a((Entity)this, (byte)4);
            this.b(SoundEffects.Ed);
            return IOglin.a(level, this, livingEntity);
        }
        return false;
    }

    @Override
    public boolean y() {
        return true;
    }

    @Override
    protected void e(EntityLiving entity) {
        if (!this.e_()) {
            IOglin.a(this, entity);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        boolean flag = super.a(level, damageSource, amount);
        if (flag && (entity = damageSource.d()) instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            if (this.c(livingEntity) && !BehaviorUtil.a((EntityLiving)this, livingEntity, 4.0)) {
                this.j(livingEntity);
            }
            return true;
        }
        return flag;
    }

    private void j(EntityLiving target) {
        this.bE.b(MemoryModuleType.E);
        this.bE.a(MemoryModuleType.o, target, 200L);
    }

    public BehaviorController<EntityZoglin> eb() {
        return super.eb();
    }

    protected void t() {
        Activity activity = this.bE.g().orElse(null);
        this.bE.a((List<Activity>)ImmutableList.of((Object)Activity.k, (Object)Activity.b));
        Activity activity1 = this.bE.g().orElse(null);
        if (activity1 == Activity.k && activity != Activity.k) {
            this.gs();
        }
        this.w(this.bE.a(MemoryModuleType.o));
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("zoglinBrain");
        this.eb().a(level, this);
        profilerFiller.c();
        this.t();
    }

    @Override
    public void a(boolean childZombie) {
        this.au().a(bY, childZombie);
        if (!this.dV().C && childZombie) {
            this.g(GenericAttributes.c).a(0.5);
        }
    }

    @Override
    public boolean e_() {
        return this.au().a(bY);
    }

    @Override
    public void d_() {
        if (this.cj > 0) {
            --this.cj;
        }
        super.d_();
    }

    @Override
    public void b(byte id) {
        if (id == 4) {
            this.cj = 10;
            this.b(SoundEffects.Ed);
        } else {
            super.b(id);
        }
    }

    @Override
    public int x() {
        return this.cj;
    }

    @Override
    protected SoundEffect u() {
        if (this.dV().C) {
            return null;
        }
        return this.bE.a(MemoryModuleType.o) ? SoundEffects.Ec : SoundEffects.Eb;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.Ef;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.Ee;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.Eg, 0.15f, 1.0f);
    }

    protected void gs() {
        this.b(SoundEffects.Ec);
    }

    @Override
    @Nullable
    public EntityLiving O_() {
        return this.R();
    }

    @Override
    protected void ac() {
        super.ac();
        PacketDebug.a(this);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        if (this.e_()) {
            compound.a("IsBaby", true);
        }
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        if (compound.q("IsBaby")) {
            this.a(true);
        }
    }
}

