/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.WitchConsumePotionEvent;
import com.destroystokyo.paper.event.entity.WitchThrowPotionEvent;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTargetWitch;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestHealableRaider;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Witch;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.inventory.ItemStack;

public class EntityWitch
extends EntityRaider
implements IRangedEntity {
    private static final MinecraftKey a = MinecraftKey.b("drinking");
    private static final AttributeModifier b = new AttributeModifier(a, -0.25, AttributeModifier.Operation.a);
    private static final DataWatcherObject<Boolean> bY = DataWatcher.a(EntityWitch.class, DataWatcherRegistry.k);
    public int bZ;
    private PathfinderGoalNearestHealableRaider<EntityRaider> ca;
    private PathfinderGoalNearestAttackableTargetWitch<EntityHuman> cb;

    public EntityWitch(EntityTypes<? extends EntityWitch> entityType, World level) {
        super((EntityTypes<? extends EntityRaider>)entityType, level);
    }

    @Override
    protected void E() {
        super.E();
        this.ca = new PathfinderGoalNearestHealableRaider<EntityRaider>(this, EntityRaider.class, true, (entity, level) -> this.gI() && entity.aq() != EntityTypes.bH);
        this.cb = new PathfinderGoalNearestAttackableTargetWitch<EntityHuman>(this, EntityHuman.class, 10, true, false, null);
        this.bS.a(1, new PathfinderGoalFloat(this));
        this.bS.a(2, new PathfinderGoalArrowAttack(this, 1.0, 60, 10.0f));
        this.bS.a(2, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bS.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bS.a(3, new PathfinderGoalRandomLookaround(this));
        this.bT.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class));
        this.bT.a(2, this.ca);
        this.bT.a(3, this.cb);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bY, false);
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.Dg;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.Dk;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.Di;
    }

    public void z(boolean usingItem) {
        this.au().a(bY, usingItem);
    }

    public boolean m() {
        return this.au().a(bY);
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gx().a(GenericAttributes.s, 26.0).a(GenericAttributes.v, 0.25);
    }

    @Override
    public void d_() {
        if (!this.dV().C && this.bL()) {
            this.ca.k();
            if (this.ca.i() <= 0) {
                this.cb.a(true);
            } else {
                this.cb.a(false);
            }
            if (this.m()) {
                if (this.bZ-- <= 0) {
                    this.z(false);
                    net.minecraft.world.item.ItemStack mainHandItem = this.eZ();
                    this.a(EnumItemSlot.a, net.minecraft.world.item.ItemStack.j);
                    PotionContents potionContents = mainHandItem.a(DataComponents.Q);
                    if (mainHandItem.a(Items.ti)) {
                        WitchConsumePotionEvent event = new WitchConsumePotionEvent((Witch)this.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(mainHandItem));
                        PotionContents potionContents2 = potionContents = event.callEvent() ? CraftItemStack.unwrap(event.getPotion()).a(DataComponents.Q) : null;
                    }
                    if (mainHandItem.a(Items.ti) && potionContents != null) {
                        potionContents.a((MobEffect effect) -> this.addEffect((MobEffect)effect, EntityPotionEffectEvent.Cause.ATTACK));
                    }
                    ((Entity)this).a(GameEvent.l);
                    this.g(GenericAttributes.v).c(b.b());
                }
            } else {
                Holder<PotionRegistry> holder = null;
                if (this.ae.i() < 0.15f && ((Entity)this).a(TagsFluid.a) && !this.b(MobEffects.m)) {
                    holder = Potions.w;
                } else if (this.ae.i() < 0.15f && (this.bY() || this.eF() != null && this.eF().a(DamageTypeTags.i)) && !this.b(MobEffects.l)) {
                    holder = Potions.l;
                } else if (this.ae.i() < 0.05f && this.eD() < this.eS()) {
                    holder = Potions.y;
                } else if (this.ae.i() < 0.5f && this.O_() != null && !this.b(MobEffects.a) && this.O_().g((Entity)this) > 121.0) {
                    holder = Potions.n;
                }
                if (holder != null) {
                    this.setDrinkingPotion(PotionContents.a(Items.ti, holder));
                }
            }
            if (this.ae.i() < 7.5E-4f) {
                this.dV().a((Entity)this, (byte)15);
            }
        }
        super.d_();
    }

    public void setDrinkingPotion(net.minecraft.world.item.ItemStack potion) {
        potion = CraftEventFactory.handleWitchReadyPotionEvent(this, potion);
        this.a(EnumItemSlot.a, potion);
        this.bZ = this.eZ().a(this);
        this.z(true);
        if (!this.bb()) {
            this.dV().a(null, this.dA(), this.dC(), this.dG(), SoundEffects.Dj, this.dm(), 1.0f, 0.8f + this.ae.i() * 0.4f);
        }
        AttributeModifiable attribute = this.g(GenericAttributes.v);
        attribute.c(a);
        attribute.b(b);
    }

    @Override
    public SoundEffect aj_() {
        return SoundEffects.Dh;
    }

    @Override
    public void b(byte id) {
        if (id == 15) {
            for (int i2 = 0; i2 < this.ae.a(35) + 10; ++i2) {
                this.dV().a(Particles.ap, this.dA() + this.ae.k() * (double)0.13f, this.cR().e + 0.5 + this.ae.k() * (double)0.13f, this.dG() + this.ae.k() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else {
            super.b(id);
        }
    }

    @Override
    protected float f(DamageSource source, float damage) {
        damage = super.f(source, damage);
        if (source.d() == this) {
            damage = 0.0f;
        }
        if (source.a(DamageTypeTags.k)) {
            damage *= 0.15f;
        }
        return damage;
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        if (!this.m()) {
            Vec3D deltaMovement = target.dy();
            double d2 = target.dA() + deltaMovement.d - this.dA();
            double d1 = target.dE() - (double)1.1f - this.dC();
            double d22 = target.dG() + deltaMovement.f - this.dG();
            double squareRoot = Math.sqrt(d2 * d2 + d22 * d22);
            Holder<PotionRegistry> holder = Potions.A;
            if (target instanceof EntityRaider) {
                holder = target.eD() <= 4.0f ? Potions.y : Potions.F;
                this.h((EntityLiving)null);
            } else if (squareRoot >= 8.0 && !target.b(MobEffects.b)) {
                holder = Potions.q;
            } else if (target.eD() >= 8.0f && !target.b(MobEffects.s)) {
                holder = Potions.C;
            } else if (squareRoot <= 3.0 && !target.b(MobEffects.r) && this.ae.i() < 0.25f) {
                holder = Potions.L;
            }
            World world = this.dV();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                net.minecraft.world.item.ItemStack itemStack = PotionContents.a(Items.wo, holder);
                WitchThrowPotionEvent event = new WitchThrowPotionEvent((Witch)this.getBukkitEntity(), (LivingEntity)target.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(itemStack));
                if (!event.callEvent()) {
                    return;
                }
                itemStack = CraftItemStack.asNMSCopy(event.getPotion());
                IProjectile.a(EntityPotion::new, serverLevel, itemStack, this, d2, d1 + squareRoot * 0.2, d22, 0.75f, 8.0f);
            }
            if (!this.bb()) {
                this.dV().a(null, this.dA(), this.dC(), this.dG(), SoundEffects.Dl, this.dm(), 1.0f, 0.8f + this.ae.i() * 0.4f);
            }
        }
    }

    @Override
    public void a(WorldServer level, int wave, boolean unused) {
    }

    @Override
    public boolean gs() {
        return false;
    }
}

