/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBowShoot;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRestrictSun;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityShootBowEvent;

public abstract class EntitySkeletonAbstract
extends EntityMonster
implements IRangedEntity {
    private static final int a = 20;
    private static final int b = 40;
    private final PathfinderGoalBowShoot<EntitySkeletonAbstract> c = new PathfinderGoalBowShoot<EntitySkeletonAbstract>(this, 1.0, 20, 15.0f);
    private final PathfinderGoalMeleeAttack d = new PathfinderGoalMeleeAttack(this, 1.2, false){

        @Override
        public void e() {
            super.e();
            EntitySkeletonAbstract.this.w(false);
        }

        @Override
        public void d() {
            super.d();
            EntitySkeletonAbstract.this.w(true);
        }
    };
    private boolean shouldBurnInDay = true;

    protected EntitySkeletonAbstract(EntityTypes<? extends EntitySkeletonAbstract> entityType, World level) {
        super((EntityTypes<? extends EntityMonster>)entityType, level);
        this.t();
    }

    @Override
    protected void E() {
        this.bS.a(2, new PathfinderGoalRestrictSun(this));
        this.bS.a(3, new PathfinderGoalFleeSun(this, 1.0));
        this.bS.a(3, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 6.0f, 1.0, 1.2));
        this.bS.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bS.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bS.a(6, new PathfinderGoalRandomLookaround(this));
        this.bT.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bT.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bT.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.bT.a(3, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.bY));
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gx().a(GenericAttributes.v, 0.25);
    }

    public boolean shouldBurnInDay() {
        return this.shouldBurnInDay;
    }

    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.shouldBurnInDay = shouldBurnInDay;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(this.p(), 0.15f, 1.0f);
    }

    abstract SoundEffect p();

    @Override
    public void d_() {
        boolean isSunBurnTick;
        boolean bl = isSunBurnTick = this.shouldBurnInDay && this.gk();
        if (isSunBurnTick) {
            ItemStack itemBySlot = this.a(EnumItemSlot.f);
            if (!itemBySlot.f()) {
                if (itemBySlot.m()) {
                    Item item = itemBySlot.h();
                    itemBySlot.b(itemBySlot.o() + this.ae.a(2));
                    if (itemBySlot.o() >= itemBySlot.p()) {
                        this.a(item, EnumItemSlot.f);
                        this.a(EnumItemSlot.f, ItemStack.j);
                    }
                }
                isSunBurnTick = false;
            }
            if (isSunBurnTick) {
                this.d(8.0f);
            }
        }
        super.d_();
    }

    @Override
    public void r() {
        super.r();
        Entity entity = this.dl();
        if (entity instanceof EntityCreature) {
            EntityCreature pathfinderMob = (EntityCreature)entity;
            this.aX = pathfinderMob.aX;
        }
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        super.a(random, difficulty);
        this.a(EnumItemSlot.a, new ItemStack(Items.pa));
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        spawnGroupData = super.a(level, difficulty, spawnReason, spawnGroupData);
        RandomSource random = level.H_();
        this.a(random, difficulty);
        this.a(level, random, difficulty);
        this.t();
        this.a_(this.dV().paperConfig().entities.behavior.mobsCanAlwaysPickUpLoot.skeletons || random.i() < 0.55f * difficulty.d());
        if (this.a(EnumItemSlot.f).f()) {
            LocalDate localDate = LocalDate.now();
            int i2 = localDate.get(ChronoField.DAY_OF_MONTH);
            int i1 = localDate.get(ChronoField.MONTH_OF_YEAR);
            if (i1 == 10 && i2 == 31 && random.i() < 0.25f) {
                this.a(EnumItemSlot.f, new ItemStack(random.i() < 0.1f ? Blocks.es : Blocks.er));
                this.bV[EnumItemSlot.f.b()] = 0.0f;
            }
        }
        return spawnGroupData;
    }

    public void t() {
        if (this.dV() != null && !this.dV().C) {
            this.bS.a(this.d);
            this.bS.a(this.c);
            ItemStack itemInHand = this.b(ProjectileHelper.a(this, Items.pa));
            if (itemInHand.a(Items.pa)) {
                int hardAttackInterval = this.x();
                if (this.dV().am() != EnumDifficulty.d) {
                    hardAttackInterval = this.gs();
                }
                this.c.c(hardAttackInterval);
                this.bS.a(4, this.c);
            } else {
                this.bS.a(4, this.d);
            }
        }
    }

    protected int x() {
        return 20;
    }

    protected int gs() {
        return 40;
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        ItemStack itemInHand = this.b(ProjectileHelper.a(this, Items.pa));
        ItemStack projectile = this.d(itemInHand);
        EntityArrow arrow = this.a(projectile, distanceFactor, itemInHand);
        double d2 = target.dA() - this.dA();
        double d1 = target.e(0.3333333333333333) - arrow.dC();
        double d22 = target.dG() - this.dG();
        double squareRoot = Math.sqrt(d2 * d2 + d22 * d22);
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            EntityShootBowEvent event = CraftEventFactory.callEntityShootBowEvent(this, this.eZ(), arrow.u(), arrow, EnumHand.a, 0.8f, true);
            if (event.isCancelled()) {
                event.getProjectile().remove();
                return;
            }
            if (event.getProjectile() == arrow.getBukkitEntity()) {
                IProjectile.a(arrow, serverLevel, projectile, d2, d1 + squareRoot * (double)0.2f, d22, 1.6f, 14 - serverLevel.am().a() * 4);
            }
        }
        this.a(SoundEffects.xN, 1.0f, 1.0f / (this.dY().i() * 0.4f + 0.8f));
    }

    protected EntityArrow a(ItemStack arrow, float velocity, @Nullable ItemStack weapon) {
        return ProjectileHelper.a(this, arrow, velocity, weapon);
    }

    @Override
    public boolean a(ItemProjectileWeapon projectileWeapon) {
        return projectileWeapon == Items.pa;
    }

    @Override
    public TagKey<Item> Z() {
        return TagsItem.bR;
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.t();
        if (compound.e("Paper.ShouldBurnInDay")) {
            this.shouldBurnInDay = compound.q("Paper.ShouldBurnInDay");
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Paper.ShouldBurnInDay", this.shouldBurnInDay);
    }

    @Override
    public void setItemSlot(EnumItemSlot slot, ItemStack stack, boolean silent) {
        super.setItemSlot(slot, stack, silent);
        if (!this.dV().C) {
            this.t();
        }
    }

    public boolean gt() {
        return this.cw();
    }
}

