/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import io.papermc.paper.event.entity.ShulkerDuplicateEvent;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftLocation;
import org.bukkit.entity.Shulker;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class EntityShulker
extends EntityGolem
implements VariantHolder<Optional<EnumColor>>,
IMonster {
    private static final MinecraftKey d = MinecraftKey.b("covered");
    private static final AttributeModifier bY = new AttributeModifier(d, 20.0, AttributeModifier.Operation.a);
    protected static final DataWatcherObject<EnumDirection> a = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.q);
    protected static final DataWatcherObject<Byte> b = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Byte> c = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.a);
    private static final int bZ = 6;
    private static final byte ca = 16;
    private static final byte cb = 16;
    private static final int cc = 8;
    private static final int cd = 8;
    private static final int ce = 5;
    private static final float cf = 0.05f;
    static final Vector3f cg = SystemUtils.a(() -> {
        BaseBlockPosition unitVec3i = EnumDirection.d.q();
        return new Vector3f((float)unitVec3i.u(), (float)unitVec3i.v(), (float)unitVec3i.w());
    });
    private static final float ch = 3.0f;
    private float ci;
    private float cj;
    @Nullable
    private BlockPosition ck;
    private int cl;
    private static final float cm = 1.0f;

    public EntityShulker(EntityTypes<? extends EntityShulker> entityType, World level) {
        super((EntityTypes<? extends EntityGolem>)entityType, level);
        this.bN = 5;
        this.bO = new d(this);
    }

    @Override
    protected void E() {
        this.bS.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f, 0.02f, true));
        this.bS.a(4, new a());
        this.bS.a(7, new f());
        this.bS.a(8, new PathfinderGoalRandomLookaround(this));
        this.bT.a(1, new PathfinderGoalHurtByTarget(this, this.getClass()).a(new Class[0]));
        this.bT.a(2, new e(this));
        this.bT.a(3, new c(this));
    }

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.a;
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.xl;
    }

    @Override
    public void U() {
        if (!this.gw()) {
            super.U();
        }
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.xr;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return this.gw() ? SoundEffects.xt : SoundEffects.xs;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, EnumDirection.a);
        builder.a(b, (byte)0);
        builder.a(c, (byte)16);
    }

    public static AttributeProvider.Builder m() {
        return EntityInsentient.F().a(GenericAttributes.s, 30.0);
    }

    @Override
    protected EntityAIBodyControl J() {
        return new b(this);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.a(EnumDirection.a(compound.f("AttachFace")));
        this.al.a(b, compound.f("Peek"));
        if (compound.b("Color", 99)) {
            this.al.a(c, compound.f("Color"));
        }
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("AttachFace", (byte)this.t().d());
        compound.a("Peek", this.al.a(b));
        compound.a("Color", this.al.a(c));
    }

    @Override
    public void h() {
        super.h();
        if (!(this.dV().C || this.bZ() || this.a(this.dv(), this.t()))) {
            this.gt();
        }
        if (this.gu()) {
            this.gv();
        }
        if (this.dV().C) {
            if (this.cl > 0) {
                --this.cl;
            } else {
                this.ck = null;
            }
        }
    }

    private void gt() {
        EnumDirection direction = this.h(this.dv());
        if (direction != null) {
            this.a(direction);
        } else {
            this.p();
        }
    }

    @Override
    protected AxisAlignedBB c(Vec3D position) {
        float physicalPeek = EntityShulker.L(this.cj);
        EnumDirection opposite = this.t().g();
        return EntityShulker.a(this.ej(), opposite, physicalPeek, position);
    }

    private static float L(float peek) {
        return 0.5f - MathHelper.a((0.5f + peek) * (float)Math.PI) * 0.5f;
    }

    private boolean gu() {
        this.ci = this.cj;
        float f2 = (float)this.gy() * 0.01f;
        if (this.cj == f2) {
            return false;
        }
        this.cj = this.cj > f2 ? MathHelper.a(this.cj - 0.05f, f2, 1.0f) : MathHelper.a(this.cj + 0.05f, 0.0f, f2);
        return true;
    }

    private void gv() {
        this.ay();
        float physicalPeek = EntityShulker.L(this.cj);
        float physicalPeek1 = EntityShulker.L(this.ci);
        EnumDirection opposite = this.t().g();
        float f2 = (physicalPeek - physicalPeek1) * this.ej();
        if (!(f2 <= 0.0f)) {
            for (Entity entity : this.dV().a((Entity)this, EntityShulker.a(this.ej(), opposite, physicalPeek1, physicalPeek, this.dt()), IEntitySelector.f.and(entity1 -> !entity1.z(this)))) {
                if (entity instanceof EntityShulker || entity.ad) continue;
                entity.a(EnumMoveType.e, new Vec3D(f2 * (float)opposite.j(), f2 * (float)opposite.k(), f2 * (float)opposite.l()));
            }
        }
    }

    public static AxisAlignedBB a(float scale, EnumDirection expansionDirection, float peek, Vec3D position) {
        return EntityShulker.a(scale, expansionDirection, -1.0f, peek, position);
    }

    public static AxisAlignedBB a(float scale, EnumDirection expansionDirection, float currentPeek, float oldPeek, Vec3D position) {
        AxisAlignedBB aabb = new AxisAlignedBB((double)(-scale) * 0.5, 0.0, (double)(-scale) * 0.5, (double)scale * 0.5, scale, (double)scale * 0.5);
        double d2 = Math.max(currentPeek, oldPeek);
        double d1 = Math.min(currentPeek, oldPeek);
        AxisAlignedBB aabb1 = aabb.b((double)expansionDirection.j() * d2 * (double)scale, (double)expansionDirection.k() * d2 * (double)scale, (double)expansionDirection.l() * d2 * (double)scale).a((double)(-expansionDirection.j()) * (1.0 + d1) * (double)scale, (double)(-expansionDirection.k()) * (1.0 + d1) * (double)scale, (double)(-expansionDirection.l()) * (1.0 + d1) * (double)scale);
        return aabb1.d(position.d, position.e, position.f);
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        if (this.dV().B_()) {
            this.ck = null;
            this.cl = 0;
        }
        this.a(EnumDirection.a);
        return super.a(entity, force);
    }

    @Override
    public void ae() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        super.stopRiding(suppressCancellation);
        if (this.dV().C) {
            this.ck = this.dv();
        }
        this.aY = 0.0f;
        this.aX = 0.0f;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.v(0.0f);
        this.aZ = this.dL();
        this.bz();
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public void a(EnumMoveType type, Vec3D pos) {
        if (type == EnumMoveType.d) {
            this.p();
        } else {
            super.a(type, pos);
        }
    }

    @Override
    public Vec3D dy() {
        return Vec3D.c;
    }

    @Override
    public void i(Vec3D deltaMovement) {
    }

    @Override
    public void a_(double x2, double y2, double z2) {
        BlockPosition blockPos1;
        BlockPosition blockPos = this.dv();
        if (this.bZ()) {
            super.a_(x2, y2, z2);
        } else {
            super.a_((double)MathHelper.a(x2) + 0.5, MathHelper.a(y2 + 0.5), (double)MathHelper.a(z2) + 0.5);
        }
        if (this.af != 0 && !(blockPos1 = this.dv()).equals(blockPos)) {
            this.al.a(b, (byte)0);
            this.ar = true;
            if (this.dV().C && !this.bZ() && !blockPos1.equals(this.ck)) {
                this.ck = blockPos;
                this.cl = 6;
                this.aa = this.dA();
                this.ab = this.dC();
                this.ac = this.dG();
            }
        }
    }

    @Nullable
    protected EnumDirection h(BlockPosition pos) {
        for (EnumDirection direction : EnumDirection.values()) {
            if (!this.a(pos, direction)) continue;
            return direction;
        }
        return null;
    }

    boolean a(BlockPosition pos, EnumDirection facing) {
        if (this.i(pos)) {
            return false;
        }
        EnumDirection opposite = facing.g();
        if (!this.dV().a(pos.a(facing), this, opposite)) {
            return false;
        }
        AxisAlignedBB aabb = EntityShulker.a(this.ej(), opposite, 1.0f, pos.c()).h(1.0E-6);
        return this.dV().a((Entity)this, aabb);
    }

    private boolean i(BlockPosition pos) {
        IBlockData blockState = this.dV().a_(pos);
        if (blockState.l()) {
            return false;
        }
        boolean flag = blockState.a(Blocks.bX) && pos.equals(this.dv());
        return !flag;
    }

    protected boolean p() {
        if (!this.gf() && this.bL()) {
            BlockPosition blockPos = this.dv();
            for (int i2 = 0; i2 < 5; ++i2) {
                BlockPosition blockPos1 = blockPos.b(MathHelper.b(this.ae, -8, 8), MathHelper.b(this.ae, -8, 8), MathHelper.b(this.ae, -8, 8));
                if (blockPos1.v() <= this.dV().L_() || !this.dV().u(blockPos1) || !this.dV().F_().a(blockPos1) || !this.dV().a((Entity)this, new AxisAlignedBB(blockPos1).h(1.0E-6))) continue;
                EnumDirection direction = this.h(blockPos1);
                EntityTeleportEvent teleportEvent = CraftEventFactory.callEntityTeleportEvent(this, blockPos1.u(), blockPos1.v(), blockPos1.w());
                if (teleportEvent.isCancelled() || teleportEvent.getTo() == null) {
                    return false;
                }
                blockPos1 = CraftLocation.toBlockPosition(teleportEvent.getTo());
                if (direction == null) continue;
                this.ao();
                this.a(direction);
                this.a(SoundEffects.xw, 1.0f, 1.0f);
                this.a_((double)blockPos1.u() + 0.5, blockPos1.v(), (double)blockPos1.w() + 0.5);
                this.dV().a(GameEvent.R, blockPos, GameEvent.a.a(this));
                this.al.a(b, (byte)0);
                this.h((EntityLiving)null);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void a(double x2, double y2, double z2, float yRot, float xRot, int steps) {
        this.bq = 0;
        this.a_(x2, y2, z2);
        this.b(yRot, xRot);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity directEntity;
        if (this.gw() && (directEntity = damageSource.c()) instanceof EntityArrow) {
            return false;
        }
        if (!super.a(level, damageSource, amount)) {
            return false;
        }
        if ((double)this.eD() < (double)this.eS() * 0.5 && this.ae.a(4) == 0) {
            this.p();
        } else if (damageSource.a(DamageTypeTags.j) && (directEntity = damageSource.c()) != null && directEntity.aq() == EntityTypes.bc) {
            this.gx();
        }
        return true;
    }

    private boolean gw() {
        return this.gy() == 0;
    }

    private void gx() {
        Vec3D vec3 = this.dt();
        AxisAlignedBB boundingBox = this.cR();
        if (!this.gw() && this.p()) {
            EntityShulker shulker;
            int size = this.dV().a(EntityTypes.bb, boundingBox.g(8.0), Entity::bL).size();
            float f2 = (float)(size - 1) / 5.0f;
            if (!(this.dV().A.i() < f2) && (shulker = EntityTypes.bb.a(this.dV(), EntitySpawnReason.e)) != null) {
                shulker.a(this.x());
                shulker.f(vec3);
                if (!new ShulkerDuplicateEvent((Shulker)shulker.getBukkitEntity(), (Shulker)this.getBukkitEntity()).callEvent()) {
                    return;
                }
                this.dV().addFreshEntity(shulker, CreatureSpawnEvent.SpawnReason.BREEDING);
            }
        }
    }

    @Override
    public boolean bN() {
        return this.bL();
    }

    public EnumDirection t() {
        return this.al.a(a);
    }

    @Override
    public void a(EnumDirection attachFace) {
        this.al.a(a, attachFace);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (a.equals(key)) {
            this.a(this.ax());
        }
        super.a(key);
    }

    public int gy() {
        return this.al.a(b).byteValue();
    }

    public void b(int peekAmount) {
        if (!this.dV().C) {
            this.g(GenericAttributes.a).c(d);
            if (peekAmount == 0) {
                this.g(GenericAttributes.a).d(bY);
                this.a(SoundEffects.xq, 1.0f, 1.0f);
                ((Entity)this).a((Holder<GameEvent>)GameEvent.j);
            } else {
                this.a(SoundEffects.xu, 1.0f, 1.0f);
                ((Entity)this).a((Holder<GameEvent>)GameEvent.k);
            }
        }
        this.al.a(b, (byte)peekAmount);
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.ci, this.cj);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.aX = 0.0f;
        this.aY = 0.0f;
    }

    @Override
    public int ad() {
        return 180;
    }

    @Override
    public int af() {
        return 180;
    }

    @Override
    public void h(Entity entity) {
    }

    @Nullable
    public Vec3D K(float partialTick) {
        if (this.ck != null && this.cl > 0) {
            double d2 = (double)((float)this.cl - partialTick) / 6.0;
            d2 *= d2;
            BlockPosition blockPos = this.dv();
            double d1 = (double)(blockPos.u() - this.ck.u()) * (d2 *= (double)this.ej());
            double d22 = (double)(blockPos.v() - this.ck.v()) * d2;
            double d3 = (double)(blockPos.w() - this.ck.w()) * d2;
            return new Vec3D(-d1, -d22, -d3);
        }
        return null;
    }

    @Override
    protected float b(float scale) {
        return Math.min(scale, 3.0f);
    }

    @Override
    public void a(Optional<EnumColor> variant) {
        this.al.a(c, variant.map(color -> (byte)color.a()).orElse((byte)16));
    }

    public Optional<EnumColor> x() {
        return Optional.ofNullable(this.gs());
    }

    @Nullable
    public EnumColor gs() {
        byte b2 = this.al.a(c);
        return b2 != 16 && b2 <= 15 ? EnumColor.a(b2) : null;
    }

    class d
    extends ControllerLook {
        public d(EntityInsentient mob) {
            super(mob);
        }

        @Override
        protected void b() {
        }

        @Override
        protected Optional<Float> i() {
            EnumDirection opposite = EntityShulker.this.t().g();
            Vector3f vector3f = opposite.b().transform(new Vector3f((Vector3fc)cg));
            BaseBlockPosition unitVec3i = opposite.q();
            Vector3f vector3f1 = new Vector3f((float)unitVec3i.u(), (float)unitVec3i.v(), (float)unitVec3i.w());
            vector3f1.cross((Vector3fc)vector3f);
            double d2 = this.e - this.a.dA();
            double d1 = this.f - this.a.dE();
            double d22 = this.g - this.a.dG();
            Vector3f vector3f2 = new Vector3f((float)d2, (float)d1, (float)d22);
            float f2 = vector3f1.dot((Vector3fc)vector3f2);
            float f1 = vector3f.dot((Vector3fc)vector3f2);
            return !(Math.abs(f2) > 1.0E-5f) && !(Math.abs(f1) > 1.0E-5f) ? Optional.empty() : Optional.of(Float.valueOf((float)(MathHelper.d((double)(-f2), (double)f1) * 180.0 / 3.1415927410125732)));
        }

        @Override
        protected Optional<Float> h() {
            return Optional.of(Float.valueOf(0.0f));
        }
    }

    class a
    extends PathfinderGoal {
        private int b;

        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving target = EntityShulker.this.O_();
            return target != null && target.bL() && EntityShulker.this.dV().am() != EnumDifficulty.a;
        }

        @Override
        public void d() {
            this.b = 20;
            EntityShulker.this.b(100);
        }

        @Override
        public void e() {
            EntityShulker.this.b(0);
        }

        @Override
        public boolean V_() {
            return true;
        }

        @Override
        public void a() {
            if (EntityShulker.this.dV().am() != EnumDifficulty.a) {
                --this.b;
                EntityLiving target = EntityShulker.this.O_();
                if (target != null) {
                    EntityShulker.this.L().a(target, 180.0f, 180.0f);
                    double d2 = EntityShulker.this.g((Entity)target);
                    if (d2 < 400.0) {
                        if (this.b <= 0) {
                            this.b = 20 + EntityShulker.this.ae.a(10) * 20 / 2;
                            EntityShulker.this.dV().b(new EntityShulkerBullet(EntityShulker.this.dV(), EntityShulker.this, target, EntityShulker.this.t().o()));
                            EntityShulker.this.a(SoundEffects.xv, 2.0f, (EntityShulker.this.ae.i() - EntityShulker.this.ae.i()) * 0.2f + 1.0f);
                        }
                    } else {
                        EntityShulker.this.h((EntityLiving)null);
                    }
                    super.a();
                }
            }
        }
    }

    class f
    extends PathfinderGoal {
        private int b;

        f() {
        }

        @Override
        public boolean b() {
            return EntityShulker.this.O_() == null && EntityShulker.this.ae.a(f.b(40)) == 0 && EntityShulker.this.a(EntityShulker.this.dv(), EntityShulker.this.t());
        }

        @Override
        public boolean c() {
            return EntityShulker.this.O_() == null && this.b > 0;
        }

        @Override
        public void d() {
            this.b = this.a(20 * (1 + EntityShulker.this.ae.a(3)));
            EntityShulker.this.b(30);
        }

        @Override
        public void e() {
            if (EntityShulker.this.O_() == null) {
                EntityShulker.this.b(0);
            }
        }

        @Override
        public void a() {
            --this.b;
        }
    }

    class e
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public e(EntityShulker shulker) {
            super((EntityInsentient)shulker, EntityHuman.class, true);
        }

        @Override
        public boolean b() {
            return EntityShulker.this.dV().am() != EnumDifficulty.a && super.b();
        }

        @Override
        protected AxisAlignedBB a(double targetDistance) {
            EnumDirection attachFace = ((EntityShulker)this.e).t();
            if (attachFace.o() == EnumDirection.EnumAxis.a) {
                return this.e.cR().c(4.0, targetDistance, targetDistance);
            }
            return attachFace.o() == EnumDirection.EnumAxis.c ? this.e.cR().c(targetDistance, targetDistance, 4.0) : this.e.cR().c(targetDistance, 4.0, targetDistance);
        }
    }

    static class c
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        public c(EntityShulker shulker) {
            super(shulker, EntityLiving.class, 10, true, false, (entity, level) -> entity instanceof IMonster);
        }

        @Override
        public boolean b() {
            return this.e.cr() != null && super.b();
        }

        @Override
        protected AxisAlignedBB a(double targetDistance) {
            EnumDirection attachFace = ((EntityShulker)this.e).t();
            if (attachFace.o() == EnumDirection.EnumAxis.a) {
                return this.e.cR().c(4.0, targetDistance, targetDistance);
            }
            return attachFace.o() == EnumDirection.EnumAxis.c ? this.e.cR().c(targetDistance, targetDistance, 4.0) : this.e.cR().c(targetDistance, 4.0, targetDistance);
        }
    }

    static class b
    extends EntityAIBodyControl {
        public b(EntityInsentient mob) {
            super(mob);
        }

        @Override
        public void a() {
        }
    }
}

