/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;

public class EntityRavager
extends EntityRaider {
    private static final Predicate<Entity> bY = entity -> !(entity instanceof EntityRavager) && entity.bL();
    private static final Predicate<Entity> bZ = entity -> bY.test((Entity)entity) && !entity.aq().equals(EntityTypes.f);
    private static final Predicate<EntityLiving> ca = livingEntity -> !(livingEntity instanceof EntityRavager) && livingEntity.bL() && livingEntity.dh();
    private static final double cb = 0.3;
    private static final double cc = 0.35;
    private static final int cd = 8356754;
    private static final float ce = 0.57254905f;
    private static final float cf = 0.5137255f;
    private static final float cg = 0.49803922f;
    public static final int a = 10;
    public static final int b = 40;
    public int ch;
    public int ci;
    public int cj;

    public EntityRavager(EntityTypes<? extends EntityRavager> entityType, World level) {
        super((EntityTypes<? extends EntityRaider>)entityType, level);
        this.bN = 20;
        this.a(PathType.v, 0.0f);
    }

    @Override
    protected void E() {
        super.E();
        this.bS.a(0, new PathfinderGoalFloat(this));
        this.bS.a(4, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.bS.a(5, new PathfinderGoalRandomStrollLand(this, 0.4));
        this.bS.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bS.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.bT.a(2, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bT.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bT.a(4, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, true, (entity, level) -> !entity.e_()));
        this.bT.a(4, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    protected void W() {
        boolean flag = !(this.cW() instanceof EntityInsentient) || this.cW().aq().a(TagsEntity.c);
        boolean flag1 = !(this.dk() instanceof AbstractBoat);
        this.bS.a(PathfinderGoal.Type.a, flag);
        this.bS.a(PathfinderGoal.Type.c, flag && flag1);
        this.bS.a(PathfinderGoal.Type.b, flag);
        this.bS.a(PathfinderGoal.Type.d, flag);
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gx().a(GenericAttributes.s, 100.0).a(GenericAttributes.v, 0.3).a(GenericAttributes.p, 0.75).a(GenericAttributes.c, 12.0).a(GenericAttributes.d, 1.5).a(GenericAttributes.m, 32.0).a(GenericAttributes.B, 1.0);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("AttackTick", this.ch);
        compound.a("StunTick", this.ci);
        compound.a("RoarTick", this.cj);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.ch = compound.h("AttackTick");
        this.ci = compound.h("StunTick");
        this.cj = compound.h("RoarTick");
    }

    @Override
    public SoundEffect aj_() {
        return SoundEffects.vF;
    }

    @Override
    public int af() {
        return 45;
    }

    @Override
    public void d_() {
        super.d_();
        if (this.bL()) {
            if (this.fi()) {
                this.g(GenericAttributes.v).a(0.0);
            } else {
                double d2 = this.O_() != null ? 0.35 : 0.3;
                double baseValue = this.g(GenericAttributes.v).b();
                this.g(GenericAttributes.v).a(MathHelper.d(0.1, baseValue, d2));
            }
            World world = this.dV();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                if (this.P && serverLevel.O().b(GameRules.c)) {
                    boolean flag = false;
                    AxisAlignedBB aabb = this.cR().g(0.2);
                    for (BlockPosition blockPos : BlockPosition.b(MathHelper.a(aabb.a), MathHelper.a(aabb.b), MathHelper.a(aabb.c), MathHelper.a(aabb.d), MathHelper.a(aabb.e), MathHelper.a(aabb.f))) {
                        IBlockData blockState = serverLevel.a_(blockPos);
                        Block block = blockState.b();
                        if (!(block instanceof BlockLeaves) || !CraftEventFactory.callEntityChangeBlockEvent(this, blockPos, blockState.y().g())) continue;
                        flag = serverLevel.a(blockPos, true, this) || flag;
                    }
                    if (!flag && this.aJ()) {
                        if (new EntityJumpEvent((LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                            this.s();
                        } else {
                            this.t(false);
                        }
                    }
                }
            }
            if (this.cj > 0) {
                --this.cj;
                if (this.cj == 10) {
                    this.gD();
                }
            }
            if (this.ch > 0) {
                --this.ch;
            }
            if (this.ci > 0) {
                --this.ci;
                this.gC();
                if (this.ci == 0) {
                    this.a(SoundEffects.vK, 1.0f, 1.0f);
                    this.cj = 20;
                }
            }
        }
    }

    private void gC() {
        if (this.ae.a(6) == 0) {
            double d2 = this.dA() - (double)this.dq() * Math.sin(this.aX * ((float)Math.PI / 180)) + (this.ae.j() * 0.6 - 0.3);
            double d1 = this.dC() + (double)this.dr() - 0.3;
            double d22 = this.dG() + (double)this.dq() * Math.cos(this.aX * ((float)Math.PI / 180)) + (this.ae.j() * 0.6 - 0.3);
            this.dV().a(ColorParticleOption.a(Particles.u, 0.49803922f, 0.5137255f, 0.57254905f), d2, d1, d22, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected boolean fi() {
        return super.fi() || this.ch > 0 || this.ci > 0 || this.cj > 0;
    }

    @Override
    public boolean E(Entity entity) {
        return this.ci <= 0 && this.cj <= 0 && super.E(entity);
    }

    @Override
    protected void e(EntityLiving entity) {
        if (this.cj == 0) {
            if (this.ae.j() < 0.5) {
                this.ci = 40;
                this.a(SoundEffects.vJ, 1.0f, 1.0f);
                this.dV().a((Entity)this, (byte)39);
                entity.h(this);
            } else {
                this.b((Entity)entity);
            }
            entity.T = true;
        }
    }

    private void gD() {
        if (this.bL()) {
            World world = this.dV();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                Predicate<Entity> predicate = serverLevel.O().b(GameRules.c) ? bY : bZ;
                for (EntityLiving livingEntity : this.dV().a(EntityLiving.class, this.cR().g(4.0), predicate)) {
                    if (!(livingEntity instanceof EntityIllagerAbstract)) {
                        livingEntity.a(serverLevel, this.dW().b(this), 6.0f);
                    }
                    if (livingEntity instanceof EntityHuman) continue;
                    this.b((Entity)livingEntity);
                }
                ((Entity)this).a(GameEvent.u);
            } else {
                for (EntityLiving livingEntity1 : this.dV().a(EntityLiving.class, this.cR().g(4.0), ca)) {
                    this.b((Entity)livingEntity1);
                }
                Vec3D center = this.cR().f();
                for (int i2 = 0; i2 < 40; ++i2) {
                    double d2 = this.ae.k() * 0.2;
                    double d1 = this.ae.k() * 0.2;
                    double d22 = this.ae.k() * 0.2;
                    this.dV().a(Particles.ad, center.d, center.e, center.f, d2, d1, d22);
                }
            }
        }
    }

    private void b(Entity entity) {
        double d2 = entity.dA() - this.dA();
        double d1 = entity.dG() - this.dG();
        double max = Math.max(d2 * d2 + d1 * d1, 0.001);
        entity.push(d2 / max * 4.0, 0.2, d1 / max * 4.0, this);
    }

    @Override
    public void b(byte id) {
        if (id == 4) {
            this.ch = 10;
            this.a(SoundEffects.vE, 1.0f, 1.0f);
        } else if (id == 39) {
            this.ci = 40;
        }
        super.b(id);
    }

    public int p() {
        return this.ch;
    }

    public int x() {
        return this.ci;
    }

    public int gB() {
        return this.cj;
    }

    @Override
    public boolean c(WorldServer level, Entity source) {
        this.ch = 10;
        level.a((Entity)this, (byte)4);
        this.a(SoundEffects.vE, 1.0f, 1.0f);
        return super.c(level, source);
    }

    @Override
    @Nullable
    protected SoundEffect u() {
        return SoundEffects.vD;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.vH;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.vG;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.vI, 0.15f, 1.0f);
    }

    @Override
    public boolean a(IWorldReader level) {
        return !level.d(this.cR());
    }

    @Override
    public void a(WorldServer level, int wave, boolean unused) {
    }

    @Override
    public boolean gs() {
        return false;
    }

    @Override
    protected AxisAlignedBB gi() {
        AxisAlignedBB aabb = super.gi();
        return aabb.f(0.05, 0.0, 0.05);
    }
}

