/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalCrossbowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBanner;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityPillager
extends EntityIllagerAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityPillager.class, DataWatcherRegistry.k);
    private static final int b = 5;
    private static final int bY = 300;
    public final InventorySubcontainer bZ = new InventorySubcontainer(5);

    public EntityPillager(EntityTypes<? extends EntityPillager> entityType, World level) {
        super((EntityTypes<? extends EntityIllagerAbstract>)entityType, level);
    }

    @Override
    protected void E() {
        super.E();
        this.bS.a(0, new PathfinderGoalFloat(this));
        this.bS.a(1, new PathfinderGoalAvoidTarget<Creaking>(this, Creaking.class, 8.0f, 1.0, 1.2));
        this.bS.a(2, new EntityRaider.a(this, 10.0f));
        this.bS.a(3, new PathfinderGoalCrossbowAttack<EntityPillager>(this, 1.0, 8.0f));
        this.bS.a(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.bS.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 15.0f, 1.0f));
        this.bS.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 15.0f));
        this.bT.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bT.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bT.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        this.bT.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gx().a(GenericAttributes.v, 0.35f).a(GenericAttributes.s, 24.0).a(GenericAttributes.c, 5.0).a(GenericAttributes.m, 32.0);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, false);
    }

    @Override
    public boolean a(ItemProjectileWeapon projectileWeapon) {
        return projectileWeapon == Items.wV;
    }

    public boolean x() {
        return this.al.a(a);
    }

    @Override
    public void b(boolean isCharging) {
        this.al.a(a, isCharging);
    }

    @Override
    public void a() {
        this.bf = 0;
    }

    @Override
    public TagKey<Item> Z() {
        return TagsItem.bU;
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        this.b(compound, this.dX());
    }

    @Override
    public EntityIllagerAbstract.a m() {
        if (this.x()) {
            return EntityIllagerAbstract.a.f;
        }
        if (this.b(Items.wV)) {
            return EntityIllagerAbstract.a.e;
        }
        return this.gh() ? EntityIllagerAbstract.a.b : EntityIllagerAbstract.a.h;
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.a(compound, this.dX());
        this.a_(true);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return 0.0f;
    }

    @Override
    public int aj() {
        return 1;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.H_();
        this.a(random, difficulty);
        this.a(level, random, difficulty);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        this.a(EnumItemSlot.a, new ItemStack(Items.wV));
    }

    @Override
    protected void b(WorldAccess level, RandomSource random, DifficultyDamageScaler difficulty) {
        ItemStack mainHandItem;
        super.b(level, random, difficulty);
        if (random.a(300) == 0 && (mainHandItem = this.eZ()).a(Items.wV)) {
            EnchantmentManager.a(mainHandItem, level.K_(), VanillaEnchantmentProviders.b, difficulty, random);
        }
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.uv;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.ux;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.uy;
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        this.b(this, 1.6f);
    }

    @Override
    public InventorySubcontainer t() {
        return this.bZ;
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        ItemStack item = entity.l();
        if (item.h() instanceof ItemBanner) {
            super.a(level, entity);
        } else if (this.i(item)) {
            this.a(entity);
            ItemStack itemStack = this.bZ.b(item);
            if (itemStack.f()) {
                entity.discard(EntityRemoveEvent.Cause.PICKUP);
            } else {
                item.e(itemStack.M());
            }
        }
    }

    private boolean i(ItemStack item) {
        return this.gI() && item.a(Items.vP);
    }

    @Override
    public SlotAccess a_(int slot) {
        int i2 = slot - 300;
        return i2 >= 0 && i2 < this.bZ.b() ? SlotAccess.a(this.bZ, i2) : super.a_(slot);
    }

    @Override
    public void a(WorldServer level, int wave, boolean unused) {
        boolean flag;
        Raid currentRaid = this.gF();
        boolean bl = flag = this.ae.i() <= currentRaid.v();
        if (flag) {
            ItemStack itemStack = new ItemStack(Items.wV);
            ResourceKey<EnchantmentProvider> resourceKey = wave > currentRaid.a(EnumDifficulty.c) ? VanillaEnchantmentProviders.d : (wave > currentRaid.a(EnumDifficulty.b) ? VanillaEnchantmentProviders.c : null);
            if (resourceKey != null) {
                EnchantmentManager.a(itemStack, level.K_(), resourceKey, level.d_(this.dv()), this.dY());
                this.a(EnumItemSlot.a, itemStack);
            }
        }
    }

    @Override
    public SoundEffect aj_() {
        return SoundEffects.uw;
    }
}

