/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityFlying;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityPhantom
extends EntityFlying
implements IMonster {
    public static final float a = 7.448451f;
    public static final int b = MathHelper.f(24.166098f);
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityPhantom.class, DataWatcherRegistry.b);
    Vec3D d = Vec3D.c;
    public BlockPosition bX = BlockPosition.c;
    AttackPhase bY = AttackPhase.a;
    @Nullable
    public UUID spawningEntity;
    public boolean shouldBurnInDay = true;

    public EntityPhantom(EntityTypes<? extends EntityPhantom> entityType, World level) {
        super((EntityTypes<? extends EntityFlying>)entityType, level);
        this.bN = 5;
        this.bP = new g(this);
        this.bO = new f(this);
    }

    @Override
    public boolean ba() {
        return (this.p() + this.af) % b == 0;
    }

    @Override
    protected EntityAIBodyControl J() {
        return new d(this);
    }

    @Override
    protected void E() {
        this.bS.a(1, new c());
        this.bS.a(2, new i());
        this.bS.a(3, new e());
        this.bT.a(1, new b());
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, 0);
    }

    public void b(int phantomSize) {
        this.al.a(c, MathHelper.a(phantomSize, 0, 64));
    }

    private void t() {
        this.m_();
        this.g(GenericAttributes.c).a(6 + this.m());
    }

    public int m() {
        return this.al.a(c);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (c.equals(key)) {
            this.t();
        }
        super.a(key);
    }

    public int p() {
        return this.ar() * 3;
    }

    @Override
    protected boolean ab() {
        return true;
    }

    @Override
    public void h() {
        super.h();
        if (this.dV().C) {
            float cos = MathHelper.b((float)(this.p() + this.af) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI);
            float cos1 = MathHelper.b((float)(this.p() + this.af + 1) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI);
            if (cos > 0.0f && cos1 <= 0.0f) {
                this.dV().a(this.dA(), this.dC(), this.dG(), SoundEffects.tX, this.dm(), 0.95f + this.ae.i() * 0.05f, 0.95f + this.ae.i() * 0.05f, false);
            }
            float f2 = this.dq() * 1.48f;
            float f1 = MathHelper.b(this.dL() * ((float)Math.PI / 180)) * f2;
            float f22 = MathHelper.a(this.dL() * ((float)Math.PI / 180)) * f2;
            float f3 = (0.3f + cos * 0.45f) * this.dr() * 2.5f;
            this.dV().a(Particles.ab, this.dA() + (double)f1, this.dC() + (double)f3, this.dG() + (double)f22, 0.0, 0.0, 0.0);
            this.dV().a(Particles.ab, this.dA() - (double)f1, this.dC() + (double)f3, this.dG() - (double)f22, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void d_() {
        if (this.bL() && this.shouldBurnInDay && this.gk()) {
            this.d(8.0f);
        }
        super.d_();
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.bX = this.dv().b(5);
        this.b(0);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        if (compound.e("AX")) {
            this.bX = new BlockPosition(compound.h("AX"), compound.h("AY"), compound.h("AZ"));
        }
        this.b(compound.h("Size"));
        if (compound.b("Paper.SpawningEntity")) {
            this.spawningEntity = compound.a("Paper.SpawningEntity");
        }
        if (compound.e("Paper.ShouldBurnInDay")) {
            this.shouldBurnInDay = compound.q("Paper.ShouldBurnInDay");
        }
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("AX", this.bX.u());
        compound.a("AY", this.bX.v());
        compound.a("AZ", this.bX.w());
        compound.a("Size", this.m());
        if (this.spawningEntity != null) {
            compound.a("Paper.SpawningEntity", this.spawningEntity);
        }
        compound.a("Paper.ShouldBurnInDay", this.shouldBurnInDay);
    }

    @Override
    public boolean a(double distance) {
        return true;
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.tU;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.tY;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.tW;
    }

    @Override
    public float fg() {
        return 1.0f;
    }

    @Override
    public boolean a(EntityTypes<?> type) {
        return true;
    }

    @Override
    public EntitySize e(EntityPose pose) {
        int phantomSize = this.m();
        EntitySize entityDimensions = super.e(pose);
        return entityDimensions.a(1.0f + 0.15f * (float)phantomSize);
    }

    boolean a(WorldServer level, EntityLiving entity, PathfinderTargetCondition targetingConditions) {
        return targetingConditions.a(level, this, entity);
    }

    static final class AttackPhase
    extends Enum<AttackPhase> {
        public static final /* enum */ AttackPhase a = new AttackPhase();
        public static final /* enum */ AttackPhase b = new AttackPhase();
        private static final /* synthetic */ AttackPhase[] c;

        public static AttackPhase[] values() {
            return (AttackPhase[])c.clone();
        }

        public static AttackPhase valueOf(String name) {
            return Enum.valueOf(AttackPhase.class, name);
        }

        private static /* synthetic */ AttackPhase[] a() {
            return new AttackPhase[]{a, b};
        }

        static {
            c = AttackPhase.a();
        }
    }

    class g
    extends ControllerMove {
        private float m;

        public g(EntityInsentient mob) {
            super(mob);
            this.m = 0.1f;
        }

        @Override
        public void a() {
            if (EntityPhantom.this.P) {
                EntityPhantom.this.v(EntityPhantom.this.dL() + 180.0f);
                this.m = 0.1f;
            }
            double d2 = EntityPhantom.this.d.d - EntityPhantom.this.dA();
            double d1 = EntityPhantom.this.d.e - EntityPhantom.this.dC();
            double d22 = EntityPhantom.this.d.f - EntityPhantom.this.dG();
            double squareRoot = Math.sqrt(d2 * d2 + d22 * d22);
            if (Math.abs(squareRoot) > (double)1.0E-5f) {
                double d3 = 1.0 - Math.abs(d1 * (double)0.7f) / squareRoot;
                squareRoot = Math.sqrt((d2 *= d3) * d2 + (d22 *= d3) * d22);
                double squareRoot1 = Math.sqrt(d2 * d2 + d22 * d22 + d1 * d1);
                float yRot = EntityPhantom.this.dL();
                float f2 = (float)MathHelper.d(d22, d2);
                float f1 = MathHelper.h(EntityPhantom.this.dL() + 90.0f);
                float f22 = MathHelper.h(f2 * 57.295776f);
                EntityPhantom.this.v(MathHelper.e(f1, f22, 4.0f) - 90.0f);
                EntityPhantom.this.aX = EntityPhantom.this.dL();
                this.m = MathHelper.d(yRot, EntityPhantom.this.dL()) < 3.0f ? MathHelper.d(this.m, 1.8f, 0.005f * (1.8f / this.m)) : MathHelper.d(this.m, 0.2f, 0.025f);
                float f3 = (float)(-(MathHelper.d(-d1, squareRoot) * 180.0 / 3.1415927410125732));
                EntityPhantom.this.w(f3);
                float f4 = EntityPhantom.this.dL() + 90.0f;
                double d4 = (double)(this.m * MathHelper.b(f4 * ((float)Math.PI / 180))) * Math.abs(d2 / squareRoot1);
                double d5 = (double)(this.m * MathHelper.a(f4 * ((float)Math.PI / 180))) * Math.abs(d22 / squareRoot1);
                double d6 = (double)(this.m * MathHelper.a(f3 * ((float)Math.PI / 180))) * Math.abs(d1 / squareRoot1);
                Vec3D deltaMovement = EntityPhantom.this.dy();
                EntityPhantom.this.i(deltaMovement.e(new Vec3D(d4, d6, d5).d(deltaMovement).c(0.2)));
            }
        }
    }

    static class f
    extends ControllerLook {
        public f(EntityInsentient mob) {
            super(mob);
        }

        @Override
        public void a() {
        }
    }

    class d
    extends EntityAIBodyControl {
        public d(EntityInsentient mob) {
            super(mob);
        }

        @Override
        public void a() {
            EntityPhantom.this.aZ = EntityPhantom.this.aX;
            EntityPhantom.this.aX = EntityPhantom.this.dL();
        }
    }

    class c
    extends PathfinderGoal {
        private int b;

        c() {
        }

        @Override
        public boolean b() {
            EntityLiving target = EntityPhantom.this.O_();
            return target != null && EntityPhantom.this.a(net.minecraft.world.entity.monster.EntityPhantom$c.a(EntityPhantom.this.dV()), target, PathfinderTargetCondition.a);
        }

        @Override
        public void d() {
            this.b = this.a(10);
            EntityPhantom.this.bY = AttackPhase.a;
            this.h();
        }

        @Override
        public void e() {
            EntityPhantom.this.bX = EntityPhantom.this.dV().a(HeightMap.Type.e, EntityPhantom.this.bX).b(10 + EntityPhantom.this.ae.a(20));
        }

        @Override
        public void a() {
            if (EntityPhantom.this.bY == AttackPhase.a) {
                --this.b;
                if (this.b <= 0) {
                    EntityPhantom.this.bY = AttackPhase.b;
                    this.h();
                    this.b = this.a((8 + EntityPhantom.this.ae.a(4)) * 20);
                    EntityPhantom.this.a(SoundEffects.tZ, 10.0f, 0.95f + EntityPhantom.this.ae.i() * 0.1f);
                }
            }
        }

        private void h() {
            EntityPhantom.this.bX = EntityPhantom.this.O_().dv().b(20 + EntityPhantom.this.ae.a(20));
            if (EntityPhantom.this.bX.v() < EntityPhantom.this.dV().P()) {
                EntityPhantom.this.bX = new BlockPosition(EntityPhantom.this.bX.u(), EntityPhantom.this.dV().P() + 1, EntityPhantom.this.bX.w());
            }
        }
    }

    class i
    extends h {
        private static final int c = 20;
        private boolean d;
        private int e;

        i() {
        }

        @Override
        public boolean b() {
            return EntityPhantom.this.O_() != null && EntityPhantom.this.bY == AttackPhase.b;
        }

        @Override
        public boolean c() {
            EntityLiving target = EntityPhantom.this.O_();
            if (target == null) {
                return false;
            }
            if (!target.bL()) {
                return false;
            }
            if (target instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)target;
                if (target.Z_() || player.b()) {
                    return false;
                }
            }
            if (!this.b()) {
                return false;
            }
            if (EntityPhantom.this.af > this.e) {
                this.e = EntityPhantom.this.af + 20;
                List<Entity> entitiesOfClass = EntityPhantom.this.dV().a(EntityCat.class, EntityPhantom.this.cR().g(16.0), IEntitySelector.a);
                for (EntityCat entityCat : entitiesOfClass) {
                    entityCat.gH();
                }
                this.d = !entitiesOfClass.isEmpty();
            }
            return !this.d;
        }

        @Override
        public void d() {
        }

        @Override
        public void e() {
            EntityPhantom.this.h((EntityLiving)null);
            EntityPhantom.this.bY = AttackPhase.a;
        }

        @Override
        public void a() {
            EntityLiving target = EntityPhantom.this.O_();
            if (target != null) {
                EntityPhantom.this.d = new Vec3D(target.dA(), target.e(0.5), target.dG());
                if (EntityPhantom.this.cR().g(0.2f).c(target.cR())) {
                    EntityPhantom.this.c(net.minecraft.world.entity.monster.EntityPhantom$i.a(EntityPhantom.this.dV()), (Entity)target);
                    EntityPhantom.this.bY = AttackPhase.a;
                    if (!EntityPhantom.this.bb()) {
                        EntityPhantom.this.dV().c(1039, EntityPhantom.this.dv(), 0);
                    }
                } else if (EntityPhantom.this.P || EntityPhantom.this.aN > 0) {
                    EntityPhantom.this.bY = AttackPhase.a;
                }
            }
        }
    }

    class e
    extends h {
        private float c;
        private float d;
        private float e;
        private float f;

        e() {
        }

        @Override
        public boolean b() {
            return EntityPhantom.this.O_() == null || EntityPhantom.this.bY == AttackPhase.a;
        }

        @Override
        public void d() {
            this.d = 5.0f + EntityPhantom.this.ae.i() * 10.0f;
            this.e = -4.0f + EntityPhantom.this.ae.i() * 9.0f;
            this.f = EntityPhantom.this.ae.h() ? 1.0f : -1.0f;
            this.i();
        }

        @Override
        public void a() {
            if (EntityPhantom.this.ae.a(this.a(350)) == 0) {
                this.e = -4.0f + EntityPhantom.this.ae.i() * 9.0f;
            }
            if (EntityPhantom.this.ae.a(this.a(250)) == 0) {
                this.d += 1.0f;
                if (this.d > 15.0f) {
                    this.d = 5.0f;
                    this.f = -this.f;
                }
            }
            if (EntityPhantom.this.ae.a(this.a(450)) == 0) {
                this.c = EntityPhantom.this.ae.i() * 2.0f * (float)Math.PI;
                this.i();
            }
            if (this.h()) {
                this.i();
            }
            if (EntityPhantom.this.d.e < EntityPhantom.this.dC() && !EntityPhantom.this.dV().u(EntityPhantom.this.dv().c(1))) {
                this.e = Math.max(1.0f, this.e);
                this.i();
            }
            if (EntityPhantom.this.d.e > EntityPhantom.this.dC() && !EntityPhantom.this.dV().u(EntityPhantom.this.dv().b(1))) {
                this.e = Math.min(-1.0f, this.e);
                this.i();
            }
        }

        private void i() {
            if (BlockPosition.c.equals(EntityPhantom.this.bX)) {
                EntityPhantom.this.bX = EntityPhantom.this.dv();
            }
            this.c += this.f * 15.0f * ((float)Math.PI / 180);
            EntityPhantom.this.d = Vec3D.a(EntityPhantom.this.bX).b(this.d * MathHelper.b(this.c), -4.0f + this.e, this.d * MathHelper.a(this.c));
        }
    }

    class b
    extends PathfinderGoal {
        private final PathfinderTargetCondition b = PathfinderTargetCondition.a().a(64.0);
        private int c = net.minecraft.world.entity.monster.EntityPhantom$b.b(20);

        b() {
        }

        @Override
        public boolean b() {
            if (this.c > 0) {
                --this.c;
                return false;
            }
            this.c = net.minecraft.world.entity.monster.EntityPhantom$b.b(60);
            WorldServer serverLevel = net.minecraft.world.entity.monster.EntityPhantom$b.a(EntityPhantom.this.dV());
            List<EntityHuman> nearbyPlayers = serverLevel.a(this.b, EntityPhantom.this, EntityPhantom.this.cR().c(16.0, 64.0, 16.0));
            if (!nearbyPlayers.isEmpty()) {
                nearbyPlayers.sort(Comparator.comparing(Entity::dC).reversed());
                for (EntityHuman player : nearbyPlayers) {
                    if (!EntityPhantom.this.a(serverLevel, player, PathfinderTargetCondition.a)) continue;
                    if (!EntityPhantom.this.dV().paperConfig().entities.behavior.phantomsOnlyAttackInsomniacs || IEntitySelector.IS_INSOMNIAC.test(player)) {
                        EntityPhantom.this.setTarget(player, EntityTargetEvent.TargetReason.CLOSEST_PLAYER, true);
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean c() {
            EntityLiving target = EntityPhantom.this.O_();
            return target != null && EntityPhantom.this.a(net.minecraft.world.entity.monster.EntityPhantom$b.a(EntityPhantom.this.dV()), target, PathfinderTargetCondition.a);
        }
    }

    abstract class h
    extends PathfinderGoal {
        public h() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        protected boolean h() {
            return EntityPhantom.this.d.c(EntityPhantom.this.dA(), EntityPhantom.this.dC(), EntityPhantom.this.dG()) < 4.0;
        }
    }
}

