/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntitySquid;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.EntityGuardianElder;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;

public class EntityGuardian
extends EntityMonster {
    protected static final int b = 80;
    private static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityGuardian.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> d = DataWatcher.a(EntityGuardian.class, DataWatcherRegistry.b);
    private float bY;
    private float bZ;
    private float ca;
    private float cb;
    private float cc;
    @Nullable
    private EntityLiving cd;
    private int ce;
    private boolean cf;
    @Nullable
    public PathfinderGoalRandomStroll c;
    public PathfinderGoalGuardianAttack guardianAttackGoal;

    public EntityGuardian(EntityTypes<? extends EntityGuardian> entityType, World level) {
        super((EntityTypes<? extends EntityMonster>)entityType, level);
        this.bN = 10;
        this.a(PathType.j, 0.0f);
        this.bP = new ControllerMoveGuardian(this);
        this.bZ = this.bY = this.ae.i();
    }

    @Override
    protected void E() {
        PathfinderGoalMoveTowardsRestriction moveTowardsRestrictionGoal = new PathfinderGoalMoveTowardsRestriction(this, 1.0);
        this.c = new PathfinderGoalRandomStroll(this, 1.0, 80);
        this.guardianAttackGoal = new PathfinderGoalGuardianAttack(this);
        this.bS.a(4, this.guardianAttackGoal);
        this.bS.a(5, moveTowardsRestrictionGoal);
        this.bS.a(7, this.c);
        this.bS.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bS.a(8, new PathfinderGoalLookAtPlayer(this, EntityGuardian.class, 12.0f, 0.01f));
        this.bS.a(9, new PathfinderGoalRandomLookaround(this));
        this.c.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        moveTowardsRestrictionGoal.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        this.bT.a(1, new PathfinderGoalNearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 10, true, false, new EntitySelectorGuardianTargetHumanSquid(this)));
    }

    public static AttributeProvider.Builder x() {
        return EntityMonster.gx().a(GenericAttributes.c, 6.0).a(GenericAttributes.v, 0.5).a(GenericAttributes.s, 30.0);
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new NavigationGuardian(this, level);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, false);
        builder.a(d, 0);
    }

    public boolean gs() {
        return this.al.a(a);
    }

    void x(boolean moving) {
        this.al.a(a, moving);
    }

    public int p() {
        return 80;
    }

    public void b(int activeAttackTargetId) {
        this.al.a(d, activeAttackTargetId);
    }

    public boolean gt() {
        return this.al.a(d) != 0;
    }

    @Nullable
    public EntityLiving gu() {
        if (!this.gt()) {
            return null;
        }
        if (this.dV().C) {
            if (this.cd != null) {
                return this.cd;
            }
            Entity entity = this.dV().a(this.al.a(d));
            if (entity instanceof EntityLiving) {
                this.cd = (EntityLiving)entity;
                return this.cd;
            }
            return null;
        }
        return this.O_();
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (d.equals(key)) {
            this.ce = 0;
            this.cd = null;
        }
    }

    @Override
    public int T() {
        return 160;
    }

    @Override
    protected SoundEffect u() {
        return this.bm() ? SoundEffects.lO : SoundEffects.lP;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return this.bm() ? SoundEffects.lU : SoundEffects.lV;
    }

    @Override
    public SoundEffect o_() {
        return this.bm() ? SoundEffects.lR : SoundEffects.lS;
    }

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.c;
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return level.b_(pos).a(TagsFluid.a) ? 10.0f + level.w(pos) : super.a(pos, level);
    }

    @Override
    public void d_() {
        if (this.bL()) {
            if (this.dV().C) {
                Vec3D deltaMovement;
                this.bZ = this.bY;
                if (!this.bj()) {
                    this.ca = 2.0f;
                    deltaMovement = this.dy();
                    if (deltaMovement.e > 0.0 && this.cf && !this.bb()) {
                        this.dV().a(this.dA(), this.dC(), this.dG(), this.t(), this.dm(), 1.0f, 1.0f, false);
                    }
                    this.cf = deltaMovement.e < 0.0 && this.dV().a(this.dv().e(), this);
                } else {
                    this.ca = this.gs() ? (this.ca < 0.5f ? 4.0f : (this.ca += (0.5f - this.ca) * 0.1f)) : (this.ca += (0.125f - this.ca) * 0.2f);
                }
                this.bY += this.ca;
                this.cc = this.cb;
                this.cb = !this.bm() ? this.ae.i() : (this.gs() ? (this.cb += (0.0f - this.cb) * 0.25f) : (this.cb += (1.0f - this.cb) * 0.06f));
                if (this.gs() && this.bj()) {
                    deltaMovement = this.g(0.0f);
                    for (int i2 = 0; i2 < 2; ++i2) {
                        this.dV().a(Particles.d, this.d(0.5) - deltaMovement.d * 1.5, this.dD() - deltaMovement.e * 1.5, this.g(0.5) - deltaMovement.f * 1.5, 0.0, 0.0, 0.0);
                    }
                }
                if (this.gt()) {
                    EntityLiving activeAttackTarget;
                    if (this.ce < this.p()) {
                        ++this.ce;
                    }
                    if ((activeAttackTarget = this.gu()) != null) {
                        this.L().a(activeAttackTarget, 90.0f, 90.0f);
                        this.L().a();
                        double d2 = this.L(0.0f);
                        double d1 = activeAttackTarget.dA() - this.dA();
                        double d22 = activeAttackTarget.e(0.5) - this.dE();
                        double d3 = activeAttackTarget.dG() - this.dG();
                        double squareRoot = Math.sqrt(d1 * d1 + d22 * d22 + d3 * d3);
                        d1 /= squareRoot;
                        d22 /= squareRoot;
                        d3 /= squareRoot;
                        double randomDouble = this.ae.j();
                        while (randomDouble < squareRoot) {
                            this.dV().a(Particles.d, this.dA() + d1 * (randomDouble += 1.8 - d2 + this.ae.j() * (1.7 - d2)), this.dE() + d22 * randomDouble, this.dG() + d3 * randomDouble, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            if (this.bm()) {
                this.j(300);
            } else if (this.aJ()) {
                this.i(this.dy().b((this.ae.i() * 2.0f - 1.0f) * 0.4f, 0.5, (this.ae.i() * 2.0f - 1.0f) * 0.4f));
                this.v(this.ae.i() * 360.0f);
                this.d(false);
                this.ar = true;
            }
            if (this.gt()) {
                this.v(this.aZ);
            }
        }
        super.d_();
    }

    protected SoundEffect t() {
        return SoundEffects.lT;
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.bZ, this.bY);
    }

    public float K(float partialTick) {
        return MathHelper.h(partialTick, this.cc, this.cb);
    }

    public float L(float partialTick) {
        return ((float)this.ce + partialTick) / (float)this.p();
    }

    public float gv() {
        return this.ce;
    }

    @Override
    public boolean a(IWorldReader level) {
        return level.f(this);
    }

    public static boolean b(EntityTypes<? extends EntityGuardian> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return !(random.a(20) != 0 && level.v(pos) || level.am() == EnumDifficulty.a || !EntitySpawnReason.a(spawnReason) && !level.b_(pos).a(TagsFluid.a) || !level.b_(pos.e()).a(TagsFluid.a));
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        if (!this.gs() && !damageSource.a(DamageTypeTags.w) && !damageSource.a(DamageTypes.P) && (entity = damageSource.c()) instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            livingEntity.a(level, this.dW().d(this), 2.0f);
        }
        if (this.c != null) {
            this.c.i();
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    public int ad() {
        return 180;
    }

    @Override
    public void a_(Vec3D travelVector) {
        if (this.dh() && this.bj()) {
            this.a(0.1f, travelVector);
            this.a(EnumMoveType.a, this.dy());
            this.i(this.dy().c(0.9));
            if (!this.gs() && this.O_() == null) {
                this.i(this.dy().b(0.0, -0.005, 0.0));
            }
        } else {
            super.a_(travelVector);
        }
    }

    static class ControllerMoveGuardian
    extends ControllerMove {
        private final EntityGuardian l;

        public ControllerMoveGuardian(EntityGuardian mob) {
            super(mob);
            this.l = mob;
        }

        @Override
        public void a() {
            if (this.k == ControllerMove.Operation.b && !this.l.P().k()) {
                Vec3D vec3 = new Vec3D(this.e - this.l.dA(), this.f - this.l.dC(), this.g - this.l.dG());
                double len = vec3.g();
                double d2 = vec3.d / len;
                double d1 = vec3.e / len;
                double d22 = vec3.f / len;
                float f2 = (float)(MathHelper.d(vec3.f, vec3.d) * 180.0 / 3.1415927410125732) - 90.0f;
                this.l.v(this.b(this.l.dL(), f2, 90.0f));
                this.l.aX = this.l.dL();
                float f1 = (float)(this.h * this.l.h(GenericAttributes.v));
                float f22 = MathHelper.h(0.125f, this.l.fp(), f1);
                this.l.C(f22);
                double d3 = Math.sin((double)(this.l.af + this.l.ar()) * 0.5) * 0.05;
                double cos = Math.cos(this.l.dL() * ((float)Math.PI / 180));
                double sin = Math.sin(this.l.dL() * ((float)Math.PI / 180));
                double d4 = Math.sin((double)(this.l.af + this.l.ar()) * 0.75) * 0.05;
                this.l.i(this.l.dy().b(d3 * cos, d4 * (sin + cos) * 0.25 + (double)f22 * d1 * 0.1, d3 * sin));
                ControllerLook lookControl = this.l.L();
                double d5 = this.l.dA() + d2 * 2.0;
                double d6 = this.l.dE() + d1 / len;
                double d7 = this.l.dG() + d22 * 2.0;
                double wantedX = lookControl.e();
                double wantedY = lookControl.f();
                double wantedZ = lookControl.g();
                if (!lookControl.d()) {
                    wantedX = d5;
                    wantedY = d6;
                    wantedZ = d7;
                }
                this.l.L().a(MathHelper.d(0.125, wantedX, d5), MathHelper.d(0.125, wantedY, d6), MathHelper.d(0.125, wantedZ, d7), 10.0f, 40.0f);
                this.l.x(true);
            } else {
                this.l.C(0.0f);
                this.l.x(false);
            }
        }
    }

    public static class PathfinderGoalGuardianAttack
    extends PathfinderGoal {
        private final EntityGuardian a;
        public int b;
        private final boolean c;

        public PathfinderGoalGuardianAttack(EntityGuardian guardian) {
            this.a = guardian;
            this.c = guardian instanceof EntityGuardianElder;
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving target = this.a.O_();
            return target != null && target.bL();
        }

        @Override
        public boolean c() {
            return super.c() && (this.c || this.a.O_() != null && this.a.g((Entity)this.a.O_()) > 9.0);
        }

        @Override
        public void d() {
            this.b = -10;
            this.a.P().m();
            EntityLiving target = this.a.O_();
            if (target != null) {
                this.a.L().a(target, 90.0f, 90.0f);
            }
            this.a.ar = true;
        }

        @Override
        public void e() {
            this.a.b(0);
            this.a.h((EntityLiving)null);
            this.a.c.i();
        }

        @Override
        public boolean V_() {
            return true;
        }

        @Override
        public void a() {
            EntityLiving target = this.a.O_();
            if (target != null) {
                this.a.P().m();
                this.a.L().a(target, 90.0f, 90.0f);
                if (!this.a.E(target)) {
                    this.a.h((EntityLiving)null);
                } else {
                    ++this.b;
                    if (this.b == 0) {
                        this.a.b(target.ar());
                        if (!this.a.bb()) {
                            this.a.dV().a((Entity)this.a, (byte)21);
                        }
                    } else if (this.b >= this.a.p()) {
                        float f2 = 1.0f;
                        if (this.a.dV().am() == EnumDifficulty.d) {
                            f2 += 2.0f;
                        }
                        if (this.c) {
                            f2 += 2.0f;
                        }
                        WorldServer serverLevel = PathfinderGoalGuardianAttack.a(this.a);
                        target.a(serverLevel, this.a.dW().c((Entity)this.a, (Entity)this.a), f2);
                        this.a.c(serverLevel, (Entity)target);
                        this.a.h((EntityLiving)null);
                    }
                    super.a();
                }
            }
        }
    }

    static class EntitySelectorGuardianTargetHumanSquid
    implements PathfinderTargetCondition.a {
        private final EntityGuardian a;

        public EntitySelectorGuardianTargetHumanSquid(EntityGuardian guardian) {
            this.a = guardian;
        }

        @Override
        public boolean test(@Nullable EntityLiving entity, WorldServer level) {
            return (entity instanceof EntityHuman || entity instanceof EntitySquid || entity instanceof Axolotl) && entity.g((Entity)this.a) > 9.0;
        }
    }
}

