/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.monster.EntityIllagerWizard;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class EntityEvoker
extends EntityIllagerWizard {
    @Nullable
    private EntitySheep a;

    public EntityEvoker(EntityTypes<? extends EntityEvoker> entityType, World level) {
        super((EntityTypes<? extends EntityIllagerWizard>)entityType, level);
        this.bN = 10;
    }

    @Override
    protected void E() {
        super.E();
        this.bS.a(0, new PathfinderGoalFloat(this));
        this.bS.a(1, new b());
        this.bS.a(2, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 8.0f, 0.6, 1.0));
        this.bS.a(3, new PathfinderGoalAvoidTarget<Creaking>(this, Creaking.class, 8.0f, 0.6, 1.0));
        this.bS.a(4, new c());
        this.bS.a(5, new a());
        this.bS.a(6, new d());
        this.bS.a(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.bS.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.bS.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.bT.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bT.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true).c(300));
        this.bT.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false).c(300));
        this.bT.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, false));
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gx().a(GenericAttributes.v, 0.5).a(GenericAttributes.m, 12.0).a(GenericAttributes.s, 24.0);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
    }

    @Override
    public SoundEffect aj_() {
        return SoundEffects.iU;
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
    }

    @Override
    protected boolean t(Entity entity) {
        EntityVex vex;
        return entity == this || super.t(entity) || entity instanceof EntityVex && (vex = (EntityVex)entity).t() != null && this.t(vex.t());
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.iS;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.iV;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.iX;
    }

    public void a(@Nullable EntitySheep wololoTarget) {
        this.a = wololoTarget;
    }

    @Nullable
    public EntitySheep gM() {
        return this.a;
    }

    @Override
    protected SoundEffect x() {
        return SoundEffects.iT;
    }

    @Override
    public void a(WorldServer level, int wave, boolean unused) {
    }

    class b
    extends EntityIllagerWizard.b {
        b() {
            super(EntityEvoker.this);
        }

        @Override
        public void a() {
            if (EntityEvoker.this.O_() != null) {
                EntityEvoker.this.L().a(EntityEvoker.this.O_(), (float)EntityEvoker.this.af(), (float)EntityEvoker.this.ad());
            } else if (EntityEvoker.this.gM() != null) {
                EntityEvoker.this.L().a(EntityEvoker.this.gM(), (float)EntityEvoker.this.af(), (float)EntityEvoker.this.ad());
            }
        }
    }

    class c
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition e;

        c() {
            super(EntityEvoker.this);
            this.e = PathfinderTargetCondition.b().a(16.0).d().e();
        }

        @Override
        public boolean b() {
            if (!super.b()) {
                return false;
            }
            int size = net.minecraft.world.entity.monster.EntityEvoker$c.a(EntityEvoker.this.dV()).a(EntityVex.class, this.e, EntityEvoker.this, EntityEvoker.this.cR().g(16.0)).size();
            return EntityEvoker.this.ae.a(8) + 1 > size;
        }

        @Override
        protected int h() {
            return 100;
        }

        @Override
        protected int i() {
            return 340;
        }

        @Override
        protected void k() {
            WorldServer serverLevel = (WorldServer)EntityEvoker.this.dV();
            ScoreboardTeam team = EntityEvoker.this.cr();
            for (int i2 = 0; i2 < 3; ++i2) {
                BlockPosition blockPos = EntityEvoker.this.dv().b(-2 + EntityEvoker.this.ae.a(5), 1, -2 + EntityEvoker.this.ae.a(5));
                EntityVex vex = EntityTypes.bB.a(EntityEvoker.this.dV(), EntitySpawnReason.f);
                if (vex == null) continue;
                vex.a(blockPos, 0.0f, 0.0f);
                vex.a((WorldAccess)serverLevel, EntityEvoker.this.dV().d_(blockPos), EntitySpawnReason.f, null);
                vex.a(EntityEvoker.this);
                vex.h(blockPos);
                vex.b(20 * (30 + EntityEvoker.this.ae.a(90)));
                if (team != null) {
                    serverLevel.g().a(vex.cI(), team);
                }
                serverLevel.addFreshEntityWithPassengers(vex, CreatureSpawnEvent.SpawnReason.SPELL);
                serverLevel.a(GameEvent.t, blockPos, GameEvent.a.a(EntityEvoker.this));
            }
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.iZ;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.b;
        }
    }

    class a
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        a() {
            super(EntityEvoker.this);
        }

        @Override
        protected int h() {
            return 40;
        }

        @Override
        protected int i() {
            return 100;
        }

        @Override
        protected void k() {
            EntityLiving target = EntityEvoker.this.O_();
            double min = Math.min(target.dC(), EntityEvoker.this.dC());
            double d2 = Math.max(target.dC(), EntityEvoker.this.dC()) + 1.0;
            float f2 = (float)MathHelper.d(target.dG() - EntityEvoker.this.dG(), target.dA() - EntityEvoker.this.dA());
            if (EntityEvoker.this.g((Entity)target) < 9.0) {
                float f1;
                int i2;
                for (i2 = 0; i2 < 5; ++i2) {
                    f1 = f2 + (float)i2 * (float)Math.PI * 0.4f;
                    this.a(EntityEvoker.this.dA() + (double)MathHelper.b(f1) * 1.5, EntityEvoker.this.dG() + (double)MathHelper.a(f1) * 1.5, min, d2, f1, 0);
                }
                for (i2 = 0; i2 < 8; ++i2) {
                    f1 = f2 + (float)i2 * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.a(EntityEvoker.this.dA() + (double)MathHelper.b(f1) * 2.5, EntityEvoker.this.dG() + (double)MathHelper.a(f1) * 2.5, min, d2, f1, 3);
                }
            } else {
                for (int i3 = 0; i3 < 16; ++i3) {
                    double d1 = 1.25 * (double)(i3 + 1);
                    int i1 = 1 * i3;
                    this.a(EntityEvoker.this.dA() + (double)MathHelper.b(f2) * d1, EntityEvoker.this.dG() + (double)MathHelper.a(f2) * d1, min, d2, f2, i1);
                }
            }
        }

        private void a(double x2, double z2, double minY, double maxY, float yRot, int warmupDelay) {
            BlockPosition blockPos = BlockPosition.a(x2, maxY, z2);
            boolean flag = false;
            double d2 = 0.0;
            do {
                IBlockData blockState1;
                VoxelShape collisionShape;
                BlockPosition blockPos1 = blockPos.e();
                IBlockData blockState = EntityEvoker.this.dV().a_(blockPos1);
                if (!blockState.c((IBlockAccess)EntityEvoker.this.dV(), blockPos1, EnumDirection.b)) continue;
                if (!EntityEvoker.this.dV().u(blockPos) && !(collisionShape = (blockState1 = EntityEvoker.this.dV().a_(blockPos)).g(EntityEvoker.this.dV(), blockPos)).c()) {
                    d2 = collisionShape.c(EnumDirection.EnumAxis.b);
                }
                flag = true;
                break;
            } while ((blockPos = blockPos.e()).v() >= MathHelper.a(minY) - 1);
            if (flag) {
                EntityEvoker.this.dV().b(new EntityEvokerFangs(EntityEvoker.this.dV(), x2, (double)blockPos.v() + d2, z2, yRot, warmupDelay, EntityEvoker.this));
                EntityEvoker.this.dV().a(GameEvent.t, new Vec3D(x2, (double)blockPos.v() + d2, z2), GameEvent.a.a(EntityEvoker.this));
            }
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.iY;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.c;
        }
    }

    public class d
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition e;

        public d() {
            super(EntityEvoker.this);
            this.e = PathfinderTargetCondition.b().a(16.0).a((EntityLiving entity, WorldServer level) -> ((EntitySheep)entity).t() == EnumColor.l);
        }

        @Override
        public boolean b() {
            if (EntityEvoker.this.O_() != null) {
                return false;
            }
            if (EntityEvoker.this.gB()) {
                return false;
            }
            if (EntityEvoker.this.af < this.c) {
                return false;
            }
            WorldServer serverLevel = net.minecraft.world.entity.monster.EntityEvoker$d.a(EntityEvoker.this.dV());
            if (!serverLevel.O().b(GameRules.c)) {
                return false;
            }
            List<EntitySheep> nearbyEntities = serverLevel.a(EntitySheep.class, this.e, EntityEvoker.this, EntityEvoker.this.cR().c(16.0, 4.0, 16.0));
            if (nearbyEntities.isEmpty()) {
                return false;
            }
            EntityEvoker.this.a(nearbyEntities.get(EntityEvoker.this.ae.a(nearbyEntities.size())));
            return true;
        }

        @Override
        public boolean c() {
            return EntityEvoker.this.gM() != null && this.b > 0;
        }

        @Override
        public void e() {
            super.e();
            EntityEvoker.this.a((EntitySheep)null);
        }

        @Override
        protected void k() {
            EntitySheep wololoTarget = EntityEvoker.this.gM();
            if (wololoTarget != null && wololoTarget.bL()) {
                wololoTarget.b(EnumColor.o);
            }
        }

        @Override
        protected int n() {
            return 40;
        }

        @Override
        protected int h() {
            return 60;
        }

        @Override
        protected int i() {
            return 140;
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.ja;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.d;
        }
    }
}

