/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.CreeperIgniteEvent;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSwell;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.Creeper;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityCreeper
extends EntityMonster {
    private static final DataWatcherObject<Integer> a = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> b = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private int d;
    public int bY;
    public int bZ = 30;
    public int ca = 3;
    private int cb;
    public Entity entityIgniter;

    public EntityCreeper(EntityTypes<? extends EntityCreeper> entityType, World level) {
        super((EntityTypes<? extends EntityMonster>)entityType, level);
    }

    @Override
    protected void E() {
        this.bS.a(1, new PathfinderGoalFloat(this));
        this.bS.a(2, new PathfinderGoalSwell(this));
        this.bS.a(3, new PathfinderGoalAvoidTarget<EntityOcelot>(this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.bS.a(3, new PathfinderGoalAvoidTarget<EntityCat>(this, EntityCat.class, 6.0f, 1.0, 1.2));
        this.bS.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bS.a(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.bS.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bS.a(6, new PathfinderGoalRandomLookaround(this));
        this.bT.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bT.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gx().a(GenericAttributes.v, 0.25);
    }

    @Override
    public int cE() {
        return this.O_() == null ? this.y(0.0f) : this.y(this.eD() - 1.0f);
    }

    @Override
    public boolean a(float fallDistance, float multiplier, DamageSource source) {
        boolean flag = super.a(fallDistance, multiplier, source);
        this.bY += (int)(fallDistance * 1.5f);
        if (this.bY > this.bZ - 5) {
            this.bY = this.bZ - 5;
        }
        return flag;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, -1);
        builder.a(b, false);
        builder.a(c, false);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        if (this.al.a(b).booleanValue()) {
            compound.a("powered", true);
        }
        compound.a("Fuse", (short)this.bZ);
        compound.a("ExplosionRadius", (byte)this.ca);
        compound.a("ignited", this.x());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.al.a(b, compound.q("powered"));
        if (compound.b("Fuse", 99)) {
            this.bZ = compound.g("Fuse");
        }
        if (compound.b("ExplosionRadius", 99)) {
            this.ca = compound.f("ExplosionRadius");
        }
        if (compound.q("ignited")) {
            this.al.a(c, true);
        }
    }

    @Override
    public void h() {
        if (this.bL()) {
            int swellDir;
            this.d = this.bY;
            if (this.x()) {
                this.b(1);
            }
            if ((swellDir = this.t()) > 0 && this.bY == 0) {
                this.a(SoundEffects.gF, 1.0f, 0.5f);
                ((Entity)this).a(GameEvent.I);
            }
            this.bY += swellDir;
            if (this.bY < 0) {
                this.bY = 0;
            }
            if (this.bY >= this.bZ) {
                this.bY = this.bZ;
                this.gv();
            }
        }
        super.h();
    }

    @Override
    public void h(@Nullable EntityLiving target) {
        if (!(target instanceof Goat)) {
            super.h(target);
        }
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.gE;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.gD;
    }

    @Override
    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
        EntityCreeper creeper;
        super.a(level, damageSource, recentlyHit);
        Entity entity = damageSource.d();
        if (entity != this && entity instanceof EntityCreeper && (creeper = (EntityCreeper)entity).gt()) {
            creeper.gu();
            this.a(level, Items.vo);
        }
    }

    @Override
    public boolean c(WorldServer level, Entity source) {
        return true;
    }

    public boolean p() {
        return this.al.a(b);
    }

    public float J(float partialTicks) {
        return MathHelper.h(partialTicks, this.d, this.bY) / (float)(this.bZ - 2);
    }

    public int t() {
        return this.al.a(a);
    }

    public void b(int state) {
        this.al.a(a, state);
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        super.a(level, lightning);
        if (CraftEventFactory.callCreeperPowerEvent(this, lightning, CreeperPowerEvent.PowerCause.LIGHTNING).isCancelled()) {
            return;
        }
        this.al.a(b, true);
    }

    public void setPowered(boolean powered) {
        this.al.a(b, powered);
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(TagsItem.bv)) {
            SoundEffect soundEvent = itemInHand.a(Items.uV) ? SoundEffects.jk : SoundEffects.jz;
            this.dV().a(player, this.dA(), this.dC(), this.dG(), soundEvent, this.dm(), 1.0f, this.ae.i() * 0.4f + 0.8f);
            if (!this.dV().C) {
                this.entityIgniter = player;
                this.gs();
                if (itemInHand.p() == 0) {
                    itemInHand.h(1);
                } else {
                    itemInHand.a(1, (EntityLiving)player, EntityCreeper.d(hand));
                }
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    public void gv() {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            float f2 = this.p() ? 2.0f : 1.0f;
            ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, (float)this.ca * f2, false);
            if (!event.isCancelled()) {
                this.be = true;
                serverLevel.a((Entity)this, this.dA(), this.dC(), this.dG(), event.getRadius(), event.getFire(), World.a.c);
                this.gy();
                this.a(serverLevel, Entity.RemovalReason.a);
                this.discard(EntityRemoveEvent.Cause.EXPLODE);
            } else {
                this.bY = 0;
                this.al.a(c, false);
            }
        }
    }

    private void gy() {
        Collection<MobEffect> activeEffects = this.eA();
        if (!activeEffects.isEmpty() && !this.dV().paperConfig().entities.behavior.disableCreeperLingeringEffect) {
            EntityAreaEffectCloud areaEffectCloud = new EntityAreaEffectCloud(this.dV(), this.dA(), this.dC(), this.dG());
            areaEffectCloud.a(this);
            areaEffectCloud.a(2.5f);
            areaEffectCloud.b(-0.5f);
            areaEffectCloud.c(10);
            areaEffectCloud.a(areaEffectCloud.g() / 2);
            areaEffectCloud.c(-areaEffectCloud.c() / (float)areaEffectCloud.g());
            for (MobEffect mobEffectInstance : activeEffects) {
                areaEffectCloud.a(new MobEffect(mobEffectInstance));
            }
            this.dV().addFreshEntity(areaEffectCloud, CreatureSpawnEvent.SpawnReason.EXPLOSION);
        }
    }

    public void setIgnited(boolean ignited) {
        CreeperIgniteEvent event;
        if (this.x() != ignited && (event = new CreeperIgniteEvent((Creeper)this.getBukkitEntity(), ignited)).callEvent()) {
            this.al.a(c, event.isIgnited());
        }
    }

    public boolean x() {
        return this.al.a(c);
    }

    public void gs() {
        this.setIgnited(true);
    }

    public boolean gt() {
        return this.p() && this.cb < 1;
    }

    public void gu() {
        ++this.cb;
    }
}

