/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;

public class EntityItem
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<ItemStack> c = DataWatcher.a(EntityItem.class, DataWatcherRegistry.h);
    private static final float d = 0.1f;
    public static final float a = 0.2125f;
    private static final int e = 6000;
    private static final int f = Short.MAX_VALUE;
    private static final int g = Short.MIN_VALUE;
    public int h;
    public int i;
    public int j = 5;
    @Nullable
    public UUID k;
    @Nullable
    private Entity l;
    @Nullable
    public UUID m;
    public final float b;
    public boolean canMobPickup = true;
    private int despawnRate = -1;
    public TriState frictionState = TriState.NOT_SET;

    public EntityItem(EntityTypes<? extends EntityItem> entityType, World level) {
        super(entityType, level);
        this.b = this.ae.i() * (float)Math.PI * 2.0f;
        this.v(this.ae.i() * 360.0f);
    }

    public EntityItem(World level, double posX, double posY, double posZ, ItemStack itemStack) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.aq, level);
        this.a_(posX, posY, posZ);
        this.n(this.ae.j() * 0.2 - 0.1, 0.2, this.ae.j() * 0.2 - 0.1);
        this.a(itemStack);
    }

    public EntityItem(World level, double posX, double posY, double posZ, ItemStack itemStack, double deltaX, double deltaY, double deltaZ) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.aq, level);
        this.a_(posX, posY, posZ);
        this.n(deltaX, deltaY, deltaZ);
        this.a(itemStack);
    }

    private EntityItem(EntityItem other) {
        super(other.aq(), other.dV());
        this.a(other.l().v());
        this.w(other);
        this.h = other.h;
        this.b = other.b;
    }

    @Override
    public boolean bh() {
        return this.l().a(TagsItem.br);
    }

    @Override
    @Nullable
    public Entity p() {
        World world;
        if (this.l != null && !this.l.dQ()) {
            return this.l;
        }
        if (this.k != null && (world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.l = serverLevel.a(this.k);
            return this.l;
        }
        return null;
    }

    @Override
    public void x(Entity entity) {
        super.x(entity);
        if (entity instanceof EntityItem) {
            EntityItem itemEntity = (EntityItem)entity;
            this.l = itemEntity.l;
        }
    }

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(c, ItemStack.j);
    }

    @Override
    protected double bd() {
        return 0.04;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.i > 0 && this.i != Short.MAX_VALUE) {
            --this.i;
        }
        if (this.h != Short.MIN_VALUE) {
            ++this.h;
        }
        if (!this.dV().C && this.h >= this.despawnRate) {
            if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                this.h = 0;
                return;
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public void h() {
        if (this.l().f()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            double d2;
            int i2;
            super.h();
            if (this.i > 0 && this.i != Short.MAX_VALUE) {
                --this.i;
            }
            this.K = this.dA();
            this.L = this.dC();
            this.M = this.dG();
            Vec3D deltaMovement = this.dy();
            if (this.bj() && this.b(TagsFluid.a) > (double)0.1f) {
                this.A();
            } else if (this.bx() && this.b(TagsFluid.b) > (double)0.1f) {
                this.B();
            } else {
                this.bf();
            }
            if (this.dV().C) {
                this.ad = false;
            } else {
                boolean bl = this.ad = !this.dV().a((Entity)this, this.cR().h(1.0E-7));
                if (this.ad) {
                    this.m(this.dA(), (this.cR().b + this.cR().e) / 2.0, this.dG());
                }
            }
            if (!this.aJ() || this.dy().j() > (double)1.0E-5f || (this.af + this.ar()) % 4 == 0) {
                this.a(EnumMoveType.a, this.dy());
                this.aK();
                float f2 = 0.98f;
                if (this.frictionState == TriState.FALSE) {
                    f2 = 1.0f;
                } else if (this.aJ()) {
                    f2 = this.dV().a_(this.aQ()).b().g() * 0.98f;
                }
                this.i(this.dy().d(f2, 0.98, f2));
                if (this.aJ()) {
                    Vec3D deltaMovement1 = this.dy();
                    if (deltaMovement1.e < 0.0) {
                        this.i(deltaMovement1.d(1.0, -0.5, 1.0));
                    }
                }
            }
            boolean flag = MathHelper.a(this.K) != MathHelper.a(this.dA()) || MathHelper.a(this.L) != MathHelper.a(this.dC()) || MathHelper.a(this.M) != MathHelper.a(this.dG());
            int n2 = i2 = flag ? 2 : 40;
            if (this.af % i2 == 0 && !this.dV().C && this.D()) {
                this.C();
            }
            if (this.h != Short.MIN_VALUE) {
                ++this.h;
            }
            this.ar |= this.bq();
            if (!this.dV().C && (d2 = this.dy().d(deltaMovement).h()) > 0.01) {
                this.ar = true;
            }
            if (!this.dV().C && this.h >= this.despawnRate) {
                if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                    this.h = 0;
                    return;
                }
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            }
        }
    }

    @Override
    public BlockPosition aQ() {
        return this.e(0.999999f);
    }

    private void A() {
        this.h((double)0.99f);
    }

    private void B() {
        this.h((double)0.95f);
    }

    private void h(double multiplier) {
        Vec3D deltaMovement = this.dy();
        this.n(deltaMovement.d * multiplier, deltaMovement.e + (double)(deltaMovement.e < (double)0.06f ? 5.0E-4f : 0.0f), deltaMovement.f * multiplier);
    }

    private void C() {
        if (this.D()) {
            double radius = this.dV().spigotConfig.itemMerge;
            for (EntityItem itemEntity : this.dV().a(EntityItem.class, this.cR().c(radius, this.dV().paperConfig().entities.behavior.onlyMergeItemsHorizontally ? 0.0 : radius - 0.5, radius), (? super T neighbour) -> neighbour != this && neighbour.D())) {
                if (!itemEntity.D() || this.dV().paperConfig().fixes.fixItemsMergingThroughWalls && this.dV().clipDirect(this.dt(), itemEntity.dt(), VoxelShapeCollision.a(this)) == MovingObjectPosition.EnumMovingObjectType.b) continue;
                this.a(itemEntity);
                if (!this.dQ()) continue;
                break;
            }
        }
    }

    private boolean D() {
        ItemStack item = this.l();
        return this.bL() && this.i != Short.MAX_VALUE && this.h != Short.MIN_VALUE && this.h < this.despawnRate && item.M() < item.k();
    }

    private void a(EntityItem itemEntity) {
        ItemStack item = this.l();
        ItemStack item1 = itemEntity.l();
        if (Objects.equals(this.m, itemEntity.m) && EntityItem.a(item, item1)) {
            EntityItem.a(this, item, itemEntity, item1);
        }
    }

    public static boolean a(ItemStack destinationStack, ItemStack originStack) {
        return originStack.M() + destinationStack.M() <= originStack.k() && ItemStack.c(destinationStack, originStack);
    }

    public static ItemStack a(ItemStack destinationStack, ItemStack originStack, int amount) {
        int min = Math.min(Math.min(destinationStack.k(), amount) - destinationStack.M(), originStack.M());
        ItemStack itemStack = destinationStack.c(destinationStack.M() + min);
        originStack.h(min);
        return itemStack;
    }

    private static void a(EntityItem destinationEntity, ItemStack destinationStack, ItemStack originStack) {
        ItemStack itemStack = EntityItem.a(destinationStack, originStack, 64);
        destinationEntity.a(itemStack);
    }

    private static void a(EntityItem destinationEntity, ItemStack destinationStack, EntityItem originEntity, ItemStack originStack) {
        if (!CraftEventFactory.callItemMergeEvent(originEntity, destinationEntity)) {
            return;
        }
        EntityItem.a(destinationEntity, destinationStack, originStack);
        destinationEntity.i = Math.max(destinationEntity.i, originEntity.i);
        destinationEntity.h = Math.min(destinationEntity.h, originEntity.h);
        if (originStack.f()) {
            originEntity.discard(EntityRemoveEvent.Cause.MERGE);
        }
    }

    @Override
    public boolean bi() {
        return !this.l().a(this.dW().a()) || super.bi();
    }

    @Override
    protected boolean aF() {
        return this.j <= 0 || this.af % 10 == 0;
    }

    @Override
    public final boolean b(DamageSource damageSource) {
        return !this.d(damageSource) && this.l().a(damageSource);
    }

    @Override
    public final boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.d(damageSource)) {
            return false;
        }
        if (!level.O().b(GameRules.c) && damageSource.d() instanceof EntityInsentient) {
            return false;
        }
        if (!this.l().a(damageSource)) {
            return false;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount)) {
            return false;
        }
        this.bD();
        this.j = (int)((float)this.j - amount);
        this.a(GameEvent.o, damageSource.d());
        if (this.j <= 0) {
            this.l().a(this);
            this.discard(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    public boolean a(Explosion explosion) {
        return !explosion.h() || super.a(explosion);
    }

    @Override
    public void b(NBTTagCompound compound) {
        compound.a("Health", (short)this.j);
        compound.a("Age", (short)this.h);
        compound.a("PickupDelay", (short)this.i);
        if (this.k != null) {
            compound.a("Thrower", this.k);
        }
        if (this.m != null) {
            compound.a("Owner", this.m);
        }
        if (!this.l().f()) {
            compound.a("Item", this.l().a(this.dX()));
        }
        if (this.frictionState != TriState.NOT_SET) {
            compound.a("Paper.FrictionState", this.frictionState.toString());
        }
    }

    @Override
    public void a(NBTTagCompound compound) {
        this.j = compound.g("Health");
        this.h = compound.g("Age");
        if (compound.e("PickupDelay")) {
            this.i = compound.g("PickupDelay");
        }
        if (compound.b("Owner")) {
            this.m = compound.a("Owner");
        }
        if (compound.b("Thrower")) {
            this.k = compound.a("Thrower");
            this.l = null;
        }
        if (compound.b("Item", 10)) {
            NBTTagCompound compound1 = compound.p("Item");
            this.a(ItemStack.a((HolderLookup.a)this.dX(), (NBTBase)compound1).orElse(ItemStack.j));
        } else {
            this.a(ItemStack.j);
        }
        if (compound.e("Paper.FrictionState")) {
            String fs = compound.l("Paper.FrictionState");
            try {
                this.frictionState = TriState.valueOf((String)fs);
            }
            catch (Exception ignored) {
                LogUtils.getLogger().error("Unknown friction state {} for {}", (Object)fs, (Object)this);
            }
        }
        if (this.l().f()) {
            this.discard(null);
        }
    }

    @Override
    public void a_(EntityHuman entity) {
        if (!this.dV().C) {
            ItemStack item = this.l();
            Item item1 = item.h();
            int count = item.M();
            int canHold = entity.gi().canHold(item);
            int remaining = count - canHold;
            boolean flyAtPlayer = false;
            if (this.i <= 0) {
                PlayerAttemptPickupItemEvent attemptEvent = new PlayerAttemptPickupItemEvent((Player)entity.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                this.dV().getCraftServer().getPluginManager().callEvent((Event)attemptEvent);
                flyAtPlayer = attemptEvent.getFlyAtPlayer();
                if (attemptEvent.isCancelled()) {
                    if (flyAtPlayer) {
                        entity.a((Entity)this, count);
                    }
                    return;
                }
            }
            if (this.i <= 0 && canHold > 0) {
                EntityPickupItemEvent entityEvent;
                item.e(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent((Player)entity.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                playerEvent.setCancelled(!playerEvent.getPlayer().getCanPickupItems());
                this.dV().getCraftServer().getPluginManager().callEvent((Event)playerEvent);
                flyAtPlayer = playerEvent.getFlyAtPlayer();
                if (playerEvent.isCancelled()) {
                    item.e(count);
                    if (flyAtPlayer) {
                        entity.a((Entity)this, count);
                    }
                    return;
                }
                entityEvent.setCancelled(!(entityEvent = new EntityPickupItemEvent((LivingEntity)entity.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining)).getEntity().getCanPickupItems());
                this.dV().getCraftServer().getPluginManager().callEvent((Event)entityEvent);
                if (entityEvent.isCancelled()) {
                    item.e(count);
                    return;
                }
                ItemStack current = this.l();
                if (!item.equals(current)) {
                    item = current;
                } else {
                    item.e(canHold + remaining);
                }
                this.i = 0;
            } else if (this.i == 0) {
                this.i = -1;
            }
            if (this.i == 0 && (this.m == null || this.m.equals(entity.cG())) && entity.gi().f(item)) {
                if (flyAtPlayer) {
                    entity.a((Entity)this, count);
                }
                if (item.f()) {
                    this.discard(EntityRemoveEvent.Cause.PICKUP);
                    item.e(count);
                }
                entity.a(StatisticList.e.b(item1), count);
                entity.a(this);
            }
        }
    }

    @Override
    public IChatBaseComponent al() {
        IChatBaseComponent customName = this.an();
        return customName != null ? customName : this.l().A();
    }

    @Override
    public boolean cB() {
        return false;
    }

    @Override
    @Nullable
    public Entity b(TeleportTransition teleportTransition) {
        Entity entity = super.b(teleportTransition);
        if (!this.dV().C && entity instanceof EntityItem) {
            EntityItem itemEntity = (EntityItem)entity;
            itemEntity.C();
        }
        return entity;
    }

    public ItemStack l() {
        return this.au().a(c);
    }

    public void a(ItemStack stack) {
        this.au().a(c, stack);
        this.despawnRate = this.dV().paperConfig().entities.spawning.altItemDespawnRate.enabled ? this.dV().paperConfig().entities.spawning.altItemDespawnRate.items.getOrDefault((Object)stack.h(), this.dV().spigotConfig.itemDespawnRate) : this.dV().spigotConfig.itemDespawnRate;
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (c.equals(key)) {
            this.l().a((Entity)this);
        }
    }

    public void b(@Nullable UUID target) {
        this.m = target;
    }

    public void b(Entity thrower) {
        this.k = thrower.cG();
        this.l = thrower;
    }

    public int m() {
        return this.h;
    }

    public void s() {
        this.i = 10;
    }

    public void t() {
        this.i = 0;
    }

    public void u() {
        this.i = Short.MAX_VALUE;
    }

    public void b(int pickupDelay) {
        this.i = pickupDelay;
    }

    public boolean v() {
        return this.i > 0;
    }

    public void w() {
        this.h = Short.MIN_VALUE;
    }

    public void x() {
        this.h = -6000;
    }

    public void y() {
        this.u();
        this.h = this.despawnRate - 1;
    }

    public static float f(float age, float bobOffset) {
        return age / 20.0f + bobOffset;
    }

    public EntityItem z() {
        return new EntityItem(this);
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.i;
    }

    @Override
    public float dM() {
        return 180.0f - EntityItem.f((float)this.m() + 0.5f, this.b) / ((float)Math.PI * 2) * 360.0f;
    }

    @Override
    public SlotAccess a_(int slot) {
        return slot == 0 ? SlotAccess.a(this::l, this::a) : super.a_(slot);
    }
}

