/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContextDirectional;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.BlockConcretePowder;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EntityFallingBlock
extends Entity {
    private static final Logger f = LogUtils.getLogger();
    public IBlockData g = Blocks.L.m();
    public int a;
    public boolean b = true;
    public boolean h;
    public boolean i;
    public int j = 40;
    public float k;
    @Nullable
    public NBTTagCompound c;
    public boolean d;
    protected static final DataWatcherObject<BlockPosition> e = DataWatcher.a(EntityFallingBlock.class, DataWatcherRegistry.o);
    public boolean autoExpire = true;

    public EntityFallingBlock(EntityTypes<? extends EntityFallingBlock> entityType, World level) {
        super(entityType, level);
    }

    public EntityFallingBlock(World level, double x2, double y2, double z2, IBlockData state) {
        this((EntityTypes<? extends EntityFallingBlock>)EntityTypes.X, level);
        this.g = state;
        this.I = true;
        this.a_(x2, y2, z2);
        this.i(Vec3D.c);
        this.K = x2;
        this.L = y2;
        this.M = z2;
        this.a(this.dv());
    }

    public static EntityFallingBlock a(World level, BlockPosition pos, IBlockData blockState) {
        EntityFallingBlock fallingBlockEntity = new EntityFallingBlock(level, (double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5, blockState.b(BlockProperties.J) ? (IBlockData)blockState.b(BlockProperties.J, false) : blockState);
        if (!CraftEventFactory.callEntityChangeBlockEvent(fallingBlockEntity, pos, blockState.y().g())) {
            return fallingBlockEntity;
        }
        level.a(pos, blockState.y().g(), 3);
        level.b(fallingBlockEntity);
        return fallingBlockEntity;
    }

    @Override
    public boolean cB() {
        return false;
    }

    @Override
    public final boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (!this.d(damageSource)) {
            this.bD();
        }
        return false;
    }

    public void a(BlockPosition startPos) {
        this.al.a(e, startPos);
    }

    public BlockPosition l() {
        return this.al.a(e);
    }

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(e, BlockPosition.c);
    }

    @Override
    public boolean bH() {
        return !this.dQ();
    }

    @Override
    protected double bd() {
        return 0.04;
    }

    @Override
    public void h() {
        if (this.g.l()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            Block block = this.g.b();
            ++this.a;
            this.bf();
            this.a(EnumMoveType.a, this.dy());
            this.aK();
            if (this.dV().paperConfig().fixes.fallingBlockHeightNerf.test(v2 -> this.dC() > (double)v2)) {
                WorldServer serverLevel;
                World world;
                if (this.b && (world = this.dV()) instanceof WorldServer && (serverLevel = (WorldServer)world).O().b(GameRules.i)) {
                    this.a(serverLevel, block);
                }
                this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
                return;
            }
            this.bW();
            World world = this.dV();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                if (this.bL() || this.d) {
                    MovingObjectPositionBlock blockHitResult;
                    BlockPosition blockPos = this.dv();
                    boolean flag = this.g.b() instanceof BlockConcretePowder;
                    boolean flag1 = flag && this.dV().b_(blockPos).a(TagsFluid.a);
                    double d2 = this.dy().h();
                    if (flag && d2 > 1.0 && (blockHitResult = this.dV().a(new RayTrace(new Vec3D(this.K, this.L, this.M), this.dt(), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.b, this))).d() != MovingObjectPosition.EnumMovingObjectType.a && this.dV().b_(blockHitResult.b()).a(TagsFluid.a)) {
                        blockPos = blockHitResult.b();
                        flag1 = true;
                    }
                    if (!this.aJ() && !flag1) {
                        if (this.a > 100 && this.autoExpire && (blockPos.v() <= this.dV().L_() || blockPos.v() > this.dV().an()) || this.a > 600 && this.autoExpire) {
                            if (this.b && serverLevel.O().b(GameRules.i)) {
                                this.a(serverLevel, block);
                            }
                            this.discard(EntityRemoveEvent.Cause.DROP);
                        }
                    } else {
                        IBlockData blockState = this.dV().a_(blockPos);
                        this.i(this.dy().d(0.7, -0.5, 0.7));
                        if (!blockState.a(Blocks.bX)) {
                            if (!this.h) {
                                boolean flag3;
                                boolean canBeReplaced = blockState.a(new BlockActionContextDirectional(this.dV(), blockPos, EnumDirection.a, ItemStack.j, EnumDirection.b));
                                boolean flag2 = BlockFalling.n(this.dV().a_(blockPos.e())) && (!flag || !flag1);
                                boolean bl = flag3 = this.g.a((IWorldReader)this.dV(), blockPos) && !flag2;
                                if (canBeReplaced && flag3) {
                                    if (this.g.b(BlockProperties.J) && this.dV().b_(blockPos).a() == FluidTypes.c) {
                                        this.g = (IBlockData)this.g.b(BlockProperties.J, true);
                                    }
                                    if (!CraftEventFactory.callEntityChangeBlockEvent(this, blockPos, this.g)) {
                                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                        return;
                                    }
                                    if (this.dV().a(blockPos, this.g, 3)) {
                                        TileEntity blockEntity;
                                        ((WorldServer)this.dV()).m().a.a(this, new PacketPlayOutBlockChange(blockPos, this.dV().a_(blockPos)));
                                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                        if (block instanceof Fallable) {
                                            ((Fallable)((Object)block)).a(this.dV(), blockPos, this.g, blockState, this);
                                        }
                                        if (this.c != null && this.g.x() && (blockEntity = this.dV().c_(blockPos)) != null) {
                                            NBTTagCompound compoundTag = blockEntity.d(this.dV().K_());
                                            for (String string : this.c.e()) {
                                                compoundTag.a(string, this.c.c(string).d());
                                            }
                                            try {
                                                blockEntity.c(compoundTag, this.dV().K_());
                                            }
                                            catch (Exception var16) {
                                                f.error("Failed to load block entity from falling block", (Throwable)var16);
                                            }
                                            blockEntity.e();
                                        }
                                    } else if (this.b && serverLevel.O().b(GameRules.i)) {
                                        this.discard(EntityRemoveEvent.Cause.DROP);
                                        this.a(block, blockPos);
                                        this.a(serverLevel, block);
                                    }
                                } else {
                                    this.discard(EntityRemoveEvent.Cause.DROP);
                                    if (this.b && serverLevel.O().b(GameRules.i)) {
                                        this.a(block, blockPos);
                                        this.a(serverLevel, block);
                                    }
                                }
                            } else {
                                this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                this.a(block, blockPos);
                            }
                        }
                    }
                }
            }
            this.i(this.dy().c(0.98));
        }
    }

    public void a(Block block, BlockPosition pos) {
        if (block instanceof Fallable) {
            ((Fallable)((Object)block)).a(this.dV(), pos, this);
        }
    }

    @Override
    public boolean a(float fallDistance, float multiplier, DamageSource source) {
        DamageSource damageSource;
        if (!this.i) {
            return false;
        }
        int ceil = MathHelper.f(fallDistance - 1.0f);
        if (ceil < 0) {
            return false;
        }
        Predicate<Entity> predicate = IEntitySelector.e.and(IEntitySelector.b);
        Block block = this.g.b();
        if (block instanceof Fallable) {
            Fallable fallable = (Fallable)((Object)block);
            damageSource = fallable.a(this);
        } else {
            damageSource = this.dW().a(this);
        }
        DamageSource damageSource2 = damageSource;
        float f2 = Math.min(MathHelper.d((float)ceil * this.k), this.j);
        this.dV().a((Entity)this, this.cR(), predicate).forEach(entity -> entity.a(damageSource2, f2));
        boolean isAnvil = this.g.a(TagsBlock.O);
        if (isAnvil && f2 > 0.0f && this.ae.i() < 0.05f + (float)ceil * 0.05f) {
            IBlockData blockState = BlockAnvil.e(this.g);
            if (blockState == null) {
                this.h = true;
            } else {
                this.g = blockState;
            }
        }
        return false;
    }

    @Override
    protected void b(NBTTagCompound compound) {
        compound.a("BlockState", GameProfileSerializer.a(this.g));
        compound.a("Time", this.a);
        compound.a("DropItem", this.b);
        compound.a("HurtEntities", this.i);
        compound.a("FallHurtAmount", this.k);
        compound.a("FallHurtMax", this.j);
        if (this.c != null) {
            compound.a("TileEntityData", this.c);
        }
        compound.a("CancelDrop", this.h);
        if (!this.autoExpire) {
            compound.a("Paper.AutoExpire", false);
        }
    }

    @Override
    protected void a(NBTTagCompound compound) {
        this.g = GameProfileSerializer.a(this.dV().a(Registries.f), compound.p("BlockState"));
        this.a = compound.h("Time");
        if (compound.b("HurtEntities", 99)) {
            this.i = compound.q("HurtEntities");
            this.k = compound.j("FallHurtAmount");
            this.j = compound.h("FallHurtMax");
        } else if (this.g.a(TagsBlock.O)) {
            this.i = true;
        }
        if (compound.b("DropItem", 99)) {
            this.b = compound.q("DropItem");
        }
        if (!(!compound.b("TileEntityData", 10) || this.dV().paperConfig().entities.spawning.filterBadTileEntityNbtFromFallingBlocks && this.g.b() instanceof GameMasterBlock)) {
            this.c = compound.p("TileEntityData").i();
        }
        this.h = compound.q("CancelDrop");
        if (this.g.l()) {
            this.g = Blocks.L.m();
        }
        if (compound.e("Paper.AutoExpire")) {
            this.autoExpire = compound.q("Paper.AutoExpire");
        }
    }

    public void b(float fallDamagePerDistance, int fallDamageMax) {
        this.i = true;
        this.k = fallDamagePerDistance;
        this.j = fallDamageMax;
    }

    public void m() {
        this.h = true;
    }

    @Override
    public boolean cF() {
        return false;
    }

    @Override
    public void a(CrashReportSystemDetails category) {
        super.a(category);
        category.a("Immitating BlockState", this.g.toString());
    }

    public IBlockData p() {
        return this.g;
    }

    @Override
    protected IChatBaseComponent cz() {
        return IChatBaseComponent.a("entity.minecraft.falling_block_type", this.g.b().f());
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        return new PacketPlayOutSpawnEntity((Entity)this, entity, Block.j(this.p()));
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.g = Block.a(packet.p());
        this.I = true;
        double x2 = packet.g();
        double y2 = packet.h();
        double z2 = packet.i();
        this.a_(x2, y2, z2);
        this.a(this.dv());
    }

    @Override
    @Nullable
    public Entity b(TeleportTransition teleportTransition) {
        ResourceKey<World> resourceKey = teleportTransition.b().ai();
        ResourceKey<World> resourceKey1 = this.dV().ai();
        boolean flag = (resourceKey1 == World.k || resourceKey == World.k) && resourceKey1 != resourceKey;
        Entity entity = super.b(teleportTransition);
        this.d = entity != null && flag && GlobalConfiguration.get().unsupportedSettings.allowUnsafeEndPortalTeleportation;
        return entity;
    }
}

