/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntityPainting
extends EntityHanging
implements VariantHolder<Holder<PaintingVariant>> {
    private static final DataWatcherObject<Holder<PaintingVariant>> g = DataWatcher.a(EntityPainting.class, DataWatcherRegistry.A);
    public static final MapCodec<Holder<PaintingVariant>> d = PaintingVariant.c.fieldOf("variant");
    public static final Codec<Holder<PaintingVariant>> e = d.codec();
    public static final float f = 0.0625f;

    public EntityPainting(EntityTypes<? extends EntityPainting> entityType, World level) {
        super((EntityTypes<? extends EntityHanging>)entityType, level);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(g, (Holder)this.dX().e(Registries.X).a().orElseThrow());
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (g.equals(key)) {
            this.l();
        }
    }

    public void b(Holder<PaintingVariant> variant) {
        this.al.a(g, variant);
    }

    public Holder<PaintingVariant> s() {
        return this.al.a(g);
    }

    public static Optional<EntityPainting> a(World level, BlockPosition pos, EnumDirection direction) {
        EntityPainting painting = new EntityPainting(level, pos);
        ArrayList<Holder> list = new ArrayList<Holder>();
        level.K_().e(Registries.X).c(PaintingVariantTags.a).forEach(list::add);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        painting.a(direction);
        list.removeIf(holder -> {
            painting.b((Holder<PaintingVariant>)holder);
            return !painting.m();
        });
        if (list.isEmpty()) {
            return Optional.empty();
        }
        int i2 = list.stream().mapToInt(EntityPainting::c).max().orElse(0);
        list.removeIf(holder -> EntityPainting.c(holder) < i2);
        Optional randomSafe = SystemUtils.b(list, painting.ae);
        if (randomSafe.isEmpty()) {
            return Optional.empty();
        }
        painting.b((Holder)randomSafe.get());
        painting.a(direction);
        return Optional.of(painting);
    }

    private static int c(Holder<PaintingVariant> variant) {
        return variant.a().a();
    }

    private EntityPainting(World level, BlockPosition pos) {
        super((EntityTypes<? extends EntityHanging>)EntityTypes.aK, level, pos);
    }

    public EntityPainting(World level, BlockPosition pos, EnumDirection direction, Holder<PaintingVariant> variant) {
        this(level, pos);
        this.b(variant);
        this.a(direction);
    }

    @Override
    public void b(NBTTagCompound compound) {
        e.encodeStart(this.dX().a(DynamicOpsNBT.a), this.s()).ifSuccess(tag -> compound.a((NBTTagCompound)tag));
        compound.a("facing", (byte)this.c.e());
        super.b(compound);
    }

    @Override
    public void a(NBTTagCompound compound) {
        e.parse(this.dX().a(DynamicOpsNBT.a), (Object)compound).ifSuccess(this::b);
        this.c = EnumDirection.b(compound.f("facing"));
        super.a(compound);
        this.a(this.c);
    }

    @Override
    protected AxisAlignedBB a(BlockPosition pos, EnumDirection direction) {
        PaintingVariant variant = this.s().a();
        return EntityPainting.calculateBoundingBoxStatic(pos, direction, variant.b(), variant.c());
    }

    public static AxisAlignedBB calculateBoundingBoxStatic(BlockPosition pos, EnumDirection direction, int width, int height) {
        float f2 = 0.46875f;
        Vec3D vec3 = Vec3D.b(pos).a(direction, -0.46875);
        double d2 = EntityPainting.b(width);
        double d1 = EntityPainting.b(height);
        EnumDirection counterClockWise = direction.i();
        Vec3D vec31 = vec3.a(counterClockWise, d2).a(EnumDirection.b, d1);
        EnumDirection.EnumAxis axis = direction.o();
        double d22 = axis == EnumDirection.EnumAxis.a ? 0.0625 : (double)width;
        double d3 = height;
        double d4 = axis == EnumDirection.EnumAxis.c ? 0.0625 : (double)width;
        return AxisAlignedBB.a(vec31, d22, d3, d4);
    }

    private static double b(int size) {
        return size % 2 == 0 ? 0.5 : 0.0;
    }

    @Override
    public void a(WorldServer level, @Nullable Entity entity) {
        if (level.O().b(GameRules.i)) {
            EntityHuman player;
            this.a(SoundEffects.sQ, 1.0f, 1.0f);
            if (!(entity instanceof EntityHuman) || !(player = (EntityHuman)entity).fV()) {
                this.a(level, Items.qE);
            }
        }
    }

    @Override
    public void z() {
        this.a(SoundEffects.sR, 1.0f, 1.0f);
    }

    @Override
    public void b(double x2, double y2, double z2, float yaw, float pitch) {
        this.a_(x2, y2, z2);
    }

    @Override
    public void a(double x2, double y2, double z2, float yRot, float xRot, int steps) {
        this.a_(x2, y2, z2);
    }

    @Override
    public Vec3D du() {
        return Vec3D.a(this.a);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        return new PacketPlayOutSpawnEntity((Entity)this, this.c.d(), this.p());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.a(EnumDirection.a(packet.p()));
    }

    @Override
    public ItemStack dI() {
        return new ItemStack(Items.qE);
    }
}

