/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import io.papermc.paper.event.player.PlayerItemFrameChangeEvent;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;

public class EntityItemFrame
extends EntityHanging {
    public static final DataWatcherObject<ItemStack> e = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.h);
    public static final DataWatcherObject<Integer> f = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.b);
    public static final int d = 8;
    private static final float g = 0.0625f;
    private static final float h = 0.75f;
    private static final float i = 0.75f;
    public float j = 1.0f;
    public boolean k;
    @Nullable
    public MapId cachedMapId;

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> entityType, World level) {
        super((EntityTypes<? extends EntityHanging>)entityType, level);
    }

    public EntityItemFrame(World level, BlockPosition pos, EnumDirection facingDirection) {
        this(EntityTypes.as, level, pos, facingDirection);
    }

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> entityType, World level, BlockPosition pos, EnumDirection direction) {
        super((EntityTypes<? extends EntityHanging>)entityType, level, pos);
        this.a(direction);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(e, ItemStack.j);
        builder.a(f, 0);
    }

    @Override
    public void a(EnumDirection facingDirection) {
        Validate.notNull((Object)facingDirection);
        this.c = facingDirection;
        if (facingDirection.o().d()) {
            this.w(0.0f);
            this.v(this.c.e() * 90);
        } else {
            this.w(-90 * facingDirection.f().a());
            this.v(0.0f);
        }
        this.O = this.dN();
        this.N = this.dL();
        this.l();
    }

    @Override
    protected AxisAlignedBB a(BlockPosition pos, EnumDirection direction) {
        return EntityItemFrame.calculateBoundingBoxStatic(pos, direction);
    }

    public static AxisAlignedBB calculateBoundingBoxStatic(BlockPosition pos, EnumDirection direction) {
        float f2 = 0.46875f;
        Vec3D vec3 = Vec3D.b(pos).a(direction, -0.46875);
        EnumDirection.EnumAxis axis = direction.o();
        double d2 = axis == EnumDirection.EnumAxis.a ? 0.0625 : 0.75;
        double d1 = axis == EnumDirection.EnumAxis.b ? 0.0625 : 0.75;
        double d22 = axis == EnumDirection.EnumAxis.c ? 0.0625 : 0.75;
        return AxisAlignedBB.a(vec3, d2, d1, d22);
    }

    @Override
    public boolean m() {
        if (this.k) {
            return true;
        }
        if (!this.dV().g(this)) {
            return false;
        }
        IBlockData blockState = this.dV().a_(this.a.a(this.c.g()));
        return (blockState.e() || this.c.o().d() && BlockDiodeAbstract.n(blockState)) && this.dV().a((Entity)this, this.cR(), EntityHanging.b).isEmpty();
    }

    @Override
    public void a(EnumMoveType type, Vec3D pos) {
        if (!this.k) {
            super.a(type, pos);
        }
    }

    @Override
    public void push(double x2, double y2, double z2, @Nullable Entity pushingEntity) {
        if (!this.k) {
            super.push(x2, y2, z2, pushingEntity);
        }
    }

    @Override
    public void c(WorldServer level) {
        this.c(this.A());
        super.c(level);
    }

    private boolean a(DamageSource damageSource) {
        return !damageSource.a(DamageTypeTags.l) && !this.A().f();
    }

    private static boolean e(DamageSource damageSource) {
        return damageSource.a(DamageTypeTags.d) || damageSource.h();
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return (!this.k || EntityItemFrame.e(damageSource)) && !this.d(damageSource);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (!this.k) {
            if (this.d(damageSource)) {
                return false;
            }
            if (this.a(damageSource)) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, false) || this.dQ()) {
                    return true;
                }
                Entity entity = damageSource.d();
                if (entity instanceof EntityHuman) {
                    EntityHuman player = (EntityHuman)entity;
                    PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), this.A().asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.REMOVE);
                    if (!event.callEvent()) {
                        return true;
                    }
                    this.a(ItemStack.fromBukkitCopy(event.getItemStack()), false);
                }
                this.a(level, damageSource.d(), false);
                this.a(GameEvent.c, damageSource.d());
                this.a(this.s(), 1.0f, 1.0f);
                return true;
            }
            return super.a(level, damageSource, amount);
        }
        return EntityItemFrame.e(damageSource) && super.a(level, damageSource, amount);
    }

    public SoundEffect s() {
        return SoundEffects.nX;
    }

    @Override
    public boolean a(double distance) {
        double d2 = 16.0;
        return distance < (d2 *= 64.0 * EntityItemFrame.cK()) * d2;
    }

    @Override
    public void a(WorldServer level, @Nullable Entity entity) {
        this.a(this.t(), 1.0f, 1.0f);
        this.a(level, entity, true);
        this.a(GameEvent.c, entity);
    }

    public SoundEffect t() {
        return SoundEffects.nV;
    }

    @Override
    public void z() {
        this.a(this.u(), 1.0f, 1.0f);
    }

    public SoundEffect u() {
        return SoundEffects.nW;
    }

    private void a(WorldServer level, @Nullable Entity entity, boolean dropItem) {
        if (!this.k) {
            EntityHuman player;
            ItemStack item = this.A();
            this.b(ItemStack.j);
            if (!level.O().b(GameRules.i)) {
                if (entity == null) {
                    this.c(item);
                }
            } else if (entity instanceof EntityHuman && (player = (EntityHuman)entity).fV()) {
                this.c(item);
            } else {
                if (dropItem) {
                    this.a(level, this.x());
                }
                if (!item.f()) {
                    item = item.v();
                    this.c(item);
                    if (this.ae.i() < this.j) {
                        this.a(level, item);
                    }
                }
            }
        }
    }

    private void c(ItemStack stack) {
        WorldMap savedData;
        MapId framedMapId = this.a(stack);
        if (framedMapId != null && (savedData = ItemWorldMap.a(framedMapId, this.dV())) != null) {
            savedData.a(this.a, this.ar());
        }
        stack.a((Entity)null);
    }

    public ItemStack A() {
        return this.au().a(e);
    }

    @Override
    @Nullable
    public EntityItem a(WorldServer serverLevel, ItemStack stack) {
        return this.a(serverLevel, stack, this.cO() == EnumDirection.a ? -0.6f : 0.0f);
    }

    @Nullable
    public MapId a(ItemStack stack) {
        return stack.a(DataComponents.L);
    }

    public boolean B() {
        return this.A().b(DataComponents.L);
    }

    public void b(ItemStack stack) {
        this.a(stack, true);
    }

    public void a(ItemStack stack, boolean updateNeighbours) {
        this.setItem(stack, updateNeighbours, true);
    }

    public void setItem(ItemStack stack, boolean updateNeighbours, boolean playSound) {
        if (!stack.f()) {
            stack = stack.c(1);
        }
        this.d(stack);
        this.au().a(e, stack);
        if (!stack.f() && updateNeighbours && playSound) {
            this.a(this.v(), 1.0f, 1.0f);
        }
        if (updateNeighbours && this.a != null) {
            this.dV().c(this.a, Blocks.a);
        }
    }

    public SoundEffect v() {
        return SoundEffects.nU;
    }

    @Override
    public SlotAccess a_(int slot) {
        return slot == 0 ? SlotAccess.a(this::A, this::b) : super.a_(slot);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (key.equals(e)) {
            this.d(this.A());
        }
    }

    private void d(ItemStack item) {
        this.cachedMapId = item.a().a(DataComponents.L);
        if (!item.f() && item.I() != this) {
            item.a(this);
        }
        this.l();
    }

    public int C() {
        return this.au().a(f);
    }

    public void b(int rotation) {
        this.a(rotation, true);
    }

    private void a(int rotation, boolean updateNeighbours) {
        this.au().a(f, rotation % 8);
        if (updateNeighbours && this.a != null) {
            this.dV().c(this.a, Blocks.a);
        }
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        if (!this.A().f()) {
            compound.a("Item", this.A().a(this.dX()));
            compound.a("ItemRotation", (byte)this.C());
            compound.a("ItemDropChance", this.j);
        }
        compound.a("Facing", (byte)this.c.d());
        compound.a("Invisible", this.cp());
        compound.a("Fixed", this.k);
    }

    @Override
    public void a(NBTTagCompound compound) {
        ItemStack itemStack;
        super.a(compound);
        if (compound.b("Item", 10)) {
            NBTTagCompound compound1 = compound.p("Item");
            itemStack = ItemStack.a((HolderLookup.a)this.dX(), (NBTBase)compound1).orElse(ItemStack.j);
        } else {
            itemStack = ItemStack.j;
        }
        ItemStack item = this.A();
        if (!item.f() && !ItemStack.a(itemStack, item)) {
            this.c(item);
        }
        this.a(itemStack, false);
        if (!itemStack.f()) {
            this.a(compound.f("ItemRotation"), false);
            if (compound.b("ItemDropChance", 99)) {
                this.j = compound.j("ItemDropChance");
            }
        }
        this.a(EnumDirection.a(compound.f("Facing")));
        this.k(compound.q("Invisible"));
        this.k = compound.q("Fixed");
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        boolean flag1;
        ItemStack itemInHand = player.b(hand);
        boolean flag = !this.A().f();
        boolean bl = flag1 = !itemInHand.f();
        if (this.k) {
            return EnumInteractionResult.e;
        }
        if (!player.dV().C) {
            if (!flag) {
                if (flag1 && !this.dQ()) {
                    WorldMap savedData = ItemWorldMap.b(itemInHand, this.dV());
                    if (savedData != null && savedData.a(256)) {
                        return EnumInteractionResult.d;
                    }
                    PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), itemInHand.asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.PLACE);
                    if (!event.callEvent()) {
                        return EnumInteractionResult.d;
                    }
                    this.b(ItemStack.fromBukkitCopy(event.getItemStack()));
                    this.a(GameEvent.c, (Entity)player);
                    itemInHand.a(1, (EntityLiving)player);
                    return EnumInteractionResult.a;
                }
                return EnumInteractionResult.e;
            }
            PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), this.A().asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.ROTATE);
            if (!event.callEvent()) {
                return EnumInteractionResult.d;
            }
            this.setItem(ItemStack.fromBukkitCopy(event.getItemStack()), false, false);
            this.a(this.w(), 1.0f, 1.0f);
            this.b(this.C() + 1);
            this.a(GameEvent.c, (Entity)player);
            return EnumInteractionResult.a;
        }
        return (EnumInteractionResult)((Object)(!flag && !flag1 ? EnumInteractionResult.e : EnumInteractionResult.a));
    }

    public SoundEffect w() {
        return SoundEffects.nY;
    }

    public int D() {
        return this.A().f() ? 0 : this.C() % 8 + 1;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        return new PacketPlayOutSpawnEntity((Entity)this, this.c.d(), this.p());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.a(EnumDirection.a(packet.p()));
    }

    @Override
    public ItemStack dI() {
        ItemStack item = this.A();
        return item.f() ? this.x() : item.v();
    }

    protected ItemStack x() {
        return new ItemStack(Items.vb);
    }

    @Override
    public float dM() {
        EnumDirection direction = this.cO();
        int i2 = direction.o().b() ? 90 * direction.f().a() : 0;
        return MathHelper.b(180 + direction.e() * 90 + this.C() * 45 + i2);
    }
}

