/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vector3f;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class EntityArmorStand
extends EntityLiving {
    public static final int a = 5;
    private static final boolean bQ = true;
    public static final Vector3f b = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f c = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f d = new Vector3f(-10.0f, 0.0f, -10.0f);
    public static final Vector3f e = new Vector3f(-15.0f, 0.0f, 10.0f);
    public static final Vector3f f = new Vector3f(-1.0f, 0.0f, -1.0f);
    public static final Vector3f g = new Vector3f(1.0f, 0.0f, 1.0f);
    private static final EntitySize bR = EntitySize.c(0.0f, 0.0f);
    private static final EntitySize bS = EntityTypes.f.n().a(0.5f).b(0.9875f);
    private static final double bT = 0.1;
    private static final double bU = 0.9;
    private static final double bV = 0.4;
    private static final double bW = 1.6;
    public static final int h = 8;
    public static final int i = 16;
    public static final int j = 1;
    public static final int k = 4;
    public static final int bG = 8;
    public static final int bH = 16;
    public static final DataWatcherObject<Byte> bI = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Vector3f> bJ = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> bK = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> bL = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> bM = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> bN = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> bO = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    private static final Predicate<Entity> bX = entity -> {
        EntityMinecartAbstract abstractMinecart;
        return entity instanceof EntityMinecartAbstract && (abstractMinecart = (EntityMinecartAbstract)entity).B();
    };
    private final NonNullList<net.minecraft.world.item.ItemStack> bY = NonNullList.a(2, net.minecraft.world.item.ItemStack.j);
    private final NonNullList<net.minecraft.world.item.ItemStack> bZ = NonNullList.a(4, net.minecraft.world.item.ItemStack.j);
    private boolean ca;
    public long bP;
    public int cb;
    public Vector3f cc = b;
    public Vector3f cd = c;
    public Vector3f ce = d;
    public Vector3f cf = e;
    public Vector3f cg = f;
    public Vector3f ch = g;
    public boolean canMove = true;
    public boolean canTick = true;
    public boolean canTickSetByAPI = false;
    private boolean noTickPoseDirty = false;
    private boolean noTickEquipmentDirty = false;

    public EntityArmorStand(EntityTypes<? extends EntityArmorStand> entityType, World level) {
        super((EntityTypes<? extends EntityLiving>)entityType, level);
        if (level != null) {
            this.canTick = level.paperConfig().entities.armorStands.tick;
        }
    }

    public EntityArmorStand(World level, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityArmorStand>)EntityTypes.f, level);
        this.a_(x2, y2, z2);
    }

    public static AttributeProvider.Builder m() {
        return EntityArmorStand.ed().a(GenericAttributes.B, 0.0);
    }

    @Override
    public float getBukkitYaw() {
        return this.dL();
    }

    @Override
    public void m_() {
        double x2 = this.dA();
        double y2 = this.dC();
        double z2 = this.dG();
        super.m_();
        this.a_(x2, y2, z2);
    }

    private boolean E() {
        return !this.x() && !this.bc();
    }

    @Override
    public boolean dj() {
        return super.dj() && this.E();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bI, (byte)0);
        builder.a(bJ, b);
        builder.a(bK, c);
        builder.a(bL, d);
        builder.a(bM, e);
        builder.a(bN, f);
        builder.a(bO, g);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> fc() {
        return this.bY;
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> fb() {
        return this.bZ;
    }

    @Override
    public net.minecraft.world.item.ItemStack a(EnumItemSlot slot) {
        switch (slot.a()) {
            case a: {
                return this.bY.get(slot.b());
            }
            case b: {
                return this.bZ.get(slot.b());
            }
        }
        return net.minecraft.world.item.ItemStack.j;
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.g && !this.g(slot);
    }

    @Override
    public void a(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack, boolean silent) {
        this.c(stack);
        switch (slot.a()) {
            case a: {
                this.onEquipItem(slot, this.bY.set(slot.b(), stack), stack, silent);
                break;
            }
            case b: {
                this.onEquipItem(slot, this.bZ.set(slot.b(), stack), stack, silent);
            }
        }
        this.noTickEquipmentDirty = true;
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        NBTTagList listTag = new NBTTagList();
        for (net.minecraft.world.item.ItemStack itemStack : this.bZ) {
            listTag.add(itemStack.b(this.dX()));
        }
        compound.a("ArmorItems", listTag);
        NBTTagList listTag1 = new NBTTagList();
        for (net.minecraft.world.item.ItemStack itemStack1 : this.bY) {
            listTag1.add(itemStack1.b(this.dX()));
        }
        compound.a("HandItems", listTag1);
        compound.a("Invisible", this.cp());
        compound.a("Small", this.p());
        compound.a("ShowArms", this.t());
        compound.a("DisabledSlots", this.cb);
        compound.a("NoBasePlate", !this.u());
        if (this.x()) {
            compound.a("Marker", this.x());
        }
        compound.a("Pose", this.F());
        if (this.canTickSetByAPI) {
            compound.a("Paper.CanTickOverride", this.canTick);
        }
    }

    @Override
    public void a(NBTTagCompound compound) {
        NBTTagCompound compound1;
        int i2;
        NBTTagList list;
        super.a(compound);
        if (compound.b("ArmorItems", 9)) {
            list = compound.c("ArmorItems", 10);
            for (i2 = 0; i2 < this.bZ.size(); ++i2) {
                compound1 = list.a(i2);
                this.bZ.set(i2, net.minecraft.world.item.ItemStack.a((HolderLookup.a)this.dX(), compound1));
            }
        }
        if (compound.b("HandItems", 9)) {
            list = compound.c("HandItems", 10);
            for (i2 = 0; i2 < this.bY.size(); ++i2) {
                compound1 = list.a(i2);
                this.bY.set(i2, net.minecraft.world.item.ItemStack.a((HolderLookup.a)this.dX(), compound1));
            }
        }
        this.k(compound.q("Invisible"));
        this.u(compound.q("Small"));
        this.a(compound.q("ShowArms"));
        this.cb = compound.h("DisabledSlots");
        this.b(compound.q("NoBasePlate"));
        this.v(compound.q("Marker"));
        boolean bl = this.ad = !this.E();
        if (compound.e("Paper.CanTickOverride")) {
            this.canTick = compound.q("Paper.CanTickOverride");
            this.canTickSetByAPI = true;
        }
        NBTTagCompound compound2 = compound.p("Pose");
        this.c(compound2);
    }

    private void c(NBTTagCompound compound) {
        NBTTagList list = compound.c("Head", 5);
        this.a(list.isEmpty() ? b : new Vector3f(list));
        NBTTagList list1 = compound.c("Body", 5);
        this.b(list1.isEmpty() ? c : new Vector3f(list1));
        NBTTagList list2 = compound.c("LeftArm", 5);
        this.c(list2.isEmpty() ? d : new Vector3f(list2));
        NBTTagList list3 = compound.c("RightArm", 5);
        this.d(list3.isEmpty() ? e : new Vector3f(list3));
        NBTTagList list4 = compound.c("LeftLeg", 5);
        this.e(list4.isEmpty() ? f : new Vector3f(list4));
        NBTTagList list5 = compound.c("RightLeg", 5);
        this.f(list5.isEmpty() ? g : new Vector3f(list5));
    }

    private NBTTagCompound F() {
        NBTTagCompound compoundTag = new NBTTagCompound();
        if (!b.equals(this.cc)) {
            compoundTag.a("Head", this.cc.a());
        }
        if (!c.equals(this.cd)) {
            compoundTag.a("Body", this.cd.a());
        }
        if (!d.equals(this.ce)) {
            compoundTag.a("LeftArm", this.ce.a());
        }
        if (!e.equals(this.cf)) {
            compoundTag.a("RightArm", this.cf.a());
        }
        if (!f.equals(this.cg)) {
            compoundTag.a("LeftLeg", this.cg.a());
        }
        if (!g.equals(this.ch)) {
            compoundTag.a("RightLeg", this.ch.a());
        }
        return compoundTag;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    @Override
    protected void D(Entity entity) {
    }

    @Override
    protected void o() {
        if (!this.dV().paperConfig().entities.armorStands.doCollisionEntityLookups) {
            return;
        }
        for (Entity entity : this.dV().a(EntityMinecartAbstract.class, this.cR(), bX)) {
            if (!(this.g(entity) <= 0.2)) continue;
            entity.h(this);
        }
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, Vec3D vec, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemInHand = player.b(hand);
        if (this.x() || itemInHand.a(Items.vL)) {
            return EnumInteractionResult.e;
        }
        if (player.Z_()) {
            return EnumInteractionResult.a;
        }
        if (player.dV().C) {
            return EnumInteractionResult.b;
        }
        EnumItemSlot equipmentSlotForItem = this.f(itemInHand);
        if (itemInHand.f()) {
            EnumItemSlot equipmentSlot;
            EnumItemSlot clickedSlot = this.l(vec);
            EnumItemSlot enumItemSlot = equipmentSlot = this.g(clickedSlot) ? equipmentSlotForItem : clickedSlot;
            if (this.d(equipmentSlot) && this.a(player, equipmentSlot, itemInHand, hand)) {
                return EnumInteractionResult.b;
            }
        } else {
            if (this.g(equipmentSlotForItem)) {
                return EnumInteractionResult.d;
            }
            if (equipmentSlotForItem.a() == EnumItemSlot.Function.a && !this.t()) {
                return EnumInteractionResult.d;
            }
            if (this.a(player, equipmentSlotForItem, itemInHand, hand)) {
                return EnumInteractionResult.b;
            }
        }
        return EnumInteractionResult.e;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EnumItemSlot l(Vec3D vector) {
        EnumItemSlot equipmentSlot = EnumItemSlot.a;
        boolean isSmall = this.p();
        double d2 = vector.e / (double)(this.ej() * this.ei());
        EnumItemSlot equipmentSlot1 = EnumItemSlot.c;
        if (d2 >= 0.1) {
            double d3 = isSmall ? 0.8 : 0.45;
            if (d2 < 0.1 + d3 && this.d(equipmentSlot1)) {
                return EnumItemSlot.c;
            }
        }
        double d4 = isSmall ? 0.3 : 0.0;
        if (d2 >= 0.9 + d4) {
            double d5 = isSmall ? 1.0 : 0.7;
            if (d2 < 0.9 + d5 && this.d(EnumItemSlot.e)) {
                return EnumItemSlot.e;
            }
        }
        if (d2 >= 0.4) {
            double d6 = isSmall ? 1.0 : 0.8;
            if (d2 < 0.4 + d6 && this.d(EnumItemSlot.d)) {
                return EnumItemSlot.d;
            }
        }
        if (d2 >= 1.6 && this.d(EnumItemSlot.f)) {
            return EnumItemSlot.f;
        }
        if (this.d(EnumItemSlot.a)) return equipmentSlot;
        if (!this.d(EnumItemSlot.b)) return equipmentSlot;
        return EnumItemSlot.b;
    }

    public boolean g(EnumItemSlot slot) {
        return (this.cb & 1 << slot.b(0)) != 0 || slot.a() == EnumItemSlot.Function.a && !this.t();
    }

    private boolean a(EntityHuman player, EnumItemSlot slot, net.minecraft.world.item.ItemStack stack, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemBySlot = this.a(slot);
        if (!itemBySlot.f() && (this.cb & 1 << slot.b(8)) != 0) {
            return false;
        }
        if (itemBySlot.f() && (this.cb & 1 << slot.b(16)) != 0) {
            return false;
        }
        CraftItemStack armorStandItem = CraftItemStack.asCraftMirror(itemBySlot);
        CraftItemStack playerHeldItem = CraftItemStack.asCraftMirror(stack);
        Player player1 = (Player)player.getBukkitEntity();
        ArmorStand self = (ArmorStand)this.getBukkitEntity();
        EquipmentSlot slot1 = CraftEquipmentSlot.getSlot(slot);
        EquipmentSlot hand1 = CraftEquipmentSlot.getHand(hand);
        PlayerArmorStandManipulateEvent armorStandManipulateEvent = new PlayerArmorStandManipulateEvent(player1, self, (ItemStack)playerHeldItem, (ItemStack)armorStandItem, slot1, hand1);
        this.dV().getCraftServer().getPluginManager().callEvent((Event)armorStandManipulateEvent);
        if (armorStandManipulateEvent.isCancelled()) {
            return true;
        }
        if (player.fV() && itemBySlot.f() && !stack.f()) {
            this.a(slot, stack.c(1));
            return true;
        }
        if (stack.f() || stack.M() <= 1) {
            this.a(slot, stack);
            player.a(hand, itemBySlot);
            return true;
        }
        if (!itemBySlot.f()) {
            return false;
        }
        this.a(slot, stack.a(1));
        return true;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.dQ()) {
            return false;
        }
        if (!level.O().b(GameRules.c) && damageSource.d() instanceof EntityInsentient) {
            return false;
        }
        if (damageSource.a(DamageTypeTags.d)) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount)) {
                return false;
            }
            this.kill(level, damageSource);
            return false;
        }
        if (this.a(level, damageSource) || this.x()) {
            return false;
        }
        if (damageSource.a(DamageTypeTags.l)) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, true, this.ca)) {
                return false;
            }
            EntityDeathEvent event = this.brokenByAnything(level, damageSource);
            if (!event.isCancelled()) {
                this.kill(level, damageSource, false);
            }
            return false;
        }
        if (damageSource.a(DamageTypeTags.u)) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, true, this.ca)) {
                return false;
            }
            if (this.bY()) {
                this.c(level, damageSource, 0.15f);
            } else {
                this.d(5.0f);
            }
            return false;
        }
        if (damageSource.a(DamageTypeTags.v) && this.eD() > 0.5f) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, true, this.ca)) {
                return false;
            }
            this.c(level, damageSource, 4.0f);
            return false;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, true, this.ca)) {
            return false;
        }
        boolean isCanBreakArmorStand = damageSource.a(DamageTypeTags.B);
        boolean isAlwaysKillsArmorStands = damageSource.a(DamageTypeTags.A);
        if (!isCanBreakArmorStand && !isAlwaysKillsArmorStands) {
            return false;
        }
        Entity entity = damageSource.d();
        if (entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            if (!player.gj().e) {
                return false;
            }
        }
        if (damageSource.h()) {
            this.H();
            this.G();
            this.kill(level, damageSource);
            return true;
        }
        long gameTime = level.ad();
        if (gameTime - this.bP > 5L && !isAlwaysKillsArmorStands) {
            level.a((Entity)this, (byte)32);
            this.a(GameEvent.o, damageSource.d());
            this.bP = gameTime;
        } else {
            EntityDeathEvent event = this.brokenByPlayer(level, damageSource);
            this.G();
            if (!event.isCancelled()) {
                this.kill(level, damageSource, false);
            }
        }
        return true;
    }

    @Override
    public void b(byte id) {
        if (id == 32) {
            if (this.dV().C) {
                this.dV().a(this.dA(), this.dC(), this.dG(), SoundEffects.aC, this.dm(), 0.3f, 1.0f, false);
                this.bP = this.dV().ad();
            }
        } else {
            super.b(id);
        }
    }

    @Override
    public boolean a(double distance) {
        double d2 = this.cR().a() * 4.0;
        if (Double.isNaN(d2) || d2 == 0.0) {
            d2 = 4.0;
        }
        return distance < (d2 *= 64.0) * d2;
    }

    private void G() {
        if (this.dV() instanceof WorldServer) {
            ((WorldServer)this.dV()).a(new ParticleParamBlock(Particles.b, Blocks.n.m()), this.dA(), this.e(0.6666666666666666), this.dG(), 10, (double)(this.dq() / 4.0f), (double)(this.dr() / 4.0f), (double)(this.dq() / 4.0f), 0.05);
        }
    }

    private void c(WorldServer level, DamageSource damageSource, float damageAmount) {
        float health = this.eD();
        if ((health -= damageAmount) <= 0.5f) {
            this.brokenByAnything(level, damageSource);
            EntityDeathEvent event = this.brokenByAnything(level, damageSource);
            if (!event.isCancelled()) {
                this.kill(level, damageSource, false);
            }
        } else {
            this.x(health);
            this.a(GameEvent.o, damageSource.d());
        }
    }

    private EntityDeathEvent brokenByPlayer(WorldServer level, DamageSource damageSource) {
        net.minecraft.world.item.ItemStack itemStack = new net.minecraft.world.item.ItemStack(Items.vF);
        itemStack.b(DataComponents.g, this.an());
        this.drops.add(new Entity.DefaultDrop(itemStack, stack -> Block.a(this.dV(), this.dv(), stack)));
        return this.brokenByAnything(level, damageSource);
    }

    private EntityDeathEvent brokenByAnything(WorldServer level, DamageSource damageSource) {
        net.minecraft.world.item.ItemStack itemStack;
        this.H();
        for (int i2 = 0; i2 < this.bY.size(); ++i2) {
            itemStack = this.bY.get(i2);
            if (itemStack.f()) continue;
            this.drops.add(new Entity.DefaultDrop(itemStack, stack -> Block.a(this.dV(), this.dv().d(), stack)));
            this.bY.set(i2, net.minecraft.world.item.ItemStack.j);
        }
        for (int ix = 0; ix < this.bZ.size(); ++ix) {
            itemStack = this.bZ.get(ix);
            if (itemStack.f()) continue;
            this.drops.add(new Entity.DefaultDrop(itemStack, stack -> Block.a(this.dV(), this.dv().d(), stack)));
            this.bZ.set(ix, net.minecraft.world.item.ItemStack.j);
        }
        return this.dropAllDeathLoot(level, damageSource);
    }

    @Override
    private void H() {
        this.dV().a(null, this.dA(), this.dC(), this.dG(), SoundEffects.aA, this.dm(), 1.0f, 1.0f);
    }

    @Override
    protected float g(float yRot, float animStep) {
        this.aY = this.N;
        this.aX = this.dL();
        return 0.0f;
    }

    @Override
    public void a_(Vec3D travelVector) {
        if (this.E()) {
            super.a_(travelVector);
        }
    }

    @Override
    public void r(float offset) {
        this.aY = this.N = offset;
        this.ba = this.aZ = offset;
    }

    @Override
    public void q(float rotation) {
        this.aY = this.N = rotation;
        this.ba = this.aZ = rotation;
    }

    @Override
    public void h() {
        if (!this.canTick) {
            if (this.noTickPoseDirty) {
                this.noTickPoseDirty = false;
                this.updatePose();
            }
            if (this.noTickEquipmentDirty) {
                this.noTickEquipmentDirty = false;
                this.detectEquipmentUpdatesPublic();
            }
            return;
        }
        super.h();
        this.updatePose();
    }

    public void updatePose() {
        Vector3f rotations5;
        Vector3f rotations4;
        Vector3f rotations3;
        Vector3f rotations2;
        Vector3f rotations1;
        Vector3f rotations = this.al.a(bJ);
        if (!this.cc.equals(rotations)) {
            this.a(rotations);
        }
        if (!this.cd.equals(rotations1 = this.al.a(bK))) {
            this.b(rotations1);
        }
        if (!this.ce.equals(rotations2 = this.al.a(bL))) {
            this.c(rotations2);
        }
        if (!this.cf.equals(rotations3 = this.al.a(bM))) {
            this.d(rotations3);
        }
        if (!this.cg.equals(rotations4 = this.al.a(bN))) {
            this.e(rotations4);
        }
        if (!this.ch.equals(rotations5 = this.al.a(bO))) {
            this.f(rotations5);
        }
    }

    @Override
    protected void K() {
        this.k(this.ca);
    }

    @Override
    public void k(boolean invisible) {
        this.ca = invisible;
        super.k(invisible);
    }

    @Override
    public boolean e_() {
        return this.p();
    }

    @Override
    public boolean em() {
        return true;
    }

    @Override
    public void c(WorldServer level) {
        this.kill(level, null);
    }

    public void kill(WorldServer level, @Nullable DamageSource damageSource) {
        this.kill(level, damageSource, true);
    }

    public void kill(WorldServer level, @Nullable DamageSource damageSource, boolean callEvent) {
        EntityDeathEvent event;
        if (callEvent && (event = CraftEventFactory.callEntityDeathEvent(this, damageSource == null ? this.dW().y() : damageSource, this.drops)).isCancelled()) {
            return;
        }
        this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        ((Entity)this).a(GameEvent.p);
    }

    @Override
    public boolean a(Explosion explosion) {
        return !explosion.h() || this.cp();
    }

    @Override
    public EnumPistonReaction n_() {
        return this.x() ? EnumPistonReaction.d : super.n_();
    }

    @Override
    public boolean s_() {
        return this.x();
    }

    public void u(boolean small) {
        this.al.a(bI, this.a(this.al.a(bI), 1, small));
    }

    public boolean p() {
        return (this.al.a(bI) & 1) != 0;
    }

    public void a(boolean showArms) {
        this.al.a(bI, this.a(this.al.a(bI), 4, showArms));
    }

    public boolean t() {
        return (this.al.a(bI) & 4) != 0;
    }

    public void b(boolean noBasePlate) {
        this.al.a(bI, this.a(this.al.a(bI), 8, noBasePlate));
    }

    @Override
    public boolean u() {
        return (this.al.a(bI) & 8) == 0;
    }

    public void v(boolean marker) {
        this.al.a(bI, this.a(this.al.a(bI), 16, marker));
    }

    public boolean x() {
        return (this.al.a(bI) & 0x10) != 0;
    }

    private byte a(byte oldBit, int offset, boolean value) {
        oldBit = value ? (byte)(oldBit | offset) : (byte)(oldBit & ~offset);
        return oldBit;
    }

    public void a(Vector3f headPose) {
        this.cc = headPose;
        this.al.a(bJ, headPose);
        this.noTickPoseDirty = true;
    }

    public void b(Vector3f bodyPose) {
        this.cd = bodyPose;
        this.al.a(bK, bodyPose);
        this.noTickPoseDirty = true;
    }

    public void c(Vector3f leftArmPose) {
        this.ce = leftArmPose;
        this.al.a(bL, leftArmPose);
        this.noTickPoseDirty = true;
    }

    public void d(Vector3f rightArmPose) {
        this.cf = rightArmPose;
        this.al.a(bM, rightArmPose);
        this.noTickPoseDirty = true;
    }

    public void e(Vector3f leftLegPose) {
        this.cg = leftLegPose;
        this.al.a(bN, leftLegPose);
        this.noTickPoseDirty = true;
    }

    public void f(Vector3f rightLegPose) {
        this.ch = rightLegPose;
        this.al.a(bO, rightLegPose);
        this.noTickPoseDirty = true;
    }

    public Vector3f y() {
        return this.cc;
    }

    public Vector3f z() {
        return this.cd;
    }

    public Vector3f A() {
        return this.ce;
    }

    public Vector3f B() {
        return this.cf;
    }

    public Vector3f C() {
        return this.cg;
    }

    public Vector3f D() {
        return this.ch;
    }

    @Override
    public boolean bH() {
        return super.bH() && !this.x();
    }

    @Override
    public boolean v(Entity entity) {
        return entity instanceof EntityHuman && !this.dV().a((EntityHuman)entity, this.dv());
    }

    @Override
    public EnumMainHand fy() {
        return EnumMainHand.b;
    }

    @Override
    public EntityLiving.a eM() {
        return new EntityLiving.a(SoundEffects.aB, SoundEffects.aB);
    }

    @Override
    @Nullable
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.aC;
    }

    @Override
    @Nullable
    public SoundEffect o_() {
        return SoundEffects.aA;
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
    }

    @Override
    public boolean fL() {
        return false;
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (bI.equals(key)) {
            this.m_();
            this.I = !this.x();
        }
        super.a(key);
    }

    @Override
    public boolean fM() {
        return false;
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.w(this.x());
    }

    private EntitySize w(boolean isMarker) {
        if (isMarker) {
            return bR;
        }
        return this.e_() ? bS : this.aq().n();
    }

    @Override
    public Vec3D n(float partialTicks) {
        if (this.x()) {
            AxisAlignedBB aabb = this.w(false).a(this.dt());
            BlockPosition blockPos = this.dv();
            int i2 = Integer.MIN_VALUE;
            for (BlockPosition blockPos1 : BlockPosition.c(BlockPosition.a(aabb.a, aabb.b, aabb.c), BlockPosition.a(aabb.d, aabb.e, aabb.f))) {
                int max = Math.max(this.dV().a(EnumSkyBlock.b, blockPos1), this.dV().a(EnumSkyBlock.a, blockPos1));
                if (max == 15) {
                    return Vec3D.b(blockPos1);
                }
                if (max <= i2) continue;
                i2 = max;
                blockPos = blockPos1.j();
            }
            return Vec3D.b(blockPos);
        }
        return super.n(partialTicks);
    }

    @Override
    public net.minecraft.world.item.ItemStack dI() {
        return new net.minecraft.world.item.ItemStack(Items.vF);
    }

    @Override
    public boolean ex() {
        return !this.cp() && !this.x();
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        if (this.canMove) {
            super.a(type, movement);
        }
    }
}

