/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.destroystokyo.paper.event.block.TNTPrimeEvent;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.DragonFlightHistory;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerManager;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EntityEnderDragon
extends EntityInsentient
implements IMonster {
    private static final Logger cc = LogUtils.getLogger();
    public static final DataWatcherObject<Integer> a = DataWatcher.a(EntityEnderDragon.class, DataWatcherRegistry.b);
    private static final PathfinderTargetCondition cd = PathfinderTargetCondition.a().a(64.0);
    private static final int ce = 200;
    private static final int cf = 400;
    private static final float cg = 0.25f;
    private static final String ch = "DragonDeathTime";
    private static final String ci = "DragonPhase";
    public final DragonFlightHistory b = new DragonFlightHistory();
    public final EntityComplexPart[] cj;
    public final EntityComplexPart c;
    private final EntityComplexPart ck;
    private final EntityComplexPart cl;
    private final EntityComplexPart cm;
    private final EntityComplexPart cn;
    private final EntityComplexPart co;
    private final EntityComplexPart cp;
    private final EntityComplexPart cq;
    public float d;
    public float bX;
    public boolean bY;
    public int bZ;
    public float ca;
    @Nullable
    public EntityEnderCrystal cb;
    @Nullable
    private EnderDragonBattle cr;
    private BlockPosition cs = BlockPosition.c;
    private final DragonControllerManager ct;
    private int cu = 100;
    private float cv;
    private final PathPoint[] cw = new PathPoint[24];
    private final int[] cx = new int[24];
    private final Path cy = new Path();
    private final Explosion explosionSource;
    @Nullable
    private BlockPosition podium;

    public EntityEnderDragon(EntityTypes<? extends EntityEnderDragon> entityType, World level) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.P, level);
        this.c = new EntityComplexPart(this, "head", 1.0f, 1.0f);
        this.ck = new EntityComplexPart(this, "neck", 3.0f, 3.0f);
        this.cl = new EntityComplexPart(this, "body", 5.0f, 3.0f);
        this.cm = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cn = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.co = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cp = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.cq = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.cj = new EntityComplexPart[]{this.c, this.ck, this.cl, this.cm, this.cn, this.co, this.cp, this.cq};
        this.x(this.eS());
        this.ad = true;
        this.ct = new DragonControllerManager(this);
        this.explosionSource = new ServerExplosion(level.getMinecraftWorld(), this, null, null, new Vec3D(Double.NaN, Double.NaN, Double.NaN), Float.NaN, true, Explosion.Effect.b);
    }

    public void a(EnderDragonBattle dragonFight) {
        this.cr = dragonFight;
    }

    public void c(BlockPosition fightOrigin) {
        this.cs = fightOrigin;
    }

    public BlockPosition m() {
        return this.cs;
    }

    public static AttributeProvider.Builder p() {
        return EntityInsentient.F().a(GenericAttributes.s, 200.0);
    }

    public BlockPosition getPodium() {
        if (this.podium == null) {
            return WorldGenEndTrophy.a(this.m());
        }
        return this.podium;
    }

    public void setPodium(@Nullable BlockPosition blockPos) {
        this.podium = blockPos;
    }

    @Override
    public boolean ba() {
        float cos = MathHelper.b(this.bX * ((float)Math.PI * 2));
        float cos1 = MathHelper.b(this.d * ((float)Math.PI * 2));
        return cos1 <= -0.3f && cos >= -0.3f;
    }

    @Override
    public void aZ() {
        if (this.dV().C && !this.bb()) {
            this.dV().a(this.dA(), this.dC(), this.dG(), SoundEffects.iy, this.dm(), 5.0f, 0.8f + this.ae.i() * 0.3f, false);
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, DragonControllerPhase.k.b());
    }

    @Override
    public void d_() {
        WorldServer serverLevel;
        EnderDragonBattle dragonFight;
        World world;
        this.aO();
        if (this.dV().C) {
            this.x(this.eD());
            if (!this.bb() && !this.ct.a().a() && --this.cu < 0) {
                this.dV().a(this.dA(), this.dC(), this.dG(), SoundEffects.iz, this.dm(), 2.5f, 0.8f + this.ae.i() * 0.3f, false);
                this.cu = 200 + this.ae.a(200);
            }
        }
        if (this.cr == null && (world = this.dV()) instanceof WorldServer && (dragonFight = (serverLevel = (WorldServer)world).F()) != null && this.cG().equals(dragonFight.i())) {
            this.cr = dragonFight;
        }
        this.d = this.bX;
        if (this.eE()) {
            float f2 = (this.ae.i() - 0.5f) * 8.0f;
            float f1 = (this.ae.i() - 0.5f) * 4.0f;
            float f22 = (this.ae.i() - 0.5f) * 8.0f;
            this.dV().a(Particles.w, this.dA() + (double)f2, this.dC() + 2.0 + (double)f1, this.dG() + (double)f22, 0.0, 0.0, 0.0);
        } else {
            this.gr();
            Vec3D deltaMovement = this.dy();
            float f1 = 0.2f / ((float)deltaMovement.i() * 10.0f + 1.0f);
            this.bX = this.ct.a().a() ? (this.bX += 0.1f) : (this.bY ? (this.bX += f1 * 0.5f) : (this.bX += (f1 *= (float)Math.pow(2.0, deltaMovement.e))));
            this.v(MathHelper.h(this.dL()));
            if (this.gf()) {
                this.bX = 0.5f;
            } else {
                float f4;
                float f3;
                this.b.a(this.dC(), this.dL());
                World world2 = this.dV();
                if (world2 instanceof WorldServer) {
                    Vec3D flyTargetLocation;
                    WorldServer serverLevel1 = (WorldServer)world2;
                    IDragonController currentPhase = this.ct.a();
                    currentPhase.a(serverLevel1);
                    if (this.ct.a() != currentPhase) {
                        currentPhase = this.ct.a();
                        currentPhase.a(serverLevel1);
                    }
                    if ((flyTargetLocation = currentPhase.f()) != null && currentPhase.h() != DragonControllerPhase.k) {
                        double d2 = flyTargetLocation.d - this.dA();
                        double d1 = flyTargetLocation.e - this.dC();
                        double d22 = flyTargetLocation.f - this.dG();
                        double d3 = d2 * d2 + d1 * d1 + d22 * d22;
                        float flySpeed = currentPhase.e();
                        double squareRoot = Math.sqrt(d2 * d2 + d22 * d22);
                        if (squareRoot > 0.0) {
                            d1 = MathHelper.a(d1 / squareRoot, (double)(-flySpeed), (double)flySpeed);
                        }
                        this.i(this.dy().b(0.0, d1 * 0.01, 0.0));
                        this.v(MathHelper.h(this.dL()));
                        Vec3D vec3 = flyTargetLocation.a(this.dA(), this.dC(), this.dG()).d();
                        Vec3D vec31 = new Vec3D(MathHelper.a(this.dL() * ((float)Math.PI / 180)), this.dy().e, -MathHelper.b(this.dL() * ((float)Math.PI / 180))).d();
                        float max = Math.max(((float)vec31.b(vec3) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d2) > (double)1.0E-5f || Math.abs(d22) > (double)1.0E-5f) {
                            f3 = MathHelper.a(MathHelper.h(180.0f - (float)MathHelper.d(d2, d22) * 57.295776f - this.dL()), -50.0f, 50.0f);
                            this.ca *= 0.8f;
                            this.ca += f3 * currentPhase.g();
                            this.v(this.dL() + this.ca * 0.1f);
                        }
                        f3 = (float)(2.0 / (d3 + 1.0));
                        f4 = 0.06f;
                        this.a(0.06f * (max * f3 + (1.0f - f3)), new Vec3D(0.0, 0.0, -1.0));
                        if (this.bY) {
                            this.a(EnumMoveType.a, this.dy().c((double)0.8f));
                        } else {
                            this.a(EnumMoveType.a, this.dy());
                        }
                        Vec3D vec32 = this.dy().d();
                        double d4 = 0.8 + 0.15 * (vec32.b(vec31) + 1.0) / 2.0;
                        this.i(this.dy().d(d4, 0.91f, d4));
                    }
                } else {
                    if (this.bq > 0) {
                        this.a(this.bq, this.br, this.bs, this.bt, this.bu, this.bv);
                        --this.bq;
                    }
                    this.ct.a().b();
                }
                if (!this.dV().B_()) {
                    this.aK();
                }
                this.aX = this.dL();
                Vec3D[] vec3s = new Vec3D[this.cj.length];
                for (int i2 = 0; i2 < this.cj.length; ++i2) {
                    vec3s[i2] = new Vec3D(this.cj[i2].dA(), this.cj[i2].dC(), this.cj[i2].dG());
                }
                float f5 = (float)(this.b.a(5).a() - this.b.a(10).a()) * 10.0f * ((float)Math.PI / 180);
                float cos = MathHelper.b(f5);
                float sin = MathHelper.a(f5);
                float f6 = this.dL() * ((float)Math.PI / 180);
                float sin1 = MathHelper.a(f6);
                float cos1 = MathHelper.b(f6);
                this.a(this.cl, (double)(sin1 * 0.5f), 0.0, (double)(-cos1 * 0.5f));
                this.a(this.cp, (double)(cos1 * 4.5f), 2.0, (double)(sin1 * 4.5f));
                this.a(this.cq, (double)(cos1 * -4.5f), 2.0, (double)(sin1 * -4.5f));
                World world3 = this.dV();
                if (world3 instanceof WorldServer) {
                    WorldServer serverLevel2 = (WorldServer)world3;
                    if (this.aN == 0) {
                        this.a(serverLevel2, serverLevel2.a((Entity)this, this.cp.cR().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        this.a(serverLevel2, serverLevel2.a((Entity)this, this.cq.cR().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        this.b(serverLevel2, serverLevel2.a((Entity)this, this.c.cR().g(1.0), IEntitySelector.e));
                        this.b(serverLevel2, serverLevel2.a((Entity)this, this.ck.cR().g(1.0), IEntitySelector.e));
                    }
                }
                float sin2 = MathHelper.a(this.dL() * ((float)Math.PI / 180) - this.ca * 0.01f);
                float cos2 = MathHelper.b(this.dL() * ((float)Math.PI / 180) - this.ca * 0.01f);
                float headYOffset = this.gq();
                this.a(this.c, (double)(sin2 * 6.5f * cos), (double)(headYOffset + sin * 6.5f), (double)(-cos2 * 6.5f * cos));
                this.a(this.ck, (double)(sin2 * 5.5f * cos), (double)(headYOffset + sin * 5.5f), (double)(-cos2 * 5.5f * cos));
                DragonFlightHistory.a sample = this.b.a(5);
                for (int i1 = 0; i1 < 3; ++i1) {
                    EntityComplexPart enderDragonPart = null;
                    if (i1 == 0) {
                        enderDragonPart = this.cm;
                    }
                    if (i1 == 1) {
                        enderDragonPart = this.cn;
                    }
                    if (i1 == 2) {
                        enderDragonPart = this.co;
                    }
                    DragonFlightHistory.a sample1 = this.b.a(12 + i1 * 2);
                    float f7 = this.dL() * ((float)Math.PI / 180) + this.i((double)(sample1.b() - sample.b())) * ((float)Math.PI / 180);
                    float sin3 = MathHelper.a(f7);
                    float maxx = MathHelper.b(f7);
                    f3 = 1.5f;
                    f4 = (float)(i1 + 1) * 2.0f;
                    this.a(enderDragonPart, (double)(-(sin1 * 1.5f + sin3 * f4) * cos), sample1.a() - sample.a() - (double)((f4 + 1.5f) * sin) + 1.5, (double)((cos1 * 1.5f + maxx * f4) * cos));
                }
                World world4 = this.dV();
                if (world4 instanceof WorldServer) {
                    WorldServer serverLevel3 = (WorldServer)world4;
                    this.bY = this.a(serverLevel3, this.c.cR()) | this.a(serverLevel3, this.ck.cR()) | this.a(serverLevel3, this.cl.cR());
                    if (this.cr != null) {
                        this.cr.b(this);
                    }
                }
                for (int i1 = 0; i1 < this.cj.length; ++i1) {
                    this.cj[i1].K = vec3s[i1].d;
                    this.cj[i1].L = vec3s[i1].e;
                    this.cj[i1].M = vec3s[i1].f;
                    this.cj[i1].aa = vec3s[i1].d;
                    this.cj[i1].ab = vec3s[i1].e;
                    this.cj[i1].ac = vec3s[i1].f;
                }
            }
        }
    }

    private void a(EntityComplexPart part, double offsetX, double offsetY, double offsetZ) {
        part.a_(this.dA() + offsetX, this.dC() + offsetY, this.dG() + offsetZ);
    }

    private float gq() {
        if (this.ct.a().a()) {
            return -1.0f;
        }
        DragonFlightHistory.a sample = this.b.a(5);
        DragonFlightHistory.a sample1 = this.b.a(0);
        return (float)(sample.a() - sample1.a());
    }

    private void gr() {
        if (this.cb != null) {
            EntityRegainHealthEvent event;
            if (this.cb.dQ()) {
                this.cb = null;
            } else if (this.af % 10 == 0 && this.eD() < this.eS() && (event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0, EntityRegainHealthEvent.RegainReason.ENDER_CRYSTAL)).callEvent()) {
                this.x((float)((double)this.eD() + event.getAmount()));
            }
        }
        if (this.ae.a(10) == 0) {
            List<EntityEnderCrystal> entitiesOfClass = this.dV().a(EntityEnderCrystal.class, this.cR().g(32.0));
            EntityEnderCrystal endCrystal = null;
            double d2 = Double.MAX_VALUE;
            for (EntityEnderCrystal endCrystal1 : entitiesOfClass) {
                double d1 = endCrystal1.g(this);
                if (!(d1 < d2)) continue;
                d2 = d1;
                endCrystal = endCrystal1;
            }
            this.cb = endCrystal;
        }
    }

    private void a(WorldServer level, List<Entity> targets) {
        double d2 = (this.cl.cR().a + this.cl.cR().d) / 2.0;
        double d1 = (this.cl.cR().c + this.cl.cR().f) / 2.0;
        for (Entity entity : targets) {
            if (!(entity instanceof EntityLiving)) continue;
            EntityLiving livingEntity = (EntityLiving)entity;
            double d22 = entity.dA() - d2;
            double d3 = entity.dG() - d1;
            double max = Math.max(d22 * d22 + d3 * d3, 0.1);
            entity.push(d22 / max * 4.0, 0.2f, d3 / max * 4.0, this);
            if (this.ct.a().a() || livingEntity.eq() >= entity.af - 2) continue;
            DamageSource damageSource = this.dW().b(this);
            entity.a(level, damageSource, 5.0f);
            EnchantmentManager.a(level, entity, damageSource);
        }
    }

    private void b(WorldServer level, List<Entity> entities) {
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLiving)) continue;
            DamageSource damageSource = this.dW().b(this);
            entity.a(level, damageSource, 10.0f);
            EnchantmentManager.a(level, entity, damageSource);
        }
    }

    private float i(double angle) {
        return (float)MathHelper.d(angle);
    }

    private boolean a(WorldServer level, AxisAlignedBB box) {
        int floor = MathHelper.a(box.a);
        int floor1 = MathHelper.a(box.b);
        int floor2 = MathHelper.a(box.c);
        int floor3 = MathHelper.a(box.d);
        int floor4 = MathHelper.a(box.e);
        int floor5 = MathHelper.a(box.f);
        boolean flag = false;
        boolean flag1 = false;
        ArrayList<org.bukkit.block.Block> destroyedBlocks = new ArrayList<org.bukkit.block.Block>();
        for (int i2 = floor; i2 <= floor3; ++i2) {
            for (int i1 = floor1; i1 <= floor4; ++i1) {
                for (int i22 = floor2; i22 <= floor5; ++i22) {
                    BlockPosition blockPos = new BlockPosition(i2, i1, i22);
                    IBlockData blockState = level.a_(blockPos);
                    if (blockState.l() || blockState.a(TagsBlock.aG)) continue;
                    if (level.O().b(GameRules.c) && !blockState.a(TagsBlock.aF)) {
                        flag1 = true;
                        destroyedBlocks.add(CraftBlock.at(level, blockPos));
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (!flag1) {
            return flag;
        }
        EntityExplodeEvent event = CraftEventFactory.callEntityExplodeEvent(this, destroyedBlocks, 0.0f, this.explosionSource.b());
        if (event.isCancelled()) {
            return flag;
        }
        if (event.getYield() == 0.0f) {
            for (org.bukkit.block.Block block : event.blockList()) {
                this.dV().a(new BlockPosition(block.getX(), block.getY(), block.getZ()), false);
            }
        } else {
            for (org.bukkit.block.Block block : event.blockList()) {
                CraftBlock tntBlock;
                Material blockType = block.getType();
                if (blockType.isAir()) continue;
                CraftBlock craftBlock = (CraftBlock)block;
                BlockPosition pos = craftBlock.getPosition();
                Block nmsBlock = craftBlock.getNMS().b();
                if (nmsBlock.a(this.explosionSource)) {
                    TileEntity blockEntity = craftBlock.getNMS().x() ? this.dV().c_(pos) : null;
                    LootParams.a builder = new LootParams.a((WorldServer)this.dV()).a(LootContextParameters.f, Vec3D.b(pos)).a(LootContextParameters.i, ItemStack.j).a(LootContextParameters.j, Float.valueOf(1.0f / event.getYield())).b(LootContextParameters.h, blockEntity);
                    craftBlock.getNMS().a(builder).forEach(stack -> Block.a(this.dV(), pos, stack));
                    craftBlock.getNMS().a((WorldServer)this.dV(), pos, ItemStack.j, false);
                }
                if (!new TNTPrimeEvent((org.bukkit.block.Block)(tntBlock = CraftBlock.at(this.dV(), pos)), TNTPrimeEvent.PrimeReason.EXPLOSION, (org.bukkit.entity.Entity)this.explosionSource.c().getBukkitEntity()).callEvent()) continue;
                nmsBlock.a((WorldServer)this.dV(), pos, this.explosionSource);
                this.dV().a(pos, false);
            }
        }
        if (flag1) {
            BlockPosition blockPos1 = new BlockPosition(floor + this.ae.a(floor3 - floor + 1), floor1 + this.ae.a(floor4 - floor1 + 1), floor2 + this.ae.a(floor5 - floor2 + 1));
            level.c(2008, blockPos1, 0);
        }
        return flag;
    }

    public boolean a(WorldServer level, EntityComplexPart part, DamageSource damageSource, float amount) {
        if (this.ct.a().h() == DragonControllerPhase.j) {
            return false;
        }
        amount = this.ct.a().a(damageSource, amount);
        if (part != this.c) {
            amount = amount / 4.0f + Math.min(amount, 1.0f);
        }
        if (amount < 0.01f) {
            return false;
        }
        if (damageSource.d() instanceof EntityHuman || damageSource.a(DamageTypeTags.y)) {
            float health = this.eD();
            this.c(level, damageSource, amount);
            if (this.eE() && !this.ct.a().a()) {
                this.x(1.0f);
                this.ct.a(DragonControllerPhase.j);
            }
            if (this.ct.a().a()) {
                this.cv = this.cv + health - this.eD();
                if (this.cv > 0.25f * this.eS()) {
                    this.cv = 0.0f;
                    this.ct.a(DragonControllerPhase.e);
                }
            }
        }
        return true;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        return this.a(level, this.cl, damageSource, amount);
    }

    protected void c(WorldServer level, DamageSource damageSource, float amount) {
        super.a(level, damageSource, amount);
    }

    @Override
    public void c(WorldServer level) {
        this.silentDeath = true;
        EntityDeathEvent deathEvent = CraftEventFactory.callEntityDeathEvent(this, this.dW().y());
        if (deathEvent.isCancelled()) {
            this.silentDeath = false;
            return;
        }
        this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        ((Entity)this).a(GameEvent.p);
        if (this.cr != null) {
            this.cr.b(this);
            this.cr.a(this);
        }
    }

    @Override
    protected void el() {
        World world;
        if (this.cr != null) {
            this.cr.b(this);
        }
        ++this.bZ;
        if (this.bZ >= 180 && this.bZ <= 200) {
            float f2 = (this.ae.i() - 0.5f) * 8.0f;
            float f1 = (this.ae.i() - 0.5f) * 4.0f;
            float f22 = (this.ae.i() - 0.5f) * 8.0f;
            this.dV().a(Particles.v, this.dA() + (double)f2, this.dC() + 2.0 + (double)f1, this.dG() + (double)f22, 0.0, 0.0, 0.0);
        }
        int i2 = this.expToDrop;
        World f22 = this.dV();
        if (f22 instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)f22;
            if (this.bZ > 150 && this.bZ % 5 == 0) {
                EntityExperienceOrb.award(serverLevel, this.dt(), MathHelper.d((float)i2 * 0.08f), ExperienceOrb.SpawnReason.ENTITY_DEATH, this.bc, this);
            }
            if (this.bZ == 1 && !this.bb()) {
                int viewDistance = serverLevel.getCraftServer().getViewDistance() * 16;
                for (EntityPlayer player : serverLevel.getPlayersForGlobalSoundGamerule()) {
                    double deltaX = this.dA() - player.dA();
                    double deltaZ = this.dG() - player.dG();
                    double distanceSquared = MathHelper.k(deltaX) + MathHelper.k(deltaZ);
                    double soundRadiusSquared = serverLevel.getGlobalSoundRangeSquared(config -> config.dragonDeathSoundRadius);
                    if (!serverLevel.O().b(GameRules.X) && distanceSquared > soundRadiusSquared) continue;
                    if (distanceSquared > (double)MathHelper.h(viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.dA() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.dG() + deltaZ / deltaLength * (double)viewDistance;
                        player.f.b(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)relativeX, (int)this.dC(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.f.b(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)this.dA(), (int)this.dC(), (int)this.dG()), 0, true));
                }
            }
        }
        Vec3D vec3 = new Vec3D(0.0, 0.1f, 0.0);
        this.a(EnumMoveType.a, vec3);
        for (EntityComplexPart enderDragonPart : this.cj) {
            enderDragonPart.bz();
            enderDragonPart.b(enderDragonPart.dt().e(vec3));
        }
        if (this.bZ == 200 && (world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel1 = (WorldServer)world;
            EntityExperienceOrb.award(serverLevel1, this.dt(), MathHelper.d((float)i2 * 0.2f), ExperienceOrb.SpawnReason.ENTITY_DEATH, this.bc, this);
            if (this.cr != null) {
                this.cr.a(this);
            }
            this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
            ((Entity)this).a(GameEvent.p);
        }
    }

    public int t() {
        if (this.cw[0] == null) {
            for (int i2 = 0; i2 < 24; ++i2) {
                int floor1;
                int floor;
                int i1 = 5;
                if (i2 < 12) {
                    floor = MathHelper.d(60.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                    floor1 = MathHelper.d(60.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                } else if (i2 < 20) {
                    int i22 = i2 - 12;
                    floor = MathHelper.d(40.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i22)));
                    floor1 = MathHelper.d(40.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i22)));
                    i1 += 10;
                } else {
                    int var7 = i2 - 20;
                    floor = MathHelper.d(20.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)var7)));
                    floor1 = MathHelper.d(20.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)var7)));
                }
                int max = Math.max(73, this.dV().a(HeightMap.Type.f, new BlockPosition(floor, 0, floor1)).v() + i1);
                this.cw[i2] = new PathPoint(floor, max, floor1);
            }
            this.cx[0] = 6146;
            this.cx[1] = 8197;
            this.cx[2] = 8202;
            this.cx[3] = 16404;
            this.cx[4] = 32808;
            this.cx[5] = 32848;
            this.cx[6] = 65696;
            this.cx[7] = 131392;
            this.cx[8] = 131712;
            this.cx[9] = 263424;
            this.cx[10] = 526848;
            this.cx[11] = 525313;
            this.cx[12] = 1581057;
            this.cx[13] = 3166214;
            this.cx[14] = 2138120;
            this.cx[15] = 6373424;
            this.cx[16] = 4358208;
            this.cx[17] = 12910976;
            this.cx[18] = 9044480;
            this.cx[19] = 9706496;
            this.cx[20] = 15216640;
            this.cx[21] = 0xD0E000;
            this.cx[22] = 11763712;
            this.cx[23] = 0x7E0000;
        }
        return this.q(this.dA(), this.dC(), this.dG());
    }

    public int q(double x2, double y2, double z2) {
        float f2 = 10000.0f;
        int i2 = 0;
        PathPoint node = new PathPoint(MathHelper.a(x2), MathHelper.a(y2), MathHelper.a(z2));
        int i1 = 0;
        if (this.cr == null || this.cr.e() == 0) {
            i1 = 12;
        }
        for (int i22 = i1; i22 < 24; ++i22) {
            float f1;
            if (this.cw[i22] == null || !((f1 = this.cw[i22].c(node)) < f2)) continue;
            f2 = f1;
            i2 = i22;
        }
        return i2;
    }

    @Nullable
    public PathEntity a(int startIndex, int finishIndex, @Nullable PathPoint andThen) {
        PathPoint node;
        for (int i2 = 0; i2 < 24; ++i2) {
            node = this.cw[i2];
            node.i = false;
            node.g = 0.0f;
            node.e = 0.0f;
            node.f = 0.0f;
            node.h = null;
            node.d = -1;
        }
        PathPoint node1 = this.cw[startIndex];
        node = this.cw[finishIndex];
        node1.e = 0.0f;
        node1.g = node1.f = node1.a(node);
        this.cy.a();
        this.cy.a(node1);
        PathPoint node2 = node1;
        int i1 = 0;
        if (this.cr == null || this.cr.e() == 0) {
            i1 = 12;
        }
        while (!this.cy.e()) {
            PathPoint node3 = this.cy.c();
            if (node3.equals(node)) {
                if (andThen != null) {
                    andThen.h = node;
                    node = andThen;
                }
                return this.a(node1, node);
            }
            if (node3.a(node) < node2.a(node)) {
                node2 = node3;
            }
            node3.i = true;
            int i2 = 0;
            for (int i3 = 0; i3 < 24; ++i3) {
                if (this.cw[i3] != node3) continue;
                i2 = i3;
                break;
            }
            for (int i3x = i1; i3x < 24; ++i3x) {
                if ((this.cx[i2] & 1 << i3x) <= 0) continue;
                PathPoint node4 = this.cw[i3x];
                if (node4.i) continue;
                float f2 = node3.e + node3.a(node4);
                if (node4.c() && !(f2 < node4.e)) continue;
                node4.h = node3;
                node4.e = f2;
                node4.f = node4.a(node);
                if (node4.c()) {
                    this.cy.a(node4, node4.e + node4.f);
                    continue;
                }
                node4.g = node4.e + node4.f;
                this.cy.a(node4);
            }
        }
        if (node2 == node1) {
            return null;
        }
        cc.debug("Failed to find path from {} to {}", (Object)startIndex, (Object)finishIndex);
        if (andThen != null) {
            andThen.h = node2;
            node2 = andThen;
        }
        return this.a(node1, node2);
    }

    private PathEntity a(PathPoint start, PathPoint finish) {
        ArrayList list = Lists.newArrayList();
        PathPoint node = finish;
        list.add(0, finish);
        while (node.h != null) {
            node = node.h;
            list.add(0, node);
        }
        return new PathEntity(list, new BlockPosition(finish.a, finish.b, finish.c), true);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a(ci, this.ct.a().h().b());
        compound.a(ch, this.bZ);
        compound.a("Bukkit.expToDrop", this.expToDrop);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        if (compound.e(ci)) {
            this.ct.a(DragonControllerPhase.a(compound.h(ci)));
        }
        if (compound.e(ch)) {
            this.bZ = compound.h(ch);
        }
        if (compound.e("Bukkit.expToDrop")) {
            this.expToDrop = compound.h("Bukkit.expToDrop");
        }
    }

    @Override
    public void dH() {
    }

    public EntityComplexPart[] x() {
        return this.cj;
    }

    @Override
    public boolean bH() {
        return false;
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.iv;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.iA;
    }

    @Override
    public float fg() {
        return 5.0f;
    }

    public Vec3D J(float partialTicks) {
        Vec3D viewVector;
        IDragonController currentPhase = this.ct.a();
        DragonControllerPhase<? extends IDragonController> phase = currentPhase.h();
        if (phase == DragonControllerPhase.d || phase == DragonControllerPhase.e) {
            BlockPosition heightmapPos = this.dV().a(HeightMap.Type.f, this.getPodium());
            float max = Math.max((float)Math.sqrt(heightmapPos.b(this.dt())) / 4.0f, 1.0f);
            float f2 = 6.0f / max;
            float xRot = this.dN();
            float f1 = 1.5f;
            this.w(-f2 * 1.5f * 5.0f);
            viewVector = this.g(partialTicks);
            this.w(xRot);
        } else if (currentPhase.a()) {
            float xRot1 = this.dN();
            float max = 1.5f;
            this.w(-45.0f);
            viewVector = this.g(partialTicks);
            this.w(xRot1);
        } else {
            viewVector = this.g(partialTicks);
        }
        return viewVector;
    }

    public void a(WorldServer level, EntityEnderCrystal crystal, BlockPosition pos, DamageSource damageSource) {
        EntityHuman player = damageSource.d() instanceof EntityHuman ? (EntityHuman)damageSource.d() : level.a(cd, (double)pos.u(), (double)pos.v(), (double)pos.w());
        if (crystal == this.cb) {
            this.a(level, this.c, this.dW().d(crystal, player), 10.0f);
        }
        this.ct.a().a(crystal, pos, damageSource, player);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (a.equals(key) && this.dV().C) {
            this.ct.a(DragonControllerPhase.a(this.au().a(a)));
        }
        super.a(key);
    }

    public DragonControllerManager go() {
        return this.ct;
    }

    @Nullable
    public EnderDragonBattle gp() {
        return this.cr;
    }

    @Override
    public boolean b(MobEffect effectInstance, @Nullable Entity entity) {
        return false;
    }

    @Override
    protected boolean o(Entity entity) {
        return false;
    }

    @Override
    public boolean o(boolean allowPassengers) {
        return false;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        EntityComplexPart[] subEntities = this.x();
        for (int i2 = 0; i2 < subEntities.length; ++i2) {
            subEntities[i2].e(i2 + packet.b() + 1);
        }
    }

    @Override
    public boolean c(EntityLiving target) {
        return target.ew();
    }

    @Override
    protected float b(float scale) {
        return 1.0f;
    }

    @Override
    public int getExpReward(WorldServer worldserver, Entity entity) {
        boolean flag = worldserver.O().b(GameRules.f);
        int i2 = 500;
        if (this.cr != null && !this.cr.f()) {
            i2 = 12000;
        }
        return flag ? i2 : 0;
    }
}

