/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.dimension.end.EnumDragonRespawn;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityEnderCrystal
extends Entity {
    private static final DataWatcherObject<Optional<BlockPosition>> b = DataWatcher.a(EntityEnderCrystal.class, DataWatcherRegistry.p);
    private static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityEnderCrystal.class, DataWatcherRegistry.k);
    public int a;
    public boolean generatedByDragonFight = false;

    public EntityEnderCrystal(EntityTypes<? extends EntityEnderCrystal> entityType, World level) {
        super(entityType, level);
        this.I = true;
        this.a = this.ae.a(100000);
    }

    public EntityEnderCrystal(World level, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityEnderCrystal>)EntityTypes.R, level);
        this.a_(x2, y2, z2);
    }

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(b, Optional.empty());
        builder.a(c, true);
    }

    @Override
    public void h() {
        ++this.a;
        this.aK();
        this.bW();
        if (this.dV() instanceof WorldServer) {
            BlockPosition blockPos = this.dv();
            if (((WorldServer)this.dV()).F() != null && this.dV().a_(blockPos).l() && !CraftEventFactory.callBlockIgniteEvent(this.dV(), blockPos, this).isCancelled()) {
                this.dV().b(blockPos, BlockFireAbstract.a(this.dV(), blockPos));
            }
        }
        if (this.dV().paperConfig().unsupportedSettings.fixInvulnerableEndCrystalExploit && this.generatedByDragonFight && this.cC() && (!Objects.equals(((WorldServer)this.dV()).uuid, this.getOriginWorld()) || ((WorldServer)this.dV()).F() == null || ((WorldServer)this.dV()).F().z == null || ((WorldServer)this.dV()).F().z.ordinal() > EnumDragonRespawn.d.ordinal())) {
            this.n(false);
            this.a((BlockPosition)null);
        }
    }

    @Override
    protected void b(NBTTagCompound compound) {
        if (this.l() != null) {
            compound.a("beam_target", GameProfileSerializer.a(this.l()));
        }
        compound.a("ShowBottom", this.m());
        if (this.generatedByDragonFight) {
            compound.a("Paper.GeneratedByDragonFight", this.generatedByDragonFight);
        }
    }

    @Override
    protected void a(NBTTagCompound compound) {
        GameProfileSerializer.a(compound, "beam_target").ifPresent(this::a);
        if (compound.b("ShowBottom", 1)) {
            this.a(compound.q("ShowBottom"));
        }
        if (compound.b("Paper.GeneratedByDragonFight", 1)) {
            this.generatedByDragonFight = compound.q("Paper.GeneratedByDragonFight");
        }
    }

    @Override
    public boolean bH() {
        return true;
    }

    @Override
    public final boolean b(DamageSource damageSource) {
        return !this.d(damageSource) && !(damageSource.d() instanceof EntityEnderDragon);
    }

    @Override
    public final boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.d(damageSource)) {
            return false;
        }
        if (damageSource.d() instanceof EntityEnderDragon) {
            return false;
        }
        if (!this.dQ()) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, false)) {
                return false;
            }
            if (!damageSource.a(DamageTypeTags.l)) {
                DamageSource damageSource1 = damageSource.d() != null ? this.dW().d(this, damageSource.d()) : null;
                ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, 6.0f, false);
                if (event.isCancelled()) {
                    return false;
                }
                this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.EXPLODE);
                level.a(this, damageSource1, null, this.dA(), this.dC(), this.dG(), event.getRadius(), event.getFire(), World.a.b);
            } else {
                this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
            }
            this.a(level, damageSource);
        }
        return true;
    }

    @Override
    public void c(WorldServer level) {
        this.a(level, this.dW().p());
        super.c(level);
    }

    private void a(WorldServer level, DamageSource damageSource) {
        EnderDragonBattle dragonFight = level.F();
        if (dragonFight != null) {
            dragonFight.a(this, damageSource);
        }
    }

    public void a(@Nullable BlockPosition beamTarget) {
        this.au().a(b, Optional.ofNullable(beamTarget));
    }

    @Nullable
    public BlockPosition l() {
        return this.au().a(b).orElse(null);
    }

    public void a(boolean showBottom) {
        this.au().a(c, showBottom);
    }

    public boolean m() {
        return this.au().a(c);
    }

    @Override
    public boolean a(double distance) {
        return super.a(distance) || this.l() != null;
    }

    @Override
    public ItemStack dI() {
        return new ItemStack(Items.wf);
    }
}

