/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sniffer;

import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.sniffer.SnifferAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;

public class Sniffer
extends EntityAnimal {
    private static final int ce = 1700;
    private static final int cf = 6000;
    private static final int cg = 30;
    private static final int ch = 120;
    private static final int ci = 48000;
    private static final float cj = 0.4f;
    private static final EntitySize ck = EntitySize.b(EntityTypes.bi.l(), EntityTypes.bi.m() - 0.4f).b(0.81f);
    private static final DataWatcherObject<State> cl = DataWatcher.a(Sniffer.class, DataWatcherRegistry.C);
    private static final DataWatcherObject<Integer> cm = DataWatcher.a(Sniffer.class, DataWatcherRegistry.b);
    public final AnimationState bY = new AnimationState();
    public final AnimationState bZ = new AnimationState();
    public final AnimationState ca = new AnimationState();
    public final AnimationState cc = new AnimationState();
    public final AnimationState cd = new AnimationState();

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gx().a(GenericAttributes.v, 0.1f).a(GenericAttributes.s, 14.0);
    }

    public Sniffer(EntityTypes<? extends EntityAnimal> entityType, World level) {
        super(entityType, level);
        this.P().a(true);
        this.a(PathType.j, -1.0f);
        this.a(PathType.g, -1.0f);
        this.a(PathType.y, -1.0f);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cl, State.a);
        builder.a(cm, 0);
    }

    @Override
    public void H() {
        super.H();
        if (this.bY() || this.bj()) {
            this.a(PathType.j, 0.0f);
        }
    }

    @Override
    public void I() {
        this.a(PathType.j, -1.0f);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.gF() == State.f ? ck.a(this.ei()) : super.e(pose);
    }

    public boolean t() {
        return this.gF() == State.e;
    }

    public boolean x() {
        return this.bE.c(MemoryModuleType.R).orElse(false);
    }

    public boolean gs() {
        return !this.x() && !this.gp() && !this.bj() && !this.gC() && this.aJ() && !this.bZ() && !this.P_();
    }

    public boolean gt() {
        return this.gF() == State.f || this.gF() == State.e;
    }

    private BlockPosition gw() {
        Vec3D headPosition = this.gE();
        return BlockPosition.a(headPosition.a(), this.dC() + (double)0.2f, headPosition.c());
    }

    private Vec3D gE() {
        return this.dt().e(this.bV().c(2.25));
    }

    public State gF() {
        return this.al.a(cl);
    }

    private Sniffer b(State state) {
        this.al.a(cl, state);
        return this;
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (cl.equals(key)) {
            State state = this.gF();
            this.gG();
            switch (state.ordinal()) {
                case 1: {
                    this.bY.b(this.af);
                    break;
                }
                case 2: {
                    this.bZ.b(this.af);
                    break;
                }
                case 3: {
                    this.ca.b(this.af);
                }
                default: {
                    break;
                }
                case 5: {
                    this.cc.b(this.af);
                    break;
                }
                case 6: {
                    this.cd.b(this.af);
                }
            }
            this.m_();
        }
        super.a(key);
    }

    private void gG() {
        this.cc.a();
        this.ca.a();
        this.cd.a();
        this.bY.a();
        this.bZ.a();
    }

    public Sniffer a(State state) {
        switch (state.ordinal()) {
            case 0: {
                this.b(State.a);
                break;
            }
            case 1: {
                this.a(SoundEffects.zk, 1.0f, 1.0f);
                this.b(State.b);
                break;
            }
            case 2: {
                this.b(State.c).gH();
                break;
            }
            case 3: {
                this.a(SoundEffects.zg, 1.0f, 1.0f);
                this.b(State.d);
                break;
            }
            case 4: {
                this.b(State.e);
                break;
            }
            case 5: {
                this.b(State.f).gI();
                break;
            }
            case 6: {
                this.a(SoundEffects.zj, 1.0f, 1.0f);
                this.b(State.g);
            }
        }
        return this;
    }

    private Sniffer gH() {
        this.a(SoundEffects.zf, 1.0f, this.e_() ? 1.3f : 1.0f);
        return this;
    }

    private Sniffer gI() {
        this.al.a(cm, this.af + 120);
        this.dV().a((Entity)this, (byte)63);
        return this;
    }

    public Sniffer x(boolean storeExploredPosition) {
        if (storeExploredPosition) {
            this.i(this.aR());
        }
        return this;
    }

    public Optional<BlockPosition> gu() {
        return IntStream.range(0, 5).mapToObj(i2 -> LandRandomPos.a(this, 10 + 2 * i2, 3)).filter(Objects::nonNull).map(BlockPosition::a).filter(blockPos -> this.dV().F_().a((BlockPosition)blockPos)).map(BlockPosition::e).filter(this::h).findFirst();
    }

    public boolean gv() {
        return !this.gp() && !this.x() && !this.e_() && !this.bj() && this.aJ() && !this.bZ() && this.h(this.gw().e());
    }

    private boolean h(BlockPosition pos) {
        return this.dV().a_(pos).a(TagsBlock.cu) && this.gK().noneMatch(globalPos -> GlobalPos.a(this.dV().ai(), pos).equals(globalPos)) && Optional.ofNullable(this.P().a(pos, 1)).map(PathEntity::j).orElse(false) != false;
    }

    private void gJ() {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.al.a(cm) == this.af) {
                BlockPosition headBlock = this.gw();
                this.a(serverLevel, LootTables.aG, (WorldServer serverLevel1, ItemStack itemStack) -> {
                    EntityItem itemEntity = new EntityItem(this.dV(), headBlock.u(), headBlock.v(), headBlock.w(), (ItemStack)itemStack);
                    itemEntity.s();
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)itemEntity.getBukkitEntity());
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                    serverLevel1.b(itemEntity);
                });
                this.a(SoundEffects.ze, 1.0f, 1.0f);
            }
        }
    }

    private Sniffer a(AnimationState animationState) {
        boolean flag;
        boolean bl = flag = animationState.a((float)this.af) > 1700L && animationState.a((float)this.af) < 6000L;
        if (flag) {
            BlockPosition headBlock = this.gw();
            IBlockData blockState = this.dV().a_(headBlock.e());
            if (blockState.o() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    Vec3D vec3 = Vec3D.b(headBlock).b(0.0, -0.65f, 0.0);
                    this.dV().a(new ParticleParamBlock(Particles.b, blockState), vec3.d, vec3.e, vec3.f, 0.0, 0.0, 0.0);
                }
                if (this.af % 10 == 0) {
                    this.dV().a(this.dA(), this.dC(), this.dG(), blockState.A().f(), this.dm(), 0.5f, 0.5f, false);
                }
            }
        }
        if (this.af % 10 == 0) {
            this.dV().a(GameEvent.u, this.gw(), GameEvent.a.a(this));
        }
        return this;
    }

    public Sniffer i(BlockPosition pos) {
        List list = this.gK().limit(20L).collect(Collectors.toList());
        list.add(0, GlobalPos.a(this.dV().ai(), pos));
        this.eb().a(MemoryModuleType.aQ, list);
        return this;
    }

    public Stream<GlobalPos> gK() {
        return this.eb().c(MemoryModuleType.aQ).stream().flatMap(Collection::stream);
    }

    @Override
    public void s() {
        double d2;
        super.s();
        double speedModifier = this.bP.c();
        if (speedModifier > 0.0 && (d2 = this.dy().j()) < 0.01) {
            this.a(0.1f, new Vec3D(0.0, 0.0, 1.0));
        }
    }

    @Override
    public void a(WorldServer level, EntityAnimal mate) {
        EntityFertilizeEggEvent result = CraftEventFactory.callEntityFertilizeEggEvent(this, mate);
        if (result.isCancelled()) {
            return;
        }
        ItemStack itemStack = new ItemStack(Items.kN);
        EntityItem itemEntity = new EntityItem(level, this.dt().a(), this.dt().b(), this.dt().c(), itemStack);
        itemEntity.s();
        this.finalizeSpawnChildFromBreeding(level, mate, null, result.getExperience());
        if (this.spawnAtLocation(level, itemEntity) != null) {
            this.a(SoundEffects.zl, 1.0f, (this.ae.i() - this.ae.i()) * 0.2f + 0.5f);
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        this.a(State.a);
        super.a(damageSource);
    }

    @Override
    public void h() {
        switch (this.gF().ordinal()) {
            case 4: {
                this.gL();
                break;
            }
            case 5: {
                this.a(this.cc).gJ();
            }
        }
        super.h();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        boolean isFood = this.j(itemInHand);
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (interactionResult.a() && isFood) {
            this.gy();
        }
        return interactionResult;
    }

    @Override
    protected void gy() {
        this.dV().a(null, this, SoundEffects.za, SoundCategory.g, 1.0f, MathHelper.b(this.dV().A, 0.8f, 1.2f));
    }

    private void gL() {
        if (this.dV().B_() && this.af % 20 == 0) {
            this.dV().a(this.dA(), this.dC(), this.dG(), SoundEffects.zh, this.dm(), 1.0f, 1.0f, false);
        }
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.yZ, 0.15f, 1.0f);
    }

    @Override
    protected SoundEffect u() {
        return Set.of(State.f, State.e).contains((Object)this.gF()) ? null : SoundEffects.zb;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.zc;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.zd;
    }

    @Override
    public int af() {
        return 50;
    }

    @Override
    public void a(boolean baby) {
        this.c_(baby ? -48000 : 0);
    }

    @Override
    public EntityAgeable a(WorldServer level, EntityAgeable otherParent) {
        return EntityTypes.bi.a(level, EntitySpawnReason.e);
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        if (!(otherAnimal instanceof Sniffer)) {
            return false;
        }
        Sniffer sniffer = (Sniffer)otherAnimal;
        Set<State> set = Set.of(State.a, State.c, State.b);
        return set.contains((Object)this.gF()) && set.contains((Object)sniffer.gF()) && super.a(otherAnimal);
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aa);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return SnifferAi.a(this.ec().a(dynamic));
    }

    public BehaviorController<Sniffer> eb() {
        return super.eb();
    }

    protected BehaviorController.b<Sniffer> ec() {
        return BehaviorController.a(SnifferAi.b, SnifferAi.a);
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("snifferBrain");
        this.eb().a(level, this);
        profilerFiller.b("snifferActivityUpdate");
        SnifferAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    @Override
    protected void ac() {
        super.ac();
        PacketDebug.a(this);
    }

    public static final class State
    extends Enum<State> {
        public static final /* enum */ State a = new State(0);
        public static final /* enum */ State b = new State(1);
        public static final /* enum */ State c = new State(2);
        public static final /* enum */ State d = new State(3);
        public static final /* enum */ State e = new State(4);
        public static final /* enum */ State f = new State(5);
        public static final /* enum */ State g = new State(6);
        public static final IntFunction<State> h;
        public static final StreamCodec<ByteBuf, State> i;
        private final int j;
        private static final /* synthetic */ State[] k;

        public static State[] values() {
            return (State[])k.clone();
        }

        public static State valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        private State(int id) {
            this.j = id;
        }

        public int a() {
            return this.j;
        }

        private static /* synthetic */ State[] b() {
            return new State[]{a, b, c, d, e, f, g};
        }

        static {
            k = State.b();
            h = ByIdMap.a(State::a, State.values(), ByIdMap.a.a);
            i = ByteBufCodecs.a(h, State::a);
        }
    }
}

