/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLlamaFollow;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class EntityLlama
extends EntityHorseChestedAbstract
implements VariantHolder<Variant>,
IRangedEntity {
    private static final int bY = 5;
    private static final DataWatcherObject<Integer> bZ = DataWatcher.a(EntityLlama.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> ca = DataWatcher.a(EntityLlama.class, DataWatcherRegistry.b);
    private static final EntitySize cc = EntityTypes.ax.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.ax.m() - 0.8125f, -0.3f)).a(0.5f);
    boolean cd;
    @Nullable
    private EntityLlama ce;
    @Nullable
    public EntityLlama cf;

    public EntityLlama(EntityTypes<? extends EntityLlama> entityType, World level) {
        super((EntityTypes<? extends EntityHorseChestedAbstract>)entityType, level);
        this.P().a(40.0f);
        this.maxDomestication = 30;
    }

    public boolean gv() {
        return false;
    }

    public void setStrengthPublic(int strength) {
        this.w(strength);
    }

    private void w(int strength) {
        this.al.a(bZ, Math.max(1, Math.min(5, strength)));
    }

    private void b(RandomSource random) {
        int i2 = random.i() < 0.04f ? 5 : 3;
        this.w(1 + random.a(i2));
    }

    public int gw() {
        return this.al.a(bZ);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("Variant", this.gF().g);
        compound.a("Strength", this.gw());
    }

    @Override
    public void a(NBTTagCompound compound) {
        this.w(compound.h("Strength"));
        super.a(compound);
        this.a(Variant.a(compound.h("Variant")));
    }

    @Override
    protected void E() {
        this.bS.a(0, new PathfinderGoalFloat(this));
        this.bS.a(1, new PathfinderGoalTame(this, 1.2));
        this.bS.a(2, new PathfinderGoalLlamaFollow(this, 2.1f));
        this.bS.a(3, new PathfinderGoalArrowAttack(this, 1.25, 40, 20.0f));
        this.bS.a(3, new PathfinderGoalPanic(this, 1.2));
        this.bS.a(4, new PathfinderGoalBreed(this, 1.0));
        this.bS.a(5, new PathfinderGoalTempt(this, 1.25, itemStack -> itemStack.a(TagsItem.ar), false));
        this.bS.a(6, new PathfinderGoalFollowParent(this, 1.0));
        this.bS.a(7, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.bS.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bS.a(9, new PathfinderGoalRandomLookaround(this));
        this.bT.a(1, new c(this));
        this.bT.a(2, new a(this));
    }

    public static AttributeProvider.Builder gE() {
        return EntityLlama.p();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bZ, 0);
        builder.a(ca, 0);
    }

    public Variant gF() {
        return Variant.a(this.al.a(ca));
    }

    @Override
    public void a(Variant variant) {
        this.al.a(ca, variant.g);
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aq);
    }

    @Override
    protected boolean a(EntityHuman player, ItemStack stack) {
        SoundEffect eatingSound;
        int i2 = 0;
        int i1 = 0;
        float f2 = 0.0f;
        boolean flag = false;
        if (stack.a(Items.qb)) {
            i2 = 10;
            i1 = 3;
            f2 = 2.0f;
        } else if (stack.a(Blocks.iH.j())) {
            i2 = 90;
            i1 = 6;
            f2 = 10.0f;
            if (this.gJ() && this.Y_() == 0 && this.gz()) {
                flag = true;
                this.setInLove(player, stack.v());
            }
        }
        if (this.eD() < this.eS() && f2 > 0.0f) {
            this.heal(f2, EntityRegainHealthEvent.RegainReason.EATING);
            flag = true;
        }
        if (this.e_() && i2 > 0) {
            this.dV().a(Particles.P, this.d(1.0), this.dD() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
            if (!this.dV().C) {
                this.b_(i2);
            }
            flag = true;
        }
        if (i1 > 0 && (flag || !this.gJ()) && this.gP() < this.gV()) {
            flag = true;
            if (!this.dV().C) {
                this.u(i1);
            }
        }
        if (flag && !this.bb() && (eatingSound = this.gu()) != null) {
            this.dV().a(null, this.dA(), this.dC(), this.dG(), this.gu(), this.dm(), 1.0f, 1.0f + (this.ae.i() - this.ae.i()) * 0.2f);
        }
        return flag;
    }

    @Override
    public boolean fi() {
        return this.eE() || this.gM();
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        Variant variant;
        RandomSource random = level.H_();
        this.b(random);
        if (spawnGroupData instanceof b) {
            variant = ((b)spawnGroupData).a;
        } else {
            variant = SystemUtils.a(Variant.values(), random);
            spawnGroupData = new b(variant);
        }
        this.a(variant);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    protected boolean gt() {
        return false;
    }

    @Override
    protected SoundEffect gT() {
        return SoundEffects.ox;
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.ow;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.oB;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.oz;
    }

    @Override
    @Nullable
    protected SoundEffect gu() {
        return SoundEffects.oA;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.oD, 0.15f, 1.0f);
    }

    @Override
    protected void x() {
        this.a(SoundEffects.oy, 1.0f, (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
    }

    @Override
    public int af_() {
        return this.t() ? this.gw() : 0;
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return true;
    }

    @Override
    public boolean f() {
        return false;
    }

    @Override
    public int gV() {
        return super.gV();
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        return otherAnimal != this && otherAnimal instanceof EntityLlama && this.hb() && ((EntityLlama)otherAnimal).hb();
    }

    @Nullable
    public EntityLlama b(WorldServer level, EntityAgeable otherParent) {
        EntityLlama llama = this.gG();
        if (llama != null) {
            this.a(otherParent, llama);
            EntityLlama llama1 = (EntityLlama)otherParent;
            int i2 = this.ae.a(Math.max(this.gw(), llama1.gw())) + 1;
            if (this.ae.i() < 0.03f) {
                ++i2;
            }
            llama.w(i2);
            llama.a(this.ae.h() ? this.gF() : llama1.gF());
        }
        return llama;
    }

    @Nullable
    protected EntityLlama gG() {
        return EntityTypes.ax.a(this.dV(), EntitySpawnReason.e);
    }

    private void k(EntityLiving target) {
        EntityLlamaSpit llamaSpit = new EntityLlamaSpit(this.dV(), this);
        double d2 = target.dA() - this.dA();
        double d1 = target.e(0.3333333333333333) - llamaSpit.dC();
        double d22 = target.dG() - this.dG();
        double d3 = Math.sqrt(d2 * d2 + d22 * d22) * (double)0.2f;
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            IProjectile.a(llamaSpit, serverLevel, ItemStack.j, d2, d1 + d3, d22, 1.5f, 10.0f);
        }
        if (!this.bb()) {
            this.dV().a(null, this.dA(), this.dC(), this.dG(), SoundEffects.oC, this.dm(), 1.0f, 1.0f + (this.ae.i() - this.ae.i()) * 0.2f);
        }
        this.cd = true;
    }

    void E(boolean didSpit) {
        this.cd = didSpit;
    }

    @Override
    public boolean a(float fallDistance, float multiplier, DamageSource source) {
        int i2 = this.f(fallDistance, multiplier);
        if (i2 <= 0) {
            return false;
        }
        if (fallDistance >= 6.0f) {
            this.a(source, (float)i2);
            if (this.ca()) {
                for (Entity entity : this.dc()) {
                    entity.a(source, (float)i2);
                }
            }
        }
        this.eO();
        return true;
    }

    public void gH() {
        if (this.ce != null) {
            this.ce.cf = null;
        }
        this.ce = null;
    }

    @Override
    public void a(EntityLlama caravanHead) {
        this.ce = caravanHead;
        this.ce.cf = this;
    }

    public boolean gI() {
        return this.cf != null;
    }

    public boolean he() {
        return this.ce != null;
    }

    @Nullable
    public EntityLlama hf() {
        return this.ce;
    }

    @Override
    protected double gr() {
        return 2.0;
    }

    @Override
    protected void g(WorldServer level) {
        if (!this.he() && this.e_()) {
            super.g(level);
        }
    }

    @Override
    public boolean gW() {
        return false;
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        this.k(target);
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.75 * (double)this.cS(), (double)this.dq() * 0.5);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? cc : super.e(pose);
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        return EntityLlama.a(this, entity, dimensions.d());
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable {
        public static final /* enum */ Variant a = new Variant(0, "creamy");
        public static final /* enum */ Variant b = new Variant(1, "white");
        public static final /* enum */ Variant c = new Variant(2, "brown");
        public static final /* enum */ Variant d = new Variant(3, "gray");
        public static final Codec<Variant> e;
        private static final IntFunction<Variant> f;
        final int g;
        private final String h;
        private static final /* synthetic */ Variant[] i;

        public static Variant[] values() {
            return (Variant[])i.clone();
        }

        public static Variant valueOf(String name) {
            return Enum.valueOf(Variant.class, name);
        }

        private Variant(int id, String name) {
            this.g = id;
            this.h = name;
        }

        public int a() {
            return this.g;
        }

        public static Variant a(int id) {
            return f.apply(id);
        }

        @Override
        public String c() {
            return this.h;
        }

        private static /* synthetic */ Variant[] b() {
            return new Variant[]{a, b, c, d};
        }

        static {
            i = Variant.b();
            e = INamable.a(Variant::values);
            f = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.c);
        }
    }

    static class c
    extends PathfinderGoalHurtByTarget {
        public c(EntityLlama llama) {
            super(llama, new Class[0]);
        }

        @Override
        public boolean c() {
            EntityInsentient entityInsentient = this.e;
            if (entityInsentient instanceof EntityLlama) {
                EntityLlama llama = (EntityLlama)entityInsentient;
                if (llama.cd) {
                    llama.E(false);
                    return false;
                }
            }
            return super.c();
        }
    }

    static class a
    extends PathfinderGoalNearestAttackableTarget<EntityWolf> {
        public a(EntityLlama llama) {
            super(llama, EntityWolf.class, 16, false, true, (entity, level) -> !((EntityWolf)entity).p());
        }

        @Override
        protected double l() {
            return super.l() * 0.25;
        }
    }

    static class b
    extends EntityAgeable.a {
        public final Variant a;

        b(Variant variant) {
            super(true);
            this.a = variant;
        }
    }
}

