/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.PathfinderGoalHorseTrap;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityHorseSkeleton
extends EntityHorseAbstract {
    private final PathfinderGoalHorseTrap bY = new PathfinderGoalHorseTrap(this);
    private static final int bZ = 18000;
    private static final EntitySize ca = EntityTypes.bf.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.bf.m() - 0.03125f, 0.0f)).a(0.5f);
    private boolean cc;
    public int cd;

    public EntityHorseSkeleton(EntityTypes<? extends EntityHorseSkeleton> entityType, World level) {
        super((EntityTypes<? extends EntityHorseAbstract>)entityType, level);
    }

    public static AttributeProvider.Builder p() {
        return EntityHorseSkeleton.gU().a(GenericAttributes.s, 15.0).a(GenericAttributes.v, 0.2f);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return !EntitySpawnReason.a(spawnReason) ? EntityAnimal.b(entityType, level, spawnReason, pos, random) : EntitySpawnReason.b(spawnReason) || EntityHorseSkeleton.a(level, pos);
    }

    @Override
    protected void a(RandomSource random) {
        this.g(GenericAttributes.o).a(EntityHorseSkeleton.a(random::j));
    }

    @Override
    protected void gK() {
    }

    @Override
    protected SoundEffect u() {
        return ((Entity)this).a(TagsFluid.a) ? SoundEffects.xI : SoundEffects.xE;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.xF;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.xG;
    }

    @Override
    protected SoundEffect aV() {
        if (this.aJ()) {
            if (!this.ca()) {
                return SoundEffects.xL;
            }
            ++this.cy;
            if (this.cy > 5 && this.cy % 3 == 0) {
                return SoundEffects.xJ;
            }
            if (this.cy <= 5) {
                return SoundEffects.xL;
            }
        }
        return SoundEffects.xH;
    }

    @Override
    protected void f(float volume) {
        if (this.aJ()) {
            super.f(0.3f);
        } else {
            super.f(Math.min(0.1f, volume * 25.0f));
        }
    }

    @Override
    protected void ha() {
        if (this.bj()) {
            this.a(SoundEffects.xK, 0.4f, 1.0f);
        } else {
            super.ha();
        }
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? ca : super.e(pose);
    }

    @Override
    public void d_() {
        super.d_();
        if (this.t() && this.cd++ >= 18000) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("SkeletonTrap", this.t());
        compound.a("SkeletonTrapTime", this.cd);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.x(compound.q("SkeletonTrap"));
        this.cd = compound.h("SkeletonTrapTime");
    }

    @Override
    protected float fm() {
        return 0.96f;
    }

    public boolean t() {
        return this.cc;
    }

    public void x(boolean isTrap) {
        if (isTrap != this.cc) {
            this.cc = isTrap;
            if (isTrap) {
                this.bS.a(1, this.bY);
            } else {
                this.bS.a(this.bY);
            }
        }
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable otherParent) {
        return EntityTypes.bf.a(level, EntitySpawnReason.e);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return !this.gJ() ? EnumInteractionResult.e : super.b(player, hand);
    }
}

