/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.event.entity.EntityDeathEvent;

public abstract class EntityHorseChestedAbstract
extends EntityHorseAbstract {
    private static final DataWatcherObject<Boolean> bY = DataWatcher.a(EntityHorseChestedAbstract.class, DataWatcherRegistry.k);
    private final EntitySize bZ;

    protected EntityHorseChestedAbstract(EntityTypes<? extends EntityHorseChestedAbstract> entityType, World level) {
        super((EntityTypes<? extends EntityHorseAbstract>)entityType, level);
        this.cx = false;
        this.bZ = entityType.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, entityType.m() - 0.15625f, 0.0f)).a(0.5f);
    }

    @Override
    protected void a(RandomSource random) {
        this.g(GenericAttributes.s).a(EntityHorseChestedAbstract.a(random::a));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bY, false);
    }

    public static AttributeProvider.Builder p() {
        return EntityHorseChestedAbstract.gU().a(GenericAttributes.v, 0.175f).a(GenericAttributes.o, 0.5);
    }

    public boolean t() {
        return this.al.a(bY);
    }

    public void x(boolean chested) {
        this.al.a(bY, chested);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? this.bZ : super.e(pose);
    }

    @Override
    protected void f(WorldServer level) {
        super.f(level);
        if (this.t()) {
            this.a(level, Blocks.cD);
        }
    }

    @Override
    protected void postDeathDropItems(EntityDeathEvent event) {
        if (this.t() && !event.isCancelled()) {
            this.x(false);
        }
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("ChestedHorse", this.t());
        if (this.t()) {
            NBTTagList listTag = new NBTTagList();
            for (int i2 = 1; i2 < this.ct.b(); ++i2) {
                ItemStack item = this.ct.a(i2);
                if (item.f()) continue;
                NBTTagCompound compoundTag = new NBTTagCompound();
                compoundTag.a("Slot", (byte)(i2 - 1));
                listTag.add(item.b(this.dX(), compoundTag));
            }
            compound.a("Items", listTag);
        }
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.x(compound.q("ChestedHorse"));
        this.gR();
        if (this.t()) {
            NBTTagList list = compound.c("Items", 10);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                NBTTagCompound compound1 = list.a(i2);
                int i1 = compound1.f("Slot") & 0xFF;
                if (i1 >= this.ct.b() - 1) continue;
                this.ct.a(i1 + 1, ItemStack.a((HolderLookup.a)this.dX(), (NBTBase)compound1).orElse(ItemStack.j));
            }
        }
        this.gS();
    }

    @Override
    public SlotAccess a_(int slot) {
        return slot == 499 ? new SlotAccess(){

            @Override
            public ItemStack a() {
                return EntityHorseChestedAbstract.this.t() ? new ItemStack(Items.fb) : ItemStack.j;
            }

            @Override
            public boolean a(ItemStack carried) {
                if (carried.f()) {
                    if (EntityHorseChestedAbstract.this.t()) {
                        EntityHorseChestedAbstract.this.x(false);
                        EntityHorseChestedAbstract.this.gR();
                    }
                    return true;
                }
                if (carried.a(Items.fb)) {
                    if (!EntityHorseChestedAbstract.this.t()) {
                        EntityHorseChestedAbstract.this.x(true);
                        EntityHorseChestedAbstract.this.gR();
                    }
                    return true;
                }
                return false;
            }
        } : super.a_(slot);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean flag;
        boolean bl = flag = !this.e_() && this.gJ() && player.fY();
        if (!this.ca() && !flag) {
            ItemStack itemInHand = player.b(hand);
            if (!itemInHand.f()) {
                if (this.j(itemInHand)) {
                    return this.c(player, itemInHand);
                }
                if (!this.gJ()) {
                    this.gZ();
                    return EnumInteractionResult.a;
                }
                if (!this.t() && itemInHand.a(Items.fb)) {
                    this.d(player, itemInHand);
                    return EnumInteractionResult.a;
                }
            }
            return super.b(player, hand);
        }
        return super.b(player, hand);
    }

    private void d(EntityHuman player, ItemStack chestStack) {
        this.x(true);
        this.x();
        chestStack.a(1, (EntityLiving)player);
        this.gR();
    }

    protected void x() {
        this.a(SoundEffects.hC, 1.0f, (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
    }

    @Override
    public int af_() {
        return this.t() ? 5 : 0;
    }
}

