/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.DoubleSupplier;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryListener;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.ContainerSingleItem;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.inventory.InventoryHolder;

public abstract class EntityHorseAbstract
extends EntityAnimal
implements IInventoryListener,
HasCustomInventoryScreen,
OwnableEntity,
IJumpable,
ISaddleable {
    public static final int cj = 400;
    public static final int ck = 499;
    public static final int cl = 500;
    public static final double cm = 0.15;
    private static final float bY = (float)EntityHorseAbstract.b(() -> 0.0);
    private static final float bZ = (float)EntityHorseAbstract.b(() -> 1.0);
    private static final float ca = (float)EntityHorseAbstract.a(() -> 0.0);
    private static final float cc = (float)EntityHorseAbstract.a(() -> 1.0);
    private static final float cd = EntityHorseAbstract.a((int i2) -> 0);
    private static final float ce = EntityHorseAbstract.a((int i2) -> i2 - 1);
    private static final float cf = 0.25f;
    private static final float cg = 0.5f;
    private static final PathfinderTargetCondition.a ch = (entity, level) -> {
        EntityHorseAbstract abstractHorse;
        return entity instanceof EntityHorseAbstract && (abstractHorse = (EntityHorseAbstract)entity).gO();
    };
    private static final PathfinderTargetCondition ci = PathfinderTargetCondition.b().a(16.0).d().a(ch);
    private static final DataWatcherObject<Byte> cz = DataWatcher.a(EntityHorseAbstract.class, DataWatcherRegistry.a);
    private static final int cC = 2;
    private static final int cD = 4;
    private static final int cE = 8;
    private static final int cF = 16;
    private static final int cG = 32;
    private static final int cH = 64;
    public static final int cn = 0;
    public static final int co = 1;
    public static final int cp = 3;
    private int cI;
    private int cJ;
    private int cK;
    public int cq;
    public int cr;
    protected boolean cs;
    public InventorySubcontainer ct;
    protected int cu;
    protected float cv;
    protected boolean cw;
    private float cL;
    private float cM;
    private float cN;
    private float cO;
    private float cP;
    private float cQ;
    protected boolean cx = true;
    protected int cy;
    @Nullable
    private UUID cR;
    private final IInventory cS = new ContainerSingleItem(){
        public final List<HumanEntity> transaction = new ArrayList<HumanEntity>();
        private int maxStack = 99;

        @Override
        public ItemStack f() {
            return EntityHorseAbstract.this.ak();
        }

        @Override
        public void b(ItemStack item) {
            EntityHorseAbstract.this.h(item);
        }

        @Override
        public void e() {
        }

        @Override
        public boolean a(EntityHuman player) {
            return player.dk() == EntityHorseAbstract.this || player.b((Entity)EntityHorseAbstract.this, 4.0);
        }

        @Override
        public List<ItemStack> getContents() {
            return Arrays.asList(this.f());
        }

        @Override
        public void onOpen(CraftHumanEntity player) {
            this.transaction.add(player);
        }

        @Override
        public void onClose(CraftHumanEntity player) {
            this.transaction.remove(player);
        }

        @Override
        public List<HumanEntity> getViewers() {
            return this.transaction;
        }

        @Override
        public int an_() {
            return this.maxStack;
        }

        @Override
        public void setMaxStackSize(int size) {
            this.maxStack = size;
        }

        @Override
        public InventoryHolder getOwner() {
            return (AbstractHorse)EntityHorseAbstract.this.getBukkitEntity();
        }

        @Override
        public Location getLocation() {
            return EntityHorseAbstract.this.getBukkitEntity().getLocation();
        }
    };
    public int maxDomestication = 100;

    protected EntityHorseAbstract(EntityTypes<? extends EntityHorseAbstract> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        this.gR();
    }

    @Override
    protected void E() {
        this.bS.a(1, new PathfinderGoalPanic(this, 1.2));
        this.bS.a(1, new PathfinderGoalTame(this, 1.2));
        this.bS.a(2, new PathfinderGoalBreed(this, 1.0, EntityHorseAbstract.class));
        this.bS.a(4, new PathfinderGoalFollowParent(this, 1.0));
        this.bS.a(6, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.bS.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bS.a(8, new PathfinderGoalRandomLookaround(this));
        if (this.gt()) {
            this.bS.a(9, new RandomStandGoal(this));
        }
        this.gK();
    }

    protected void gK() {
        this.bS.a(0, new PathfinderGoalFloat(this));
        this.bS.a(3, new PathfinderGoalTempt(this, 1.25, stack -> stack.a(TagsItem.aj), false));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cz, (byte)0);
    }

    protected boolean s(int flagId) {
        return (this.al.a(cz) & flagId) != 0;
    }

    protected void d(int flagId, boolean value) {
        byte b2 = this.al.a(cz);
        if (value) {
            this.al.a(cz, (byte)(b2 | flagId));
        } else {
            this.al.a(cz, (byte)(b2 & ~flagId));
        }
    }

    public boolean gJ() {
        return this.s(2);
    }

    @Override
    @Nullable
    public UUID aa_() {
        return this.cR;
    }

    public void b(@Nullable UUID uuid) {
        this.cR = uuid;
    }

    public boolean gL() {
        return this.cs;
    }

    public void y(boolean tamed) {
        this.d(2, tamed);
    }

    public void z(boolean jumping) {
        this.cs = jumping;
    }

    @Override
    public boolean a(Entity leashHolder, float distance) {
        if (distance > 6.0f && this.gM()) {
            this.B(false);
        }
        return true;
    }

    public boolean gM() {
        return this.s(16);
    }

    public boolean gN() {
        return this.s(32);
    }

    public boolean gO() {
        return this.s(8);
    }

    public void A(boolean breeding) {
        this.d(8, breeding);
    }

    @Override
    public boolean f() {
        return this.bL() && !this.e_() && this.gJ();
    }

    @Override
    public void a(ItemStack stack, @Nullable SoundCategory soundSource) {
        this.ct.a(0, stack);
    }

    public void b(EntityHuman player, ItemStack stack) {
        if (this.a(stack, EnumItemSlot.g)) {
            this.h(stack.b(1, (EntityLiving)player));
        }
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return slot == EnumItemSlot.g && this.gJ() || super.f(slot);
    }

    @Override
    public boolean j() {
        return this.s(4);
    }

    public int gP() {
        return this.cu;
    }

    public void t(int temper) {
        this.cu = temper;
    }

    public int u(int addedTemper) {
        int i2 = MathHelper.a(this.gP() + addedTemper, 0, this.gV());
        this.t(i2);
        return i2;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return !this.ca();
    }

    private void p() {
        SoundEffect eatingSound;
        this.x();
        if (!this.bb() && (eatingSound = this.gu()) != null) {
            this.dV().a(null, this.dA(), this.dC(), this.dG(), eatingSound, this.dm(), 1.0f, 1.0f + (this.ae.i() - this.ae.i()) * 0.2f);
        }
    }

    @Override
    public boolean a(float fallDistance, float multiplier, DamageSource source) {
        int i2;
        if (fallDistance > 1.0f) {
            this.a(SoundEffects.nn, 0.4f, 1.0f);
        }
        if ((i2 = this.f(fallDistance, multiplier)) <= 0) {
            return false;
        }
        this.a(source, (float)i2);
        if (this.ca()) {
            for (Entity entity : this.dc()) {
                entity.a(source, (float)i2);
            }
        }
        this.eO();
        return true;
    }

    public final int gQ() {
        return EntityHorseAbstract.v(this.af_());
    }

    public static int v(int columns) {
        return columns * 3 + 1;
    }

    public void gR() {
        InventorySubcontainer simpleContainer = this.ct;
        this.ct = new InventorySubcontainer(this.gQ(), (InventoryHolder)((AbstractHorse)this.getBukkitEntity()));
        if (simpleContainer != null) {
            simpleContainer.b(this);
            int min = Math.min(simpleContainer.b(), this.ct.b());
            for (int i2 = 0; i2 < min; ++i2) {
                ItemStack item = simpleContainer.a(i2);
                if (item.f()) continue;
                this.ct.a(i2, item.v());
            }
        }
        this.ct.a(this);
        this.gS();
    }

    protected void gS() {
        if (!this.dV().C) {
            this.d(4, !this.ct.a(0).f());
        }
    }

    @Override
    public void a(IInventory invBasic) {
        boolean isSaddled = this.j();
        this.gS();
        if (this.af > 20 && !isSaddled && this.j()) {
            this.a(this.ab_(), 0.5f, 1.0f);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        boolean flag = super.a(level, damageSource, amount);
        if (flag && this.ae.a(3) == 0) {
            this.gY();
        }
        return flag;
    }

    protected boolean gt() {
        return true;
    }

    @Nullable
    protected SoundEffect gu() {
        return null;
    }

    @Nullable
    protected SoundEffect gT() {
        return null;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        if (!block.n()) {
            IBlockData blockState = this.dV().a_(pos.d());
            SoundEffectType soundType = block.A();
            if (blockState.a(Blocks.ea)) {
                soundType = blockState.A();
            }
            if (this.ca() && this.cx) {
                ++this.cy;
                if (this.cy > 5 && this.cy % 3 == 0) {
                    this.a(soundType);
                } else if (this.cy <= 5) {
                    this.a(SoundEffects.nq, soundType.a() * 0.15f, soundType.b());
                }
            } else if (this.b(soundType)) {
                this.a(SoundEffects.nq, soundType.a() * 0.15f, soundType.b());
            } else {
                this.a(SoundEffects.np, soundType.a() * 0.15f, soundType.b());
            }
        }
    }

    private boolean b(SoundEffectType soundType) {
        return soundType == SoundEffectType.b || soundType == SoundEffectType.aT || soundType == SoundEffectType.B || soundType == SoundEffectType.aU || soundType == SoundEffectType.aS;
    }

    protected void a(SoundEffectType soundType) {
        this.a(SoundEffects.nk, soundType.a() * 0.15f, soundType.b());
    }

    public static AttributeProvider.Builder gU() {
        return EntityAnimal.gx().a(GenericAttributes.o, 0.7).a(GenericAttributes.s, 53.0).a(GenericAttributes.v, 0.225f).a(GenericAttributes.B, 1.0).a(GenericAttributes.x, 6.0).a(GenericAttributes.k, 0.5);
    }

    @Override
    public int aj() {
        return 6;
    }

    public int gV() {
        return this.maxDomestication;
    }

    @Override
    public float fg() {
        return 0.8f;
    }

    @Override
    public int T() {
        return 400;
    }

    @Override
    public void b(EntityHuman player) {
        if (!this.dV().C && (!this.ca() || this.y(player)) && this.gJ()) {
            player.a(this, this.ct);
        }
    }

    public EnumInteractionResult c(EntityHuman player, ItemStack stack) {
        boolean flag = this.a(player, stack);
        if (flag) {
            stack.a(1, (EntityLiving)player);
        }
        return (EnumInteractionResult)((Object)(!flag && !this.dV().C ? EnumInteractionResult.e : EnumInteractionResult.b));
    }

    protected boolean a(EntityHuman player, ItemStack stack) {
        boolean flag = false;
        float f2 = 0.0f;
        int i2 = 0;
        int i1 = 0;
        if (stack.a(Items.qb)) {
            f2 = 2.0f;
            i2 = 20;
            i1 = 3;
        } else if (stack.a(Items.sx)) {
            f2 = 1.0f;
            i2 = 30;
            i1 = 3;
        } else if (stack.a(Blocks.iH.j())) {
            f2 = 20.0f;
            i2 = 180;
        } else if (stack.a(Items.oZ)) {
            f2 = 3.0f;
            i2 = 60;
            i1 = 3;
        } else if (stack.a(Items.vj)) {
            f2 = 4.0f;
            i2 = 60;
            i1 = 5;
            if (!this.dV().C && this.gJ() && this.Y_() == 0 && !this.gC()) {
                flag = true;
                this.setInLove(player, stack.v());
            }
        } else if (stack.a(Items.qF) || stack.a(Items.qG)) {
            f2 = 10.0f;
            i2 = 240;
            i1 = 10;
            if (!this.dV().C && this.gJ() && this.Y_() == 0 && !this.gC()) {
                flag = true;
                this.setInLove(player, stack.v());
            }
        }
        if (this.eD() < this.eS() && f2 > 0.0f) {
            this.heal(f2, EntityRegainHealthEvent.RegainReason.EATING);
            flag = true;
        }
        if (this.e_() && i2 > 0) {
            this.dV().a(Particles.P, this.d(1.0), this.dD() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
            if (!this.dV().C) {
                this.b_(i2);
                flag = true;
            }
        }
        if (!(i1 <= 0 || !flag && this.gJ() || this.gP() >= this.gV() || this.dV().C)) {
            this.u(i1);
            flag = true;
        }
        if (flag) {
            this.p();
            ((Entity)this).a(GameEvent.m);
        }
        return flag;
    }

    protected void a(EntityHuman player) {
        this.B(false);
        this.C(false);
        if (!this.dV().C) {
            player.v(this.dL());
            player.w(this.dN());
            player.n(this);
        }
    }

    @Override
    public boolean fi() {
        return super.fi() && this.ca() && this.j() || this.gM() || this.gN();
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.ai);
    }

    private void t() {
        this.cq = 1;
    }

    @Override
    protected void f(WorldServer level) {
        super.f(level);
        if (this.ct != null) {
            for (int i2 = 0; i2 < this.ct.b(); ++i2) {
                ItemStack item = this.ct.a(i2);
                if (item.f() || EnchantmentManager.a(item, EnchantmentEffectComponents.D)) continue;
                this.a(level, item);
            }
        }
    }

    @Override
    public void d_() {
        if (this.ae.a(200) == 0) {
            this.t();
        }
        super.d_();
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.bL()) {
                if (this.ae.a(900) == 0 && this.aP == 0) {
                    this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
                }
                if (this.gW()) {
                    if (!this.gM() && !this.ca() && this.ae.a(300) == 0 && serverLevel.a_(this.dv().e()).a(Blocks.i)) {
                        this.B(true);
                    }
                    if (this.gM() && ++this.cI > 50) {
                        this.cI = 0;
                        this.B(false);
                    }
                }
                this.g(serverLevel);
            }
        }
    }

    protected void g(WorldServer level) {
        EntityHorseAbstract nearestEntity;
        if (this.gO() && this.e_() && !this.gM() && (nearestEntity = level.a(EntityHorseAbstract.class, ci, this, this.dA(), this.dC(), this.dG(), this.cR().g(16.0))) != null && this.g((Entity)nearestEntity) > 4.0) {
            this.bR.a((Entity)nearestEntity, 0);
        }
    }

    public boolean gW() {
        return true;
    }

    @Override
    public void h() {
        super.h();
        if (this.cJ > 0 && ++this.cJ > 30) {
            this.cJ = 0;
            this.d(64, false);
        }
        if (this.dj() && this.cK > 0 && ++this.cK > 20) {
            this.cK = 0;
            this.C(false);
        }
        if (this.cq > 0 && ++this.cq > 8) {
            this.cq = 0;
        }
        if (this.cr > 0) {
            ++this.cr;
            if (this.cr > 300) {
                this.cr = 0;
            }
        }
        this.cM = this.cL;
        if (this.gM()) {
            this.cL += (1.0f - this.cL) * 0.4f + 0.05f;
            if (this.cL > 1.0f) {
                this.cL = 1.0f;
            }
        } else {
            this.cL += (0.0f - this.cL) * 0.4f - 0.05f;
            if (this.cL < 0.0f) {
                this.cL = 0.0f;
            }
        }
        this.cO = this.cN;
        if (this.gN()) {
            this.cM = this.cL = 0.0f;
            this.cN += (1.0f - this.cN) * 0.4f + 0.05f;
            if (this.cN > 1.0f) {
                this.cN = 1.0f;
            }
        } else {
            this.cw = false;
            this.cN += (0.8f * this.cN * this.cN * this.cN - this.cN) * 0.6f - 0.05f;
            if (this.cN < 0.0f) {
                this.cN = 0.0f;
            }
        }
        this.cQ = this.cP;
        if (this.s(64)) {
            this.cP += (1.0f - this.cP) * 0.7f + 0.05f;
            if (this.cP > 1.0f) {
                this.cP = 1.0f;
            }
        } else {
            this.cP += (0.0f - this.cP) * 0.7f - 0.05f;
            if (this.cP < 0.0f) {
                this.cP = 0.0f;
            }
        }
    }

    public void setMouthOpen(boolean open) {
        this.d(64, open);
    }

    public boolean isMouthOpen() {
        return this.s(64);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        if (this.ca() || this.e_()) {
            return super.b(player, hand);
        }
        if (this.gJ() && player.fY()) {
            this.b(player);
            return EnumInteractionResult.a;
        }
        ItemStack itemInHand = player.b(hand);
        if (!itemInHand.f()) {
            EnumInteractionResult interactionResult = itemInHand.a(player, (EntityLiving)this, hand);
            if (interactionResult.a()) {
                return interactionResult;
            }
            if (this.a(itemInHand, EnumItemSlot.g) && !this.fX()) {
                this.b(player, itemInHand);
                return EnumInteractionResult.a;
            }
        }
        this.a(player);
        return EnumInteractionResult.a;
    }

    private void x() {
        if (!this.dV().C) {
            this.cJ = 1;
            this.d(64, true);
        }
    }

    public void B(boolean eating) {
        this.d(16, eating);
    }

    public void setForceStanding(boolean standing) {
        this.d(32, standing);
    }

    public void C(boolean standing) {
        if (standing) {
            this.B(false);
        }
        this.d(32, standing);
    }

    @Nullable
    public SoundEffect gX() {
        return this.u();
    }

    public void gY() {
        if (this.gt() && this.dj()) {
            this.cK = 1;
            this.C(true);
        }
    }

    public void gZ() {
        if (!this.gN()) {
            this.gY();
            this.b(this.gT());
        }
    }

    public boolean g(EntityHuman player) {
        this.b(player.cG());
        this.y(true);
        if (player instanceof EntityPlayer) {
            CriterionTriggers.y.a((EntityPlayer)player, this);
        }
        this.dV().a((Entity)this, (byte)7);
        return true;
    }

    @Override
    protected void a(EntityHuman player, Vec3D travelVector) {
        super.a(player, travelVector);
        Vec2F riddenRotation = this.j(player);
        this.b(riddenRotation.j, riddenRotation.i);
        this.aX = this.aZ = this.dL();
        this.N = this.aZ;
        if (this.dh()) {
            if (travelVector.f <= 0.0) {
                this.cy = 0;
            }
            if (this.aJ()) {
                this.z(false);
                if (this.cv > 0.0f && !this.gL()) {
                    this.b(this.cv, travelVector);
                }
                this.cv = 0.0f;
            }
        }
    }

    protected Vec2F j(EntityLiving entity) {
        return new Vec2F(entity.dN() * 0.5f, entity.dL());
    }

    @Override
    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        if (this.aJ() && this.cv == 0.0f && this.gN() && !this.cw) {
            return Vec3D.c;
        }
        float f2 = player.bn * 0.5f;
        float f1 = player.bp;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3D(f2, 0.0, f1);
    }

    @Override
    protected float e(EntityHuman player) {
        return (float)this.h(GenericAttributes.v);
    }

    protected void b(float playerJumpPendingScale, Vec3D travelVector) {
        double d2 = this.A(playerJumpPendingScale);
        Vec3D deltaMovement = this.dy();
        this.n(deltaMovement.d, d2, deltaMovement.f);
        this.z(true);
        this.ar = true;
        if (travelVector.f > 0.0) {
            float sin = MathHelper.a(this.dL() * ((float)Math.PI / 180));
            float cos = MathHelper.b(this.dL() * ((float)Math.PI / 180));
            this.i(this.dy().b(-0.4f * sin * playerJumpPendingScale, 0.0, 0.4f * cos * playerJumpPendingScale));
        }
    }

    protected void ha() {
        this.a(SoundEffects.nm, 0.4f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("EatingHaystack", this.gM());
        compound.a("Bred", this.gO());
        compound.a("Temper", this.gP());
        compound.a("Tame", this.gJ());
        if (this.aa_() != null) {
            compound.a("Owner", this.aa_());
        }
        compound.a("Bukkit.MaxDomestication", this.maxDomestication);
        if (!this.ct.a(0).f()) {
            compound.a("SaddleItem", this.ct.a(0).a(this.dX()));
        }
    }

    @Override
    public void a(NBTTagCompound compound) {
        ItemStack itemStack;
        UUID uuid;
        super.a(compound);
        this.B(compound.q("EatingHaystack"));
        this.A(compound.q("Bred"));
        this.t(compound.h("Temper"));
        this.y(compound.q("Tame"));
        if (compound.b("Owner")) {
            uuid = compound.a("Owner");
        } else {
            String string = compound.l("Owner");
            uuid = NameReferencingFileConverter.a(this.cV(), string);
        }
        if (uuid != null) {
            this.b(uuid);
        }
        if (compound.e("Bukkit.MaxDomestication")) {
            this.maxDomestication = compound.h("Bukkit.MaxDomestication");
        }
        if (compound.b("SaddleItem", 10) && (itemStack = ItemStack.a((HolderLookup.a)this.dX(), (NBTBase)compound.p("SaddleItem")).orElse(ItemStack.j)).a(Items.on)) {
            this.ct.a(0, itemStack);
        }
        this.gS();
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        return false;
    }

    protected boolean hb() {
        return !this.ca() && !this.bZ() && this.gJ() && !this.e_() && this.eD() >= this.eS() && this.gC();
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable otherParent) {
        return null;
    }

    protected void a(EntityAgeable parent, EntityHorseAbstract child) {
        this.a(parent, child, GenericAttributes.s, (double)cd, (double)ce);
        this.a(parent, child, GenericAttributes.o, (double)ca, (double)cc);
        this.a(parent, child, GenericAttributes.v, (double)bY, (double)bZ);
    }

    private void a(EntityAgeable parent, EntityHorseAbstract child, Holder<AttributeBase> attribute, double min, double max) {
        double d2 = EntityHorseAbstract.a(this.i(attribute), parent.i(attribute), min, max, this.ae);
        child.g(attribute).a(d2);
    }

    static double a(double value1, double value2, double min, double max, RandomSource random) {
        double d3;
        if (max <= min) {
            throw new IllegalArgumentException("Incorrect range for an attribute");
        }
        value1 = MathHelper.a(value1, min, max);
        value2 = MathHelper.a(value2, min, max);
        double d2 = 0.15 * (max - min);
        double d22 = (value1 + value2) / 2.0;
        double d1 = Math.abs(value1 - value2) + d2 * 2.0;
        double d4 = d22 + d1 * (d3 = (random.j() + random.j() + random.j()) / 3.0 - 0.5);
        if (d4 > max) {
            double d5 = d4 - max;
            return max - d5;
        }
        if (d4 < min) {
            double d5 = min - d4;
            return min + d5;
        }
        return d4;
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.cM, this.cL);
    }

    public float K(float partialTick) {
        return MathHelper.h(partialTick, this.cO, this.cN);
    }

    public float L(float partialTick) {
        return MathHelper.h(partialTick, this.cQ, this.cP);
    }

    @Override
    public void b(int jumpPower) {
        if (this.j()) {
            if (jumpPower < 0) {
                jumpPower = 0;
            } else {
                this.cw = true;
                this.gY();
            }
            this.cv = jumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPower / 90.0f;
        }
    }

    @Override
    public boolean a() {
        return this.j();
    }

    @Override
    public void c(int jumpPower) {
        float power = jumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPower / 90.0f;
        if (!CraftEventFactory.callHorseJumpEvent(this, power)) {
            return;
        }
        this.cw = true;
        this.gY();
        this.ha();
    }

    @Override
    public void b() {
    }

    protected void D(boolean tamed) {
        ParticleType particleOptions = tamed ? Particles.R : Particles.ag;
        for (int i2 = 0; i2 < 7; ++i2) {
            double d2 = this.ae.k() * 0.02;
            double d1 = this.ae.k() * 0.02;
            double d22 = this.ae.k() * 0.02;
            this.dV().a(particleOptions, this.d(1.0), this.dD() + 0.5, this.g(1.0), d2, d1, d22);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 7) {
            this.D(true);
        } else if (id == 6) {
            this.D(false);
        } else {
            super.b(id);
        }
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction callback) {
        super.a(passenger, callback);
        if (passenger instanceof EntityLiving) {
            ((EntityLiving)passenger).aX = this.aX;
        }
    }

    protected static float a(IntUnaryOperator operator) {
        return 15.0f + (float)operator.applyAsInt(8) + (float)operator.applyAsInt(9);
    }

    protected static double a(DoubleSupplier supplier) {
        return (double)0.4f + supplier.getAsDouble() * 0.2 + supplier.getAsDouble() * 0.2 + supplier.getAsDouble() * 0.2;
    }

    protected static double b(DoubleSupplier supplier) {
        return ((double)0.45f + supplier.getAsDouble() * 0.3 + supplier.getAsDouble() * 0.3 + supplier.getAsDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean q_() {
        return false;
    }

    @Override
    public SlotAccess a_(int slot) {
        int i2 = slot - 400;
        if (i2 == 0) {
            return new SlotAccess(){

                @Override
                public ItemStack a() {
                    return EntityHorseAbstract.this.ct.a(0);
                }

                @Override
                public boolean a(ItemStack carried) {
                    if (!carried.f() && !carried.a(Items.on)) {
                        return false;
                    }
                    EntityHorseAbstract.this.ct.a(0, carried);
                    EntityHorseAbstract.this.gS();
                    return true;
                }
            };
        }
        int i1 = slot - 500 + 1;
        return i1 >= 1 && i1 < this.ct.b() ? SlotAccess.a(this.ct, i1) : super.a_(slot);
    }

    @Override
    @Nullable
    public EntityLiving cW() {
        Entity var2;
        if (this.j() && (var2 = this.cZ()) instanceof EntityHuman) {
            return (EntityHuman)var2;
        }
        return super.cW();
    }

    @Nullable
    private Vec3D a(Vec3D direction, EntityLiving passenger) {
        double d2 = this.dA() + direction.d;
        double d1 = this.cR().b;
        double d22 = this.dG() + direction.f;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        block0: for (EntityPose pose : passenger.fO()) {
            mutableBlockPos.b(d2, d1, d22);
            double d3 = this.cR().e + 0.75;
            do {
                double blockFloorHeight = this.dV().j(mutableBlockPos);
                if ((double)mutableBlockPos.v() + blockFloorHeight > d3) continue block0;
                if (DismountUtil.a(blockFloorHeight)) {
                    AxisAlignedBB localBoundsForPose = passenger.f(pose);
                    Vec3D vec3 = new Vec3D(d2, (double)mutableBlockPos.v() + blockFloorHeight, d22);
                    if (DismountUtil.a(this.dV(), passenger, localBoundsForPose.c(vec3))) {
                        passenger.b(pose);
                        return vec3;
                    }
                }
                mutableBlockPos.c(EnumDirection.b);
            } while (!((double)mutableBlockPos.v() < d3));
        }
        return null;
    }

    @Override
    public Vec3D b(EntityLiving livingEntity) {
        Vec3D collisionHorizontalEscapeVector = EntityHorseAbstract.a(this.dq(), (double)livingEntity.dq(), this.dL() + (livingEntity.fy() == EnumMainHand.b ? 90.0f : -90.0f));
        Vec3D dismountLocationInDirection = this.a(collisionHorizontalEscapeVector, livingEntity);
        if (dismountLocationInDirection != null) {
            return dismountLocationInDirection;
        }
        Vec3D collisionHorizontalEscapeVector1 = EntityHorseAbstract.a(this.dq(), (double)livingEntity.dq(), this.dL() + (livingEntity.fy() == EnumMainHand.a ? 90.0f : -90.0f));
        Vec3D dismountLocationInDirection1 = this.a(collisionHorizontalEscapeVector1, livingEntity);
        return dismountLocationInDirection1 != null ? dismountLocationInDirection1 : this.dt();
    }

    protected void a(RandomSource random) {
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (spawnGroupData == null) {
            spawnGroupData = new EntityAgeable.a(0.2f);
        }
        this.a(level.H_());
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public boolean b(IInventory inventory) {
        return this.ct != inventory;
    }

    public int hc() {
        return this.T();
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        return super.a(entity, dimensions, partialTick).e(new Vec3D(0.0, 0.15 * (double)this.cO * (double)partialTick, -0.7 * (double)this.cO * (double)partialTick).b(-this.dL() * ((float)Math.PI / 180)));
    }

    public final IInventory hd() {
        return this.cS;
    }

    public int af_() {
        return 0;
    }
}

