/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseDonkey;
import net.minecraft.world.entity.animal.horse.EntityHorseMule;
import net.minecraft.world.entity.animal.horse.HorseColor;
import net.minecraft.world.entity.animal.horse.HorseStyle;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.SoundEffectType;

public class EntityHorse
extends EntityHorseAbstract
implements VariantHolder<HorseColor> {
    private static final DataWatcherObject<Integer> bY = DataWatcher.a(EntityHorse.class, DataWatcherRegistry.b);
    private static final EntitySize bZ = EntityTypes.al.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.al.m() + 0.125f, 0.0f)).a(0.5f);

    public EntityHorse(EntityTypes<? extends EntityHorse> entityType, World level) {
        super((EntityTypes<? extends EntityHorseAbstract>)entityType, level);
    }

    @Override
    protected void a(RandomSource random) {
        this.g(GenericAttributes.s).a(EntityHorse.a(random::a));
        this.g(GenericAttributes.v).a(EntityHorse.b(random::j));
        this.g(GenericAttributes.o).a(EntityHorse.a(random::j));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bY, 0);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("Variant", this.x());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.w(compound.h("Variant"));
    }

    private void w(int typeVariant) {
        this.al.a(bY, typeVariant);
    }

    private int x() {
        return this.al.a(bY);
    }

    public void a(HorseColor variant, HorseStyle marking) {
        this.w(variant.a() & 0xFF | marking.a() << 8 & 0xFF00);
    }

    public HorseColor p() {
        return HorseColor.a(this.x() & 0xFF);
    }

    @Override
    public void a(HorseColor variant) {
        this.w(variant.a() & 0xFF | this.x() & 0xFFFFFF00);
    }

    public HorseStyle t() {
        return HorseStyle.a((this.x() & 0xFF00) >> 8);
    }

    @Override
    protected void a(SoundEffectType soundType) {
        super.a(soundType);
        if (this.ae.a(10) == 0) {
            this.a(SoundEffects.nh, soundType.a() * 0.6f, soundType.b());
        }
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.ne;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.ni;
    }

    @Override
    @Nullable
    protected SoundEffect gu() {
        return SoundEffects.nj;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.nl;
    }

    @Override
    protected SoundEffect gT() {
        return SoundEffects.nf;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean flag;
        boolean bl = flag = !this.e_() && this.gJ() && player.fY();
        if (!this.ca() && !flag) {
            ItemStack itemInHand = player.b(hand);
            if (!itemInHand.f()) {
                if (this.j(itemInHand)) {
                    return this.c(player, itemInHand);
                }
                if (!this.gJ()) {
                    this.gZ();
                    return EnumInteractionResult.a;
                }
            }
            return super.b(player, hand);
        }
        return super.b(player, hand);
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        return otherAnimal != this && (otherAnimal instanceof EntityHorseDonkey || otherAnimal instanceof EntityHorse) && this.hb() && ((EntityHorseAbstract)otherAnimal).hb();
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable otherParent) {
        if (otherParent instanceof EntityHorseDonkey) {
            EntityHorseMule mule = EntityTypes.aF.a(level, EntitySpawnReason.e);
            if (mule != null) {
                this.a(otherParent, mule);
            }
            return mule;
        }
        EntityHorse horse = (EntityHorse)otherParent;
        EntityHorse horse1 = EntityTypes.al.a(level, EntitySpawnReason.e);
        if (horse1 != null) {
            int randomInt = this.ae.a(9);
            HorseColor variant = randomInt < 4 ? this.p() : (randomInt < 8 ? horse.p() : SystemUtils.a(HorseColor.values(), this.ae));
            int randomInt1 = this.ae.a(5);
            HorseStyle markings = randomInt1 < 2 ? this.t() : (randomInt1 < 4 ? horse.t() : SystemUtils.a(HorseStyle.values(), this.ae));
            horse1.a(variant, markings);
            this.a(otherParent, horse1);
        }
        return horse1;
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return true;
    }

    @Override
    protected void c(DamageSource damageSource, float damageAmount) {
        this.a(damageSource, damageAmount, EnumItemSlot.g);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        HorseColor variant;
        RandomSource random = level.H_();
        if (spawnGroupData instanceof a) {
            variant = ((a)spawnGroupData).a;
        } else {
            variant = SystemUtils.a(HorseColor.values(), random);
            spawnGroupData = new a(variant);
        }
        this.a(variant, SystemUtils.a(HorseStyle.values(), random));
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? bZ : super.e(pose);
    }

    public static class a
    extends EntityAgeable.a {
        public final HorseColor a;

        public a(HorseColor variant) {
            super(true);
            this.a = variant;
        }
    }
}

