/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.goat;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.InstrumentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.goat.GoatAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class Goat
extends EntityAnimal {
    public static final EntitySize bY = EntitySize.b(0.9f, 1.3f).a(0.7f);
    private static final int cf = 2;
    private static final int cg = 1;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Goat>>> bZ = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.o, SensorType.f, SensorType.r);
    protected static final ImmutableList<MemoryModuleType<?>> ca = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.h, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.av, MemoryModuleType.r, MemoryModuleType.S, MemoryModuleType.T, MemoryModuleType.O, MemoryModuleType.K, MemoryModuleType.P, (Object[])new MemoryModuleType[]{MemoryModuleType.R, MemoryModuleType.V, MemoryModuleType.W, MemoryModuleType.Z});
    public static final int cc = 10;
    public static final double cd = 0.02;
    public static final double ce = (double)0.1f;
    private static final DataWatcherObject<Boolean> ch = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> ci = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> cj = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    private boolean ck;
    private int cl;

    public Goat(EntityTypes<? extends Goat> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        this.P().a(true);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    public ItemStack p() {
        RandomSource randomSource = RandomSource.a(this.cG().hashCode());
        TagKey<Instrument> tagKey = this.gE() ? InstrumentTags.b : InstrumentTags.a;
        return this.dV().K_().e(Registries.I).a(tagKey, randomSource).map(holder -> InstrumentItem.a(Items.xi, holder)).orElseGet(() -> new ItemStack(Items.xi));
    }

    protected BehaviorController.b<Goat> ec() {
        return BehaviorController.a(ca, bZ);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return GoatAi.a(this.ec().a(dynamic));
    }

    public static AttributeProvider.Builder t() {
        return EntityAnimal.gx().a(GenericAttributes.s, 10.0).a(GenericAttributes.v, 0.2f).a(GenericAttributes.c, 2.0);
    }

    @Override
    protected void i() {
        if (this.e_()) {
            this.g(GenericAttributes.c).a(1.0);
            this.gw();
        } else {
            this.g(GenericAttributes.c).a(2.0);
            this.gv();
        }
    }

    @Override
    protected int f(float fallDistance, float damageMultiplier) {
        return super.f(fallDistance, damageMultiplier) - 10;
    }

    @Override
    protected SoundEffect u() {
        return this.gE() ? SoundEffects.lt : SoundEffects.lk;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return this.gE() ? SoundEffects.lw : SoundEffects.ln;
    }

    @Override
    public SoundEffect o_() {
        return this.gE() ? SoundEffects.lu : SoundEffects.ll;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.lB, 0.15f, 1.0f);
    }

    protected SoundEffect x() {
        return this.gE() ? SoundEffects.ly : SoundEffects.lp;
    }

    @Nullable
    public Goat b(WorldServer level, EntityAgeable otherParent) {
        Goat goat = EntityTypes.ah.a(level, EntitySpawnReason.e);
        if (goat != null) {
            EntityAgeable goat1;
            GoatAi.a(goat, level.H_());
            EntityAgeable ageableMob = level.H_().h() ? this : otherParent;
            boolean flag = ageableMob instanceof Goat && ((Goat)(goat1 = ageableMob)).gE() || level.H_().j() < 0.02;
            goat.x(flag);
        }
        return goat;
    }

    public BehaviorController<Goat> eb() {
        return super.eb();
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("goatBrain");
        this.eb().a(level, this);
        profilerFiller.c();
        profilerFiller.a("goatActivityUpdate");
        GoatAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    @Override
    public int af() {
        return 15;
    }

    @Override
    public void q(float yHeadRot) {
        int maxHeadYRot = this.af();
        float f2 = MathHelper.c(this.aX, yHeadRot);
        float f1 = MathHelper.a(f2, (float)(-maxHeadYRot), (float)maxHeadYRot);
        super.q(this.aX + f1);
    }

    @Override
    protected void gy() {
        this.dV().a(null, this, this.gE() ? SoundEffects.lv : SoundEffects.lm, SoundCategory.g, 1.0f, MathHelper.b(this.dV().A, 0.8f, 1.2f));
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.ae);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.rf) && !this.e_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((WorldServer)player.dV(), player, this.dv(), this.dv(), null, itemInHand, Items.rl, hand);
            if (event.isCancelled()) {
                player.cd.b();
                return EnumInteractionResult.e;
            }
            player.a(this.x(), 1.0f, 1.0f);
            ItemStack itemStack = ItemLiquidUtil.a(itemInHand, player, CraftItemStack.asNMSCopy(event.getItemStack()));
            player.a(hand, itemStack);
            return EnumInteractionResult.a;
        }
        boolean isFood = this.j(itemInHand);
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (interactionResult.a() && isFood) {
            this.gy();
        }
        return interactionResult;
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.H_();
        GoatAi.a(this, random);
        this.x(random.j() < 0.02);
        this.i();
        if (!this.e_() && random.i() < 0.1f) {
            DataWatcherObject<Boolean> entityDataAccessor = random.h() ? ci : cj;
            this.al.a(entityDataAccessor, false);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    protected void ac() {
        super.ac();
        PacketDebug.a(this);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return pose == EntityPose.g ? bY.a(this.ei()) : super.e(pose);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("IsScreamingGoat", this.gE());
        compound.a("HasLeftHorn", this.gs());
        compound.a("HasRightHorn", this.gt());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.x(compound.q("IsScreamingGoat"));
        this.al.a(ci, compound.q("HasLeftHorn"));
        this.al.a(cj, compound.q("HasRightHorn"));
    }

    @Override
    public void b(byte id) {
        if (id == 58) {
            this.ck = true;
        } else if (id == 59) {
            this.ck = false;
        } else {
            super.b(id);
        }
    }

    @Override
    public void d_() {
        this.cl = this.ck ? ++this.cl : (this.cl -= 2);
        this.cl = MathHelper.a(this.cl, 0, 20);
        super.d_();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ch, false);
        builder.a(ci, true);
        builder.a(cj, true);
    }

    public boolean gs() {
        return this.al.a(ci);
    }

    public boolean gt() {
        return this.al.a(cj);
    }

    public boolean gu() {
        boolean hasLeftHorn = this.gs();
        boolean hasRightHorn = this.gt();
        if (!hasLeftHorn && !hasRightHorn) {
            return false;
        }
        DataWatcherObject<Boolean> entityDataAccessor = !hasLeftHorn ? cj : (!hasRightHorn ? ci : (this.ae.h() ? ci : cj));
        this.al.a(entityDataAccessor, false);
        Vec3D vec3 = this.dt();
        ItemStack itemStack = this.p();
        double d2 = MathHelper.b(this.ae, -0.2f, 0.2f);
        double d1 = MathHelper.b(this.ae, 0.3f, 0.7f);
        double d22 = MathHelper.b(this.ae, -0.2f, 0.2f);
        EntityItem itemEntity = new EntityItem(this.dV(), vec3.a(), vec3.b(), vec3.c(), itemStack, d2, d1, d22);
        return this.spawnAtLocation((WorldServer)this.dV(), itemEntity) != null;
    }

    public void gv() {
        this.al.a(ci, true);
        this.al.a(cj, true);
    }

    public void gw() {
        this.al.a(ci, false);
        this.al.a(cj, false);
    }

    public boolean gE() {
        return this.al.a(ch);
    }

    public void x(boolean isScreamingGoat) {
        this.al.a(ch, isScreamingGoat);
    }

    public float gF() {
        return (float)this.cl / 20.0f * 30.0f * ((float)Math.PI / 180);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cb) && Goat.a(level, pos);
    }

    public void ram(EntityLiving entity) {
        BehaviorController<Goat> brain = this.eb();
        brain.a(MemoryModuleType.W, entity.dt());
        brain.b(MemoryModuleType.V);
        brain.b(MemoryModuleType.r);
        brain.b(MemoryModuleType.O);
        brain.a(Activity.r);
    }
}

