/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.frog;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.frog.FrogAi;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;

public class Frog
extends EntityAnimal
implements VariantHolder<Holder<FrogVariant>> {
    protected static final ImmutableList<SensorType<? extends Sensor<? super Frog>>> bY = ImmutableList.of(SensorType.c, SensorType.f, SensorType.v, SensorType.s, SensorType.w);
    protected static final ImmutableList<MemoryModuleType<?>> bZ = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.r, MemoryModuleType.S, MemoryModuleType.T, MemoryModuleType.o, MemoryModuleType.O, MemoryModuleType.P, (Object[])new MemoryModuleType[]{MemoryModuleType.R, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.B, MemoryModuleType.X, MemoryModuleType.Y, MemoryModuleType.Z, MemoryModuleType.aa});
    private static final DataWatcherObject<Holder<FrogVariant>> cg = DataWatcher.a(Frog.class, DataWatcherRegistry.z);
    private static final DataWatcherObject<OptionalInt> ch = DataWatcher.a(Frog.class, DataWatcherRegistry.v);
    private static final int ci = 5;
    public static final String ca = "variant";
    private static final ResourceKey<FrogVariant> cj = FrogVariant.b;
    public final AnimationState cc = new AnimationState();
    public final AnimationState cd = new AnimationState();
    public final AnimationState ce = new AnimationState();
    public final AnimationState cf = new AnimationState();

    public Frog(EntityTypes<? extends EntityAnimal> entityType, World level) {
        super(entityType, level);
        this.bO = new a(this);
        this.a(PathType.j, 4.0f);
        this.a(PathType.e, -1.0f);
        this.bP = new SmoothSwimmingMoveControl(this, 85, 10, 0.02f, 0.1f, true);
    }

    protected BehaviorController.b<Frog> ec() {
        return BehaviorController.a(bZ, bY);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return FrogAi.a(this.ec().a(dynamic));
    }

    public BehaviorController<Frog> eb() {
        return super.eb();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cg, BuiltInRegistries.aj.b(cj));
        builder.a(ch, OptionalInt.empty());
    }

    public void p() {
        this.al.a(ch, OptionalInt.empty());
    }

    public Optional<Entity> t() {
        return this.al.a(ch).stream().mapToObj(this.dV()::a).filter(Objects::nonNull).findFirst();
    }

    public void b(Entity tongueTarget) {
        this.al.a(ch, OptionalInt.of(tongueTarget.ar()));
    }

    @Override
    public int ai() {
        return 35;
    }

    @Override
    public int af() {
        return 5;
    }

    public Holder<FrogVariant> x() {
        return this.al.a(cg);
    }

    public void j(Holder<FrogVariant> variant) {
        this.al.a(cg, variant);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a(ca, this.x().e().orElse(cj).a().toString());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        Optional.ofNullable(MinecraftKey.c(compound.l(ca))).map(resourceLocation -> ResourceKey.a(Registries.F, resourceLocation)).flatMap(BuiltInRegistries.aj::a).ifPresent(this::j);
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("frogBrain");
        this.eb().a(level, this);
        profilerFiller.c();
        profilerFiller.a("frogActivityUpdate");
        FrogAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    @Override
    public void h() {
        if (this.dV().B_()) {
            this.cf.a(this.bm() && !this.aT.d(), this.af);
        }
        super.h();
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (Entity.aq.equals(key)) {
            EntityPose pose = this.aw();
            if (pose == EntityPose.g) {
                this.cc.a(this.af);
            } else {
                this.cc.a();
            }
            if (pose == EntityPose.i) {
                this.cd.a(this.af);
            } else {
                this.cd.a();
            }
            if (pose == EntityPose.j) {
                this.ce.a(this.af);
            } else {
                this.ce.a();
            }
        }
        super.a(key);
    }

    @Override
    protected void B(float partialTick) {
        float f2 = this.cc.b() ? 0.0f : Math.min(partialTick * 25.0f, 1.0f);
        this.aT.a(f2, 0.4f, this.e_() ? 3.0f : 1.0f);
    }

    @Override
    public void gy() {
        this.dV().a(null, this, SoundEffects.kn, SoundCategory.g, 2.0f, 1.0f);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable otherParent) {
        Frog frog = EntityTypes.ab.a(level, EntitySpawnReason.e);
        if (frog != null) {
            FrogAi.a(frog, level.H_());
        }
        return frog;
    }

    @Override
    public boolean e_() {
        return false;
    }

    @Override
    public void a(boolean baby) {
    }

    @Override
    public void a(WorldServer level, EntityAnimal mate) {
        EntityFertilizeEggEvent result = CraftEventFactory.callEntityFertilizeEggEvent(this, mate);
        if (result.isCancelled()) {
            return;
        }
        this.finalizeSpawnChildFromBreeding(level, mate, null, result.getExperience());
        this.eb().a(MemoryModuleType.Y, Unit.a);
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        Holder<BiomeBase> biome = level.t(this.dv());
        if (biome.a(BiomeTags.ai)) {
            this.j(BuiltInRegistries.aj.b(FrogVariant.d));
        } else if (biome.a(BiomeTags.aj)) {
            this.j(BuiltInRegistries.aj.b(FrogVariant.c));
        } else {
            this.j(BuiltInRegistries.aj.b(cj));
        }
        FrogAi.a(this, level.H_());
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public static AttributeProvider.Builder gs() {
        return EntityAnimal.gx().a(GenericAttributes.v, 1.0).a(GenericAttributes.s, 10.0).a(GenericAttributes.c, 10.0).a(GenericAttributes.B, 1.0);
    }

    @Override
    @Nullable
    protected SoundEffect u() {
        return SoundEffects.kl;
    }

    @Override
    @Nullable
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.ko;
    }

    @Override
    @Nullable
    public SoundEffect o_() {
        return SoundEffects.km;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.kr, 0.15f, 1.0f);
    }

    @Override
    public boolean cJ() {
        return false;
    }

    @Override
    protected void ac() {
        super.ac();
        PacketDebug.a(this);
    }

    @Override
    protected int f(float fallDistance, float damageMultiplier) {
        return super.f(fallDistance, damageMultiplier) - 5;
    }

    @Override
    public void a_(Vec3D travelVector) {
        if (this.dh() && this.bj()) {
            this.a(this.fp(), travelVector);
            this.a(EnumMoveType.a, this.dy());
            this.i(this.dy().c(0.9));
        } else {
            super.a_(travelVector);
        }
    }

    public static boolean j(EntityLiving entity) {
        EntitySlime slime;
        return (!(entity instanceof EntitySlime) || (slime = (EntitySlime)entity).gs() == 1) && entity.aq().a(TagsEntity.n);
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new c(this, level);
    }

    @Override
    @Nullable
    public EntityLiving O_() {
        return this.R();
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.ao);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.ci) && Frog.a(level, pos);
    }

    class a
    extends ControllerLook {
        a(EntityInsentient mob) {
            super(mob);
        }

        @Override
        protected boolean c() {
            return Frog.this.t().isEmpty();
        }
    }

    static class c
    extends AmphibiousPathNavigation {
        c(Frog mob, World level) {
            super(mob, level);
        }

        @Override
        public boolean b(PathType pathType) {
            return pathType != PathType.k && super.b(pathType);
        }

        @Override
        protected Pathfinder a(int maxVisitedNodes) {
            this.o = new b(true);
            return new Pathfinder(this.o, maxVisitedNodes);
        }
    }

    static class b
    extends AmphibiousNodeEvaluator {
        private final BlockPosition.MutableBlockPosition a = new BlockPosition.MutableBlockPosition();

        public b(boolean prefersShallowSwimming) {
            super(prefersShallowSwimming);
        }

        @Override
        public PathPoint a() {
            return !this.c.bj() ? super.a() : this.c(new BlockPosition(MathHelper.a(this.c.cR().a), MathHelper.a(this.c.cR().b), MathHelper.a(this.c.cR().c)));
        }

        @Override
        public PathType a(PathfindingContext context, int x2, int y2, int z2) {
            this.a.d(x2, y2 - 1, z2);
            IBlockData blockState = context.a(this.a);
            return blockState.a(TagsBlock.bT) ? PathType.b : super.a(context, x2, y2, z2);
        }
    }
}

