/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.camel;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.camel.CamelAi;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class Camel
extends EntityHorseAbstract {
    public static final float bY = 0.45f;
    public static final int bZ = 55;
    public static final int ca = 30;
    private static final float cz = 0.1f;
    private static final float cC = 1.4285f;
    private static final float cD = 22.2222f;
    private static final int cE = 5;
    private static final int cF = 40;
    private static final int cG = 52;
    private static final int cH = 80;
    private static final float cI = 1.43f;
    public static final DataWatcherObject<Boolean> cc = DataWatcher.a(Camel.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Long> cd = DataWatcher.a(Camel.class, DataWatcherRegistry.c);
    public final AnimationState ce = new AnimationState();
    public final AnimationState cf = new AnimationState();
    public final AnimationState cg = new AnimationState();
    public final AnimationState ch = new AnimationState();
    public final AnimationState ci = new AnimationState();
    private static final EntitySize cJ = EntitySize.b(EntityTypes.t.l(), EntityTypes.t.m() - 1.43f).b(0.845f);
    private int cK = 0;
    private int cL = 0;

    public Camel(EntityTypes<? extends Camel> entityType, World level) {
        super((EntityTypes<? extends EntityHorseAbstract>)entityType, level);
        this.bP = new c();
        this.bO = new b();
        Navigation groundPathNavigation = (Navigation)this.P();
        groundPathNavigation.a(true);
        groundPathNavigation.d(true);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("LastPoseTick", this.al.a(cd));
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        long _long = compound.i("LastPoseTick");
        if (_long < 0L) {
            this.b(EntityPose.k);
        }
        this.a(_long);
    }

    public static AttributeProvider.Builder p() {
        return Camel.gU().a(GenericAttributes.s, 32.0).a(GenericAttributes.v, 0.09f).a(GenericAttributes.o, 0.42f).a(GenericAttributes.B, 1.5);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cc, false);
        builder.a(cd, 0L);
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        CamelAi.a(this, level.H_());
        this.b(level.a().ad());
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    protected BehaviorController.b<Camel> ec() {
        return CamelAi.a();
    }

    @Override
    protected void E() {
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return CamelAi.a(this.ec().a(dynamic));
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return pose == EntityPose.k ? cJ.a(this.ei()) : super.e(pose);
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("camelBrain");
        BehaviorController<?> brain = this.eb();
        brain.a(level, this);
        profilerFiller.c();
        profilerFiller.a("camelActivityUpdate");
        CamelAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    @Override
    public void h() {
        super.h();
        if (this.x() && this.cK < 50 && (this.aJ() || this.bn() || this.bZ())) {
            this.x(false);
        }
        if (this.cK > 0) {
            --this.cK;
            if (this.cK == 0) {
                this.dV().a(null, this.dv(), SoundEffects.dB, SoundCategory.g, 1.0f, 1.0f);
            }
        }
        if (this.dV().B_()) {
            this.he();
        }
        if (this.t()) {
            this.ag();
        }
        if (this.gv() && this.bj()) {
            this.gH();
        }
    }

    private void he() {
        if (this.cL <= 0) {
            this.cL = this.ae.a(40) + 80;
            this.ch.a(this.af);
        } else {
            --this.cL;
        }
        if (this.gw()) {
            this.cg.a();
            this.ci.a();
            if (this.hf()) {
                this.ce.b(this.af);
                this.cf.a();
            } else {
                this.ce.a();
                this.cf.b(this.af);
            }
        } else {
            this.ce.a();
            this.cf.a();
            this.ci.a(this.x(), this.af);
            this.cg.a(this.gE() && this.gI() >= 0L, this.af);
        }
    }

    @Override
    protected void B(float partialTick) {
        float min = this.aw() == EntityPose.a && !this.ci.b() ? Math.min(partialTick * 6.0f, 1.0f) : 0.0f;
        this.aT.a(min, 0.2f, this.e_() ? 3.0f : 1.0f);
    }

    @Override
    public void a_(Vec3D travelVector) {
        if (this.t() && this.aJ()) {
            this.i(this.dy().d(0.0, 1.0, 0.0));
            travelVector = travelVector.d(0.0, 1.0, 0.0);
        }
        super.a_(travelVector);
    }

    @Override
    protected void a(EntityHuman player, Vec3D travelVector) {
        super.a(player, travelVector);
        if (player.bp > 0.0f && this.gv() && !this.gE()) {
            this.gG();
        }
    }

    public boolean t() {
        return this.gv() || this.gE();
    }

    @Override
    protected float e(EntityHuman player) {
        float f2 = player.cj() && this.c() == 0 ? 0.1f : 0.0f;
        return (float)this.h(GenericAttributes.v) + f2;
    }

    @Override
    protected Vec2F j(EntityLiving entity) {
        return this.t() ? new Vec2F(this.dN(), this.dL()) : super.j(entity);
    }

    @Override
    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        return this.t() ? Vec3D.c : super.b(player, travelVector);
    }

    @Override
    public boolean a() {
        return !this.t() && super.a();
    }

    @Override
    public void b(int jumpPower) {
        if (this.j() && this.cK <= 0 && this.aJ()) {
            super.b(jumpPower);
        }
    }

    @Override
    public boolean dO() {
        return true;
    }

    @Override
    protected void b(float playerJumpPendingScale, Vec3D travelVector) {
        double d2 = this.fj();
        this.j(this.bT().d(1.0, 0.0, 1.0).d().c((double)(22.2222f * playerJumpPendingScale) * this.h(GenericAttributes.v) * (double)this.aT()).b(0.0, (double)(1.4285f * playerJumpPendingScale) * d2, 0.0));
        this.cK = 55;
        this.x(true);
        this.ar = true;
    }

    public boolean x() {
        return this.al.a(cc);
    }

    public void x(boolean dashing) {
        this.al.a(cc, dashing);
    }

    @Override
    public void c(int jumpPower) {
        this.b(SoundEffects.dA);
        ((Entity)this).a(GameEvent.u);
        this.x(true);
    }

    @Override
    public void b() {
    }

    @Override
    public int c() {
        return this.cK;
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.dz;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.dC;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.dE;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        if (block.a(TagsBlock.br)) {
            this.a(SoundEffects.dJ, 1.0f, 1.0f);
        } else {
            this.a(SoundEffects.dI, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.ak);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (player.fY() && !this.e_()) {
            this.b(player);
            return EnumInteractionResult.a;
        }
        EnumInteractionResult interactionResult = itemInHand.a(player, (EntityLiving)this, hand);
        if (interactionResult.a()) {
            return interactionResult;
        }
        if (this.j(itemInHand)) {
            return this.c(player, itemInHand);
        }
        if (this.cY().size() < 2 && !this.e_()) {
            this.a(player);
        }
        return EnumInteractionResult.a;
    }

    @Override
    public boolean a(Entity leashHolder, float distance) {
        if (distance > 6.0f && this.gv() && !this.gE() && this.gs()) {
            this.gG();
        }
        return true;
    }

    public boolean gs() {
        return this.g(this.gv() ? EntityPose.a : EntityPose.k);
    }

    @Override
    protected boolean a(EntityHuman player, ItemStack stack) {
        SoundEffect eatingSound;
        boolean isBaby;
        boolean flag1;
        boolean flag;
        if (!this.j(stack)) {
            return false;
        }
        boolean bl = flag = this.eD() < this.eS();
        if (flag) {
            this.heal(2.0f, EntityRegainHealthEvent.RegainReason.EATING);
        }
        boolean bl2 = flag1 = this.gJ() && this.Y_() == 0 && this.gz();
        if (flag1) {
            this.setInLove(player, stack.v());
        }
        if (isBaby = this.e_()) {
            this.dV().a(Particles.P, this.d(1.0), this.dD() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
            if (!this.dV().C) {
                this.b_(10);
            }
        }
        if (!(flag || flag1 || isBaby)) {
            return false;
        }
        if (!this.bb() && (eatingSound = this.gu()) != null) {
            this.dV().a(null, this.dA(), this.dC(), this.dG(), eatingSound, this.dm(), 1.0f, 1.0f + (this.ae.i() - this.ae.i()) * 0.2f);
        }
        ((Entity)this).a(GameEvent.m);
        return true;
    }

    @Override
    protected boolean gt() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean a(EntityAnimal otherAnimal) {
        if (otherAnimal == this) return false;
        if (!(otherAnimal instanceof Camel)) return false;
        Camel camel = (Camel)otherAnimal;
        if (!this.hb()) return false;
        if (!camel.hb()) return false;
        return true;
    }

    @Nullable
    public Camel b(WorldServer level, EntityAgeable otherParent) {
        return EntityTypes.t.a(level, EntitySpawnReason.e);
    }

    @Override
    @Nullable
    protected SoundEffect gu() {
        return SoundEffects.dD;
    }

    @Override
    public boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(level, damageSource, amount, event);
        if (!damageResult) {
            return false;
        }
        this.gH();
        return true;
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        int max = Math.max(this.cY().indexOf(entity), 0);
        boolean flag = max == 0;
        float f2 = 0.5f;
        float f1 = (float)(this.dQ() ? (double)0.01f : this.a(flag, 0.0f, dimensions, partialTick));
        if (this.cY().size() > 1) {
            if (!flag) {
                f2 = -0.7f;
            }
            if (entity instanceof EntityAnimal) {
                f2 += 0.2f;
            }
        }
        return new Vec3D(0.0, f1, f2 * partialTick).b(-this.dL() * ((float)Math.PI / 180));
    }

    @Override
    public float ei() {
        return this.e_() ? 0.45f : 1.0f;
    }

    private double a(boolean firstPassenger, float partialTick, EntitySize dimensions, float scale) {
        double d2 = dimensions.b() - 0.375f * scale;
        float f2 = scale * 1.43f;
        float f1 = f2 - scale * 0.2f;
        float f22 = f2 - f1;
        boolean isInPoseTransition = this.gE();
        boolean isCamelSitting = this.gv();
        if (isInPoseTransition) {
            float f3;
            int i1;
            int i2;
            int n2 = i2 = isCamelSitting ? 40 : 52;
            if (isCamelSitting) {
                i1 = 28;
                f3 = firstPassenger ? 0.5f : 0.1f;
            } else {
                i1 = firstPassenger ? 24 : 32;
                f3 = firstPassenger ? 0.6f : 0.35f;
            }
            float f4 = MathHelper.a((float)this.gI() + partialTick, 0.0f, (float)i2);
            boolean flag = f4 < (float)i1;
            float f5 = flag ? f4 / (float)i1 : (f4 - (float)i1) / (float)(i2 - i1);
            float f6 = f2 - f3 * f1;
            d2 += isCamelSitting ? (double)MathHelper.h(f5, flag ? f2 : f6, flag ? f6 : f22) : (double)MathHelper.h(f5, flag ? f22 - f2 : f22 - f6, flag ? f22 - f6 : 0.0f);
        }
        if (isCamelSitting && !isInPoseTransition) {
            d2 += (double)f22;
        }
        return d2;
    }

    @Override
    public Vec3D s(float partialTick) {
        EntitySize dimensions = this.a(this.aw());
        float ageScale = this.ei();
        return new Vec3D(0.0, this.a(true, partialTick, dimensions, ageScale) - (double)(0.2f * ageScale), dimensions.a() * 0.56f);
    }

    @Override
    public int af() {
        return 30;
    }

    @Override
    protected boolean r(Entity passenger) {
        return this.cY().size() <= 2;
    }

    @Override
    protected void ac() {
        super.ac();
        PacketDebug.a(this);
    }

    public boolean gv() {
        return this.al.a(cd) < 0L;
    }

    public boolean gw() {
        return this.gI() < 0L != this.gv();
    }

    public boolean gE() {
        long poseTime = this.gI();
        return poseTime < (long)(this.gv() ? 40 : 52);
    }

    private boolean hf() {
        return this.gv() && this.gI() < 40L && this.gI() >= 0L;
    }

    public void gF() {
        if (!this.gv() && new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), true).callEvent()) {
            this.b(SoundEffects.dG);
            this.b(EntityPose.k);
            ((Entity)this).a(GameEvent.u);
            this.a(-this.dV().ad());
        }
    }

    public void gG() {
        if (this.gv() && new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), false).callEvent()) {
            this.b(SoundEffects.dH);
            this.b(EntityPose.a);
            ((Entity)this).a(GameEvent.u);
            this.a(this.dV().ad());
        }
    }

    public void gH() {
        if (this.gv() && !new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), false).callEvent()) {
            return;
        }
        this.b(EntityPose.a);
        ((Entity)this).a(GameEvent.u);
        this.b(this.dV().ad());
    }

    @VisibleForTesting
    public void a(long lastPoseChangeTick) {
        this.al.a(cd, lastPoseChangeTick);
    }

    private void b(long lastPoseChangedTick) {
        this.a(Math.max(0L, lastPoseChangedTick - 52L - 1L));
    }

    public long gI() {
        return this.dV().ad() - Math.abs(this.al.a(cd));
    }

    @Override
    public SoundEffect ab_() {
        return SoundEffects.dF;
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (!this.ak && cc.equals(key)) {
            this.cK = this.cK == 0 ? 55 : this.cK;
        }
        super.a(key);
    }

    @Override
    public boolean gJ() {
        return true;
    }

    @Override
    public void b(EntityHuman player) {
        if (!this.dV().C) {
            player.a(this, this.ct);
        }
    }

    @Override
    protected EntityAIBodyControl J() {
        return new a(this);
    }

    class c
    extends ControllerMove {
        public c() {
            super(Camel.this);
        }

        @Override
        public void a() {
            if (this.k == ControllerMove.Operation.b && !Camel.this.P_() && Camel.this.gv() && !Camel.this.gE() && Camel.this.gs()) {
                Camel.this.gG();
            }
            super.a();
        }
    }

    class b
    extends ControllerLook {
        b() {
            super(Camel.this);
        }

        @Override
        public void a() {
            if (!Camel.this.cX()) {
                super.a();
            }
        }
    }

    class a
    extends EntityAIBodyControl {
        public a(Camel mob) {
            super(mob);
        }

        @Override
        public void a() {
            if (!Camel.this.t()) {
                super.a();
            }
        }
    }
}

