/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.axolotl;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.BinaryAnimator;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.axolotl.AxolotlAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class Axolotl
extends EntityAnimal
implements VariantHolder<Variant>,
Bucketable {
    public static final int bY = 200;
    private static final int cj = 10;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Axolotl>>> bZ = ImmutableList.of(SensorType.c, SensorType.o, SensorType.f, SensorType.p, SensorType.q);
    protected static final ImmutableList<? extends MemoryModuleType<?>> ca = ImmutableList.of(MemoryModuleType.r, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.n, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.o, MemoryModuleType.p, MemoryModuleType.K, (Object[])new MemoryModuleType[]{MemoryModuleType.y, MemoryModuleType.N, MemoryModuleType.B, MemoryModuleType.O, MemoryModuleType.P, MemoryModuleType.R, MemoryModuleType.U, MemoryModuleType.Z});
    private static final DataWatcherObject<Integer> ck = DataWatcher.a(Axolotl.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> cl = DataWatcher.a(Axolotl.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cm = DataWatcher.a(Axolotl.class, DataWatcherRegistry.k);
    public static final double cc = 20.0;
    public static final int cd = 1200;
    private static final int cn = 6000;
    public static final String ce = "Variant";
    private static final int co = 1800;
    private static final int cp = 2400;
    public final BinaryAnimator cf = new BinaryAnimator(10, MathHelper::m);
    public final BinaryAnimator cg = new BinaryAnimator(10, MathHelper::m);
    public final BinaryAnimator ch = new BinaryAnimator(10, MathHelper::m);
    public final BinaryAnimator ci = new BinaryAnimator(10, MathHelper::m);
    private static final int cq = 100;

    public Axolotl(EntityTypes<? extends Axolotl> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        this.a(PathType.j, 0.0f);
        this.bP = new d(this);
        this.bO = new c(this, 20);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return 0.0f;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ck, 0);
        builder.a(cl, false);
        builder.a(cm, false);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a(ce, this.gs().a());
        compound.a("FromBucket", this.p());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.a(Variant.a(compound.h(ce)));
        this.x(compound.q("FromBucket"));
    }

    @Override
    public void U() {
        if (!this.gt()) {
            super.U();
        }
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        boolean flag = false;
        if (spawnReason == EntitySpawnReason.l) {
            return spawnGroupData;
        }
        RandomSource random = level.H_();
        if (spawnGroupData instanceof b) {
            if (((b)spawnGroupData).a() >= 2) {
                flag = true;
            }
        } else {
            spawnGroupData = new b(Variant.a(random), Variant.a(random));
        }
        this.a(((b)spawnGroupData).a(random));
        if (flag) {
            this.c_(-24000);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public void az() {
        int airSupply = this.ct();
        super.az();
        if (!this.gf()) {
            this.s(airSupply);
        }
        if (this.dV().B_()) {
            this.gv();
        }
    }

    private void gv() {
        a animationState = this.gt() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.a : (this.bm() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.b : (this.aJ() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.c : net.minecraft.world.entity.animal.axolotl.Axolotl$a.d));
        this.cf.a(animationState == net.minecraft.world.entity.animal.axolotl.Axolotl$a.a);
        this.cg.a(animationState == net.minecraft.world.entity.animal.axolotl.Axolotl$a.b);
        this.ch.a(animationState == net.minecraft.world.entity.animal.axolotl.Axolotl$a.c);
        boolean flag = this.aT.d() || this.dN() != this.O || this.dL() != this.N;
        this.ci.a(flag);
    }

    protected void s(int airSupply) {
        if (this.bL() && !this.bl()) {
            this.j(airSupply - 1);
            if (this.ct() == -20) {
                this.j(0);
                this.a(this.dW().t(), 2.0f);
            }
        } else {
            this.j(this.cs());
        }
    }

    public void x() {
        int i2 = this.ct() + 1800;
        this.j(Math.min(i2, this.cs()));
    }

    @Override
    public int cs() {
        return this.maxAirTicks;
    }

    public Variant gs() {
        return Variant.a(this.al.a(ck));
    }

    @Override
    public void a(Variant variant) {
        this.al.a(ck, variant.a());
    }

    private static boolean a(RandomSource random) {
        return random.a(1200) == 0;
    }

    @Override
    public boolean a(IWorldReader level) {
        return level.f(this);
    }

    @Override
    public boolean cJ() {
        return false;
    }

    public void y(boolean playingDead) {
        this.al.a(cl, playingDead);
    }

    public boolean gt() {
        return this.al.a(cl);
    }

    @Override
    public boolean p() {
        return this.al.a(cm);
    }

    @Override
    public void x(boolean fromBucket) {
        this.al.a(cm, fromBucket);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable otherParent) {
        Axolotl axolotl = EntityTypes.h.a(level, EntitySpawnReason.e);
        if (axolotl != null) {
            Variant rareSpawnVariant = Axolotl.a(this.ae) ? Variant.b(this.ae) : (this.ae.h() ? this.gs() : ((Axolotl)otherParent).gs());
            axolotl.a(rareSpawnVariant);
            axolotl.fY();
        }
        return axolotl;
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aC);
    }

    @Override
    public boolean y() {
        return true;
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("axolotlBrain");
        this.eb().a(level, this);
        profilerFiller.c();
        profilerFiller.a("axolotlActivityUpdate");
        AxolotlAi.a(this);
        profilerFiller.c();
        if (!this.gf()) {
            Optional<Integer> memory = this.eb().c(MemoryModuleType.N);
            this.y(memory.isPresent() && memory.get() > 0);
        }
    }

    public static AttributeProvider.Builder gu() {
        return EntityAnimal.gx().a(GenericAttributes.s, 14.0).a(GenericAttributes.v, 1.0).a(GenericAttributes.c, 2.0).a(GenericAttributes.B, 1.0);
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new AmphibiousPathNavigation(this, level);
    }

    @Override
    public void gj() {
        this.a(SoundEffects.aK, 1.0f, 1.0f);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        float health = this.eD();
        if (!this.gf() && this.dV().A.a(3) == 0 && ((float)this.dV().A.a(3) < amount || health / this.eS() < 0.5f) && amount < health && this.bj() && (damageSource.d() != null || damageSource.c() != null) && !this.gt()) {
            this.bE.a(MemoryModuleType.N, Integer.valueOf(200));
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    public int ad() {
        return 1;
    }

    @Override
    public int af() {
        return 1;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return Bucketable.a(player, hand, this).orElse(super.b(player, hand));
    }

    @Override
    public void i(ItemStack stack) {
        Bucketable.a((EntityInsentient)this, stack);
        CustomData.a(DataComponents.X, stack, (NBTTagCompound tag) -> {
            tag.a(ce, this.gs().a());
            tag.a("Age", this.Y_());
            BehaviorController<Axolotl> brain = this.eb();
            if (brain.a(MemoryModuleType.U)) {
                tag.a("HuntingCooldown", brain.e(MemoryModuleType.U));
            }
        });
    }

    @Override
    public void h(NBTTagCompound tag) {
        Bucketable.a((EntityInsentient)this, tag);
        this.a(Variant.a(tag.h(ce)));
        if (tag.e("Age")) {
            this.c_(tag.h("Age"));
        }
        if (tag.e("HuntingCooldown")) {
            this.eb().a(MemoryModuleType.U, true, tag.i("HuntingCooldown"));
        }
    }

    @Override
    public ItemStack W_() {
        return new ItemStack(Items.rq);
    }

    @Override
    public SoundEffect t() {
        return SoundEffects.dk;
    }

    @Override
    public boolean ew() {
        return !this.gt() && super.ew();
    }

    public static void a(WorldServer level, Axolotl axolotl, EntityLiving target) {
        Entity entity;
        DamageSource lastDamageSource;
        if (target.eE() && (lastDamageSource = target.eF()) != null && (entity = lastDamageSource.d()) != null && entity.aq() == EntityTypes.bR) {
            EntityHuman player = (EntityHuman)entity;
            List<EntityHuman> entitiesOfClass = level.a(EntityHuman.class, axolotl.cR().g(20.0));
            if (entitiesOfClass.contains(player)) {
                axolotl.a(player);
            }
        }
    }

    @Override
    public void a(EntityHuman player) {
        MobEffect effect = player.c(MobEffects.j);
        if (effect == null || effect.a(2399)) {
            int i2 = effect != null ? effect.d() : 0;
            int min = Math.min(2400, 100 + i2);
            player.addEffect(new MobEffect(MobEffects.j, min, 0), this, EntityPotionEffectEvent.Cause.AXOLOTL);
        }
        player.removeEffect(MobEffects.d, EntityPotionEffectEvent.Cause.AXOLOTL);
    }

    @Override
    public boolean aa() {
        return super.aa() || this.p();
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.aM;
    }

    @Override
    @Nullable
    public SoundEffect o_() {
        return SoundEffects.aL;
    }

    @Override
    @Nullable
    protected SoundEffect u() {
        return this.bj() ? SoundEffects.aO : SoundEffects.aN;
    }

    @Override
    protected SoundEffect aW() {
        return SoundEffects.aP;
    }

    @Override
    protected SoundEffect aV() {
        return SoundEffects.aQ;
    }

    protected BehaviorController.b<Axolotl> ec() {
        return BehaviorController.a(ca, bZ);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return AxolotlAi.a(this.ec().a(dynamic));
    }

    public BehaviorController<Axolotl> eb() {
        return super.eb();
    }

    @Override
    protected void ac() {
        super.ac();
        PacketDebug.a(this);
    }

    @Override
    public void a_(Vec3D travelVector) {
        if (this.dh() && this.bj()) {
            this.a(this.fp(), travelVector);
            this.a(EnumMoveType.a, this.dy());
            this.i(this.dy().c(0.9));
        } else {
            super.a_(travelVector);
        }
    }

    @Override
    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (stack.a(Items.rp)) {
            player.a(hand, ItemLiquidUtil.a(stack, player, new ItemStack(Items.rg)));
        } else {
            super.a(player, hand, stack);
        }
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return !this.p() && !this.l_();
    }

    @Override
    @Nullable
    public EntityLiving O_() {
        return this.R();
    }

    public static boolean a(EntityTypes<? extends EntityLiving> entityType, WorldAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.ca);
    }

    @Override
    public int getDefaultMaxAirSupply() {
        return 6000;
    }

    static class d
    extends SmoothSwimmingMoveControl {
        private final Axolotl l;

        public d(Axolotl axolotl) {
            super(axolotl, 85, 10, 0.1f, 0.5f, false);
            this.l = axolotl;
        }

        @Override
        public void a() {
            if (!this.l.gt()) {
                super.a();
            }
        }
    }

    class c
    extends SmoothSwimmingLookControl {
        public c(Axolotl mob, int maxYRotFromCenter) {
            super(mob, maxYRotFromCenter);
        }

        @Override
        public void a() {
            if (!Axolotl.this.gt()) {
                super.a();
            }
        }
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable {
        public static final /* enum */ Variant a = new Variant(0, "lucy", true);
        public static final /* enum */ Variant b = new Variant(1, "wild", true);
        public static final /* enum */ Variant c = new Variant(2, "gold", true);
        public static final /* enum */ Variant d = new Variant(3, "cyan", true);
        public static final /* enum */ Variant e = new Variant(4, "blue", false);
        private static final IntFunction<Variant> g;
        public static final Codec<Variant> f;
        private final int h;
        private final String i;
        private final boolean j;
        private static final /* synthetic */ Variant[] k;

        public static Variant[] values() {
            return (Variant[])k.clone();
        }

        public static Variant valueOf(String name) {
            return Enum.valueOf(Variant.class, name);
        }

        private Variant(int id, String name, boolean common) {
            this.h = id;
            this.i = name;
            this.j = common;
        }

        public int a() {
            return this.h;
        }

        public String b() {
            return this.i;
        }

        @Override
        public String c() {
            return this.i;
        }

        public static Variant a(int id) {
            return g.apply(id);
        }

        public static Variant a(RandomSource random) {
            return Variant.a(random, true);
        }

        public static Variant b(RandomSource random) {
            return Variant.a(random, false);
        }

        private static Variant a(RandomSource random, boolean common) {
            Variant[] variants = (Variant[])Arrays.stream(Variant.values()).filter(variant -> variant.j == common).toArray(Variant[]::new);
            return SystemUtils.a(variants, random);
        }

        private static /* synthetic */ Variant[] d() {
            return new Variant[]{a, b, c, d, e};
        }

        static {
            k = Variant.d();
            g = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.a);
            f = INamable.a(Variant::values);
        }
    }

    public static class b
    extends EntityAgeable.a {
        public final Variant[] a;

        public b(Variant ... types) {
            super(false);
            this.a = types;
        }

        public Variant a(RandomSource random) {
            return this.a[random.a(this.a.length)];
        }
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a();
        public static final /* enum */ a b = new a();
        public static final /* enum */ a c = new a();
        public static final /* enum */ a d = new a();
        private static final /* synthetic */ a[] e;

        public static a[] values() {
            return (a[])e.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b, c, d};
        }

        static {
            e = net.minecraft.world.entity.animal.axolotl.Axolotl$a.a();
        }
    }
}

