/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.allay;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.allay.AllayAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.slf4j.Logger;

public class Allay
extends EntityCreature
implements InventoryCarrier,
VibrationSystem {
    private static final Logger bY = LogUtils.getLogger();
    private static final BaseBlockPosition bZ = new BaseBlockPosition(1, 1, 1);
    private static final int ca = 5;
    private static final float cb = 55.0f;
    private static final float cc = 15.0f;
    private static final int cd = 6000;
    private static final int ce = 3;
    public static final int a = 1024;
    private static final DataWatcherObject<Boolean> cf = DataWatcher.a(Allay.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cg = DataWatcher.a(Allay.class, DataWatcherRegistry.k);
    protected static final ImmutableList<SensorType<? extends Sensor<? super Allay>>> b = ImmutableList.of(SensorType.c, SensorType.d, SensorType.f, SensorType.b);
    protected static final ImmutableList<MemoryModuleType<?>> c = ImmutableList.of(MemoryModuleType.t, MemoryModuleType.n, MemoryModuleType.h, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.x, MemoryModuleType.L, MemoryModuleType.aM, MemoryModuleType.aN, MemoryModuleType.aO, MemoryModuleType.aP, MemoryModuleType.Z, (Object[])new MemoryModuleType[0]);
    public static final ImmutableList<Float> d = ImmutableList.of((Object)Float.valueOf(0.5625f), (Object)Float.valueOf(0.625f), (Object)Float.valueOf(0.75f), (Object)Float.valueOf(0.9375f), (Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.125f), (Object)Float.valueOf(1.25f), (Object)Float.valueOf(1.5f), (Object)Float.valueOf(1.875f), (Object)Float.valueOf(2.0f), (Object)Float.valueOf(2.25f), (Object[])new Float[]{Float.valueOf(2.5f), Float.valueOf(3.0f), Float.valueOf(3.75f), Float.valueOf(4.0f)});
    private final DynamicGameEventListener<VibrationSystem.b> ch;
    private VibrationSystem.a ci;
    private final VibrationSystem.d cj;
    private final DynamicGameEventListener<a> ck;
    private final InventorySubcontainer cl = new InventorySubcontainer(1);
    @Nullable
    public BlockPosition cm;
    public long cn;
    private float co;
    private float cp;
    private float cq;
    private float cr;
    private float cs;
    public boolean forceDancing = false;

    public Allay(EntityTypes<? extends Allay> entityType, World level) {
        super((EntityTypes<? extends EntityCreature>)entityType, level);
        this.bP = new ControllerMoveFlying(this, 20, true);
        this.a_(this.fN());
        this.cj = new b();
        this.ci = new VibrationSystem.a();
        this.ch = new DynamicGameEventListener<VibrationSystem.b>(new VibrationSystem.b(this));
        this.ck = new DynamicGameEventListener<a>(new a(this.cj.b(), GameEvent.E.a().a()));
    }

    public void setCanDuplicate(boolean canDuplicate) {
        this.al.a(cg, canDuplicate);
    }

    protected BehaviorController.b<Allay> ec() {
        return BehaviorController.a(c, b);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return AllayAi.a(this.ec().a(dynamic));
    }

    public BehaviorController<Allay> eb() {
        return super.eb();
    }

    public static AttributeProvider.Builder m() {
        return EntityInsentient.F().a(GenericAttributes.s, 20.0).a(GenericAttributes.l, 0.1f).a(GenericAttributes.v, 0.1f).a(GenericAttributes.c, 2.0);
    }

    @Override
    protected NavigationAbstract b(World level) {
        NavigationFlying flyingPathNavigation = new NavigationFlying(this, level);
        flyingPathNavigation.b(false);
        flyingPathNavigation.a(true);
        flyingPathNavigation.a(48.0f);
        return flyingPathNavigation;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cf, false);
        builder.a(cg, true);
    }

    @Override
    public void a_(Vec3D travelVector) {
        if (this.dh()) {
            if (this.bj()) {
                this.a(0.02f, travelVector);
                this.a(EnumMoveType.a, this.dy());
                this.i(this.dy().c((double)0.8f));
            } else if (this.bx()) {
                this.a(0.02f, travelVector);
                this.a(EnumMoveType.a, this.dy());
                this.i(this.dy().c(0.5));
            } else {
                this.a(this.fp(), travelVector);
                this.a(EnumMoveType.a, this.dy());
                this.i(this.dy().c((double)0.91f));
            }
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        return !this.b(damageSource.d()) && super.a(level, damageSource, amount);
    }

    @Override
    protected boolean t(Entity entity) {
        return this.b(entity) || super.t(entity);
    }

    private boolean b(@Nullable Entity entity) {
        if (!(entity instanceof EntityHuman)) {
            return false;
        }
        EntityHuman player = (EntityHuman)entity;
        Optional<UUID> memory = this.eb().c(MemoryModuleType.aM);
        return memory.isPresent() && player.cG().equals(memory.get());
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
    }

    @Override
    protected SoundEffect u() {
        return this.d(EnumItemSlot.a) ? SoundEffects.a : SoundEffects.b;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.d;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.c;
    }

    @Override
    public float fg() {
        return 0.4f;
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("allayBrain");
        this.eb().a(level, this);
        profilerFiller.c();
        profilerFiller.a("allayActivityUpdate");
        AllayAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    @Override
    public void d_() {
        super.d_();
        if (!this.dV().C && this.bL() && this.af % 10 == 0) {
            this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
        }
        if (this.x() && this.gw() && this.af % 20 == 0) {
            this.x(false);
            this.cm = null;
        }
        this.gx();
    }

    @Override
    public void h() {
        super.h();
        if (this.dV().C) {
            this.cp = this.co;
            this.co = this.p() ? MathHelper.a(this.co + 1.0f, 0.0f, 5.0f) : MathHelper.a(this.co - 1.0f, 0.0f, 5.0f);
            if (this.x()) {
                this.cq += 1.0f;
                this.cs = this.cr;
                this.cr = this.gs() ? (this.cr += 1.0f) : (this.cr -= 1.0f);
                this.cr = MathHelper.a(this.cr, 0.0f, 15.0f);
            } else {
                this.cq = 0.0f;
                this.cr = 0.0f;
                this.cs = 0.0f;
            }
        } else {
            VibrationSystem.c.a(this.dV(), this.ci, this.cj);
            if (this.gp()) {
                this.x(false);
            }
        }
    }

    @Override
    public boolean fN() {
        return !this.gv() && this.p();
    }

    public boolean p() {
        return !this.b(EnumHand.a).f();
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return false;
    }

    private boolean gv() {
        return this.eb().a(MemoryModuleType.aP, MemoryStatus.a);
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        ItemStack itemInHand1 = this.b(EnumHand.a);
        if (this.x() && itemInHand.a(TagsItem.W) && this.gA()) {
            Allay allay = this.duplicateAllay();
            if (allay == null) {
                return EnumInteractionResult.a;
            }
            this.dV().a((Entity)this, (byte)18);
            this.dV().a(player, this, SoundEffects.E, SoundCategory.g, 2.0f, 1.0f);
            this.a(player, itemInHand);
            return EnumInteractionResult.a;
        }
        if (itemInHand1.f() && !itemInHand.f()) {
            ItemStack itemStack = itemInHand.c(1);
            this.a(EnumHand.a, itemStack);
            this.a(player, itemInHand);
            this.dV().a(player, this, SoundEffects.e, SoundCategory.g, 2.0f, 1.0f);
            this.eb().a(MemoryModuleType.aM, player.cG());
            return EnumInteractionResult.a;
        }
        if (!itemInHand1.f() && hand == EnumHand.a && itemInHand.f()) {
            this.a(EnumItemSlot.a, ItemStack.j);
            this.dV().a(player, this, SoundEffects.f, SoundCategory.g, 2.0f, 1.0f);
            this.a(EnumHand.a);
            for (ItemStack itemStack1 : this.t().f()) {
                BehaviorUtil.a((EntityLiving)this, itemStack1, this.dt());
            }
            this.eb().b(MemoryModuleType.aM);
            player.i(itemInHand1);
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    public void b(BlockPosition jukeboxPos, boolean jukeboxPlaying) {
        if (jukeboxPlaying) {
            if (!this.x()) {
                this.cm = jukeboxPos;
                this.x(true);
            }
        } else if (jukeboxPos.equals(this.cm) || this.cm == null) {
            this.cm = null;
            this.x(false);
        }
    }

    @Override
    public InventorySubcontainer t() {
        return this.cl;
    }

    @Override
    protected BaseBlockPosition Y() {
        return bZ;
    }

    @Override
    public boolean c(WorldServer level, ItemStack stack) {
        ItemStack itemInHand = this.b(EnumHand.a);
        return !itemInHand.f() && level.O().b(GameRules.c) && this.cl.c(stack) && this.c(itemInHand, stack);
    }

    private boolean c(ItemStack first, ItemStack second) {
        return ItemStack.b(first, second) && !this.d(first, second);
    }

    private boolean d(ItemStack first, ItemStack second) {
        PotionContents potionContents1;
        PotionContents potionContents = first.a(DataComponents.Q);
        return !Objects.equals(potionContents, potionContents1 = second.a(DataComponents.Q));
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        InventoryCarrier.a(level, this, this, entity);
    }

    @Override
    protected void ac() {
        super.ac();
        PacketDebug.a(this);
    }

    @Override
    public boolean ba() {
        return !this.aJ();
    }

    @Override
    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> listenerConsumer) {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            listenerConsumer.accept(this.ch, serverLevel);
            listenerConsumer.accept(this.ck, serverLevel);
        }
    }

    public boolean x() {
        return this.al.a(cf);
    }

    public void x(boolean dancing) {
        if (!(this.dV().C || !this.dj() || dancing && this.gp())) {
            this.al.a(cf, dancing);
        }
    }

    private boolean gw() {
        if (this.forceDancing) {
            return false;
        }
        return this.cm == null || !this.cm.a(this.dt(), (double)GameEvent.E.a().a()) || !this.dV().a_(this.cm).a(Blocks.eg);
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.cp, this.co) / 5.0f;
    }

    public boolean gs() {
        float f2 = this.cq % 55.0f;
        return f2 < 15.0f;
    }

    public float K(float partialTick) {
        return MathHelper.h(partialTick, this.cs, this.cr) / 15.0f;
    }

    @Override
    public boolean a(ItemStack oldItem, ItemStack newItem) {
        return !this.c(oldItem, newItem);
    }

    @Override
    protected void f(WorldServer level) {
        super.f(level);
        this.cl.f().forEach(stack -> this.a(level, (ItemStack)stack));
        ItemStack itemBySlot = this.a(EnumItemSlot.a);
        if (!itemBySlot.f() && !EnchantmentManager.a(itemBySlot, EnchantmentEffectComponents.D)) {
            this.a(level, itemBySlot);
            this.a(EnumItemSlot.a, ItemStack.j);
        }
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        this.b(compound, this.dX());
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        VibrationSystem.a.a.encodeStart(registryOps, (Object)this.ci).resultOrPartial(string -> bY.error("Failed to encode vibration listener for Allay: '{}'", string)).ifPresent(tag -> compound.a("listener", (NBTBase)tag));
        compound.a("DuplicationCooldown", this.cn);
        compound.a("CanDuplicate", this.gA());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.a(compound, this.dX());
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        if (compound.b("listener", 10)) {
            VibrationSystem.a.a.parse(registryOps, (Object)compound.p("listener")).resultOrPartial(string -> bY.error("Failed to parse vibration listener for Allay: '{}'", string)).ifPresent(data -> {
                this.ci = data;
            });
        }
        this.cn = compound.i("DuplicationCooldown");
        this.al.a(cg, compound.q("CanDuplicate"));
    }

    @Override
    protected boolean gq() {
        return false;
    }

    private void gx() {
        if (this.cn > 0L) {
            --this.cn;
        }
        if (!this.dV().B_() && this.cn == 0L && !this.gA()) {
            this.al.a(cg, true);
        }
    }

    @Nullable
    public Allay duplicateAllay() {
        Allay allay = EntityTypes.c.a(this.dV(), EntitySpawnReason.e);
        if (allay != null) {
            allay.f(this.dt());
            allay.fY();
            allay.gz();
            this.gz();
            this.dV().addFreshEntity(allay, CreatureSpawnEvent.SpawnReason.DUPLICATION);
        }
        return allay;
    }

    public void gz() {
        this.cn = 6000L;
        this.al.a(cg, false);
    }

    public boolean gA() {
        return this.al.a(cg);
    }

    private void a(EntityHuman player, ItemStack stack) {
        stack.a(1, (EntityLiving)player);
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, (double)this.cS() * 0.6, (double)this.dq() * 0.1);
    }

    @Override
    public void b(byte id) {
        if (id == 18) {
            for (int i2 = 0; i2 < 3; ++i2) {
                this.gB();
            }
        } else {
            super.b(id);
        }
    }

    private void gB() {
        double d2 = this.ae.k() * 0.02;
        double d1 = this.ae.k() * 0.02;
        double d22 = this.ae.k() * 0.02;
        this.dV().a(Particles.R, this.d(1.0), this.dD() + 0.5, this.g(1.0), d2, d1, d22);
    }

    @Override
    public VibrationSystem.a gt() {
        return this.ci;
    }

    @Override
    public VibrationSystem.d gu() {
        return this.cj;
    }

    class b
    implements VibrationSystem.d {
        private static final int b = 16;
        private final PositionSource c;

        b() {
            this.c = new EntityPositionSource(Allay.this, Allay.this.cS());
        }

        @Override
        public int a() {
            return 16;
        }

        @Override
        public PositionSource b() {
            return this.c;
        }

        @Override
        public boolean a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, GameEvent.a context) {
            if (Allay.this.gf()) {
                return false;
            }
            Optional<GlobalPos> memory = Allay.this.eb().c(MemoryModuleType.aN);
            if (memory.isEmpty()) {
                return true;
            }
            GlobalPos globalPos = memory.get();
            return globalPos.a(level.ai(), Allay.this.dv(), 1024) && globalPos.b().equals(pos);
        }

        @Override
        public void a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, @Nullable Entity entity, @Nullable Entity playerEntity, float distance) {
            if (gameEvent.a(GameEvent.H)) {
                AllayAi.a(Allay.this, new BlockPosition(pos));
            }
        }

        @Override
        public TagKey<GameEvent> c() {
            return GameEventTags.e;
        }
    }

    class a
    implements GameEventListener {
        private final PositionSource b;
        private final int c;

        public a(PositionSource listenerSource, int listenerRadius) {
            this.b = listenerSource;
            this.c = listenerRadius;
        }

        @Override
        public PositionSource a() {
            return this.b;
        }

        @Override
        public int b() {
            return this.c;
        }

        @Override
        public boolean a(WorldServer level, Holder<GameEvent> gameEvent, GameEvent.a context, Vec3D pos) {
            if (gameEvent.a(GameEvent.E)) {
                Allay.this.b(BlockPosition.a(pos), true);
                return true;
            }
            if (gameEvent.a(GameEvent.F)) {
                Allay.this.b(BlockPosition.a(pos), false);
                return true;
            }
            return false;
        }
    }
}

