/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.event.entity.EntityDyeEvent;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBeg;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.animal.WolfVariants;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityWolf
extends EntityTameableAnimal
implements IEntityAngerable,
VariantHolder<Holder<WolfVariant>> {
    private static final DataWatcherObject<Boolean> ce = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> cf = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> cg = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Holder<WolfVariant>> ch = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.y);
    public static final PathfinderTargetCondition.a cc = (entity, level) -> {
        EntityTypes<?> type = entity.aq();
        return type == EntityTypes.ba || type == EntityTypes.aX || type == EntityTypes.aa;
    };
    private static final float ci = 8.0f;
    private static final float cj = 40.0f;
    private static final float ck = 0.125f;
    public static final float cd = 0.62831855f;
    private float cl;
    private float cm;
    public boolean cn;
    private boolean co;
    private float cp;
    private float cq;
    private static final UniformInt cr = TimeRange.a(20, 39);
    @Nullable
    private UUID cs;

    public EntityWolf(EntityTypes<? extends EntityWolf> entityType, World level) {
        super((EntityTypes<? extends EntityTameableAnimal>)entityType, level);
        this.a(false, false);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    @Override
    protected void E() {
        this.bS.a(1, new PathfinderGoalFloat(this));
        this.bS.a(1, new EntityTameableAnimal.a(1.5, DamageTypeTags.G));
        this.bS.a(2, new PathfinderGoalSit(this));
        this.bS.a(3, new a<EntityLlama>(this, EntityLlama.class, 24.0f, 1.5, 1.5));
        this.bS.a(4, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bS.a(5, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.bS.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.bS.a(7, new PathfinderGoalBreed(this, 1.0));
        this.bS.a(8, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bS.a(9, new PathfinderGoalBeg(this, 8.0f));
        this.bS.a(10, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bS.a(10, new PathfinderGoalRandomLookaround(this));
        this.bT.a(1, new PathfinderGoalOwnerHurtByTarget(this));
        this.bT.a(2, new PathfinderGoalOwnerHurtTarget(this));
        this.bT.a(3, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.bT.a(4, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a));
        this.bT.a(5, new PathfinderGoalRandomTargetNonTamed<EntityAnimal>(this, EntityAnimal.class, false, cc));
        this.bT.a(6, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.bY));
        this.bT.a(7, new PathfinderGoalNearestAttackableTarget<EntitySkeletonAbstract>((EntityInsentient)this, EntitySkeletonAbstract.class, false));
        this.bT.a(8, new PathfinderGoalUniversalAngerReset<EntityWolf>(this, true));
    }

    public MinecraftKey gE() {
        WolfVariant wolfVariant = this.gF().a();
        if (this.p()) {
            return wolfVariant.b();
        }
        return this.ac_() ? wolfVariant.c() : wolfVariant.a();
    }

    public Holder<WolfVariant> gF() {
        return this.al.a(ch);
    }

    public void j(Holder<WolfVariant> variant) {
        this.al.a(ch, variant);
    }

    public static AttributeProvider.Builder gG() {
        return EntityAnimal.gx().a(GenericAttributes.v, 0.3f).a(GenericAttributes.s, 8.0).a(GenericAttributes.c, 4.0);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        IRegistryCustom registryAccess = this.dX();
        IRegistry<WolfVariant> registry = registryAccess.e(Registries.m);
        builder.a(ch, (Holder)registry.a(WolfVariants.j).or(registry::a).orElseThrow());
        builder.a(ce, false);
        builder.a(cf, EnumColor.o.a());
        builder.a(cg, 0);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.DH, 0.15f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("CollarColor", (byte)this.gI().a());
        this.gF().e().ifPresent(resourceKey -> compound.a("variant", resourceKey.a().toString()));
        this.a_(compound);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        Optional.ofNullable(MinecraftKey.c(compound.l("variant"))).map(resourceLocation -> ResourceKey.a(Registries.m, resourceLocation)).flatMap(resourceKey -> this.dX().e(Registries.m).a((ResourceKey)resourceKey)).ifPresent(this::j);
        if (compound.b("CollarColor", 99)) {
            this.a(EnumColor.a(compound.h("CollarColor")));
        }
        this.a(this.dV(), compound);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        Holder<WolfVariant> holder;
        Holder<BiomeBase> biome = level.t(this.dv());
        if (spawnGroupData instanceof b) {
            b wolfPackData = (b)spawnGroupData;
            holder = wolfPackData.a;
        } else {
            holder = WolfVariants.a(this.dX(), biome);
            spawnGroupData = new b(holder);
        }
        this.j(holder);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    protected SoundEffect u() {
        if (this.ac_()) {
            return SoundEffects.DC;
        }
        if (this.ae.a(3) == 0) {
            return this.p() && this.eD() < 20.0f ? SoundEffects.DI : SoundEffects.DF;
        }
        return SoundEffects.DA;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return this.j(damageSource) ? SoundEffects.Dy : SoundEffects.DE;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.DB;
    }

    @Override
    public float fg() {
        return 0.4f;
    }

    @Override
    public void d_() {
        super.d_();
        if (!this.dV().C && this.cn && !this.co && !this.go() && this.aJ()) {
            this.co = true;
            this.cp = 0.0f;
            this.cq = 0.0f;
            this.dV().a((Entity)this, (byte)8);
        }
        if (!this.dV().C) {
            this.a((WorldServer)this.dV(), true);
        }
    }

    @Override
    public void h() {
        super.h();
        if (this.bL()) {
            this.cm = this.cl;
            this.cl = this.gJ() ? (this.cl += (1.0f - this.cl) * 0.4f) : (this.cl += (0.0f - this.cl) * 0.4f);
            if (this.bl()) {
                this.cn = true;
                if (this.co && !this.dV().C) {
                    this.dV().a((Entity)this, (byte)56);
                    this.gK();
                }
            } else if ((this.cn || this.co) && this.co) {
                if (this.cp == 0.0f) {
                    this.a(SoundEffects.DG, this.fg(), (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
                    ((Entity)this).a((Holder<GameEvent>)GameEvent.u);
                }
                this.cq = this.cp;
                this.cp += 0.05f;
                if (this.cq >= 2.0f) {
                    this.cn = false;
                    this.co = false;
                    this.cq = 0.0f;
                    this.cp = 0.0f;
                }
                if (this.cp > 0.4f) {
                    float f2 = (float)this.dC();
                    int i2 = (int)(MathHelper.a((this.cp - 0.4f) * (float)Math.PI) * 7.0f);
                    Vec3D deltaMovement = this.dy();
                    for (int i1 = 0; i1 < i2; ++i1) {
                        float f1 = (this.ae.i() * 2.0f - 1.0f) * this.dq() * 0.5f;
                        float f22 = (this.ae.i() * 2.0f - 1.0f) * this.dq() * 0.5f;
                        this.dV().a(Particles.ao, this.dA() + (double)f1, (double)(f2 + 0.8f), this.dG() + (double)f22, deltaMovement.d, deltaMovement.e, deltaMovement.f);
                    }
                }
            }
        }
    }

    private void gK() {
        this.co = false;
        this.cp = 0.0f;
        this.cq = 0.0f;
    }

    @Override
    public void a(DamageSource cause) {
        this.cn = false;
        this.co = false;
        this.cq = 0.0f;
        this.cp = 0.0f;
        super.a(cause);
    }

    public float J(float partialTick) {
        return !this.cn ? 1.0f : Math.min(0.75f + MathHelper.h(partialTick, this.cq, this.cp) / 2.0f * 0.25f, 1.0f);
    }

    public float K(float partialTick) {
        return MathHelper.h(partialTick, this.cq, this.cp);
    }

    public float L(float partialTick) {
        return MathHelper.h(partialTick, this.cm, this.cl) * 0.15f * (float)Math.PI;
    }

    @Override
    public int ad() {
        return this.x() ? 20 : super.ad();
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.a(level, damageSource)) {
            return false;
        }
        if (!super.a(level, damageSource, amount)) {
            return false;
        }
        this.z(false);
        return true;
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return true;
    }

    @Override
    public boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        if (!this.j(damageSource)) {
            return super.actuallyHurt(level, damageSource, amount, event);
        }
        if (event.isCancelled()) {
            return false;
        }
        ItemStack bodyArmorItem = this.ak();
        int damageValue = bodyArmorItem.o();
        int maxDamage = bodyArmorItem.p();
        bodyArmorItem.a(MathHelper.f(amount), (EntityLiving)this, EnumItemSlot.g);
        if (Crackiness.b.a(damageValue, maxDamage) != Crackiness.b.a(this.ak())) {
            this.a(SoundEffects.Dx);
            level.a(new ParticleParamItem(Particles.T, Items.oV.n()), this.dA(), this.dC() + 1.0, this.dG(), 20, 0.2, 0.1, 0.2, 0.1);
        }
        return true;
    }

    private boolean j(DamageSource damageSource) {
        return this.ak().a(Items.oW) && !damageSource.a(DamageTypeTags.C);
    }

    @Override
    protected void t() {
        if (this.p()) {
            this.g(GenericAttributes.s).a(40.0);
            this.x(this.eS());
        } else {
            this.g(GenericAttributes.s).a(8.0);
        }
    }

    @Override
    protected void c(DamageSource damageSource, float damageAmount) {
        this.a(damageSource, damageAmount, EnumItemSlot.g);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        block16: {
            ItemStack itemInHand;
            block13: {
                ItemDye dyeItem;
                block15: {
                    block14: {
                        itemInHand = player.b(hand);
                        Item item = itemInHand.h();
                        if (!this.p()) break block13;
                        if (this.j(itemInHand) && this.eD() < this.eS()) {
                            this.a(player, hand, itemInHand);
                            FoodInfo foodProperties = itemInHand.a(DataComponents.w);
                            float f2 = foodProperties != null ? (float)foodProperties.a() : 1.0f;
                            this.heal(2.0f * f2, EntityRegainHealthEvent.RegainReason.EATING);
                            return EnumInteractionResult.a;
                        }
                        if (!(item instanceof ItemDye)) break block14;
                        dyeItem = (ItemDye)item;
                        if (this.j(player)) break block15;
                    }
                    if (this.a(itemInHand, EnumItemSlot.g) && !this.fX() && this.j(player) && !this.e_()) {
                        this.h(itemInHand.c(1));
                        itemInHand.a(1, (EntityLiving)player);
                        return EnumInteractionResult.a;
                    }
                    if (!itemInHand.a(Items.sS) || !this.j(player) || !this.fX() || EnchantmentManager.a(this.ak(), EnchantmentEffectComponents.E) && !player.b()) {
                        if (this.x() && this.fX() && this.j(player) && this.ak().n() && this.ak().b(itemInHand)) {
                            itemInHand.h(1);
                            this.a(SoundEffects.Dz);
                            ItemStack bodyArmorItem = this.ak();
                            int i2 = (int)((float)bodyArmorItem.p() * 0.125f);
                            bodyArmorItem.b(Math.max(0, bodyArmorItem.o() - i2));
                            return EnumInteractionResult.a;
                        }
                        EnumInteractionResult interactionResult = super.b(player, hand);
                        if (!interactionResult.a() && this.j(player)) {
                            this.z(!this.gs());
                            this.bm = false;
                            this.bR.m();
                            this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET, true);
                            return EnumInteractionResult.a.b();
                        }
                        return interactionResult;
                    }
                    itemInHand.a(1, (EntityLiving)player, EntityWolf.d(hand));
                    this.a(SoundEffects.az);
                    ItemStack bodyArmorItem = this.ak();
                    this.h(ItemStack.j);
                    World world = this.dV();
                    if (world instanceof WorldServer) {
                        WorldServer serverLevel = (WorldServer)world;
                        this.forceDrops = true;
                        this.a(serverLevel, bodyArmorItem);
                        this.forceDrops = false;
                    }
                    return EnumInteractionResult.a;
                }
                EnumColor dyeColor = dyeItem.b();
                if (dyeColor != this.gI()) {
                    EntityDyeEvent event = new EntityDyeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), DyeColor.getByWoolData((byte)((byte)dyeColor.a())), (Player)player.getBukkitEntity());
                    if (!event.callEvent()) {
                        return EnumInteractionResult.d;
                    }
                    dyeColor = EnumColor.a(event.getColor().getWoolData());
                    this.a(dyeColor);
                    itemInHand.a(1, (EntityLiving)player);
                    return EnumInteractionResult.a;
                }
                break block16;
            }
            if (!this.dV().C && itemInHand.a(Items.sw) && !this.ac_()) {
                itemInHand.a(1, (EntityLiving)player);
                this.g(player);
                return EnumInteractionResult.b;
            }
        }
        return super.b(player, hand);
    }

    private void g(EntityHuman player) {
        if (this.ae.a(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
            this.a(player);
            this.bR.m();
            this.h((EntityLiving)null);
            this.z(true);
            this.dV().a((Entity)this, (byte)7);
        } else {
            this.dV().a((Entity)this, (byte)6);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 8) {
            this.co = true;
            this.cp = 0.0f;
            this.cq = 0.0f;
        } else if (id == 56) {
            this.gK();
        } else {
            super.b(id);
        }
    }

    public float gH() {
        if (this.ac_()) {
            return 1.5393804f;
        }
        if (this.p()) {
            float maxHealth = this.eS();
            float f2 = (maxHealth - this.eD()) / maxHealth;
            return (0.55f - f2 * 0.4f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.ag);
    }

    @Override
    public int aj() {
        return 8;
    }

    @Override
    public int a() {
        return this.al.a(cg);
    }

    @Override
    public void a(int time) {
        this.al.a(cg, time);
    }

    @Override
    public void c() {
        this.a(cr.a(this.ae));
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cs;
    }

    @Override
    public void a(@Nullable UUID target) {
        this.cs = target;
    }

    public EnumColor gI() {
        return EnumColor.a(this.al.a(cf));
    }

    @Override
    public void a(EnumColor collarColor) {
        this.al.a(cf, collarColor.a());
    }

    @Nullable
    public EntityWolf b(WorldServer level, EntityAgeable otherParent) {
        EntityWolf wolf = EntityTypes.bL.a(level, EntitySpawnReason.e);
        if (wolf != null && otherParent instanceof EntityWolf) {
            EntityWolf wolf1 = (EntityWolf)otherParent;
            if (this.ae.h()) {
                wolf.j(this.gF());
            } else {
                wolf.j(wolf1.gF());
            }
            if (this.p()) {
                wolf.b(this.aa_());
                wolf.a(true, true);
                EnumColor collarColor = this.gI();
                EnumColor collarColor1 = wolf1.gI();
                wolf.a(EnumColor.a(level, collarColor, collarColor1));
            }
        }
        return wolf;
    }

    public void A(boolean isInterested) {
        this.al.a(ce, isInterested);
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        EntityWolf wolf;
        return otherAnimal != this && this.p() && otherAnimal instanceof EntityWolf && (wolf = (EntityWolf)otherAnimal).p() && !wolf.x() && this.gC() && wolf.gC();
    }

    public boolean gJ() {
        return this.al.a(ce);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean a(EntityLiving target, EntityLiving owner) {
        if (target instanceof EntityCreeper) return false;
        if (target instanceof EntityGhast) return false;
        if (target instanceof EntityArmorStand) {
            return false;
        }
        if (target instanceof EntityWolf) {
            EntityWolf wolf = (EntityWolf)target;
            if (!wolf.p()) return true;
            if (wolf.ag_() == owner) return false;
            return true;
        }
        if (target instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)target;
            if (owner instanceof EntityHuman) {
                EntityHuman player1 = (EntityHuman)owner;
                if (!player1.a(player)) return false;
            }
        }
        if (target instanceof EntityHorseAbstract) {
            EntityHorseAbstract abstractHorse = (EntityHorseAbstract)target;
            if (abstractHorse.gJ()) return false;
        }
        if (!(target instanceof EntityTameableAnimal)) return true;
        EntityTameableAnimal tamableAnimal = (EntityTameableAnimal)target;
        if (tamableAnimal.p()) return false;
        return true;
    }

    @Override
    public boolean y() {
        return !this.ac_();
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.6f * this.cS(), this.dq() * 0.4f);
    }

    public static boolean c(EntityTypes<EntityWolf> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.ch) && EntityWolf.a(level, pos);
    }

    class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityWolf j;

        public a(EntityWolf wolf, Class<T> entityClassToAvoid, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
            super(wolf, entityClassToAvoid, maxDist, walkSpeedModifier, sprintSpeedModifier);
            this.j = wolf;
        }

        @Override
        public boolean b() {
            return super.b() && this.b instanceof EntityLlama && !this.j.p() && this.a((EntityLlama)this.b);
        }

        private boolean a(EntityLlama llama) {
            return llama.gw() >= EntityWolf.this.ae.a(5);
        }

        @Override
        public void d() {
            EntityWolf.this.h((EntityLiving)null);
            super.d();
        }

        @Override
        public void a() {
            EntityWolf.this.h((EntityLiving)null);
            super.a();
        }
    }

    public static class b
    extends EntityAgeable.a {
        public final Holder<WolfVariant> a;

        public b(Holder<WolfVariant> type) {
            super(false);
            this.a = type;
        }
    }
}

