/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.destroystokyo.paper.event.entity.TurtleGoHomeEvent;
import com.destroystokyo.paper.event.entity.TurtleLayEggEvent;
import com.destroystokyo.paper.event.entity.TurtleStartDiggingEvent;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import io.papermc.paper.util.MCUtil;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTurtleEgg;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Turtle;

public class EntityTurtle
extends EntityAnimal {
    private static final DataWatcherObject<BlockPosition> bZ = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.o);
    private static final DataWatcherObject<Boolean> ca = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cc = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<BlockPosition> cd = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.o);
    private static final DataWatcherObject<Boolean> ce = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cf = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final float cg = 0.3f;
    private static final EntitySize ch = EntityTypes.bA.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.bA.m(), -0.25f)).a(0.3f);
    int ci;
    public static final PathfinderTargetCondition.a bY = (entity, level) -> entity.e_() && !entity.bj();

    public EntityTurtle(EntityTypes<? extends EntityTurtle> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        this.a(PathType.j, 0.0f);
        this.a(PathType.t, -1.0f);
        this.a(PathType.s, -1.0f);
        this.a(PathType.r, -1.0f);
        this.bP = new e(this);
    }

    public void h(BlockPosition homePos) {
        this.al.a(bZ, homePos);
    }

    public BlockPosition gs() {
        return this.al.a(bZ);
    }

    void i(BlockPosition travelPos) {
        this.al.a(cd, travelPos);
    }

    BlockPosition gt() {
        return this.al.a(cd);
    }

    public boolean p() {
        return this.al.a(ca);
    }

    public void x(boolean hasEgg) {
        this.al.a(ca, hasEgg);
    }

    public boolean t() {
        return this.al.a(cc);
    }

    void y(boolean isLayingEgg) {
        this.ci = isLayingEgg ? 1 : 0;
        this.al.a(cc, isLayingEgg);
    }

    public boolean gu() {
        return this.al.a(ce);
    }

    public void z(boolean isGoingHome) {
        this.al.a(ce, isGoingHome);
    }

    public boolean gv() {
        return this.al.a(cf);
    }

    public void A(boolean isTravelling) {
        this.al.a(cf, isTravelling);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bZ, BlockPosition.c);
        builder.a(ca, false);
        builder.a(cd, BlockPosition.c);
        builder.a(ce, false);
        builder.a(cf, false);
        builder.a(cc, false);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("HomePosX", this.gs().u());
        compound.a("HomePosY", this.gs().v());
        compound.a("HomePosZ", this.gs().w());
        compound.a("HasEgg", this.p());
        compound.a("TravelPosX", this.gt().u());
        compound.a("TravelPosY", this.gt().v());
        compound.a("TravelPosZ", this.gt().w());
    }

    @Override
    public void a(NBTTagCompound compound) {
        int _int = compound.h("HomePosX");
        int _int1 = compound.h("HomePosY");
        int _int2 = compound.h("HomePosZ");
        this.h(new BlockPosition(_int, _int1, _int2));
        super.a(compound);
        this.x(compound.q("HasEgg"));
        int _int3 = compound.h("TravelPosX");
        int _int4 = compound.h("TravelPosY");
        int _int5 = compound.h("TravelPosZ");
        this.i(new BlockPosition(_int3, _int4, _int5));
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.h(this.dv());
        this.i(BlockPosition.c);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public static boolean c(EntityTypes<EntityTurtle> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return pos.v() < level.P() + 4 && BlockTurtleEgg.a(level, pos) && EntityTurtle.a(level, pos);
    }

    @Override
    protected void E() {
        this.bS.a(0, new f(this, 1.2));
        this.bS.a(1, new a(this, 1.0));
        this.bS.a(1, new d(this, 1.0));
        this.bS.a(2, new PathfinderGoalTempt(this, 1.1, itemStack -> itemStack.a(TagsItem.az), false));
        this.bS.a(3, new c(this, 1.0));
        this.bS.a(4, new b(this, 1.0));
        this.bS.a(7, new i(this, 1.0));
        this.bS.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bS.a(9, new h(this, 1.0, 100));
    }

    public static AttributeProvider.Builder x() {
        return EntityAnimal.gx().a(GenericAttributes.s, 30.0).a(GenericAttributes.v, 0.25).a(GenericAttributes.B, 1.0);
    }

    @Override
    public boolean cJ() {
        return false;
    }

    @Override
    public int T() {
        return 200;
    }

    @Override
    @Nullable
    protected SoundEffect u() {
        return !this.bj() && this.aJ() && !this.e_() ? SoundEffects.AT : super.u();
    }

    @Override
    protected void f(float volume) {
        super.f(volume * 1.5f);
    }

    @Override
    protected SoundEffect aV() {
        return SoundEffects.Be;
    }

    @Override
    @Nullable
    protected SoundEffect e(DamageSource damageSource) {
        return this.e_() ? SoundEffects.Ba : SoundEffects.AZ;
    }

    @Override
    @Nullable
    public SoundEffect o_() {
        return this.e_() ? SoundEffects.AV : SoundEffects.AU;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        SoundEffect soundEvent = this.e_() ? SoundEffects.Bd : SoundEffects.Bc;
        this.a(soundEvent, 0.15f, 1.0f);
    }

    @Override
    public boolean gz() {
        return super.gz() && !this.p();
    }

    @Override
    protected float aU() {
        return this.X + 0.15f;
    }

    @Override
    public float ei() {
        return this.e_() ? 0.3f : 1.0f;
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new g(this, level);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable otherParent) {
        return EntityTypes.bA.a(level, EntitySpawnReason.e);
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.az);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        if (!this.gu() && level.b_(pos).a(TagsFluid.a)) {
            return 10.0f;
        }
        return BlockTurtleEgg.a(level, pos) ? 10.0f : level.w(pos);
    }

    @Override
    public void d_() {
        super.d_();
        if (this.bL() && this.t() && this.ci >= 1 && this.ci % 5 == 0) {
            BlockPosition blockPos = this.dv();
            if (BlockTurtleEgg.a(this.dV(), blockPos)) {
                this.dV().c(2001, blockPos, Block.j(this.dV().a_(blockPos.e())));
                ((Entity)this).a(GameEvent.u);
            }
        }
    }

    @Override
    protected void i() {
        WorldServer serverLevel;
        World world;
        super.i();
        if (!this.e_() && (world = this.dV()) instanceof WorldServer && (serverLevel = (WorldServer)world).O().b(GameRules.f)) {
            this.forceDrops = true;
            this.a(serverLevel, Items.oU, 1);
            this.forceDrops = false;
        }
    }

    @Override
    public void a_(Vec3D travelVector) {
        if (this.dh() && this.bj()) {
            this.a(0.1f, travelVector);
            this.a(EnumMoveType.a, this.dy());
            this.i(this.dy().c(0.9));
            if (!(this.O_() != null || this.gu() && this.gs().a(this.dt(), 20.0))) {
                this.i(this.dy().b(0.0, -0.005, 0.0));
            }
        } else {
            super.a_(travelVector);
        }
    }

    @Override
    public boolean y() {
        return false;
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        this.a(level, this.dW().c().eventEntityDamager(lightning), Float.MAX_VALUE);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? ch : super.e(pose);
    }

    static class e
    extends ControllerMove {
        private final EntityTurtle l;

        e(EntityTurtle mob) {
            super(mob);
            this.l = mob;
        }

        private void g() {
            if (this.l.bj()) {
                this.l.i(this.l.dy().b(0.0, 0.005, 0.0));
                if (!this.l.gs().a(this.l.dt(), 16.0)) {
                    this.l.C(Math.max(this.l.fp() / 2.0f, 0.08f));
                }
                if (this.l.e_()) {
                    this.l.C(Math.max(this.l.fp() / 3.0f, 0.06f));
                }
            } else if (this.l.aJ()) {
                this.l.C(Math.max(this.l.fp() / 2.0f, 0.06f));
            }
        }

        @Override
        public void a() {
            this.g();
            if (this.k == ControllerMove.Operation.b && !this.l.P().k()) {
                double d2;
                double d1;
                double d3 = this.e - this.l.dA();
                double squareRoot = Math.sqrt(d3 * d3 + (d1 = this.f - this.l.dC()) * d1 + (d2 = this.g - this.l.dG()) * d2);
                if (squareRoot < (double)1.0E-5f) {
                    this.d.C(0.0f);
                } else {
                    d1 /= squareRoot;
                    float f2 = (float)(MathHelper.d(d2, d3) * 180.0 / 3.1415927410125732) - 90.0f;
                    this.l.v(this.b(this.l.dL(), f2, 90.0f));
                    this.l.aX = this.l.dL();
                    float f1 = (float)(this.h * this.l.h(GenericAttributes.v));
                    this.l.C(MathHelper.h(0.125f, this.l.fp(), f1));
                    this.l.i(this.l.dy().b(0.0, (double)this.l.fp() * d1 * 0.1, 0.0));
                }
            } else {
                this.l.C(0.0f);
            }
        }
    }

    static class f
    extends PathfinderGoalPanic {
        f(EntityTurtle turtle, double speedModifier) {
            super(turtle, speedModifier);
        }

        @Override
        public boolean b() {
            if (!this.h()) {
                return false;
            }
            BlockPosition blockPos = this.a(this.c.dV(), this.c, 7);
            if (blockPos != null) {
                this.e = blockPos.u();
                this.f = blockPos.v();
                this.g = blockPos.w();
                return true;
            }
            return this.i();
        }
    }

    static class a
    extends PathfinderGoalBreed {
        private final EntityTurtle d;

        a(EntityTurtle turtle, double speedModifier) {
            super(turtle, speedModifier);
            this.d = turtle;
        }

        @Override
        public boolean b() {
            return super.b() && !this.d.p();
        }

        @Override
        protected void g() {
            EntityFertilizeEggEvent event;
            EntityPlayer loveCause = this.a.gB();
            if (loveCause == null && this.c.gB() != null) {
                loveCause = this.c.gB();
            }
            if ((event = CraftEventFactory.callEntityFertilizeEggEvent(this.a, this.c)).isCancelled()) {
                return;
            }
            if (loveCause != null) {
                loveCause.a(StatisticList.P);
                CriterionTriggers.p.a(loveCause, this.a, this.c, null);
            }
            this.d.x(true);
            this.a.c_(6000);
            this.c.c_(6000);
            this.a.gD();
            this.c.gD();
            RandomSource random = this.a.dY();
            if (net.minecraft.world.entity.animal.EntityTurtle$a.a(this.b).O().b(GameRules.f) && event.getExperience() > 0) {
                this.b.b(new EntityExperienceOrb(this.b, this.a.dA(), this.a.dC(), this.a.dG(), event.getExperience(), ExperienceOrb.SpawnReason.BREED, loveCause));
            }
        }
    }

    static class d
    extends PathfinderGoalGotoTarget {
        private final EntityTurtle g;

        d(EntityTurtle turtle, double speedModifier) {
            super(turtle, speedModifier, 16);
            this.g = turtle;
        }

        @Override
        public boolean b() {
            return this.g.p() && this.g.gs().a(this.g.dt(), 9.0) && super.b();
        }

        @Override
        public boolean c() {
            return super.c() && this.g.p() && this.g.gs().a(this.g.dt(), 9.0);
        }

        @Override
        public void a() {
            super.a();
            BlockPosition blockPos = this.g.dv();
            if (!this.g.bj() && this.m()) {
                if (this.g.ci < 1) {
                    this.g.y(new TurtleStartDiggingEvent((Turtle)this.g.getBukkitEntity(), MCUtil.toLocation(this.g.dV(), this.e)).callEvent());
                } else if (this.g.ci > this.a(200)) {
                    int eggCount = this.g.ae.a(4) + 1;
                    TurtleLayEggEvent layEggEvent = new TurtleLayEggEvent((Turtle)this.g.getBukkitEntity(), MCUtil.toLocation(this.g.dV(), this.e.d()), eggCount);
                    if (layEggEvent.callEvent() && CraftEventFactory.callEntityChangeBlockEvent(this.g, this.e.d(), (IBlockData)Blocks.mH.m().b(BlockTurtleEgg.f, layEggEvent.getEggCount()))) {
                        World level = this.g.dV();
                        level.a(null, blockPos, SoundEffects.Bb, SoundCategory.e, 0.3f, 0.9f + level.A.i() * 0.2f);
                        BlockPosition blockPos1 = this.e.d();
                        IBlockData blockState = (IBlockData)Blocks.mH.m().b(BlockTurtleEgg.f, layEggEvent.getEggCount());
                        level.a(blockPos1, blockState, 3);
                        level.a(GameEvent.i, blockPos1, GameEvent.a.a(this.g, blockState));
                    }
                    this.g.x(false);
                    this.g.y(false);
                    this.g.r(600);
                }
                if (this.g.t()) {
                    ++this.g.ci;
                }
            }
        }

        @Override
        protected boolean a(IWorldReader level, BlockPosition pos) {
            return level.u(pos.d()) && BlockTurtleEgg.b(level, pos);
        }
    }

    static class c
    extends PathfinderGoalGotoTarget {
        private static final int g = 1200;
        private final EntityTurtle h;

        c(EntityTurtle turtle, double speedModifier) {
            super(turtle, turtle.e_() ? 2.0 : speedModifier, 24);
            this.h = turtle;
            this.f = -1;
        }

        @Override
        public boolean c() {
            return !this.h.bj() && this.d <= 1200 && this.a(this.h.dV(), this.e);
        }

        @Override
        public boolean b() {
            return this.h.e_() && !this.h.bj() ? super.b() : !this.h.gu() && !this.h.bj() && !this.h.p() && super.b();
        }

        @Override
        public boolean l() {
            return this.d % 160 == 0;
        }

        @Override
        protected boolean a(IWorldReader level, BlockPosition pos) {
            return level.a_(pos).a(Blocks.J);
        }
    }

    static class b
    extends PathfinderGoal {
        private final EntityTurtle a;
        private final double b;
        private boolean c;
        private int d;
        private static final int e = 600;

        b(EntityTurtle turtle, double speedModifier) {
            this.a = turtle;
            this.b = speedModifier;
        }

        @Override
        public boolean b() {
            return !this.a.e_() && (this.a.p() || this.a.dY().a(net.minecraft.world.entity.animal.EntityTurtle$b.b(700)) == 0 && !this.a.gs().a(this.a.dt(), 64.0)) && new TurtleGoHomeEvent((Turtle)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public void d() {
            this.a.z(true);
            this.c = false;
            this.d = 0;
        }

        @Override
        public void e() {
            this.a.z(false);
        }

        @Override
        public boolean c() {
            return !this.a.gs().a(this.a.dt(), 7.0) && !this.c && this.d <= this.a(600);
        }

        @Override
        public void a() {
            BlockPosition homePos = this.a.gs();
            boolean flag = homePos.a(this.a.dt(), 16.0);
            if (flag) {
                ++this.d;
            }
            if (this.a.P().k()) {
                Vec3D vec3 = Vec3D.c(homePos);
                Vec3D posTowards = DefaultRandomPos.a((EntityCreature)this.a, 16, 3, vec3, 0.3141592741012573);
                if (posTowards == null) {
                    posTowards = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3, 1.5707963705062866);
                }
                if (posTowards != null && !flag && !this.a.dV().a_(BlockPosition.a(posTowards)).a(Blocks.J)) {
                    posTowards = DefaultRandomPos.a((EntityCreature)this.a, 16, 5, vec3, 1.5707963705062866);
                }
                if (posTowards == null) {
                    this.c = true;
                    return;
                }
                this.a.P().a(posTowards.d, posTowards.e, posTowards.f, this.b);
            }
        }
    }

    static class i
    extends PathfinderGoal {
        private final EntityTurtle a;
        private final double b;
        private boolean c;

        i(EntityTurtle turtle, double speedModifier) {
            this.a = turtle;
            this.b = speedModifier;
        }

        @Override
        public boolean b() {
            return !this.a.gu() && !this.a.p() && this.a.bj();
        }

        @Override
        public void d() {
            int i2 = 512;
            int i1 = 4;
            RandomSource randomSource = this.a.ae;
            int i22 = randomSource.a(1025) - 512;
            int i3 = randomSource.a(9) - 4;
            int i4 = randomSource.a(1025) - 512;
            if ((double)i3 + this.a.dC() > (double)(this.a.dV().P() - 1)) {
                i3 = 0;
            }
            BlockPosition blockPos = BlockPosition.a((double)i22 + this.a.dA(), (double)i3 + this.a.dC(), (double)i4 + this.a.dG());
            this.a.i(blockPos);
            this.a.A(true);
            this.c = false;
        }

        @Override
        public void a() {
            if (this.a.P().k()) {
                Vec3D vec3 = Vec3D.c(this.a.gt());
                Vec3D posTowards = DefaultRandomPos.a((EntityCreature)this.a, 16, 3, vec3, 0.3141592741012573);
                if (posTowards == null) {
                    posTowards = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3, 1.5707963705062866);
                }
                if (posTowards != null) {
                    int floor = MathHelper.a(posTowards.d);
                    int floor1 = MathHelper.a(posTowards.f);
                    int i2 = 34;
                    if (!this.a.dV().b(floor - 34, floor1 - 34, floor + 34, floor1 + 34)) {
                        posTowards = null;
                    }
                }
                if (posTowards == null) {
                    this.c = true;
                    return;
                }
                this.a.P().a(posTowards.d, posTowards.e, posTowards.f, this.b);
            }
        }

        @Override
        public boolean c() {
            return !this.a.P().k() && !this.c && !this.a.gu() && !this.a.gC() && !this.a.p();
        }

        @Override
        public void e() {
            this.a.A(false);
            super.e();
        }
    }

    static class h
    extends PathfinderGoalRandomStroll {
        private final EntityTurtle i;

        h(EntityTurtle turtle, double speedModifier, int interval) {
            super(turtle, speedModifier, interval);
            this.i = turtle;
        }

        @Override
        public boolean b() {
            return !this.b.bj() && !this.i.gu() && !this.i.p() && super.b();
        }
    }

    static class g
    extends AmphibiousPathNavigation {
        g(EntityTurtle turtle, World level) {
            super(turtle, level);
        }

        @Override
        public boolean a(BlockPosition pos) {
            EntityTurtle turtle;
            EntityInsentient entityInsentient = this.a;
            return entityInsentient instanceof EntityTurtle && (turtle = (EntityTurtle)entityInsentient).gv() ? this.b.a_(pos).a(Blocks.J) : !this.b.a_(pos.e()).l();
        }
    }
}

