/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.Codec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;

public class EntityTropicalFish
extends EntityFishSchool
implements VariantHolder<Variant> {
    public static final String a = "BucketVariantTag";
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityTropicalFish.class, DataWatcherRegistry.b);
    public static final List<d> b = List.of(new d(Variant.h, EnumColor.b, EnumColor.h), new d(Variant.g, EnumColor.h, EnumColor.h), new d(Variant.g, EnumColor.h, EnumColor.l), new d(Variant.l, EnumColor.a, EnumColor.h), new d(Variant.b, EnumColor.l, EnumColor.h), new d(Variant.a, EnumColor.b, EnumColor.a), new d(Variant.f, EnumColor.g, EnumColor.d), new d(Variant.j, EnumColor.k, EnumColor.e), new d(Variant.l, EnumColor.a, EnumColor.o), new d(Variant.f, EnumColor.a, EnumColor.e), new d(Variant.i, EnumColor.a, EnumColor.h), new d(Variant.l, EnumColor.a, EnumColor.b), new d(Variant.d, EnumColor.j, EnumColor.g), new d(Variant.e, EnumColor.f, EnumColor.d), new d(Variant.k, EnumColor.o, EnumColor.a), new d(Variant.c, EnumColor.h, EnumColor.o), new d(Variant.j, EnumColor.o, EnumColor.a), new d(Variant.g, EnumColor.a, EnumColor.e), new d(Variant.a, EnumColor.o, EnumColor.a), new d(Variant.b, EnumColor.h, EnumColor.a), new d(Variant.d, EnumColor.j, EnumColor.e), new d(Variant.g, EnumColor.e, EnumColor.e));
    private boolean bY = true;

    public EntityTropicalFish(EntityTypes<? extends EntityTropicalFish> entityType, World level) {
        super((EntityTypes<? extends EntityFishSchool>)entityType, level);
    }

    public static String b(int variantId) {
        return "entity.minecraft.tropical_fish.predefined." + variantId;
    }

    static int a(Variant pattern, EnumColor baseColor, EnumColor patternColor) {
        return pattern.b() & 0xFFFF | (baseColor.a() & 0xFF) << 16 | (patternColor.a() & 0xFF) << 24;
    }

    public static EnumColor c(int variantId) {
        return EnumColor.a(variantId >> 16 & 0xFF);
    }

    public static EnumColor r(int variantId) {
        return EnumColor.a(variantId >> 24 & 0xFF);
    }

    public static Variant s(int variantId) {
        return Variant.a(variantId & 0xFFFF);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, 0);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("Variant", this.gD());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.u(compound.h("Variant"));
    }

    public void u(int packedVariant) {
        this.al.a(c, packedVariant);
    }

    @Override
    public boolean q(int size) {
        return !this.bY;
    }

    public int gD() {
        return this.al.a(c);
    }

    public EnumColor gA() {
        return EntityTropicalFish.c(this.gD());
    }

    public EnumColor gB() {
        return EntityTropicalFish.r(this.gD());
    }

    public Variant gC() {
        return EntityTropicalFish.s(this.gD());
    }

    @Override
    public void a(Variant variant) {
        int packedVariant = this.gD();
        EnumColor baseColor = EntityTropicalFish.c(packedVariant);
        EnumColor patternColor = EntityTropicalFish.r(packedVariant);
        this.u(EntityTropicalFish.a(variant, baseColor, patternColor));
    }

    @Override
    public void i(ItemStack stack) {
        super.i(stack);
        CustomData.a(DataComponents.X, stack, (NBTTagCompound compoundTag) -> compoundTag.a(a, this.gD()));
    }

    @Override
    public ItemStack W_() {
        return new ItemStack(Items.rp);
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.AA;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.AB;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.AD;
    }

    @Override
    protected SoundEffect gs() {
        return SoundEffects.AC;
    }

    @Override
    public void h(NBTTagCompound tag) {
        super.h(tag);
        if (tag.b(a, 3)) {
            this.u(tag.h(a));
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        d variant;
        spawnGroupData = super.a(level, difficulty, spawnReason, spawnGroupData);
        RandomSource random = level.H_();
        if (spawnGroupData instanceof c) {
            c tropicalFishGroupData = (c)spawnGroupData;
            variant = tropicalFishGroupData.b;
        } else if ((double)random.i() < 0.9) {
            variant = SystemUtils.a(b, random);
            spawnGroupData = new c(this, variant);
        } else {
            this.bY = false;
            Variant[] patterns = Variant.values();
            EnumColor[] dyeColors = EnumColor.values();
            Variant pattern = SystemUtils.a(patterns, random);
            EnumColor dyeColor = SystemUtils.a(dyeColors, random);
            EnumColor dyeColor1 = SystemUtils.a(dyeColors, random);
            variant = new d(pattern, dyeColor, dyeColor1);
        }
        this.u(variant.a());
        return spawnGroupData;
    }

    public static boolean b(EntityTypes<EntityTropicalFish> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.b_(pos.e()).a(TagsFluid.a) && level.a_(pos.d()).a(Blocks.J) && (level.t(pos).a(BiomeTags.an) || EntityWaterAnimal.c(entityType, level, spawnReason, pos, random));
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable {
        public static final /* enum */ Variant a = new Variant("kob", Base.a, 0);
        public static final /* enum */ Variant b = new Variant("sunstreak", Base.a, 1);
        public static final /* enum */ Variant c = new Variant("snooper", Base.a, 2);
        public static final /* enum */ Variant d = new Variant("dasher", Base.a, 3);
        public static final /* enum */ Variant e = new Variant("brinely", Base.a, 4);
        public static final /* enum */ Variant f = new Variant("spotty", Base.a, 5);
        public static final /* enum */ Variant g = new Variant("flopper", Base.b, 0);
        public static final /* enum */ Variant h = new Variant("stripey", Base.b, 1);
        public static final /* enum */ Variant i = new Variant("glitter", Base.b, 2);
        public static final /* enum */ Variant j = new Variant("blockfish", Base.b, 3);
        public static final /* enum */ Variant k = new Variant("betty", Base.b, 4);
        public static final /* enum */ Variant l = new Variant("clayfish", Base.b, 5);
        public static final Codec<Variant> m;
        private static final IntFunction<Variant> n;
        private final String o;
        private final IChatBaseComponent p;
        private final Base q;
        private final int r;
        private static final /* synthetic */ Variant[] s;

        public static Variant[] values() {
            return (Variant[])s.clone();
        }

        public static Variant valueOf(String name) {
            return Enum.valueOf(Variant.class, name);
        }

        private Variant(String name, Base base, int id) {
            this.o = name;
            this.q = base;
            this.r = base.c | id << 8;
            this.p = IChatBaseComponent.c("entity.minecraft.tropical_fish.type." + this.o);
        }

        public static Variant a(int packedId) {
            return n.apply(packedId);
        }

        public Base a() {
            return this.q;
        }

        public int b() {
            return this.r;
        }

        @Override
        public String c() {
            return this.o;
        }

        public IChatBaseComponent d() {
            return this.p;
        }

        private static /* synthetic */ Variant[] e() {
            return new Variant[]{a, b, c, d, e, f, g, h, i, j, k, l};
        }

        static {
            s = Variant.e();
            m = INamable.a(Variant::values);
            n = ByIdMap.a(Variant::b, Variant.values(), a);
        }
    }

    static class c
    extends EntityFishSchool.a {
        final d b;

        c(EntityTropicalFish leader, d variant) {
            super(leader);
            this.b = variant;
        }
    }

    public record d(Variant b, EnumColor c, EnumColor d) {
        public static final Codec<d> a = Codec.INT.xmap(d::new, d::a);

        public d(int id) {
            this(EntityTropicalFish.s(id), EntityTropicalFish.c(id), EntityTropicalFish.r(id));
        }

        public int a() {
            return EntityTropicalFish.a(this.b, this.c, this.d);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "pattern;baseColor;patternColor", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "pattern;baseColor;patternColor", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "pattern;baseColor;patternColor", "b", "c", "d"}, this, o2);
        }
    }

    public static final class Base
    extends Enum<Base> {
        public static final /* enum */ Base a = new Base(0);
        public static final /* enum */ Base b = new Base(1);
        final int c;
        private static final /* synthetic */ Base[] d;

        public static Base[] values() {
            return (Base[])d.clone();
        }

        public static Base valueOf(String name) {
            return Enum.valueOf(Base.class, name);
        }

        private Base(int id) {
            this.c = id;
        }

        private static /* synthetic */ Base[] a() {
            return new Base[]{a, b};
        }

        static {
            d = Base.a();
        }
    }
}

