/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.animal.AgeableWaterCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3D;

public class EntitySquid
extends AgeableWaterCreature {
    public float bY;
    public float bZ;
    public float ca;
    public float cb;
    public float cc;
    public float cd;
    public float ce;
    public float cf;
    private float cg;
    private float ch;
    private float ci;
    Vec3D cj = Vec3D.c;

    public EntitySquid(EntityTypes<? extends EntitySquid> entityType, World level) {
        super((EntityTypes<? extends AgeableWaterCreature>)entityType, level);
        this.ch = 1.0f / (this.ae.i() + 1.0f) * 0.2f;
    }

    @Override
    protected void E() {
        this.bS.a(0, new PathfinderGoalSquid(this));
        this.bS.a(1, new a());
    }

    public static AttributeProvider.Builder gs() {
        return EntityInsentient.F().a(GenericAttributes.s, 10.0);
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.zN;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.zP;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.zO;
    }

    protected SoundEffect t() {
        return SoundEffects.zQ;
    }

    @Override
    public boolean y() {
        return true;
    }

    @Override
    public float fg() {
        return 0.4f;
    }

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.c;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable otherParent) {
        return EntityTypes.bq.a(level, EntitySpawnReason.e);
    }

    @Override
    protected double bd() {
        return 0.08;
    }

    @Override
    public void d_() {
        super.d_();
        this.bZ = this.bY;
        this.cb = this.ca;
        this.cd = this.cc;
        this.cf = this.ce;
        this.cc += this.ch;
        if ((double)this.cc > Math.PI * 2) {
            if (this.dV().C) {
                this.cc = (float)Math.PI * 2;
            } else {
                this.cc -= (float)Math.PI * 2;
                if (this.ae.a(10) == 0) {
                    this.ch = 1.0f / (this.ae.i() + 1.0f) * 0.2f;
                }
                this.dV().a((Entity)this, (byte)19);
            }
        }
        if (this.bm()) {
            if (this.cc < (float)Math.PI) {
                float f2 = this.cc / (float)Math.PI;
                this.ce = MathHelper.a(f2 * f2 * (float)Math.PI) * (float)Math.PI * 0.25f;
                if ((double)f2 > 0.75) {
                    if (this.dh()) {
                        this.i(this.cj);
                    }
                    this.ci = 1.0f;
                } else {
                    this.ci *= 0.8f;
                }
            } else {
                this.ce = 0.0f;
                if (this.dh()) {
                    this.i(this.dy().c(0.9));
                }
                this.ci *= 0.99f;
            }
            Vec3D deltaMovement = this.dy();
            double d2 = deltaMovement.i();
            this.aX += (-((float)MathHelper.d(deltaMovement.d, deltaMovement.f)) * 57.295776f - this.aX) * 0.1f;
            this.v(this.aX);
            this.ca += (float)Math.PI * this.ci * 1.5f;
            this.bY += (-((float)MathHelper.d(d2, deltaMovement.e)) * 57.295776f - this.bY) * 0.1f;
        } else {
            this.ce = MathHelper.e(MathHelper.a(this.cc)) * (float)Math.PI * 0.25f;
            if (!this.dV().C) {
                double d1 = this.dy().e;
                d1 = this.b(MobEffects.y) ? 0.05 * (double)(this.c(MobEffects.y).e() + 1) : (d1 -= this.be());
                this.n(0.0, d1 * (double)0.98f, 0.0);
            }
            this.bY += (-90.0f - this.bY) * 0.02f;
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (super.a(level, damageSource, amount) && this.ep() != null) {
            this.x();
            return true;
        }
        return false;
    }

    private Vec3D l(Vec3D vector) {
        Vec3D vec3 = vector.a(this.bZ * ((float)Math.PI / 180));
        return vec3.b(-this.aY * ((float)Math.PI / 180));
    }

    private void x() {
        this.b(this.t());
        Vec3D vec3 = this.l(new Vec3D(0.0, -1.0, 0.0)).b(this.dA(), this.dC(), this.dG());
        for (int i2 = 0; i2 < 30; ++i2) {
            Vec3D vec31 = this.l(new Vec3D((double)this.ae.i() * 0.6 - 0.3, -1.0, (double)this.ae.i() * 0.6 - 0.3));
            float f2 = this.e_() ? 0.1f : 0.3f;
            Vec3D vec32 = vec31.c((double)(f2 + this.ae.i() * 2.0f));
            ((WorldServer)this.dV()).a(this.p(), vec3.d, vec3.e + 0.5, vec3.f, 0, vec32.d, vec32.e, vec32.f, (double)0.1f);
        }
    }

    protected ParticleParam p() {
        return Particles.ak;
    }

    @Override
    public void a_(Vec3D travelVector) {
        if (this.dh()) {
            this.a(EnumMoveType.a, this.dy());
        }
    }

    @Override
    public void b(byte id) {
        if (id == 19) {
            this.cc = 0.0f;
        } else {
            super.b(id);
        }
    }

    public boolean gt() {
        return this.cj.h() > (double)1.0E-5f;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        GroupDataEntity spawnGroupData1 = Objects.requireNonNullElseGet(spawnGroupData, () -> new EntityAgeable.a(0.05f));
        return super.a(level, difficulty, spawnReason, spawnGroupData1);
    }

    static class PathfinderGoalSquid
    extends PathfinderGoal {
        private final EntitySquid a;

        public PathfinderGoalSquid(EntitySquid squid) {
            this.a = squid;
        }

        @Override
        public boolean b() {
            return true;
        }

        @Override
        public void a() {
            int noActionTime = this.a.et();
            if (noActionTime > 100) {
                this.a.cj = Vec3D.c;
            } else if (this.a.dY().a(PathfinderGoalSquid.b(50)) == 0 || !this.a.ag || !this.a.gt()) {
                float f2 = this.a.dY().i() * ((float)Math.PI * 2);
                this.a.cj = new Vec3D(MathHelper.b(f2) * 0.2f, -0.1f + this.a.dY().i() * 0.2f, MathHelper.a(f2) * 0.2f);
            }
        }
    }

    class a
    extends PathfinderGoal {
        private static final float b = 3.0f;
        private static final float c = 5.0f;
        private static final float d = 10.0f;
        private int e;

        a() {
        }

        @Override
        public boolean b() {
            EntityLiving lastHurtByMob = EntitySquid.this.ep();
            return EntitySquid.this.bj() && lastHurtByMob != null && EntitySquid.this.g((Entity)lastHurtByMob) < 100.0;
        }

        @Override
        public void d() {
            this.e = 0;
        }

        @Override
        public boolean V_() {
            return true;
        }

        @Override
        public void a() {
            ++this.e;
            EntityLiving lastHurtByMob = EntitySquid.this.ep();
            if (lastHurtByMob != null) {
                Vec3D vec3 = new Vec3D(EntitySquid.this.dA() - lastHurtByMob.dA(), EntitySquid.this.dC() - lastHurtByMob.dC(), EntitySquid.this.dG() - lastHurtByMob.dG());
                IBlockData blockState = EntitySquid.this.dV().a_(BlockPosition.a(EntitySquid.this.dA() + vec3.d, EntitySquid.this.dC() + vec3.e, EntitySquid.this.dG() + vec3.f));
                Fluid fluidState = EntitySquid.this.dV().b_(BlockPosition.a(EntitySquid.this.dA() + vec3.d, EntitySquid.this.dC() + vec3.e, EntitySquid.this.dG() + vec3.f));
                if (fluidState.a(TagsFluid.a) || blockState.l()) {
                    double len = vec3.g();
                    if (len > 0.0) {
                        vec3.d();
                        double d2 = 3.0;
                        if (len > 5.0) {
                            d2 -= (len - 5.0) / 5.0;
                        }
                        if (d2 > 0.0) {
                            vec3 = vec3.c(d2);
                        }
                    }
                    if (blockState.l()) {
                        vec3 = vec3.a(0.0, vec3.e, 0.0);
                    }
                    EntitySquid.this.cj = new Vec3D(vec3.d / 20.0, vec3.e / 20.0, vec3.f / 20.0);
                }
                if (this.e % 10 == 5) {
                    EntitySquid.this.dV().a(Particles.d, EntitySquid.this.dA(), EntitySquid.this.dC(), EntitySquid.this.dG(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

