/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalEatTile;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.entity.Sheep;
import org.bukkit.event.entity.SheepRegrowWoolEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;

public class EntitySheep
extends EntityAnimal
implements IShearable {
    private static final int bY = 40;
    private static final DataWatcherObject<Byte> bZ = DataWatcher.a(EntitySheep.class, DataWatcherRegistry.a);
    private static final Map<EnumColor, Integer> ca = Maps.newEnumMap(Arrays.stream(EnumColor.values()).collect(Collectors.toMap(dyeColor -> dyeColor, EntitySheep::c)));
    private int cc;
    private PathfinderGoalEatTile cd;

    private static int c(EnumColor dyeColor) {
        if (dyeColor == EnumColor.a) {
            return -1644826;
        }
        int textureDiffuseColor = dyeColor.d();
        float f2 = 0.75f;
        return ARGB.a(255, MathHelper.d((float)ARGB.b(textureDiffuseColor) * 0.75f), MathHelper.d((float)ARGB.c(textureDiffuseColor) * 0.75f), MathHelper.d((float)ARGB.d(textureDiffuseColor) * 0.75f));
    }

    public static int a(EnumColor dyeColor) {
        return ca.get(dyeColor);
    }

    public EntitySheep(EntityTypes<? extends EntitySheep> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
    }

    @Override
    protected void E() {
        this.cd = new PathfinderGoalEatTile(this);
        this.bS.a(0, new PathfinderGoalFloat(this));
        this.bS.a(1, new PathfinderGoalPanic(this, 1.25));
        this.bS.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bS.a(3, new PathfinderGoalTempt(this, 1.1, stack -> stack.a(TagsItem.af), false));
        this.bS.a(4, new PathfinderGoalFollowParent(this, 1.1));
        this.bS.a(5, this.cd);
        this.bS.a(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bS.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bS.a(8, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.af);
    }

    @Override
    protected void a(WorldServer level) {
        this.cc = this.cd.h();
        super.a(level);
    }

    @Override
    public void d_() {
        if (this.dV().C) {
            this.cc = Math.max(0, this.cc - 1);
        }
        super.d_();
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gx().a(GenericAttributes.s, 8.0).a(GenericAttributes.v, 0.23f);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bZ, (byte)0);
    }

    @Override
    public void b(byte id) {
        if (id == 10) {
            this.cc = 40;
        } else {
            super.b(id);
        }
    }

    public float J(float partialTick) {
        if (this.cc <= 0) {
            return 0.0f;
        }
        if (this.cc >= 4 && this.cc <= 36) {
            return 1.0f;
        }
        return this.cc < 4 ? ((float)this.cc - partialTick) / 4.0f : -((float)(this.cc - 40) - partialTick) / 4.0f;
    }

    public float K(float partialTick) {
        if (this.cc > 4 && this.cc <= 36) {
            float f2 = ((float)(this.cc - 4) - partialTick) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.a(f2 * 28.7f);
        }
        return this.cc > 0 ? 0.62831855f : this.dN() * ((float)Math.PI / 180);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.sS)) {
            World world = this.dV();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                if (this.a()) {
                    List<ItemStack> drops = this.generateDefaultDrops(serverLevel, itemInHand);
                    PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemInHand, hand, drops);
                    if (event != null) {
                        if (event.isCancelled()) {
                            return EnumInteractionResult.e;
                        }
                        drops = CraftItemStack.asNMSCopy(event.getDrops());
                    }
                    this.shear(serverLevel, SoundCategory.h, itemInHand, drops);
                    this.a(GameEvent.M, (Entity)player);
                    itemInHand.a(1, (EntityLiving)player, EntitySheep.d(hand));
                    return EnumInteractionResult.b;
                }
            }
            return EnumInteractionResult.c;
        }
        return super.b(player, hand);
    }

    @Override
    public void a(WorldServer level, SoundCategory soundSource, ItemStack shears) {
        this.shear(level, soundSource, shears, this.generateDefaultDrops(level, shears));
    }

    @Override
    public List<ItemStack> generateDefaultDrops(WorldServer serverLevel, ItemStack shears) {
        ObjectArrayList drops = new ObjectArrayList();
        this.a(serverLevel, LootTables.aV, shears, (arg_0, arg_1) -> EntitySheep.lambda$generateDefaultDrops$2((List)drops, arg_0, arg_1));
        return drops;
    }

    @Override
    public void shear(WorldServer level, SoundCategory soundSource, ItemStack shears, List<ItemStack> drops) {
        level.a(null, this, SoundEffects.xb, soundSource, 1.0f, 1.0f);
        drops.forEach(itemStack -> {
            this.forceDrops = true;
            EntityItem itemEntity = this.a(level, (ItemStack)itemStack, 1.0f);
            this.forceDrops = false;
            if (itemEntity != null) {
                itemEntity.i(itemEntity.dy().b((this.ae.i() - this.ae.i()) * 0.1f, this.ae.i() * 0.05f, (this.ae.i() - this.ae.i()) * 0.1f));
            }
        });
        this.x(true);
    }

    @Override
    public boolean a() {
        return this.bL() && !this.x() && !this.e_();
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("Sheared", this.x());
        compound.a("Color", (byte)this.t().a());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.x(compound.q("Sheared"));
        this.b(EnumColor.a(compound.f("Color")));
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.wY;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.xa;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.wZ;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.xc, 0.15f, 1.0f);
    }

    public EnumColor t() {
        return EnumColor.a(this.al.a(bZ) & 0xF);
    }

    public void b(EnumColor dyeColor) {
        byte b2 = this.al.a(bZ);
        this.al.a(bZ, (byte)(b2 & 0xF0 | dyeColor.a() & 0xF));
    }

    public boolean x() {
        return (this.al.a(bZ) & 0x10) != 0;
    }

    public void x(boolean sheared) {
        byte b2 = this.al.a(bZ);
        if (sheared) {
            this.al.a(bZ, (byte)(b2 | 0x10));
        } else {
            this.al.a(bZ, (byte)(b2 & 0xFFFFFFEF));
        }
    }

    public static EnumColor a(RandomSource random) {
        int randomInt = random.a(100);
        if (randomInt < 5) {
            return EnumColor.p;
        }
        if (randomInt < 10) {
            return EnumColor.h;
        }
        if (randomInt < 15) {
            return EnumColor.i;
        }
        if (randomInt < 18) {
            return EnumColor.m;
        }
        return random.a(500) == 0 ? EnumColor.g : EnumColor.a;
    }

    @Nullable
    public EntitySheep b(WorldServer level, EntityAgeable otherParent) {
        EntitySheep sheep = EntityTypes.ba.a(level, EntitySpawnReason.e);
        if (sheep != null) {
            EnumColor color = this.t();
            EnumColor color1 = ((EntitySheep)otherParent).t();
            sheep.b(EnumColor.a(level, color, color1));
        }
        return sheep;
    }

    @Override
    public void S() {
        if (!new SheepRegrowWoolEvent((Sheep)this.getBukkitEntity()).callEvent()) {
            return;
        }
        super.S();
        this.x(false);
        if (this.e_()) {
            this.b_(60);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.b(EntitySheep.a(level.H_()));
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    private static /* synthetic */ void lambda$generateDefaultDrops$2(List drops, WorldServer ignored, ItemStack stack) {
        for (int i2 = 0; i2 < stack.M(); ++i2) {
            drops.add(stack.c(1));
        }
    }
}

