/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.event.entity.PufferFishStateChangeEvent;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import org.bukkit.entity.PufferFish;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntityPufferFish
extends EntityFish {
    private static final DataWatcherObject<Integer> bY = DataWatcher.a(EntityPufferFish.class, DataWatcherRegistry.b);
    int bZ;
    int ca;
    private static final PathfinderTargetCondition.a cb = (entity, level) -> {
        EntityHuman player;
        return (!(entity instanceof EntityHuman) || !(player = (EntityHuman)entity).b()) && !entity.aq().a(TagsEntity.A);
    };
    static final PathfinderTargetCondition cc = PathfinderTargetCondition.b().e().d().a(cb);
    public static final int a = 0;
    public static final int b = 1;
    public static final int c = 2;

    public EntityPufferFish(EntityTypes<? extends EntityPufferFish> entityType, World level) {
        super((EntityTypes<? extends EntityFish>)entityType, level);
        this.m_();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bY, 0);
    }

    public int gt() {
        return this.al.a(bY);
    }

    public void b(int puffState) {
        this.al.a(bY, puffState);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (bY.equals(key)) {
            this.m_();
        }
        super.a(key);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("PuffState", this.gt());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.b(Math.min(compound.h("PuffState"), 2));
    }

    @Override
    public ItemStack W_() {
        return new ItemStack(Items.rm);
    }

    @Override
    protected void E() {
        super.E();
        this.bS.a(1, new a(this));
    }

    @Override
    public void h() {
        if (!this.dV().C && this.bL() && this.dj()) {
            if (this.bZ > 0) {
                boolean increase = true;
                if (this.gt() == 0) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 1).callEvent()) {
                        this.b(SoundEffects.vr);
                        this.b(1);
                    } else {
                        increase = false;
                    }
                } else if (this.bZ > 40 && this.gt() == 1) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 2).callEvent()) {
                        this.b(SoundEffects.vr);
                        this.b(2);
                    } else {
                        increase = false;
                    }
                }
                if (increase) {
                    ++this.bZ;
                }
            } else if (this.gt() != 0) {
                boolean increase = true;
                if (this.ca > 60 && this.gt() == 2) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 1).callEvent()) {
                        this.b(SoundEffects.vq);
                        this.b(1);
                    } else {
                        increase = false;
                    }
                } else if (this.ca > 100 && this.gt() == 1) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 0).callEvent()) {
                        this.b(SoundEffects.vq);
                        this.b(0);
                    } else {
                        increase = false;
                    }
                }
                if (increase) {
                    ++this.ca;
                }
            }
        }
        super.h();
    }

    @Override
    public void d_() {
        super.d_();
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.bL() && this.gt() > 0) {
                for (EntityInsentient mob : this.dV().a(EntityInsentient.class, this.cR().g(0.3), (? super T mob1) -> cc.a(serverLevel, this, (EntityLiving)mob1))) {
                    if (!mob.bL()) continue;
                    this.a(serverLevel, mob);
                }
            }
        }
    }

    private void a(WorldServer level, EntityInsentient mob) {
        int puffState = this.gt();
        if (mob.a(level, this.dW().b(this), (float)(1 + puffState))) {
            mob.addEffect(new MobEffect(MobEffects.s, 60 * puffState, 0), this, EntityPotionEffectEvent.Cause.ATTACK);
            this.a(SoundEffects.vv, 1.0f, 1.0f);
        }
    }

    @Override
    public void a_(EntityHuman entity) {
        int puffState = this.gt();
        if (entity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            if (puffState > 0 && entity.a(serverPlayer.y(), this.dW().b(this), (float)(1 + puffState))) {
                if (!this.bb()) {
                    serverPlayer.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.k, 0.0f));
                }
                entity.addEffect(new MobEffect(MobEffects.s, 60 * puffState, 0), this, EntityPotionEffectEvent.Cause.ATTACK);
            }
        }
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.vp;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.vs;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.vu;
    }

    @Override
    protected SoundEffect gs() {
        return SoundEffects.vt;
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return super.e(pose).a(EntityPufferFish.c(this.gt()));
    }

    private static float c(int puffState) {
        switch (puffState) {
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 0.7f;
            }
        }
        return 1.0f;
    }

    static class a
    extends PathfinderGoal {
        private final EntityPufferFish a;

        public a(EntityPufferFish fish) {
            this.a = fish;
        }

        @Override
        public boolean b() {
            List<EntityLiving> entitiesOfClass = this.a.dV().a(EntityLiving.class, this.a.cR().g(2.0), entity -> cc.a(net.minecraft.world.entity.animal.EntityPufferFish$a.a(this.a), this.a, (EntityLiving)entity));
            return !entitiesOfClass.isEmpty();
        }

        @Override
        public void d() {
            this.a.bZ = 1;
            this.a.ca = 0;
        }

        @Override
        public void e() {
            this.a.bZ = 0;
        }
    }
}

