/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityPig
extends EntityAnimal
implements ISteerable,
ISaddleable {
    private static final DataWatcherObject<Boolean> bY = DataWatcher.a(EntityPig.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> bZ = DataWatcher.a(EntityPig.class, DataWatcherRegistry.b);
    public final SaddleStorage ca;

    public EntityPig(EntityTypes<? extends EntityPig> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        this.ca = new SaddleStorage(this.al, bZ, bY);
    }

    @Override
    protected void E() {
        this.bS.a(0, new PathfinderGoalFloat(this));
        this.bS.a(1, new PathfinderGoalPanic(this, 1.25));
        this.bS.a(3, new PathfinderGoalBreed(this, 1.0));
        this.bS.a(4, new PathfinderGoalTempt(this, 1.2, itemStack -> itemStack.a(Items.ot), false));
        this.bS.a(4, new PathfinderGoalTempt(this, 1.2, itemStack -> itemStack.a(TagsItem.av), false));
        this.bS.a(5, new PathfinderGoalFollowParent(this, 1.1));
        this.bS.a(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bS.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bS.a(8, new PathfinderGoalRandomLookaround(this));
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gx().a(GenericAttributes.s, 10.0).a(GenericAttributes.v, 0.25);
    }

    @Override
    @Nullable
    public EntityLiving cW() {
        EntityHuman player;
        Entity entity;
        return this.j() && (entity = this.cZ()) instanceof EntityHuman && (player = (EntityHuman)entity).b(Items.ot) ? player : super.cW();
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (bZ.equals(key) && this.dV().C) {
            this.ca.a();
        }
        super.a(key);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bY, false);
        builder.a(bZ, 0);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        this.ca.a(compound);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.ca.b(compound);
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.ua;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.uc;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.ub;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.ue, 0.15f, 1.0f);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean isFood = this.j(player.b(hand));
        if (!isFood && this.j() && !this.ca() && !player.fY()) {
            if (!this.dV().C) {
                player.n(this);
            }
            return EnumInteractionResult.a;
        }
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (!interactionResult.a()) {
            ItemStack itemInHand = player.b(hand);
            return itemInHand.a(Items.on) ? itemInHand.a(player, (EntityLiving)this, hand) : EnumInteractionResult.e;
        }
        return interactionResult;
    }

    @Override
    public boolean f() {
        return this.bL() && !this.e_();
    }

    @Override
    protected void f(WorldServer level) {
        super.f(level);
        if (this.j()) {
            this.a(level, Items.on);
        }
    }

    @Override
    public boolean j() {
        return this.ca.d();
    }

    @Override
    public void a(ItemStack stack, @Nullable SoundCategory soundSource) {
        this.ca.a(true);
        if (soundSource != null) {
            this.dV().a(null, this, SoundEffects.ud, soundSource, 0.5f, 1.0f);
        }
    }

    @Override
    public Vec3D b(EntityLiving livingEntity) {
        EnumDirection motionDirection = this.cP();
        if (motionDirection.o() == EnumDirection.EnumAxis.b) {
            return super.b(livingEntity);
        }
        int[][] ints = DismountUtil.a(motionDirection);
        BlockPosition blockPos = this.dv();
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (EntityPose pose : livingEntity.fO()) {
            AxisAlignedBB localBoundsForPose = livingEntity.f(pose);
            for (int[] ints1 : ints) {
                mutableBlockPos.d(blockPos.u() + ints1[0], blockPos.v(), blockPos.w() + ints1[1]);
                double blockFloorHeight = this.dV().j(mutableBlockPos);
                if (!DismountUtil.a(blockFloorHeight)) continue;
                Vec3D vec3 = Vec3D.a(mutableBlockPos, blockFloorHeight);
                if (!DismountUtil.a(this.dV(), livingEntity, localBoundsForPose.c(vec3))) continue;
                livingEntity.b(pose);
                return vec3;
            }
        }
        return super.b(livingEntity);
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        if (level.am() != EnumDifficulty.a) {
            EntityPigZombie zombifiedPiglin = this.convertTo(EntityTypes.bQ, ConversionParams.a(this, false, true), (T mob) -> {
                if (this.eZ().f()) {
                    mob.a(EnumItemSlot.a, new ItemStack(Items.pB));
                }
                mob.fY();
            }, null, null);
            if (CraftEventFactory.callPigZapEvent(this, lightning, zombifiedPiglin).isCancelled()) {
                return;
            }
            level.addFreshEntity(zombifiedPiglin, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
            if (zombifiedPiglin == null) {
                super.a(level, lightning);
            }
        } else {
            super.a(level, lightning);
        }
    }

    @Override
    protected void a(EntityHuman player, Vec3D travelVector) {
        super.a(player, travelVector);
        this.b(player.dL(), player.dN() * 0.5f);
        this.aX = this.aZ = this.dL();
        this.N = this.aZ;
        this.ca.b();
    }

    @Override
    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float e(EntityHuman player) {
        return (float)(this.h(GenericAttributes.v) * 0.225 * (double)this.ca.c());
    }

    @Override
    public boolean a() {
        return this.ca.a(this.dY());
    }

    @Nullable
    public EntityPig b(WorldServer level, EntityAgeable otherParent) {
        return EntityTypes.aQ.a(level, EntitySpawnReason.e);
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.av);
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.6f * this.cS(), this.dq() * 0.4f);
    }
}

