/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPerch;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityPerchable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntityParrot
extends EntityPerchable
implements VariantHolder<Variant>,
EntityBird {
    private static final DataWatcherObject<Integer> cg = DataWatcher.a(EntityParrot.class, DataWatcherRegistry.b);
    private static final Predicate<EntityInsentient> ch = new Predicate<EntityInsentient>(){

        public boolean a(@Nullable EntityInsentient mob) {
            return mob != null && ci.containsKey(mob.aq());
        }
    };
    static final Map<EntityTypes<?>, SoundEffect> ci = SystemUtils.a(Maps.newHashMap(), (? super T map) -> {
        map.put(EntityTypes.o, SoundEffects.tj);
        map.put(EntityTypes.q, SoundEffects.tk);
        map.put(EntityTypes.r, SoundEffects.tl);
        map.put(EntityTypes.v, SoundEffects.tI);
        map.put(EntityTypes.D, SoundEffects.tm);
        map.put(EntityTypes.E, SoundEffects.tn);
        map.put(EntityTypes.K, SoundEffects.to);
        map.put(EntityTypes.M, SoundEffects.tp);
        map.put(EntityTypes.P, SoundEffects.tq);
        map.put(EntityTypes.O, SoundEffects.tr);
        map.put(EntityTypes.S, SoundEffects.ts);
        map.put(EntityTypes.ad, SoundEffects.tt);
        map.put(EntityTypes.ai, SoundEffects.tu);
        map.put(EntityTypes.aj, SoundEffects.tv);
        map.put(EntityTypes.am, SoundEffects.tw);
        map.put(EntityTypes.an, SoundEffects.tx);
        map.put(EntityTypes.az, SoundEffects.ty);
        map.put(EntityTypes.aP, SoundEffects.tz);
        map.put(EntityTypes.aR, SoundEffects.tA);
        map.put(EntityTypes.aS, SoundEffects.tB);
        map.put(EntityTypes.aT, SoundEffects.tC);
        map.put(EntityTypes.aY, SoundEffects.tD);
        map.put(EntityTypes.bb, SoundEffects.tE);
        map.put(EntityTypes.bd, SoundEffects.tF);
        map.put(EntityTypes.be, SoundEffects.tG);
        map.put(EntityTypes.bg, SoundEffects.tH);
        map.put(EntityTypes.bn, SoundEffects.tI);
        map.put(EntityTypes.br, SoundEffects.tJ);
        map.put(EntityTypes.bB, SoundEffects.tK);
        map.put(EntityTypes.bD, SoundEffects.tL);
        map.put(EntityTypes.bF, SoundEffects.tM);
        map.put(EntityTypes.bH, SoundEffects.tN);
        map.put(EntityTypes.bI, SoundEffects.tO);
        map.put(EntityTypes.bJ, SoundEffects.tP);
        map.put(EntityTypes.bM, SoundEffects.tQ);
        map.put(EntityTypes.bN, SoundEffects.tR);
        map.put(EntityTypes.bP, SoundEffects.tS);
    });
    public float cc;
    public float cd;
    public float ce;
    public float cf;
    private float cj = 1.0f;
    private float ck = 1.0f;
    private boolean cl;
    @Nullable
    private BlockPosition cm;

    public EntityParrot(EntityTypes<? extends EntityParrot> entityType, World level) {
        super((EntityTypes<? extends EntityPerchable>)entityType, level);
        this.bP = new ControllerMoveFlying(this, 10, false);
        this.a(PathType.n, -1.0f);
        this.a(PathType.o, -1.0f);
        this.a(PathType.x, -1.0f);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.a(SystemUtils.a(Variant.values(), level.H_()));
        if (spawnGroupData == null) {
            spawnGroupData = new EntityAgeable.a(false);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public boolean e_() {
        return false;
    }

    @Override
    protected void E() {
        this.bS.a(0, new EntityTameableAnimal.a(1.25));
        this.bS.a(0, new PathfinderGoalFloat(this));
        this.bS.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bS.a(2, new PathfinderGoalSit(this));
        this.bS.a(2, new PathfinderGoalFollowOwner(this, 1.0, 5.0f, 1.0f));
        this.bS.a(2, new a(this, 1.0));
        this.bS.a(3, new PathfinderGoalPerch(this));
        this.bS.a(3, new PathfinderGoalFollowEntity(this, 1.0, 3.0f, 7.0f));
    }

    public static AttributeProvider.Builder gE() {
        return EntityAnimal.gx().a(GenericAttributes.s, 6.0).a(GenericAttributes.l, 0.4f).a(GenericAttributes.v, 0.2f).a(GenericAttributes.c, 3.0);
    }

    @Override
    protected NavigationAbstract b(World level) {
        NavigationFlying flyingPathNavigation = new NavigationFlying(this, level);
        flyingPathNavigation.b(false);
        flyingPathNavigation.a(true);
        return flyingPathNavigation;
    }

    @Override
    public void d_() {
        if (this.cm == null || !this.cm.a(this.dt(), 3.46) || !this.dV().a_(this.cm).a(Blocks.eg)) {
            this.cl = false;
            this.cm = null;
        }
        if (this.dV().A.a(400) == 0) {
            EntityParrot.a(this.dV(), this);
        }
        super.d_();
        this.gJ();
    }

    @Override
    public void a(BlockPosition pos, boolean isPartying) {
        this.cm = pos;
        this.cl = isPartying;
    }

    public boolean gF() {
        return this.cl;
    }

    private void gJ() {
        this.cf = this.cc;
        this.ce = this.cd;
        this.cd += (float)(!this.aJ() && !this.bZ() ? 4 : -1) * 0.3f;
        this.cd = MathHelper.a(this.cd, 0.0f, 1.0f);
        if (!this.aJ() && this.cj < 1.0f) {
            this.cj = 1.0f;
        }
        this.cj *= 0.9f;
        Vec3D deltaMovement = this.dy();
        if (!this.aJ() && deltaMovement.e < 0.0) {
            this.i(deltaMovement.d(1.0, 0.6, 1.0));
        }
        this.cc += this.cj * 2.0f;
    }

    public static boolean a(World level, Entity parrot) {
        if (parrot.bL() && !parrot.bb() && level.A.a(2) == 0) {
            EntityInsentient mob;
            List<EntityInsentient> entitiesOfClass = level.a(EntityInsentient.class, parrot.cR().g(20.0), ch);
            if (!entitiesOfClass.isEmpty() && !(mob = entitiesOfClass.get(level.A.a(entitiesOfClass.size()))).bb()) {
                SoundEffect imitatedSound = EntityParrot.b(mob.aq());
                level.a(null, parrot.dA(), parrot.dC(), parrot.dG(), imitatedSound, parrot.dm(), 0.7f, EntityParrot.a(level.A));
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (!this.p() && itemInHand.a(TagsItem.aA)) {
            this.a(player, hand, itemInHand);
            if (!this.bb()) {
                this.dV().a(null, this.dA(), this.dC(), this.dG(), SoundEffects.tg, this.dm(), 1.0f, 1.0f + (this.ae.i() - this.ae.i()) * 0.2f);
            }
            if (!this.dV().C) {
                if (this.ae.a(10) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
                    this.a(player);
                    this.dV().a((Entity)this, (byte)7);
                } else {
                    this.dV().a((Entity)this, (byte)6);
                }
            }
            return EnumInteractionResult.a;
        }
        if (!itemInHand.a(TagsItem.aB)) {
            if (!this.gH() && this.p() && this.j(player)) {
                if (!this.dV().C) {
                    this.z(!this.gs());
                }
                return EnumInteractionResult.a;
            }
            return super.b(player, hand);
        }
        this.a(player, hand, itemInHand);
        this.addEffect(new MobEffect(MobEffects.s, 900), EntityPotionEffectEvent.Cause.FOOD);
        if (player.b() || !this.cC()) {
            this.a(this.dW().a(player), Float.MAX_VALUE);
        }
        return EnumInteractionResult.a;
    }

    @Override
    public boolean j(ItemStack stack) {
        return false;
    }

    public static boolean c(EntityTypes<EntityParrot> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cd) && EntityParrot.a(level, pos);
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        return false;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable otherParent) {
        return null;
    }

    @Override
    @Nullable
    public SoundEffect u() {
        return EntityParrot.a(this.dV(), this.dV().A);
    }

    public static SoundEffect a(World level, RandomSource random) {
        if (level.am() != EnumDifficulty.a && random.a(1000) == 0) {
            ArrayList list = Lists.newArrayList(ci.keySet());
            return EntityParrot.b((EntityTypes)list.get(random.a(list.size())));
        }
        return SoundEffects.te;
    }

    private static SoundEffect b(EntityTypes<?> type) {
        return ci.getOrDefault(type, SoundEffects.te);
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.ti;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.tf;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.tT, 0.15f, 1.0f);
    }

    @Override
    protected boolean ba() {
        return this.Y > this.ck;
    }

    @Override
    protected void aZ() {
        this.a(SoundEffects.th, 0.15f, 1.0f);
        this.ck = this.Y + this.cd / 2.0f;
    }

    @Override
    public float fh() {
        return EntityParrot.a(this.ae);
    }

    public static float a(RandomSource random) {
        return (random.i() - random.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.g;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return super.isCollidable(ignoreClimbing);
    }

    @Override
    protected void D(Entity entity) {
        if (!(entity instanceof EntityHuman)) {
            super.D(entity);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.a(level, damageSource)) {
            return false;
        }
        if (!super.a(level, damageSource, amount)) {
            return false;
        }
        this.z(false);
        return true;
    }

    public Variant gG() {
        return Variant.a(this.al.a(cg));
    }

    @Override
    public void a(Variant variant) {
        this.al.a(cg, variant.h);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cg, 0);
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("Variant", this.gG().h);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.a(Variant.a(compound.h("Variant")));
    }

    @Override
    public boolean gH() {
        return !this.aJ();
    }

    @Override
    protected boolean gw() {
        return true;
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.5f * this.cS(), this.dq() * 0.4f);
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable {
        public static final /* enum */ Variant a = new Variant(0, "red_blue");
        public static final /* enum */ Variant b = new Variant(1, "blue");
        public static final /* enum */ Variant c = new Variant(2, "green");
        public static final /* enum */ Variant d = new Variant(3, "yellow_blue");
        public static final /* enum */ Variant e = new Variant(4, "gray");
        public static final Codec<Variant> f;
        private static final IntFunction<Variant> g;
        final int h;
        private final String i;
        private static final /* synthetic */ Variant[] j;

        public static Variant[] values() {
            return (Variant[])j.clone();
        }

        public static Variant valueOf(String name) {
            return Enum.valueOf(Variant.class, name);
        }

        private Variant(int id, String name) {
            this.h = id;
            this.i = name;
        }

        public int a() {
            return this.h;
        }

        public static Variant a(int id) {
            return g.apply(id);
        }

        @Override
        public String c() {
            return this.i;
        }

        private static /* synthetic */ Variant[] b() {
            return new Variant[]{a, b, c, d, e};
        }

        static {
            j = Variant.b();
            f = INamable.a(Variant::values);
            g = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.c);
        }
    }

    static class a
    extends PathfinderGoalRandomFly {
        public a(EntityCreature mob, double speedModifier) {
            super(mob, speedModifier);
        }

        @Override
        @Nullable
        protected Vec3D h() {
            Vec3D vec3 = null;
            if (this.b.bj()) {
                vec3 = LandRandomPos.a(this.b, 15, 15);
            }
            if (this.b.dY().i() >= this.j) {
                vec3 = this.k();
            }
            return vec3 == null ? super.h() : vec3;
        }

        @Nullable
        private Vec3D k() {
            BlockPosition blockPos = this.b.dv();
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            BlockPosition.MutableBlockPosition mutableBlockPos1 = new BlockPosition.MutableBlockPosition();
            for (BlockPosition blockPos1 : BlockPosition.b(MathHelper.a(this.b.dA() - 3.0), MathHelper.a(this.b.dC() - 6.0), MathHelper.a(this.b.dG() - 3.0), MathHelper.a(this.b.dA() + 3.0), MathHelper.a(this.b.dC() + 6.0), MathHelper.a(this.b.dG() + 3.0))) {
                IBlockData blockState;
                boolean flag;
                if (blockPos.equals(blockPos1) || !(flag = (blockState = this.b.dV().a_(mutableBlockPos1.a((BaseBlockPosition)blockPos1, EnumDirection.a))).b() instanceof BlockLeaves || blockState.a(TagsBlock.u)) || !this.b.dV().u(blockPos1) || !this.b.dV().u(mutableBlockPos.a((BaseBlockPosition)blockPos1, EnumDirection.b))) continue;
                return Vec3D.c(blockPos1);
            }
            return null;
        }
    }
}

