/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;

public class EntityMushroomCow
extends EntityCow
implements IShearable,
VariantHolder<Type> {
    private static final DataWatcherObject<String> bY = DataWatcher.a(EntityMushroomCow.class, DataWatcherRegistry.e);
    private static final int bZ = 1024;
    private static final String ca = "stew_effects";
    @Nullable
    public SuspiciousStewEffects cc;
    @Nullable
    private UUID cd;

    public EntityMushroomCow(EntityTypes<? extends EntityMushroomCow> entityType, World level) {
        super((EntityTypes<? extends EntityCow>)entityType, level);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return level.a_(pos.e()).a(Blocks.fA) ? 10.0f : level.w(pos);
    }

    public static boolean c(EntityTypes<EntityMushroomCow> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cc) && EntityMushroomCow.a(level, pos);
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        UUID uuid = lightning.cG();
        if (!uuid.equals(this.cd)) {
            this.a(this.t() == Type.a ? Type.b : Type.a);
            this.cd = uuid;
            this.a(SoundEffects.pm, 2.0f, 1.0f);
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bY, Type.a.d);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.oY) && !this.e_()) {
            ItemStack itemStack;
            boolean flag = false;
            if (this.cc != null) {
                flag = true;
                itemStack = new ItemStack(Items.wW);
                itemStack.b(DataComponents.R, this.cc);
                this.cc = null;
            } else {
                itemStack = new ItemStack(Items.pW);
            }
            ItemStack itemStack1 = ItemLiquidUtil.a(itemInHand, player, itemStack, false);
            player.a(hand, itemStack1);
            SoundEffect soundEvent = flag ? SoundEffects.pp : SoundEffects.po;
            this.a(soundEvent, 1.0f, 1.0f);
            return EnumInteractionResult.a;
        }
        if (itemInHand.a(Items.sS) && this.a()) {
            World itemStack = this.dV();
            if (itemStack instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)itemStack;
                List<ItemStack> drops = this.generateDefaultDrops(serverLevel, itemInHand);
                PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemInHand, hand, drops);
                if (event != null) {
                    if (event.isCancelled()) {
                        return EnumInteractionResult.e;
                    }
                    drops = CraftItemStack.asNMSCopy(event.getDrops());
                }
                this.shear(serverLevel, SoundCategory.h, itemInHand, drops);
                this.a(GameEvent.M, (Entity)player);
                itemInHand.a(1, (EntityLiving)player, EntityMushroomCow.d(hand));
            }
            return EnumInteractionResult.a;
        }
        if (this.t() == Type.b) {
            Optional<SuspiciousStewEffects> effectsFromItemStack = this.i(itemInHand);
            if (effectsFromItemStack.isEmpty()) {
                return super.b(player, hand);
            }
            if (this.cc != null) {
                for (int i2 = 0; i2 < 2; ++i2) {
                    this.dV().a(Particles.ag, this.dA() + this.ae.j() / 2.0, this.e(0.5), this.dG() + this.ae.j() / 2.0, 0.0, this.ae.j() / 5.0, 0.0);
                }
            } else {
                itemInHand.a(1, (EntityLiving)player);
                for (int i3 = 0; i3 < 4; ++i3) {
                    this.dV().a(Particles.p, this.dA() + this.ae.j() / 2.0, this.e(0.5), this.dG() + this.ae.j() / 2.0, 0.0, this.ae.j() / 5.0, 0.0);
                }
                this.cc = effectsFromItemStack.get();
                this.a(SoundEffects.pn, 2.0f, 1.0f);
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    @Override
    public void a(WorldServer level, SoundCategory soundSource, ItemStack shears) {
        this.shear(level, soundSource, shears, this.generateDefaultDrops(level, shears));
    }

    @Override
    public List<ItemStack> generateDefaultDrops(WorldServer serverLevel, ItemStack shears) {
        ObjectArrayList drops = new ObjectArrayList();
        this.a(serverLevel, LootTables.aR, shears, (arg_0, arg_1) -> EntityMushroomCow.lambda$generateDefaultDrops$0((List)drops, arg_0, arg_1));
        return drops;
    }

    @Override
    public void shear(WorldServer level, SoundCategory soundSource, ItemStack shears, List<ItemStack> drops) {
        level.a(null, this, SoundEffects.pq, soundSource, 1.0f, 1.0f);
        this.convertTo(EntityTypes.C, ConversionParams.a(this, false, false), (T mob) -> {
            level.a(Particles.w, this.dA(), this.e(0.5), this.dG(), 1, 0.0, 0.0, 0.0, 0.0);
            drops.forEach(drop -> this.spawnAtLocation(level, new EntityItem(this.dV(), this.dA(), this.e(1.0), this.dG(), (ItemStack)drop)));
        }, EntityTransformEvent.TransformReason.SHEARED, CreatureSpawnEvent.SpawnReason.SHEARED);
    }

    @Override
    public boolean a() {
        return this.bL() && !this.e_();
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("Type", this.t().c());
        if (this.cc != null) {
            SuspiciousStewEffects.c.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cc).ifSuccess(tag -> compound.a(ca, (NBTBase)tag));
        }
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.a(Type.a(compound.l("Type")));
        if (compound.b(ca, 9)) {
            SuspiciousStewEffects.c.parse((DynamicOps)DynamicOpsNBT.a, (Object)compound.c(ca)).ifSuccess(suspiciousStewEffects -> {
                this.cc = suspiciousStewEffects;
            });
        }
    }

    private Optional<SuspiciousStewEffects> i(ItemStack stack) {
        SuspiciousEffectHolder suspiciousEffectHolder = SuspiciousEffectHolder.a(stack.h());
        return suspiciousEffectHolder != null ? Optional.of(suspiciousEffectHolder.c()) : Optional.empty();
    }

    @Override
    public void a(Type variant) {
        this.al.a(bY, variant.d);
    }

    public Type t() {
        return Type.a(this.al.a(bY));
    }

    @Nullable
    public EntityMushroomCow c(WorldServer level, EntityAgeable otherParent) {
        EntityMushroomCow mushroomCow = EntityTypes.aE.a(level, EntitySpawnReason.e);
        if (mushroomCow != null) {
            mushroomCow.a(this.a((EntityMushroomCow)otherParent));
        }
        return mushroomCow;
    }

    private Type a(EntityMushroomCow partner) {
        Type variant1;
        Type variant = this.t();
        Type variant2 = variant == (variant1 = partner.t()) && this.ae.a(1024) == 0 ? (variant == Type.b ? Type.a : Type.b) : (this.ae.h() ? variant : variant1);
        return variant2;
    }

    private static /* synthetic */ void lambda$generateDefaultDrops$0(List drops, WorldServer ignored, ItemStack stack) {
        for (int i2 = 0; i2 < stack.M(); ++i2) {
            drops.add(stack.c(1));
        }
    }

    public static final class Type
    extends Enum<Type>
    implements INamable {
        public static final /* enum */ Type a = new Type("red", Blocks.cn.m());
        public static final /* enum */ Type b = new Type("brown", Blocks.cm.m());
        public static final INamable.a<Type> c;
        final String d;
        private final IBlockData e;
        private static final /* synthetic */ Type[] f;

        public static Type[] values() {
            return (Type[])f.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(String type, IBlockData blockState) {
            this.d = type;
            this.e = blockState;
        }

        public IBlockData a() {
            return this.e;
        }

        @Override
        public String c() {
            return this.d;
        }

        static Type a(String name) {
            return c.a(name, a);
        }

        private static /* synthetic */ Type[] b() {
            return new Type[]{a, b};
        }

        static {
            f = Type.b();
            c = INamable.a(Type::values);
        }
    }
}

