/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.event.entity.EntityToggleSitEvent;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalNearestVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWaterJumpAbstract;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityFox
extends EntityAnimal
implements VariantHolder<Type> {
    private static final DataWatcherObject<Integer> cc = DataWatcher.a(EntityFox.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Byte> cd = DataWatcher.a(EntityFox.class, DataWatcherRegistry.a);
    private static final int ce = 1;
    public static final int bY = 4;
    public static final int bZ = 8;
    public static final int ca = 16;
    private static final int cf = 32;
    private static final int cg = 64;
    private static final int ch = 128;
    public static final DataWatcherObject<Optional<UUID>> ci = DataWatcher.a(EntityFox.class, DataWatcherRegistry.r);
    public static final DataWatcherObject<Optional<UUID>> cj = DataWatcher.a(EntityFox.class, DataWatcherRegistry.r);
    static final Predicate<EntityItem> ck = item -> !item.v() && item.bL();
    private static final Predicate<Entity> cl = entity -> {
        EntityLiving livingEntity;
        return entity instanceof EntityLiving && (livingEntity = (EntityLiving)entity).er() != null && livingEntity.es() < livingEntity.af + 600;
    };
    static final Predicate<Entity> cm = entity -> entity instanceof EntityChicken || entity instanceof EntityRabbit;
    private static final Predicate<Entity> cn = entity -> !entity.cg() && IEntitySelector.e.test((Entity)entity);
    private static final int co = 600;
    private static final EntitySize cp = EntityTypes.aa.n().a(0.5f).b(0.2975f);
    private PathfinderGoal cq;
    private PathfinderGoal cr;
    private PathfinderGoal cs;
    private float ct;
    private float cu;
    float cv;
    float cw;
    private int cx;

    public EntityFox(EntityTypes<? extends EntityFox> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        this.bO = new k();
        this.bP = new m();
        this.a(PathType.p, 0.0f);
        this.a(PathType.q, 0.0f);
        this.a_(true);
        this.P().a(32.0f);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ci, Optional.empty());
        builder.a(cj, Optional.empty());
        builder.a(cc, 0);
        builder.a(cd, (byte)0);
    }

    @Override
    protected void E() {
        this.cq = new PathfinderGoalNearestAttackableTarget<EntityAnimal>(this, EntityAnimal.class, 10, false, false, (entity, level) -> entity instanceof EntityChicken || entity instanceof EntityRabbit);
        this.cr = new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, false, false, EntityTurtle.bY);
        this.cs = new PathfinderGoalNearestAttackableTarget<EntityFish>(this, EntityFish.class, 20, false, false, (entity, level) -> entity instanceof EntityFishSchool);
        this.bS.a(0, new g());
        this.bS.a(0, new ClimbOnTopOfPowderSnowGoal(this, this.dV()));
        this.bS.a(1, new b());
        this.bS.a(2, new n(2.2));
        this.bS.a(3, new e(this, 1.0));
        this.bS.a(4, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 16.0f, 1.6, 1.4, entity -> cn.test((Entity)entity) && !this.c(entity.cG()) && !this.gG()));
        this.bS.a(4, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 8.0f, 1.6, 1.4, livingEntity -> !((EntityWolf)livingEntity).p() && !this.gG()));
        this.bS.a(4, new PathfinderGoalAvoidTarget<EntityPolarBear>(this, EntityPolarBear.class, 8.0f, 1.6, 1.4, livingEntity -> !this.gG()));
        this.bS.a(5, new u());
        this.bS.a(6, new o());
        this.bS.a(6, new s(1.25));
        this.bS.a(7, new l((double)1.2f, true));
        this.bS.a(7, new t());
        this.bS.a(8, new h(this, 1.25));
        this.bS.a(9, new q(32, 200));
        this.bS.a(10, new f((double)1.2f, 12, 1));
        this.bS.a(10, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bS.a(11, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bS.a(11, new p());
        this.bS.a(12, new j(this, EntityHuman.class, 24.0f));
        this.bS.a(13, new r());
        this.bT.a(3, new a(EntityLiving.class, false, false, (entity, level) -> cl.test(entity) && !this.c(entity.cG())));
    }

    @Override
    public void d_() {
        if (!this.dV().C && this.bL() && this.dj()) {
            EntityLiving target;
            ++this.cx;
            ItemStack itemBySlot = this.a(EnumItemSlot.a);
            if (this.i(itemBySlot)) {
                if (this.cx > 600) {
                    ItemStack itemStack = itemBySlot.a(this.dV(), (EntityLiving)this);
                    if (!itemStack.f()) {
                        this.a(EnumItemSlot.a, itemStack);
                    }
                    this.cx = 0;
                } else if (this.cx > 560 && this.ae.i() < 0.1f) {
                    this.gy();
                    this.dV().a((Entity)this, (byte)45);
                }
            }
            if ((target = this.O_()) == null || !target.bL()) {
                this.z(false);
                this.A(false);
            }
        }
        if (this.fR() || this.fi()) {
            this.bm = false;
            this.bn = 0.0f;
            this.bp = 0.0f;
        }
        super.d_();
        if (this.gG() && this.ae.i() < 0.05f) {
            this.a(SoundEffects.jF, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean fi() {
        return this.eE();
    }

    private boolean i(ItemStack stack) {
        return stack.b(DataComponents.w) && this.O_() == null && this.aJ() && !this.fR();
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        if (random.i() < 0.2f) {
            float randomFloat = random.i();
            ItemStack itemStack = randomFloat < 0.05f ? new ItemStack(Items.pf) : (randomFloat < 0.2f ? new ItemStack(Items.ry) : (randomFloat < 0.4f ? (random.h() ? new ItemStack(Items.vD) : new ItemStack(Items.vE)) : (randomFloat < 0.6f ? new ItemStack(Items.qb) : (randomFloat < 0.8f ? new ItemStack(Items.rk) : new ItemStack(Items.pY)))));
            this.a(EnumItemSlot.a, itemStack);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 45) {
            ItemStack itemBySlot = this.a(EnumItemSlot.a);
            if (!itemBySlot.f()) {
                for (int i2 = 0; i2 < 8; ++i2) {
                    Vec3D vec3 = new Vec3D(((double)this.ae.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).a(-this.dN() * ((float)Math.PI / 180)).b(-this.dL() * ((float)Math.PI / 180));
                    this.dV().a(new ParticleParamItem(Particles.T, itemBySlot), this.dA() + this.bT().d / 2.0, this.dC(), this.dG() + this.bT().f / 2.0, vec3.d, vec3.e + 0.05, vec3.f);
                }
            }
        } else {
            super.b(id);
        }
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gx().a(GenericAttributes.v, 0.3f).a(GenericAttributes.s, 10.0).a(GenericAttributes.c, 2.0).a(GenericAttributes.x, 5.0).a(GenericAttributes.m, 32.0);
    }

    @Nullable
    public EntityFox b(WorldServer level, EntityAgeable otherParent) {
        EntityFox fox = EntityTypes.aa.a(level, EntitySpawnReason.e);
        if (fox != null) {
            fox.a(this.ae.h() ? this.t() : ((EntityFox)otherParent).t());
        }
        return fox;
    }

    public static boolean c(EntityTypes<EntityFox> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cg) && EntityFox.a(level, pos);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        Holder<BiomeBase> biome = level.t(this.dv());
        Type variant = Type.a(biome);
        boolean flag = false;
        if (spawnGroupData instanceof i) {
            i foxGroupData = (i)spawnGroupData;
            variant = foxGroupData.a;
            if (foxGroupData.a() >= 2) {
                flag = true;
            }
        } else {
            spawnGroupData = new i(variant);
        }
        this.a(variant);
        if (flag) {
            this.c_(-24000);
        }
        if (level instanceof WorldServer) {
            this.gE();
        }
        this.a(level.H_(), difficulty);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    private void gE() {
        if (this.t() == Type.a) {
            this.bT.a(4, this.cq);
            this.bT.a(4, this.cr);
            this.bT.a(6, this.cs);
        } else {
            this.bT.a(4, this.cs);
            this.bT.a(6, this.cq);
            this.bT.a(6, this.cr);
        }
    }

    @Override
    protected void gy() {
        this.a(SoundEffects.jJ, 1.0f, 1.0f);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? cp : super.e(pose);
    }

    public Type t() {
        return Type.a(this.al.a(cc));
    }

    @Override
    public void a(Type variant) {
        this.al.a(cc, variant.a());
    }

    List<UUID> gF() {
        Optional<UUID> optional = this.al.a(ci);
        Optional<UUID> optional1 = this.al.a(cj);
        if (optional.isPresent() && optional1.isPresent()) {
            return List.of(optional.get(), optional1.get());
        }
        if (optional.isPresent()) {
            return List.of(optional.get());
        }
        return optional1.isPresent() ? List.of(optional1.get()) : List.of();
    }

    void b(@Nullable UUID uuid) {
        if (this.al.a(ci).isPresent()) {
            this.al.a(cj, Optional.ofNullable(uuid));
        } else {
            this.al.a(ci, Optional.ofNullable(uuid));
        }
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        List<UUID> trustedUuiDs = this.gF();
        NBTTagList listTag = new NBTTagList();
        for (UUID uuid : trustedUuiDs) {
            listTag.add(GameProfileSerializer.a(uuid));
        }
        compound.a("Trusted", listTag);
        compound.a("Sleeping", this.fR());
        compound.a("Type", this.t().c());
        compound.a("Sitting", this.x());
        compound.a("Crouching", this.ci());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        for (NBTBase tag : compound.c("Trusted", 11)) {
            this.b(GameProfileSerializer.a(tag));
        }
        this.D(compound.q("Sleeping"));
        this.a(Type.a(compound.l("Type")));
        this.setSitting(compound.q("Sitting"), false);
        this.z(compound.q("Crouching"));
        if (this.dV() instanceof WorldServer) {
            this.gE();
        }
    }

    public boolean x() {
        return this.s(1);
    }

    public void x(boolean sitting) {
        this.setSitting(sitting, true);
    }

    public void setSitting(boolean sitting, boolean fireEvent) {
        if (fireEvent && !new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), sitting).callEvent()) {
            return;
        }
        this.d(1, sitting);
    }

    public boolean gs() {
        return this.s(64);
    }

    public void B(boolean faceplanted) {
        this.d(64, faceplanted);
    }

    public boolean gG() {
        return this.s(128);
    }

    public void C(boolean defending) {
        this.d(128, defending);
    }

    @Override
    public boolean fR() {
        return this.s(32);
    }

    public void D(boolean sleeping) {
        this.d(32, sleeping);
    }

    private void d(int flagId, boolean value) {
        if (value) {
            this.al.a(cd, (byte)(this.al.a(cd) | flagId));
        } else {
            this.al.a(cd, (byte)(this.al.a(cd) & ~flagId));
        }
    }

    private boolean s(int flagId) {
        return (this.al.a(cd) & flagId) != 0;
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return slot == EnumItemSlot.a && this.fN();
    }

    @Override
    public boolean g(ItemStack stack) {
        ItemStack itemBySlot = this.a(EnumItemSlot.a);
        return itemBySlot.f() || this.cx > 0 && stack.b(DataComponents.w) && !itemBySlot.b(DataComponents.w);
    }

    private void k(ItemStack stack) {
        if (!stack.f() && !this.dV().C) {
            EntityItem itemEntity = new EntityItem(this.dV(), this.dA() + this.bT().d, this.dC() + 1.0, this.dG() + this.bT().f, stack);
            itemEntity.b(40);
            itemEntity.b((Entity)this);
            this.a(SoundEffects.jO, 1.0f, 1.0f);
            this.spawnAtLocation((WorldServer)this.dV(), itemEntity);
        }
    }

    private void l(ItemStack stack) {
        EntityItem itemEntity = new EntityItem(this.dV(), this.dA(), this.dC(), this.dG(), stack);
        this.spawnAtLocation((WorldServer)this.dV(), itemEntity);
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        ItemStack item = entity.l();
        if (!CraftEventFactory.callEntityPickupItemEvent(this, entity, item.M() - 1, !this.g(item)).isCancelled()) {
            item = entity.l();
            int count = item.M();
            if (count > 1) {
                this.l(item.a(count - 1));
            }
            this.k(this.a(EnumItemSlot.a));
            this.a(entity);
            this.a(EnumItemSlot.a, item.a(1));
            this.g(EnumItemSlot.a);
            this.a((Entity)entity, item.M());
            entity.discard(EntityRemoveEvent.Cause.PICKUP);
            this.cx = 0;
        }
    }

    @Override
    public void h() {
        super.h();
        if (this.dj()) {
            boolean isInWater = this.bj();
            if (isInWater || this.O_() != null || this.dV().af()) {
                this.gH();
            }
            if (isInWater || this.fR()) {
                this.x(false);
            }
            if (this.gs() && this.dV().A.i() < 0.2f) {
                BlockPosition blockPos = this.dv();
                IBlockData blockState = this.dV().a_(blockPos);
                this.dV().c(2001, blockPos, Block.j(blockState));
            }
        }
        this.cu = this.ct;
        this.ct = this.gw() ? (this.ct += (1.0f - this.ct) * 0.4f) : (this.ct += (0.0f - this.ct) * 0.4f);
        this.cw = this.cv;
        if (this.ci()) {
            this.cv += 0.2f;
            if (this.cv > 3.0f) {
                this.cv = 3.0f;
            }
        } else {
            this.cv = 0.0f;
        }
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.ac);
    }

    @Override
    protected void a(EntityHuman player, EntityInsentient child) {
        ((EntityFox)child).b(player.cG());
    }

    public boolean gt() {
        return this.s(16);
    }

    public void y(boolean isPouncing) {
        this.d(16, isPouncing);
    }

    public boolean gu() {
        return this.bm;
    }

    public boolean gv() {
        return this.cv == 3.0f;
    }

    public void z(boolean isCrouching) {
        this.d(4, isCrouching);
    }

    @Override
    public boolean ci() {
        return this.s(4);
    }

    public void A(boolean isInterested) {
        this.d(8, isInterested);
    }

    public boolean gw() {
        return this.s(8);
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.cu, this.ct) * 0.11f * (float)Math.PI;
    }

    public float K(float partialTick) {
        return MathHelper.h(partialTick, this.cw, this.cv);
    }

    @Override
    public void h(@Nullable EntityLiving livingEntity) {
        if (this.gG() && livingEntity == null) {
            this.C(false);
        }
        super.h(livingEntity);
    }

    void gH() {
        this.D(false);
    }

    void gI() {
        this.A(false);
        this.z(false);
        this.x(false);
        this.D(false);
        this.C(false);
        this.B(false);
    }

    boolean gJ() {
        return !this.fR() && !this.x() && !this.gs();
    }

    @Override
    public void U() {
        SoundEffect ambientSound = this.u();
        if (ambientSound == SoundEffects.jL) {
            this.a(ambientSound, 2.0f, this.fh());
        } else {
            super.U();
        }
    }

    @Override
    @Nullable
    protected SoundEffect u() {
        List<Entity> entitiesOfClass;
        if (this.fR()) {
            return SoundEffects.jM;
        }
        if (!this.dV().V() && this.ae.i() < 0.1f && (entitiesOfClass = this.dV().a(EntityHuman.class, this.cR().c(16.0, 16.0, 16.0), IEntitySelector.f)).isEmpty()) {
            return SoundEffects.jL;
        }
        return SoundEffects.jG;
    }

    @Override
    @Nullable
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.jK;
    }

    @Override
    @Nullable
    public SoundEffect o_() {
        return SoundEffects.jI;
    }

    boolean c(UUID uuid) {
        return this.gF().contains(uuid);
    }

    @Override
    protected boolean shouldSkipLoot(EnumItemSlot slot) {
        return slot == EnumItemSlot.a;
    }

    @Override
    protected EntityDeathEvent dropAllDeathLoot(WorldServer level, DamageSource damageSource) {
        EntityDeathEvent deathEvent;
        ItemStack itemBySlot = this.a(EnumItemSlot.a);
        boolean releaseMouth = false;
        if (!itemBySlot.f() && level.O().b(GameRules.f)) {
            this.a(level, itemBySlot);
            releaseMouth = true;
        }
        if ((deathEvent = super.dropAllDeathLoot(level, damageSource)) == null || deathEvent.isCancelled()) {
            return deathEvent;
        }
        if (releaseMouth) {
            this.a(EnumItemSlot.a, ItemStack.j);
        }
        return deathEvent;
    }

    public static boolean a(EntityFox fox, EntityLiving livingEntity) {
        double d2 = livingEntity.dG() - fox.dG();
        double d1 = livingEntity.dA() - fox.dA();
        double d22 = d2 / d1;
        int i2 = 6;
        for (int i1 = 0; i1 < 6; ++i1) {
            double d3 = d22 == 0.0 ? 0.0 : d2 * (double)((float)i1 / 6.0f);
            double d4 = d22 == 0.0 ? d1 * (double)((float)i1 / 6.0f) : d3 / d22;
            for (int i22 = 1; i22 < 4; ++i22) {
                if (fox.dV().a_(BlockPosition.a(fox.dA() + d4, fox.dC() + (double)i22, fox.dG() + d3)).v()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.55f * this.cS(), this.dq() * 0.4f);
    }

    public class k
    extends ControllerLook {
        public k() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (!EntityFox.this.fR()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityFox.this.gt() && !EntityFox.this.ci() && !EntityFox.this.gw() && !EntityFox.this.gs();
        }
    }

    class m
    extends ControllerMove {
        public m() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (EntityFox.this.gJ()) {
                super.a();
            }
        }
    }

    class g
    extends PathfinderGoalFloat {
        public g() {
            super(EntityFox.this);
        }

        @Override
        public void d() {
            super.d();
            EntityFox.this.gI();
        }

        @Override
        public boolean b() {
            return EntityFox.this.bj() && EntityFox.this.b(TagsFluid.a) > 0.25 || EntityFox.this.bx();
        }
    }

    class b
    extends PathfinderGoal {
        int a;

        public b() {
            this.a(EnumSet.of(PathfinderGoal.Type.b, PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return EntityFox.this.gs();
        }

        @Override
        public boolean c() {
            return this.b() && this.a > 0;
        }

        @Override
        public void d() {
            this.a = this.a(40);
        }

        @Override
        public void e() {
            EntityFox.this.B(false);
        }

        @Override
        public void a() {
            --this.a;
        }
    }

    class n
    extends PathfinderGoalPanic {
        public n(double speedModifier) {
            super(EntityFox.this, speedModifier);
        }

        @Override
        public boolean h() {
            return !EntityFox.this.gG() && super.h();
        }
    }

    class e
    extends PathfinderGoalBreed {
        public e(EntityFox this$0, double speedModifier) {
            super(this$0, speedModifier);
        }

        @Override
        public void d() {
            ((EntityFox)this.a).gI();
            ((EntityFox)this.c).gI();
            super.d();
        }

        @Override
        protected void g() {
            WorldServer serverLevel = this.b;
            EntityFox fox = (EntityFox)this.a.a(serverLevel, (EntityAgeable)this.c);
            if (fox != null) {
                EntityPlayer loveCause = this.a.gB();
                EntityPlayer loveCause1 = this.c.gB();
                EntityPlayer serverPlayer = loveCause;
                if (loveCause != null) {
                    fox.b(loveCause.cG());
                } else {
                    serverPlayer = loveCause1;
                }
                if (loveCause1 != null && loveCause != loveCause1) {
                    fox.b(loveCause1.cG());
                }
                fox.c_(-24000);
                fox.b(this.a.dA(), this.a.dC(), this.a.dG(), 0.0f, 0.0f);
                int experience = this.a.dY().a(7) + 1;
                EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(fox, this.a, this.c, loveCause, this.a.breedItem, experience);
                if (entityBreedEvent.isCancelled()) {
                    this.a.gD();
                    this.c.gD();
                    return;
                }
                experience = entityBreedEvent.getExperience();
                if (serverPlayer != null) {
                    serverPlayer.a(StatisticList.P);
                    CriterionTriggers.p.a(serverPlayer, this.a, this.c, fox);
                }
                this.a.c_(6000);
                this.c.c_(6000);
                this.a.gD();
                this.c.gD();
                serverLevel.addFreshEntityWithPassengers(fox, CreatureSpawnEvent.SpawnReason.BREEDING);
                this.b.a((Entity)this.a, (byte)18);
                if (experience > 0 && serverLevel.O().b(GameRules.f)) {
                    this.b.b(new EntityExperienceOrb(this.b, this.a.dA(), this.a.dC(), this.a.dG(), experience, ExperienceOrb.SpawnReason.BREED, loveCause, fox));
                }
            }
        }
    }

    class u
    extends PathfinderGoal {
        public u() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            if (EntityFox.this.fR()) {
                return false;
            }
            EntityLiving target = EntityFox.this.O_();
            return target != null && target.bL() && cm.test(target) && EntityFox.this.g((Entity)target) > 36.0 && !EntityFox.this.ci() && !EntityFox.this.gw() && !EntityFox.this.bm;
        }

        @Override
        public void d() {
            EntityFox.this.x(false);
            EntityFox.this.B(false);
        }

        @Override
        public void e() {
            EntityLiving target = EntityFox.this.O_();
            if (target != null && EntityFox.a(EntityFox.this, target)) {
                EntityFox.this.A(true);
                EntityFox.this.z(true);
                EntityFox.this.P().m();
                EntityFox.this.L().a(target, (float)EntityFox.this.af(), (float)EntityFox.this.ad());
            } else {
                EntityFox.this.A(false);
                EntityFox.this.z(false);
            }
        }

        @Override
        public void a() {
            EntityLiving target = EntityFox.this.O_();
            if (target != null) {
                EntityFox.this.L().a(target, (float)EntityFox.this.af(), (float)EntityFox.this.ad());
                if (EntityFox.this.g((Entity)target) <= 36.0) {
                    EntityFox.this.A(true);
                    EntityFox.this.z(true);
                    EntityFox.this.P().m();
                } else {
                    EntityFox.this.P().a((Entity)target, 1.5);
                }
            }
        }
    }

    public class o
    extends PathfinderGoalWaterJumpAbstract {
        @Override
        public boolean b() {
            if (!EntityFox.this.gv()) {
                return false;
            }
            EntityLiving target = EntityFox.this.O_();
            if (target != null && target.bL()) {
                if (target.cP() != target.cO()) {
                    return false;
                }
                boolean isPathClear = EntityFox.a(EntityFox.this, target);
                if (!isPathClear) {
                    EntityFox.this.P().a((Entity)target, 0);
                    EntityFox.this.z(false);
                    EntityFox.this.A(false);
                }
                return isPathClear;
            }
            return false;
        }

        @Override
        public boolean c() {
            EntityLiving target = EntityFox.this.O_();
            if (target != null && target.bL()) {
                double d2 = EntityFox.this.dy().e;
                return !(d2 * d2 < (double)0.05f && Math.abs(EntityFox.this.dN()) < 15.0f && EntityFox.this.aJ() || EntityFox.this.gs());
            }
            return false;
        }

        @Override
        public boolean U_() {
            return false;
        }

        @Override
        public void d() {
            EntityFox.this.t(true);
            EntityFox.this.y(true);
            EntityFox.this.A(false);
            EntityLiving target = EntityFox.this.O_();
            if (target != null) {
                EntityFox.this.L().a(target, 60.0f, 30.0f);
                Vec3D vec3 = new Vec3D(target.dA() - EntityFox.this.dA(), target.dC() - EntityFox.this.dC(), target.dG() - EntityFox.this.dG()).d();
                EntityFox.this.i(EntityFox.this.dy().b(vec3.d * 0.8, 0.9, vec3.f * 0.8));
            }
            EntityFox.this.P().m();
        }

        @Override
        public void e() {
            EntityFox.this.z(false);
            EntityFox.this.cv = 0.0f;
            EntityFox.this.cw = 0.0f;
            EntityFox.this.A(false);
            EntityFox.this.y(false);
        }

        @Override
        public void a() {
            EntityLiving target = EntityFox.this.O_();
            if (target != null) {
                EntityFox.this.L().a(target, 60.0f, 30.0f);
            }
            if (!EntityFox.this.gs()) {
                Vec3D deltaMovement = EntityFox.this.dy();
                if (deltaMovement.e * deltaMovement.e < (double)0.03f && EntityFox.this.dN() != 0.0f) {
                    EntityFox.this.w(MathHelper.i(0.2f, EntityFox.this.dN(), 0.0f));
                } else {
                    double d2 = deltaMovement.i();
                    double d1 = Math.signum(-deltaMovement.e) * Math.acos(d2 / deltaMovement.g()) * 180.0 / 3.1415927410125732;
                    EntityFox.this.w((float)d1);
                }
            }
            if (target != null && EntityFox.this.f((Entity)target) <= 2.0f) {
                EntityFox.this.c(net.minecraft.world.entity.animal.EntityFox$o.a(EntityFox.this.dV()), (Entity)target);
            } else if (EntityFox.this.dN() > 0.0f && EntityFox.this.aJ() && (float)EntityFox.this.dy().e != 0.0f && EntityFox.this.dV().a_(EntityFox.this.dv()).a(Blocks.ea)) {
                EntityFox.this.w(60.0f);
                EntityFox.this.h((EntityLiving)null);
                EntityFox.this.B(true);
            }
        }
    }

    class s
    extends PathfinderGoalFleeSun {
        private int c;

        public s(double speedModifier) {
            super(EntityFox.this, speedModifier);
            this.c = net.minecraft.world.entity.animal.EntityFox$s.b(100);
        }

        @Override
        public boolean b() {
            if (!EntityFox.this.fR() && this.a.O_() == null) {
                if (EntityFox.this.dV().af() && EntityFox.this.dV().h(this.a.dv())) {
                    return this.h();
                }
                if (this.c > 0) {
                    --this.c;
                    return false;
                }
                this.c = 100;
                BlockPosition blockPos = this.a.dv();
                return EntityFox.this.dV().V() && EntityFox.this.dV().h(blockPos) && !((WorldServer)EntityFox.this.dV()).c(blockPos) && this.h();
            }
            return false;
        }

        @Override
        public void d() {
            EntityFox.this.gI();
            super.d();
        }
    }

    class l
    extends PathfinderGoalMeleeAttack {
        public l(double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super(EntityFox.this, speedModifier, followingTargetEvenIfNotSeen);
        }

        @Override
        protected void a(EntityLiving target) {
            if (this.b(target)) {
                this.h();
                this.a.c(net.minecraft.world.entity.animal.EntityFox$l.a(this.a), (Entity)target);
                EntityFox.this.a(SoundEffects.jH, 1.0f, 1.0f);
            }
        }

        @Override
        public void d() {
            EntityFox.this.A(false);
            super.d();
        }

        @Override
        public boolean b() {
            return !EntityFox.this.x() && !EntityFox.this.fR() && !EntityFox.this.ci() && !EntityFox.this.gs() && super.b();
        }
    }

    class t
    extends d {
        private static final int c = net.minecraft.world.entity.animal.EntityFox$t.b(140);
        private int d;

        public t() {
            this.d = EntityFox.this.ae.a(c);
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b, PathfinderGoal.Type.c));
        }

        @Override
        public boolean b() {
            return EntityFox.this.bn == 0.0f && EntityFox.this.bo == 0.0f && EntityFox.this.bp == 0.0f && (this.k() || EntityFox.this.fR());
        }

        @Override
        public boolean c() {
            return this.k();
        }

        private boolean k() {
            if (this.d > 0) {
                --this.d;
                return false;
            }
            return EntityFox.this.dV().V() && this.h() && !this.i() && !EntityFox.this.av;
        }

        @Override
        public void e() {
            this.d = EntityFox.this.ae.a(c);
            EntityFox.this.gI();
        }

        @Override
        public void d() {
            EntityFox.this.x(false);
            EntityFox.this.z(false);
            EntityFox.this.A(false);
            EntityFox.this.t(false);
            EntityFox.this.D(true);
            EntityFox.this.P().m();
            EntityFox.this.N().a(EntityFox.this.dA(), EntityFox.this.dC(), EntityFox.this.dG(), 0.0);
        }
    }

    static class h
    extends PathfinderGoalFollowParent {
        private final EntityFox d;

        public h(EntityFox fox, double speedModifier) {
            super(fox, speedModifier);
            this.d = fox;
        }

        @Override
        public boolean b() {
            return !this.d.gG() && super.b();
        }

        @Override
        public boolean c() {
            return !this.d.gG() && super.c();
        }

        @Override
        public void d() {
            this.d.gI();
            super.d();
        }
    }

    class q
    extends PathfinderGoalNearestVillage {
        public q(int unused32, int interval) {
            super(EntityFox.this, interval);
        }

        @Override
        public void d() {
            EntityFox.this.gI();
            super.d();
        }

        @Override
        public boolean b() {
            return super.b() && this.h();
        }

        @Override
        public boolean c() {
            return super.c() && this.h();
        }

        private boolean h() {
            return !EntityFox.this.fR() && !EntityFox.this.x() && !EntityFox.this.gG() && EntityFox.this.O_() == null;
        }
    }

    public class f
    extends PathfinderGoalGotoTarget {
        private static final int i = 40;
        protected int g;

        public f(double speedModifier, int searchRange, int verticalSearchRange) {
            super(EntityFox.this, speedModifier, searchRange, verticalSearchRange);
        }

        @Override
        public double i() {
            return 2.0;
        }

        @Override
        public boolean l() {
            return this.d % 100 == 0;
        }

        @Override
        protected boolean a(IWorldReader level, BlockPosition pos) {
            IBlockData blockState = level.a_(pos);
            return blockState.a(Blocks.oK) && blockState.c(BlockSweetBerryBush.c) >= 2 || CaveVines.j_(blockState);
        }

        @Override
        public void a() {
            if (this.m()) {
                if (this.g >= 40) {
                    this.o();
                } else {
                    ++this.g;
                }
            } else if (!this.m() && EntityFox.this.ae.i() < 0.05f) {
                EntityFox.this.a(SoundEffects.jN, 1.0f, 1.0f);
            }
            super.a();
        }

        protected void o() {
            if (f.a(EntityFox.this.dV()).O().b(GameRules.c)) {
                IBlockData blockState = EntityFox.this.dV().a_(this.e);
                if (blockState.a(Blocks.oK)) {
                    this.b(blockState);
                } else if (CaveVines.j_(blockState)) {
                    this.a(blockState);
                }
            }
        }

        private void a(IBlockData state) {
            CaveVines.a(EntityFox.this, state, EntityFox.this.dV(), this.e);
        }

        private void b(IBlockData state) {
            int ageValue = state.c(BlockSweetBerryBush.c);
            state.b(BlockSweetBerryBush.c, 1);
            if (!CraftEventFactory.callEntityChangeBlockEvent(EntityFox.this, this.e, (IBlockData)state.b(BlockSweetBerryBush.c, 1))) {
                return;
            }
            int i2 = 1 + EntityFox.this.dV().A.a(2) + (ageValue == 3 ? 1 : 0);
            ItemStack itemBySlot = EntityFox.this.a(EnumItemSlot.a);
            if (itemBySlot.f()) {
                EntityFox.this.a(EnumItemSlot.a, new ItemStack(Items.xv));
                --i2;
            }
            if (i2 > 0) {
                Block.a(EntityFox.this.dV(), this.e, new ItemStack(Items.xv, i2));
            }
            EntityFox.this.a(SoundEffects.Ag, 1.0f, 1.0f);
            EntityFox.this.dV().a(this.e, (IBlockData)state.b(BlockSweetBerryBush.c, 1), 2);
            EntityFox.this.dV().a(GameEvent.c, this.e, GameEvent.a.a(EntityFox.this));
        }

        @Override
        public boolean b() {
            return !EntityFox.this.fR() && super.b();
        }

        @Override
        public void d() {
            this.g = 0;
            EntityFox.this.x(false);
            super.d();
        }
    }

    class p
    extends PathfinderGoal {
        public p() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            if (!EntityFox.this.a(EnumItemSlot.a).f()) {
                return false;
            }
            if (EntityFox.this.O_() != null || EntityFox.this.ep() != null) {
                return false;
            }
            if (!EntityFox.this.gJ()) {
                return false;
            }
            if (EntityFox.this.dY().a(net.minecraft.world.entity.animal.EntityFox$p.b(10)) != 0) {
                return false;
            }
            List<EntityItem> entitiesOfClass = EntityFox.this.dV().a(EntityItem.class, EntityFox.this.cR().c(8.0, 8.0, 8.0), ck);
            return !entitiesOfClass.isEmpty() && EntityFox.this.a(EnumItemSlot.a).f();
        }

        @Override
        public void a() {
            List<EntityItem> entitiesOfClass = EntityFox.this.dV().a(EntityItem.class, EntityFox.this.cR().c(8.0, 8.0, 8.0), ck);
            ItemStack itemBySlot = EntityFox.this.a(EnumItemSlot.a);
            if (itemBySlot.f() && !entitiesOfClass.isEmpty()) {
                EntityFox.this.P().a((Entity)entitiesOfClass.get(0), (double)1.2f);
            }
        }

        @Override
        public void d() {
            List<EntityItem> entitiesOfClass = EntityFox.this.dV().a(EntityItem.class, EntityFox.this.cR().c(8.0, 8.0, 8.0), ck);
            if (!entitiesOfClass.isEmpty()) {
                EntityFox.this.P().a((Entity)entitiesOfClass.get(0), (double)1.2f);
            }
        }
    }

    class j
    extends PathfinderGoalLookAtPlayer {
        public j(EntityInsentient mob, Class<? extends EntityLiving> lookAtType, float lookDistance) {
            super(mob, lookAtType, lookDistance);
        }

        @Override
        public boolean b() {
            return super.b() && !EntityFox.this.gs() && !EntityFox.this.gw();
        }

        @Override
        public boolean c() {
            return super.c() && !EntityFox.this.gs() && !EntityFox.this.gw();
        }
    }

    class r
    extends d {
        private double c;
        private double d;
        private int e;
        private int f;

        public r() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return EntityFox.this.ep() == null && EntityFox.this.dY().i() < 0.02f && !EntityFox.this.fR() && EntityFox.this.O_() == null && EntityFox.this.P().k() && !this.i() && !EntityFox.this.gt() && !EntityFox.this.ci();
        }

        @Override
        public boolean c() {
            return this.f > 0;
        }

        @Override
        public void d() {
            this.k();
            this.f = 2 + EntityFox.this.dY().a(3);
            EntityFox.this.x(true);
            EntityFox.this.P().m();
        }

        @Override
        public void e() {
            EntityFox.this.x(false);
        }

        @Override
        public void a() {
            --this.e;
            if (this.e <= 0) {
                --this.f;
                this.k();
            }
            EntityFox.this.L().a(EntityFox.this.dA() + this.c, EntityFox.this.dE(), EntityFox.this.dG() + this.d, EntityFox.this.af(), EntityFox.this.ad());
        }

        private void k() {
            double d2 = Math.PI * 2 * EntityFox.this.dY().j();
            this.c = Math.cos(d2);
            this.d = Math.sin(d2);
            this.e = this.a(80 + EntityFox.this.dY().a(20));
        }
    }

    class a
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        @Nullable
        private EntityLiving j;
        @Nullable
        private EntityLiving k;
        private int l;

        public a(Class<EntityLiving> targetType, boolean mustSee, @Nullable boolean mustReach, PathfinderTargetCondition.a selector) {
            super(EntityFox.this, targetType, 10, mustSee, mustReach, selector);
        }

        @Override
        public boolean b() {
            if (this.b > 0 && this.e.dY().a(this.b) != 0) {
                return false;
            }
            WorldServer serverLevel = net.minecraft.world.entity.animal.EntityFox$a.a(EntityFox.this.dV());
            for (UUID uuid : EntityFox.this.gF()) {
                EntityLiving livingEntity;
                Entity entity = serverLevel.a(uuid);
                if (!(entity instanceof EntityLiving)) continue;
                this.k = livingEntity = (EntityLiving)entity;
                this.j = livingEntity.ep();
                int lastHurtByMobTimestamp = livingEntity.eq();
                return lastHurtByMobTimestamp != this.l && this.a(this.j, this.d);
            }
            return false;
        }

        @Override
        public void d() {
            this.a(this.j);
            this.c = this.j;
            if (this.k != null) {
                this.l = this.k.eq();
            }
            EntityFox.this.a(SoundEffects.jF, 1.0f, 1.0f);
            EntityFox.this.C(true);
            EntityFox.this.gH();
            super.d();
        }
    }

    public static final class Type
    extends Enum<Type>
    implements INamable {
        public static final /* enum */ Type a = new Type(0, "red");
        public static final /* enum */ Type b = new Type(1, "snow");
        public static final INamable.a<Type> c;
        private static final IntFunction<Type> d;
        private final int e;
        private final String f;
        private static final /* synthetic */ Type[] g;

        public static Type[] values() {
            return (Type[])g.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(int id, String name) {
            this.e = id;
            this.f = name;
        }

        @Override
        public String c() {
            return this.f;
        }

        public int a() {
            return this.e;
        }

        public static Type a(String name) {
            return c.a(name, a);
        }

        public static Type a(int id) {
            return d.apply(id);
        }

        public static Type a(Holder<BiomeBase> biome) {
            return biome.a(BiomeTags.ar) ? b : a;
        }

        private static /* synthetic */ Type[] b() {
            return new Type[]{a, b};
        }

        static {
            g = Type.b();
            c = INamable.a(Type::values);
            d = ByIdMap.a(Type::a, Type.values(), ByIdMap.a.a);
        }
    }

    public static class i
    extends EntityAgeable.a {
        public final Type a;

        public i(Type variant) {
            super(false);
            this.a = variant;
        }
    }

    abstract class d
    extends PathfinderGoal {
        private final PathfinderTargetCondition b;

        d() {
            this.b = PathfinderTargetCondition.a().a(12.0).d().a(new c());
        }

        protected boolean h() {
            BlockPosition blockPos = BlockPosition.a(EntityFox.this.dA(), EntityFox.this.cR().e, EntityFox.this.dG());
            return !EntityFox.this.dV().h(blockPos) && EntityFox.this.c(blockPos) >= 0.0f;
        }

        protected boolean i() {
            return !net.minecraft.world.entity.animal.EntityFox$d.a(EntityFox.this.dV()).a(EntityLiving.class, this.b, EntityFox.this, EntityFox.this.cR().c(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    public class c
    implements PathfinderTargetCondition.a {
        @Override
        public boolean test(EntityLiving entity, WorldServer level) {
            if (entity instanceof EntityFox) {
                return false;
            }
            if (entity instanceof EntityChicken || entity instanceof EntityRabbit || entity instanceof EntityMonster) {
                return true;
            }
            return entity instanceof EntityTameableAnimal ? !((EntityTameableAnimal)entity).p() : (!(entity instanceof EntityHuman) || !entity.Z_() && !((EntityHuman)entity).b()) && !EntityFox.this.c(entity.cG()) && !entity.fR() && !entity.cg();
        }
    }
}

