/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;

public class EntityChicken
extends EntityAnimal {
    private static final EntitySize cg = EntityTypes.z.n().a(0.5f).b(0.2975f);
    public float bY;
    public float bZ;
    public float ca;
    public float cc;
    public float cd = 1.0f;
    private float ch = 1.0f;
    public int ce = this.ae.a(6000) + 6000;
    public boolean cf;

    public EntityChicken(EntityTypes<? extends EntityChicken> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
        this.a(PathType.j, 0.0f);
    }

    @Override
    protected void E() {
        this.bS.a(0, new PathfinderGoalFloat(this));
        this.bS.a(1, new PathfinderGoalPanic(this, 1.4));
        this.bS.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bS.a(3, new PathfinderGoalTempt(this, 1.0, itemStack -> itemStack.a(TagsItem.an), false));
        this.bS.a(4, new PathfinderGoalFollowParent(this, 1.1));
        this.bS.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bS.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bS.a(7, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? cg : super.e(pose);
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gx().a(GenericAttributes.s, 4.0).a(GenericAttributes.v, 0.25);
    }

    @Override
    public void d_() {
        super.d_();
        this.cc = this.bY;
        this.ca = this.bZ;
        this.bZ += (this.aJ() ? -1.0f : 4.0f) * 0.3f;
        this.bZ = MathHelper.a(this.bZ, 0.0f, 1.0f);
        if (!this.aJ() && this.cd < 1.0f) {
            this.cd = 1.0f;
        }
        this.cd *= 0.9f;
        Vec3D deltaMovement = this.dy();
        if (!this.aJ() && deltaMovement.e < 0.0) {
            this.i(deltaMovement.d(1.0, 0.6, 1.0));
        }
        this.bY += this.cd * 2.0f;
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.bL() && !this.e_() && !this.t() && --this.ce <= 0) {
                this.forceDrops = true;
                if (this.a(serverLevel, LootTables.aI, this::a)) {
                    this.a(SoundEffects.eV, 1.0f, (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
                    ((Entity)this).a(GameEvent.t);
                }
                this.forceDrops = false;
                this.ce = this.ae.a(6000) + 6000;
            }
        }
    }

    @Override
    protected boolean ba() {
        return this.Y > this.ch;
    }

    @Override
    protected void aZ() {
        this.ch = this.Y + this.bZ / 2.0f;
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.eT;
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.eW;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.eU;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.eX, 0.15f, 1.0f);
    }

    @Nullable
    public EntityChicken b(WorldServer level, EntityAgeable otherParent) {
        return EntityTypes.z.a(level, EntitySpawnReason.e);
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.an);
    }

    @Override
    protected int e(WorldServer level) {
        return this.t() ? 10 : super.e(level);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.cf = compound.q("IsChickenJockey");
        if (compound.e("EggLayTime")) {
            this.ce = compound.h("EggLayTime");
        }
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("IsChickenJockey", this.cf);
        compound.a("EggLayTime", this.ce);
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return this.t();
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction callback) {
        super.a(passenger, callback);
        if (passenger instanceof EntityLiving) {
            ((EntityLiving)passenger).aX = this.aX;
        }
    }

    public boolean t() {
        return this.cf;
    }

    public void x(boolean isChickenJockey) {
        this.cf = isChickenJockey;
    }
}

