/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.event.entity.EntityDyeEvent;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.CatVariantTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalCatSitOnBed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalJumpOnBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOcelotAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class EntityCat
extends EntityTameableAnimal
implements VariantHolder<Holder<CatVariant>> {
    public static final double cc = 0.6;
    public static final double cd = 0.8;
    public static final double ce = 1.33;
    private static final DataWatcherObject<Holder<CatVariant>> cf = DataWatcher.a(EntityCat.class, DataWatcherRegistry.x);
    private static final DataWatcherObject<Boolean> cg = DataWatcher.a(EntityCat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> ch = DataWatcher.a(EntityCat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> ci = DataWatcher.a(EntityCat.class, DataWatcherRegistry.b);
    private static final ResourceKey<CatVariant> cj = CatVariant.c;
    @Nullable
    private a<EntityHuman> ck;
    @Nullable
    private PathfinderGoalTempt cl;
    private float cm;
    private float cn;
    private float co;
    private float cp;
    private boolean cq;
    private float cr;
    private float cs;

    public EntityCat(EntityTypes<? extends EntityCat> entityType, World level) {
        super((EntityTypes<? extends EntityTameableAnimal>)entityType, level);
        this.gK();
    }

    @Override
    protected void E() {
        this.cl = new PathfinderGoalTemptChance(this, 0.6, itemStack -> itemStack.a(TagsItem.ah), true);
        this.bS.a(1, new PathfinderGoalFloat(this));
        this.bS.a(1, new EntityTameableAnimal.a(1.5));
        this.bS.a(2, new PathfinderGoalSit(this));
        this.bS.a(3, new b(this));
        this.bS.a(4, this.cl);
        this.bS.a(5, new PathfinderGoalCatSitOnBed(this, 1.1, 8));
        this.bS.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 5.0f));
        this.bS.a(7, new PathfinderGoalJumpOnBlock(this, 0.8));
        this.bS.a(8, new PathfinderGoalLeapAtTarget(this, 0.3f));
        this.bS.a(9, new PathfinderGoalOcelotAttack(this));
        this.bS.a(10, new PathfinderGoalBreed(this, 0.8));
        this.bS.a(11, new PathfinderGoalRandomStrollLand((EntityCreature)this, 0.8, 1.0000001E-5f));
        this.bS.a(12, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 10.0f));
        this.bT.a(1, new PathfinderGoalRandomTargetNonTamed<EntityRabbit>(this, EntityRabbit.class, false, null));
        this.bT.a(1, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.bY));
    }

    public Holder<CatVariant> gE() {
        return this.al.a(cf);
    }

    public void j(Holder<CatVariant> variant) {
        this.al.a(cf, variant);
    }

    public void A(boolean lying) {
        this.al.a(cg, lying);
    }

    public boolean gF() {
        return this.al.a(cg);
    }

    public void B(boolean relaxStateOne) {
        this.al.a(ch, relaxStateOne);
    }

    public boolean gL() {
        return this.al.a(ch);
    }

    public EnumColor gG() {
        return EnumColor.a(this.al.a(ci));
    }

    @Override
    public void a(EnumColor color) {
        this.al.a(ci, color.a());
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cf, BuiltInRegistries.ai.b(cj));
        builder.a(cg, false);
        builder.a(ch, false);
        builder.a(ci, EnumColor.o.a());
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("variant", this.gE().e().orElse(cj).a().toString());
        compound.a("CollarColor", (byte)this.gG().a());
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        Optional.ofNullable(MinecraftKey.c(compound.l("variant"))).map(resourceLocation -> ResourceKey.a(Registries.l, resourceLocation)).flatMap(BuiltInRegistries.ai::a).ifPresent(this::j);
        if (compound.b("CollarColor", 99)) {
            this.a(EnumColor.a(compound.h("CollarColor")));
        }
    }

    @Override
    public void a(WorldServer level) {
        if (this.N().b()) {
            double speedModifier = this.N().c();
            if (speedModifier == 0.6) {
                this.b(EntityPose.f);
                this.h(false);
            } else if (speedModifier == 1.33) {
                this.b(EntityPose.a);
                this.h(true);
            } else {
                this.b(EntityPose.a);
                this.h(false);
            }
        } else {
            this.b(EntityPose.a);
            this.h(false);
        }
    }

    @Override
    @Nullable
    protected SoundEffect u() {
        if (this.p()) {
            if (this.gC()) {
                return SoundEffects.dZ;
            }
            return this.ae.a(4) == 0 ? SoundEffects.ea : SoundEffects.dS;
        }
        return SoundEffects.dT;
    }

    @Override
    public int T() {
        return 120;
    }

    public void gH() {
        this.b(SoundEffects.dW);
    }

    @Override
    protected SoundEffect e(DamageSource damageSource) {
        return SoundEffects.dY;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.dU;
    }

    public static AttributeProvider.Builder gI() {
        return EntityAnimal.gx().a(GenericAttributes.s, 10.0).a(GenericAttributes.v, 0.3f).a(GenericAttributes.c, 3.0);
    }

    @Override
    protected void gy() {
        this.a(SoundEffects.dV, 1.0f, 1.0f);
    }

    @Override
    public void h() {
        super.h();
        if (this.cl != null && this.cl.i() && !this.p() && this.af % 100 == 0) {
            this.a(SoundEffects.dX, 1.0f, 1.0f);
        }
        this.gM();
    }

    private void gM() {
        if ((this.gF() || this.gL()) && this.af % 5 == 0) {
            this.a(SoundEffects.dZ, 0.6f + 0.4f * (this.ae.i() - this.ae.i()), 1.0f);
        }
        this.gN();
        this.gO();
        this.cq = false;
        if (this.gF()) {
            BlockPosition blockPos = this.dv();
            for (EntityHuman player : this.dV().a(EntityHuman.class, new AxisAlignedBB(blockPos).c(2.0, 2.0, 2.0))) {
                if (!player.fR()) continue;
                this.cq = true;
                break;
            }
        }
    }

    public boolean gJ() {
        return this.cq;
    }

    private void gN() {
        this.cn = this.cm;
        this.cp = this.co;
        if (this.gF()) {
            this.cm = Math.min(1.0f, this.cm + 0.15f);
            this.co = Math.min(1.0f, this.co + 0.08f);
        } else {
            this.cm = Math.max(0.0f, this.cm - 0.22f);
            this.co = Math.max(0.0f, this.co - 0.13f);
        }
    }

    private void gO() {
        this.cs = this.cr;
        this.cr = this.gL() ? Math.min(1.0f, this.cr + 0.1f) : Math.max(0.0f, this.cr - 0.13f);
    }

    public float J(float partialTicks) {
        return MathHelper.h(partialTicks, this.cn, this.cm);
    }

    public float K(float partialTicks) {
        return MathHelper.h(partialTicks, this.cp, this.co);
    }

    public float L(float partialTicks) {
        return MathHelper.h(partialTicks, this.cs, this.cr);
    }

    @Nullable
    public EntityCat b(WorldServer level, EntityAgeable otherParent) {
        EntityCat cat = EntityTypes.u.a(level, EntitySpawnReason.e);
        if (cat != null && otherParent instanceof EntityCat) {
            EntityCat cat1 = (EntityCat)otherParent;
            if (this.ae.h()) {
                cat.j(this.gE());
            } else {
                cat.j(cat1.gE());
            }
            if (this.p()) {
                cat.b(this.aa_());
                cat.a(true, true);
                EnumColor collarColor = this.gG();
                EnumColor collarColor1 = cat1.gG();
                cat.a(EnumColor.a(level, collarColor, collarColor1));
            }
        }
        return cat;
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        EntityCat cat;
        return this.p() && otherAnimal instanceof EntityCat && (cat = (EntityCat)otherAnimal).p() && super.a(otherAnimal);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        spawnGroupData = super.a(level, difficulty, spawnReason, spawnGroupData);
        boolean flag = level.ar() > 0.9f;
        TagKey<CatVariant> tagKey = flag ? CatVariantTags.b : CatVariantTags.a;
        BuiltInRegistries.ai.a(tagKey, level.H_()).ifPresent(this::j);
        WorldServer level1 = level.a();
        if (level1.b().getStructureWithPieceAt(this.dv(), StructureTags.o, level).b()) {
            this.j(BuiltInRegistries.ai.b(CatVariant.l));
            this.fY();
        }
        return spawnGroupData;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult;
        ItemStack itemInHand = player.b(hand);
        Item item = itemInHand.h();
        if (this.p()) {
            if (this.j(player)) {
                EnumInteractionResult interactionResult2;
                if (item instanceof ItemDye) {
                    ItemDye dyeItem = (ItemDye)item;
                    EnumColor dyeColor = dyeItem.b();
                    if (dyeColor != this.gG()) {
                        EntityDyeEvent event = new EntityDyeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), DyeColor.getByWoolData((byte)((byte)dyeColor.a())), (Player)((EntityPlayer)player).getBukkitEntity());
                        if (!event.callEvent()) {
                            return EnumInteractionResult.d;
                        }
                        dyeColor = EnumColor.a(event.getColor().getWoolData());
                        if (!this.dV().B_()) {
                            this.a(dyeColor);
                            itemInHand.a(1, (EntityLiving)player);
                            this.fY();
                        }
                        return EnumInteractionResult.a;
                    }
                } else if (this.j(itemInHand) && this.eD() < this.eS()) {
                    if (!this.dV().B_()) {
                        this.a(player, hand, itemInHand);
                        FoodInfo foodProperties = itemInHand.a(DataComponents.w);
                        this.heal(foodProperties != null ? (float)foodProperties.a() : 1.0f, EntityRegainHealthEvent.RegainReason.EATING);
                        this.gy();
                    }
                    return EnumInteractionResult.a;
                }
                if (!(interactionResult2 = super.b(player, hand)).a()) {
                    this.z(!this.gs());
                    return EnumInteractionResult.a;
                }
                return interactionResult2;
            }
        } else if (this.j(itemInHand)) {
            if (!this.dV().B_()) {
                this.a(player, hand, itemInHand);
                this.g(player);
                this.fY();
                this.gy();
            }
            return EnumInteractionResult.a;
        }
        if ((interactionResult = super.b(player, hand)).a()) {
            this.fY();
        }
        return interactionResult;
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.ah);
    }

    @Override
    public boolean h(double distanceToClosestPlayer) {
        return !this.p() && this.af > 2400;
    }

    @Override
    public void a(boolean tame, boolean applyTamingSideEffects) {
        super.a(tame, applyTamingSideEffects);
        this.gK();
    }

    protected void gK() {
        if (this.ck == null) {
            this.ck = new a<EntityHuman>(this, EntityHuman.class, 16.0f, 0.8, 1.33);
        }
        this.bS.a(this.ck);
        if (!this.p()) {
            this.bS.a(4, this.ck);
        }
    }

    private void g(EntityHuman player) {
        if (this.ae.a(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
            this.a(player);
            this.z(true);
            this.dV().a((Entity)this, (byte)7);
        } else {
            this.dV().a((Entity)this, (byte)6);
        }
    }

    @Override
    public boolean ce() {
        return this.ci() || super.ce();
    }

    static class PathfinderGoalTemptChance
    extends PathfinderGoalTempt {
        @Nullable
        private EntityLiving selectedPlayer;
        private final EntityCat d;

        public PathfinderGoalTemptChance(EntityCat cat, double speedModifier, Predicate<ItemStack> items, boolean canScare) {
            super(cat, speedModifier, items, canScare);
            this.d = cat;
        }

        @Override
        public void a() {
            super.a();
            if (this.selectedPlayer == null && this.a.dY().a(this.a(600)) == 0) {
                this.selectedPlayer = this.player;
            } else if (this.a.dY().a(this.a(500)) == 0) {
                this.selectedPlayer = null;
            }
        }

        @Override
        protected boolean h() {
            return (this.selectedPlayer == null || !this.selectedPlayer.equals(this.player)) && super.h();
        }

        @Override
        public boolean b() {
            return super.b() && !this.d.p();
        }
    }

    static class b
    extends PathfinderGoal {
        private final EntityCat a;
        @Nullable
        private EntityHuman b;
        @Nullable
        private BlockPosition c;
        private int d;

        public b(EntityCat cat) {
            this.a = cat;
        }

        @Override
        public boolean b() {
            if (!this.a.p()) {
                return false;
            }
            if (this.a.gs()) {
                return false;
            }
            EntityLiving owner = this.a.ag_();
            if (owner instanceof EntityHuman) {
                this.b = (EntityHuman)owner;
                if (!owner.fR()) {
                    return false;
                }
                if (this.a.g((Entity)this.b) > 100.0) {
                    return false;
                }
                BlockPosition blockPos = this.b.dv();
                IBlockData blockState = this.a.dV().a_(blockPos);
                if (blockState.a(TagsBlock.T)) {
                    this.c = blockState.d(BlockFacingHorizontal.aF).map(pos -> blockPos.a(pos.g())).orElseGet(() -> new BlockPosition(blockPos));
                    return !this.h();
                }
            }
            return false;
        }

        private boolean h() {
            for (EntityCat cat : this.a.dV().a(EntityCat.class, new AxisAlignedBB(this.c).g(2.0))) {
                if (cat == this.a || !cat.gF() && !cat.gL()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean c() {
            return this.a.p() && !this.a.gs() && this.b != null && this.b.fR() && this.c != null && !this.h();
        }

        @Override
        public void d() {
            if (this.c != null) {
                this.a.y(false);
                this.a.P().a((double)this.c.u(), (double)this.c.v(), (double)this.c.w(), 1.1f);
            }
        }

        @Override
        public void e() {
            this.a.A(false);
            float timeOfDay = this.a.dV().f(1.0f);
            if (this.b.gn() >= 100 && (double)timeOfDay > 0.77 && (double)timeOfDay < 0.8 && (double)this.a.dV().H_().i() < 0.7) {
                this.i();
            }
            this.d = 0;
            this.a.B(false);
            this.a.P().m();
        }

        private void i() {
            RandomSource random = this.a.dY();
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            mutableBlockPos.g(this.a.P_() ? this.a.D().dv() : this.a.dv());
            this.a.b(mutableBlockPos.u() + random.a(11) - 5, mutableBlockPos.v() + random.a(5) - 2, mutableBlockPos.w() + random.a(11) - 5, false);
            mutableBlockPos.g(this.a.dv());
            this.a.a(net.minecraft.world.entity.animal.EntityCat$b.a(this.a), LootTables.aq, (WorldServer serverLevel, ItemStack itemStack) -> {
                EntityItem item = new EntityItem((World)serverLevel, (double)mutableBlockPos.u() - (double)MathHelper.a(this.a.aX * ((float)Math.PI / 180)), mutableBlockPos.v(), (double)mutableBlockPos.w() + (double)MathHelper.b(this.a.aX * ((float)Math.PI / 180)), (ItemStack)itemStack);
                EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.a.getBukkitEntity(), (org.bukkit.entity.Item)item.getBukkitEntity());
                if (!event.callEvent()) {
                    return;
                }
                serverLevel.b(item);
            });
        }

        @Override
        public void a() {
            if (this.b != null && this.c != null) {
                this.a.y(false);
                this.a.P().a((double)this.c.u(), (double)this.c.v(), (double)this.c.w(), 1.1f);
                if (this.a.g((Entity)this.b) < 2.5) {
                    ++this.d;
                    if (this.d > this.a(16)) {
                        this.a.A(true);
                        this.a.B(false);
                    } else {
                        this.a.a((Entity)this.b, 45.0f, 45.0f);
                        this.a.B(true);
                    }
                } else {
                    this.a.A(false);
                }
            }
        }
    }

    static class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityCat i;

        public a(EntityCat cat, Class<T> entityClassToAvoid, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
            super(cat, entityClassToAvoid, maxDist, walkSpeedModifier, sprintSpeedModifier, IEntitySelector.e::test);
            this.i = cat;
        }

        @Override
        public boolean b() {
            return !this.i.p() && super.b();
        }

        @Override
        public boolean c() {
            return !this.i.p() && super.c();
        }
    }
}

